/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.FullPathIterator;
import org.sosy_lab.cpachecker.util.AbstractStates;

class DefaultFullPathIterator
extends FullPathIterator {
    DefaultFullPathIterator(ARGPath pPath, int pPos, int pOverallOffset) {
        super(pPath, pPos, pOverallOffset);
    }

    DefaultFullPathIterator(ARGPath pPath) {
        this(pPath, 0, 0);
    }

    @Override
    public void advance() throws IllegalStateException {
        boolean nextPositionHasState;
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more states in PathIterator.");
        CFAEdge nextEdge = (CFAEdge)this.fullPath.get(this.overallOffset);
        Iterable<CFANode> nextLocation = AbstractStates.extractLocations(this.getNextAbstractState());
        boolean bl = nextPositionHasState = Iterables.contains(nextLocation, (Object)nextEdge.getSuccessor()) || Iterables.contains(nextLocation, (Object)nextEdge.getPredecessor());
        if (nextPositionHasState) {
            ++this.pos;
        }
        this.currentPositionHasState = nextPositionHasState;
        ++this.overallOffset;
    }

    @Override
    public void rewind() throws IllegalStateException {
        Preconditions.checkState((boolean)this.hasPrevious(), (Object)"No more states in PathIterator.");
        boolean previousPositionHasState = Iterables.contains(AbstractStates.extractLocations(this.getPreviousAbstractState()), (Object)((CFAEdge)this.fullPath.get(this.overallOffset - 1)).getPredecessor());
        if (this.currentPositionHasState) {
            --this.pos;
        }
        this.currentPositionHasState = previousPositionHasState;
        --this.overallOffset;
    }

    @Override
    public boolean hasNext() {
        return this.pos < this.path.size() - 1;
    }

    @Override
    public boolean hasPrevious() {
        return this.overallOffset > 0;
    }
}

