/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.base.Preconditions;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.FullPathPosition;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;

abstract class FullPathIterator
extends PathIterator {
    protected final List<CFAEdge> fullPath;
    protected boolean currentPositionHasState = true;
    protected int overallOffset;

    protected FullPathIterator(ARGPath pPath, int pPos, int pOverallOffset) {
        super(pPath, pPos);
        this.fullPath = pPath.getFullPath();
        this.overallOffset = pOverallOffset;
    }

    @Override
    public int getIndex() {
        return this.overallOffset;
    }

    @Override
    public PathPosition getPosition() {
        return new FullPathPosition(this.path, this.pos, this.overallOffset);
    }

    @Override
    public ARGState getAbstractState() {
        Preconditions.checkState((boolean)this.currentPositionHasState);
        return (ARGState)this.path.asStatesList().get(this.pos);
    }

    @Override
    public boolean isPositionWithState() {
        return this.currentPositionHasState;
    }

    @Override
    public @Nullable CFAEdge getIncomingEdge() {
        Preconditions.checkState((this.overallOffset > 0 ? 1 : 0) != 0, (Object)"First state in ARGPath has no incoming edge.");
        return this.fullPath.get(this.overallOffset - 1);
    }

    @Override
    public @Nullable CFAEdge getOutgoingEdge() {
        Preconditions.checkState((this.pos < this.path.size() - 1 ? 1 : 0) != 0, (Object)"Last state in ARGPath has no outgoing edge.");
        return this.fullPath.get(this.overallOffset);
    }

    @Override
    public ARGState getPreviousAbstractState() {
        Preconditions.checkState((this.overallOffset > 0 ? 1 : 0) != 0);
        if (this.currentPositionHasState) {
            return (ARGState)this.path.asStatesList().get(this.pos - 1);
        }
        return (ARGState)this.path.asStatesList().get(this.pos);
    }

    @Override
    public ARGPath getPrefixInclusive() {
        if (this.currentPositionHasState) {
            return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos + 1), this.path.getInnerEdges().subList(0, this.pos));
        }
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos + 2), this.path.getInnerEdges().subList(0, this.pos + 1));
    }

    @Override
    public ARGPath getPrefixExclusive() {
        Preconditions.checkState((!this.currentPositionHasState || this.pos > 0 ? 1 : 0) != 0, (Object)"Exclusive prefix of first state in path would be empty.");
        if (this.currentPositionHasState) {
            Preconditions.checkState((this.pos != 0 ? 1 : 0) != 0);
            return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos), this.path.getInnerEdges().subList(0, this.pos - 1));
        }
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos + 1), this.path.getInnerEdges().subList(0, this.pos));
    }
}

