/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.util.AbstractStates;

public abstract class PathIterator {
    protected int pos;
    protected final ARGPath path;

    PathIterator(ARGPath pPath, int pPos) {
        this.path = pPath;
        this.pos = pPos;
    }

    public abstract boolean hasNext();

    public abstract boolean hasPrevious();

    public int getIndex() {
        return this.pos;
    }

    public PathPosition getPosition() {
        return new PathPosition(this.path, this.getIndex());
    }

    public abstract void advance() throws IllegalStateException;

    public abstract void rewind() throws IllegalStateException;

    public boolean advanceIfPossible() {
        if (this.hasNext()) {
            this.advance();
            return true;
        }
        return false;
    }

    public boolean rewindIfPossible() {
        if (this.hasPrevious()) {
            this.rewind();
            return true;
        }
        return false;
    }

    public boolean isPositionWithState() {
        return true;
    }

    public ARGState getAbstractState() {
        return (ARGState)this.path.asStatesList().get(this.pos);
    }

    public ARGState getNextAbstractState() {
        Preconditions.checkState((this.pos + 1 < this.path.size() ? 1 : 0) != 0);
        return (ARGState)this.path.asStatesList().get(this.pos + 1);
    }

    public ARGState getPreviousAbstractState() {
        Preconditions.checkState((this.pos - 1 >= 0 ? 1 : 0) != 0);
        return (ARGState)this.path.asStatesList().get(this.pos - 1);
    }

    public CFANode getLocation() {
        return AbstractStates.extractLocation(this.getAbstractState());
    }

    public @Nullable CFAEdge getIncomingEdge() {
        Preconditions.checkState((this.pos > 0 ? 1 : 0) != 0, (Object)"First state in ARGPath has no incoming edge.");
        return this.path.getInnerEdges().get(this.pos - 1);
    }

    public @Nullable CFAEdge getOutgoingEdge() {
        Preconditions.checkState((this.pos < this.path.size() - 1 ? 1 : 0) != 0, (Object)"Last state in ARGPath has no outgoing edge.");
        return this.path.getInnerEdges().get(this.pos);
    }

    public ARGPath getPrefixInclusive() {
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos + 1), this.path.getInnerEdges().subList(0, this.pos));
    }

    public ARGPath getPrefixExclusive() {
        Preconditions.checkState((this.pos > 0 ? 1 : 0) != 0, (Object)"Exclusive prefix of first state in path would be empty.");
        if (this.pos == 1) {
            return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos), (List<CFAEdge>)ImmutableList.of());
        }
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(0, this.pos), this.path.getInnerEdges().subList(0, this.pos - 1));
    }

    public ARGPath getSuffixInclusive() {
        int lastPos = this.path.size();
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(this.pos, lastPos), this.path.getInnerEdges().subList(this.pos, lastPos - 1));
    }

    public ARGPath getSuffixExclusive() {
        Preconditions.checkState((this.pos < this.path.size() - 1 ? 1 : 0) != 0, (Object)"Exclusive suffix of last state in path would be empty.");
        int lastPos = this.path.size();
        return new ARGPath((List<ARGState>)this.path.asStatesList().subList(this.pos + 1, lastPos), this.path.getInnerEdges().subList(this.pos + 1, lastPos - 1));
    }
}

