/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.DefaultFullPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.DefaultPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.ReverseFullPathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.ReversePathIterator;

public class PathPosition {
    protected final int pos;
    protected final ARGPath path;

    PathPosition(ARGPath pPath, int pPosition) {
        this.path = pPath;
        this.pos = pPosition;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.path.hashCode();
        result = 31 * result + this.pos;
        return result;
    }

    public boolean equals(Object pObj) {
        if (!(pObj instanceof PathPosition)) {
            return false;
        }
        PathPosition other = (PathPosition)pObj;
        return this.pos == other.pos && this.path.equals((Object)other.path);
    }

    public PathIterator iterator() {
        return new DefaultPathIterator(this.path, this.pos);
    }

    public PathIterator reverseIterator() {
        return new ReversePathIterator(this.path, this.pos);
    }

    public PathIterator fullPathIterator() {
        DefaultFullPathIterator it = new DefaultFullPathIterator(this.path);
        while (it.pos != this.pos) {
            ((PathIterator)it).advance();
        }
        assert (it.pos == this.pos);
        return new DefaultFullPathIterator(this.path, this.pos, ((PathIterator)it).getIndex());
    }

    public PathIterator reverseFullPathIterator() {
        ReverseFullPathIterator it = new ReverseFullPathIterator(this.path);
        while (it.pos != this.pos) {
            ((PathIterator)it).advance();
        }
        while (((PathIterator)it).hasNext() && it.pos == this.pos) {
            ((PathIterator)it).advance();
        }
        if (this.pos == it.pos) {
            assert (this.pos == 0);
            return new ReverseFullPathIterator(this.path, this.pos, this.pos);
        }
        assert (this.pos == it.pos + 1);
        return new ReverseFullPathIterator(this.path, this.pos, ((PathIterator)it).getIndex() + 1);
    }

    public CFANode getLocation() {
        return this.iterator().getLocation();
    }

    public ARGPath getPath() {
        return this.path;
    }
}

