/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.FullPathIterator;
import org.sosy_lab.cpachecker.util.AbstractStates;

class ReverseFullPathIterator
extends FullPathIterator {
    ReverseFullPathIterator(ARGPath pPath, int pPos, int pOverallOffset) {
        super(pPath, pPos, pOverallOffset);
    }

    ReverseFullPathIterator(ARGPath pPath) {
        this(pPath, pPath.size() - 1, pPath.getFullPath().size());
    }

    @Override
    public void advance() throws IllegalStateException {
        Preconditions.checkState((boolean)this.hasNext(), (Object)"No more states in PathIterator.");
        if (this.path.getInnerEdges().get(this.pos - 1) != null && this.currentPositionHasState) {
            --this.pos;
            --this.overallOffset;
            this.currentPositionHasState = true;
        } else {
            boolean nextPositionHasState = Iterables.contains(AbstractStates.extractLocations(this.getPreviousAbstractState()), (Object)((CFAEdge)this.fullPath.get(this.overallOffset - 1)).getPredecessor());
            if (this.currentPositionHasState) {
                --this.pos;
            }
            this.currentPositionHasState = nextPositionHasState;
            --this.overallOffset;
        }
    }

    @Override
    public void rewind() throws IllegalStateException {
        Preconditions.checkState((boolean)this.hasPrevious(), (Object)"No more states in PathIterator.");
        if (this.path.getInnerEdges().get(this.pos) != null && this.currentPositionHasState) {
            ++this.pos;
            ++this.overallOffset;
            this.currentPositionHasState = true;
        } else {
            if (Iterables.contains(AbstractStates.extractLocations(this.getNextAbstractState()), (Object)((CFAEdge)this.fullPath.get(this.overallOffset)).getSuccessor())) {
                ++this.pos;
                this.currentPositionHasState = true;
            } else {
                this.currentPositionHasState = false;
            }
            ++this.overallOffset;
        }
    }

    @Override
    public boolean hasNext() {
        return this.overallOffset > 0;
    }

    @Override
    public boolean hasPrevious() {
        return this.pos < this.path.size() - 1;
    }
}

