/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.TransitionCondition;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

public class Edge
implements Comparable<Edge> {
    private final String source;
    private final String target;
    private final TransitionCondition label;
    private final int hashCode;

    public Edge(String pSource, String pTarget, TransitionCondition pLabel) {
        Preconditions.checkNotNull((Object)pSource);
        Preconditions.checkNotNull((Object)pTarget);
        Preconditions.checkNotNull((Object)pLabel);
        this.source = pSource;
        this.target = pTarget;
        this.label = pLabel;
        this.hashCode = Objects.hash(this.label, this.source, this.target);
    }

    public String toString() {
        return String.format("{%s -- %s --> %s}", this.source, this.label, this.target);
    }

    @Override
    public int compareTo(Edge pO) {
        return ComparisonChain.start().compare((Comparable)((Object)this.source), (Comparable)((Object)pO.source)).compare((Comparable)((Object)this.target), (Comparable)((Object)pO.target)).compare((Comparable)this.label, (Comparable)pO.label).result();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof Edge) {
            Edge other = (Edge)pOther;
            return this.hashCode == other.hashCode && this.source.equals(other.source) && this.target.equals(other.target) && this.label.equals(other.label);
        }
        return false;
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public TransitionCondition getLabel() {
        return this.label;
    }

    public Optional<Edge> tryMerge(Edge pOther) {
        if (!this.source.equals(pOther.source) || !this.target.equals(pOther.target)) {
            return Optional.empty();
        }
        MapDifference difference = Maps.difference(this.label.getMapping(), pOther.label.getMapping());
        if (!difference.entriesOnlyOnLeft().isEmpty() || !difference.entriesOnlyOnRight().isEmpty()) {
            return Optional.empty();
        }
        TransitionCondition newLabel = pOther.label;
        Optional<TransitionCondition.Scope> newScope = this.label.getScope().mergeWith(newLabel.getScope());
        if (!newScope.isPresent()) {
            return Optional.empty();
        }
        newLabel = newLabel.withScope(newScope.orElseThrow());
        newLabel = newLabel.putAllAndCopy(this.label);
        for (Map.Entry diffEntry : difference.entriesDiffering().entrySet()) {
            String result;
            AutomatonGraphmlCommon.KeyDef key = (AutomatonGraphmlCommon.KeyDef)((Object)diffEntry.getKey());
            MapDifference.ValueDifference diff = (MapDifference.ValueDifference)diffEntry.getValue();
            switch (key) {
                case STARTLINE: 
                case OFFSET: {
                    int lowA = Integer.parseInt((String)diff.leftValue());
                    int lowB = Integer.parseInt((String)diff.rightValue());
                    result = Integer.toString(Math.min(lowA, lowB));
                    break;
                }
                case ENDLINE: 
                case ENDOFFSET: {
                    int highA = Integer.parseInt((String)diff.leftValue());
                    int highB = Integer.parseInt((String)diff.rightValue());
                    result = Integer.toString(Math.max(highA, highB));
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            newLabel = newLabel.putAndCopy(key, result);
        }
        return Optional.of(new Edge(this.source, this.target, newLabel));
    }
}

