/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.EdgeAppender;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.Pair;

enum GraphBuilder {
    ARG_PATH{

        @Override
        public String getId(ARGState pState) {
            return this.getId(pState, "");
        }

        private String getId(ARGState pState, String pIdentPostfix) {
            return String.format("A%d%s", pState.getStateId(), pIdentPostfix);
        }

        private String getId(ARGState pState, int pSubStateNo, int pSubStateCount) {
            return this.getId(pState, String.format("_%d_%d", pSubStateNo, pSubStateCount));
        }

        @Override
        public void buildGraph(ARGState pRootState, Predicate<? super ARGState> pPathStates, BiPredicate<ARGState, ARGState> pIsRelevantEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, Map<ARGState, CFAEdgeWithAdditionalInfo> pAdditionalInfo, Iterable<Pair<ARGState, Iterable<ARGState>>> pARGEdges, EdgeAppender pEdgeAppender) throws InterruptedException {
            int multiEdgeCount = 0;
            for (Pair<ARGState, Iterable<ARGState>> argEdges : pARGEdges) {
                ARGState s = argEdges.getFirst();
                if (!s.equals(pRootState) && s.getParents().stream().noneMatch(p -> pIsRelevantEdge.test((ARGState)p, s))) continue;
                String sourceStateNodeId = this.getId(s);
                for (ARGState child : argEdges.getSecond()) {
                    CFAEdge edgeToNextState;
                    String childStateId = this.getId(child);
                    List<CFAEdge> allEdgeToNextState = s.getEdgesToChild(child);
                    String prevStateId = sourceStateNodeId;
                    if (allEdgeToNextState.isEmpty()) {
                        edgeToNextState = null;
                    } else if (allEdgeToNextState.size() == 1) {
                        edgeToNextState = (CFAEdge)Iterables.getOnlyElement(allEdgeToNextState);
                    } else {
                        ++multiEdgeCount;
                        for (int i = 0; i < allEdgeToNextState.size() - 1; ++i) {
                            CFAEdge innerEdge = allEdgeToNextState.get(i);
                            String pseudoStateId = this.getId(child, i, multiEdgeCount);
                            assert (!(innerEdge instanceof AssumeEdge));
                            boolean isAssumptionAvailableForEdge = Iterables.any((Iterable)pValueMap.get((Object)s), a -> a.getCFAEdge().equals(innerEdge));
                            Optional<Collection<ARGState>> absentStates = isAssumptionAvailableForEdge ? Optional.of(Collections.singleton(s)) : Optional.empty();
                            pEdgeAppender.appendNewEdge(prevStateId, pseudoStateId, innerEdge, absentStates, pValueMap, CFAEdgeWithAdditionalInfo.of(innerEdge));
                            prevStateId = pseudoStateId;
                        }
                        edgeToNextState = allEdgeToNextState.get(allEdgeToNextState.size() - 1);
                    }
                    Optional<Collection<ARGState>> state = Optional.of(Collections.singleton(s));
                    if (pPathStates.apply((Object)child) && pIsRelevantEdge.test(s, child)) {
                        pEdgeAppender.appendNewEdge(prevStateId, childStateId, edgeToNextState, state, pValueMap, pAdditionalInfo.get(s));
                        if (!(edgeToNextState instanceof AssumeEdge)) continue;
                        AssumeEdge assumeEdge = (AssumeEdge)edgeToNextState;
                        AssumeEdge siblingEdge = CFAUtils.getComplimentaryAssumeEdge(assumeEdge);
                        boolean addArtificialSinkEdge = true;
                        for (ARGState sibling : s.getChildren()) {
                            if (Objects.equals(sibling, child) || !siblingEdge.equals(s.getEdgeToChild(sibling)) || !pIsRelevantEdge.test(s, sibling)) continue;
                            addArtificialSinkEdge = false;
                            break;
                        }
                        if (!addArtificialSinkEdge) continue;
                        pEdgeAppender.appendNewEdgeToSink(prevStateId, siblingEdge, state, pValueMap, pAdditionalInfo.get(s));
                        continue;
                    }
                    pEdgeAppender.appendNewEdgeToSink(prevStateId, edgeToNextState, state, pValueMap, pAdditionalInfo.get(s));
                }
            }
        }
    }
    ,
    CFA_FROM_ARG{

        @Override
        public String getId(ARGState pState) {
            return Joiner.on((String)",").join(AbstractStates.extractLocations(pState));
        }

        @Override
        public void buildGraph(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, Map<ARGState, CFAEdgeWithAdditionalInfo> pAdditionalInfo, Iterable<Pair<ARGState, Iterable<ARGState>>> pARGEdges, EdgeAppender pEdgeAppender) throws InterruptedException {
            CFANode rootNode = (CFANode)Iterables.getOnlyElement(AbstractStates.extractLocations(pRootState));
            HashSet<CFANode> subProgramNodes = new HashSet<CFANode>();
            HashMultimap states = HashMultimap.create();
            subProgramNodes.add(rootNode);
            for (Pair<ARGState, Iterable<ARGState>> edge : pARGEdges) {
                for (ARGState target : edge.getSecond()) {
                    if (!pIsRelevantState.apply((Object)target) || !pIsRelevantEdge.test(edge.getFirst(), target)) continue;
                    for (CFANode location : AbstractStates.extractLocations(target)) {
                        subProgramNodes.add(location);
                        states.put((Object)location, (Object)target);
                    }
                }
            }
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            HashSet<CFANode> visited = new HashSet<CFANode>();
            waitlist.offer(rootNode);
            visited.add(rootNode);
            while (!waitlist.isEmpty()) {
                CFANode current = (CFANode)waitlist.poll();
                for (CFAEdge leavingEdge : CFAUtils.leavingEdges(current)) {
                    Object locationStates;
                    CFANode successor = leavingEdge.getSuccessor();
                    boolean tryAddToWaitlist = false;
                    if (subProgramNodes.contains(successor)) {
                        locationStates = states.get((Object)successor);
                        tryAddToWaitlist = true;
                    } else {
                        locationStates = ImmutableSet.of();
                    }
                    boolean appended = GraphBuilder.appendEdge(pEdgeAppender, leavingEdge, Optional.of(locationStates), pValueMap);
                    if (!tryAddToWaitlist || !appended || !visited.add(successor)) continue;
                    waitlist.offer(successor);
                }
            }
        }
    }
    ,
    CFA_FULL{

        @Override
        public String getId(ARGState pState) {
            return Joiner.on((String)",").join(AbstractStates.extractLocations(pState));
        }

        @Override
        public void buildGraph(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, Map<ARGState, CFAEdgeWithAdditionalInfo> pAdditionalInfo, Iterable<Pair<ARGState, Iterable<ARGState>>> pARGEdges, EdgeAppender pEdgeAppender) throws InterruptedException {
            CFANode rootNode = (CFANode)Iterables.getOnlyElement(AbstractStates.extractLocations(pRootState));
            HashSet<CFANode> subProgramNodes = new HashSet<CFANode>();
            HashMultimap states = HashMultimap.create();
            subProgramNodes.add(rootNode);
            for (Pair<ARGState, Iterable<ARGState>> edge : pARGEdges) {
                for (ARGState target : edge.getSecond()) {
                    if (!pIsRelevantState.apply((Object)target) || !pIsRelevantEdge.test(edge.getFirst(), target)) continue;
                    for (CFANode location : AbstractStates.extractLocations(target)) {
                        subProgramNodes.add(location);
                        states.put((Object)location, (Object)target);
                    }
                }
            }
            ArrayDeque<CFANode> waitlist = new ArrayDeque<CFANode>();
            HashSet<CFANode> visited = new HashSet<CFANode>();
            waitlist.offer(rootNode);
            visited.add(rootNode);
            HashSet<CFAEdge> appended = new HashSet<CFAEdge>();
            while (!waitlist.isEmpty()) {
                CFANode current = (CFANode)waitlist.poll();
                for (CFAEdge leavingEdge : CFAUtils.leavingEdges(current)) {
                    CFANode successor = leavingEdge.getSuccessor();
                    Optional<Object> locationStates = subProgramNodes.contains(successor) ? Optional.of(states.get((Object)successor)) : Optional.empty();
                    if (visited.add(successor)) {
                        waitlist.offer(successor);
                    }
                    if (!appended.add(leavingEdge)) continue;
                    GraphBuilder.appendEdge(pEdgeAppender, leavingEdge, locationStates, pValueMap);
                }
                for (CFAEdge enteringEdge : CFAUtils.enteringEdges(current)) {
                    CFANode predecessor = enteringEdge.getPredecessor();
                    CFANode successor = enteringEdge.getSuccessor();
                    Optional<Object> locationStates = subProgramNodes.contains(successor) ? Optional.of(states.get((Object)successor)) : Optional.empty();
                    if (visited.add(predecessor)) {
                        waitlist.offer(predecessor);
                    }
                    if (!appended.add(enteringEdge)) continue;
                    GraphBuilder.appendEdge(pEdgeAppender, enteringEdge, locationStates, pValueMap);
                }
            }
        }
    };


    private static boolean appendEdge(EdgeAppender pEdgeAppender, CFAEdge pEdge, Optional<Collection<ARGState>> pStates, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) throws InterruptedException {
        String sourceId = pEdge.getPredecessor().toString();
        String targetId = pEdge.getSuccessor().toString();
        if (!(pEdge instanceof CFunctionSummaryStatementEdge)) {
            pEdgeAppender.appendNewEdge(sourceId, targetId, pEdge, pStates, pValueMap, CFAEdgeWithAdditionalInfo.of(pEdge));
            return true;
        }
        return false;
    }

    public abstract String getId(ARGState var1);

    public abstract void buildGraph(ARGState var1, Predicate<? super ARGState> var2, BiPredicate<ARGState, ARGState> var3, Multimap<ARGState, CFAEdgeWithAssumptions> var4, Map<ARGState, CFAEdgeWithAdditionalInfo> var5, Iterable<Pair<ARGState, Iterable<ARGState>>> var6, EdgeAppender var7) throws InterruptedException;
}

