/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

public class TransitionCondition
implements Comparable<TransitionCondition> {
    private static final TransitionCondition EMPTY = new TransitionCondition();
    private final EnumMap<AutomatonGraphmlCommon.KeyDef, String> keyValues;
    private final Scope scope;
    private int hashCode = 0;

    private TransitionCondition() {
        this.keyValues = new EnumMap(AutomatonGraphmlCommon.KeyDef.class);
        this.scope = new Scope(Optional.empty(), (Map<String, ASimpleDeclaration>)ImmutableMap.of());
    }

    private TransitionCondition(EnumMap<AutomatonGraphmlCommon.KeyDef, String> pKeyValues, Scope pScope) {
        this.keyValues = pKeyValues;
        this.scope = pScope;
    }

    public TransitionCondition putAndCopy(AutomatonGraphmlCommon.KeyDef pKey, String pValue) {
        if (pValue.equals(this.keyValues.get((Object)pKey))) {
            return this;
        }
        Object newMap = this.keyValues.clone();
        ((EnumMap)newMap).put(pKey, pValue);
        return new TransitionCondition((EnumMap<AutomatonGraphmlCommon.KeyDef, String>)newMap, this.scope);
    }

    public TransitionCondition putAllAndCopy(TransitionCondition tc) {
        Optional<Scope> newScope = this.scope.mergeWith(tc.scope);
        Preconditions.checkArgument((boolean)newScope.isPresent(), (Object)"Cannot merge transitions due to conflicting scopes.");
        Object newMap = null;
        for (Map.Entry<AutomatonGraphmlCommon.KeyDef, String> e : this.keyValues.entrySet()) {
            if (tc.keyValues.containsKey((Object)e.getKey())) continue;
            if (newMap == null) {
                newMap = tc.keyValues.clone();
            }
            ((EnumMap)newMap).put(e.getKey(), e.getValue());
        }
        return newMap == null ? tc : new TransitionCondition((EnumMap<AutomatonGraphmlCommon.KeyDef, String>)newMap, newScope.orElseThrow());
    }

    public TransitionCondition removeAndCopy(AutomatonGraphmlCommon.KeyDef pKey) {
        if (this.keyValues.containsKey((Object)pKey)) {
            Object newMap = this.keyValues.clone();
            ((EnumMap)newMap).remove((Object)pKey);
            return new TransitionCondition((EnumMap<AutomatonGraphmlCommon.KeyDef, String>)newMap, this.scope);
        }
        return this;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        return pOther instanceof TransitionCondition && this.keyValues.equals((Object)((TransitionCondition)pOther).keyValues) && this.scope.equals(((TransitionCondition)pOther).scope);
    }

    public Map<AutomatonGraphmlCommon.KeyDef, String> getMapping() {
        return this.keyValues;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean hasTransitionRestrictions() {
        return !this.keyValues.isEmpty();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.keyValues.hashCode() * 31 + this.scope.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this.keyValues.toString();
    }

    public boolean summarizes(TransitionCondition pLabel) {
        EnumSet<AutomatonGraphmlCommon.KeyDef> keyDefs;
        boolean ignoreInvariantScope;
        if (this.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY) || this.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT) || pLabel.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY) || pLabel.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT)) {
            return false;
        }
        if (this.equals(pLabel)) {
            return true;
        }
        boolean ignoreAssumptionScope = !this.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.ASSUMPTION) || !pLabel.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.ASSUMPTION);
        boolean bl = ignoreInvariantScope = !this.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.INVARIANT) || !pLabel.keyValues.containsKey((Object)AutomatonGraphmlCommon.KeyDef.INVARIANT);
        if (!this.keyValues.isEmpty()) {
            keyDefs = EnumSet.copyOf(this.keyValues.keySet());
            keyDefs.addAll(pLabel.keyValues.keySet());
        } else {
            keyDefs = EnumSet.copyOf(pLabel.keyValues.keySet());
        }
        keyDefs.remove((Object)AutomatonGraphmlCommon.KeyDef.ASSUMPTION);
        keyDefs.remove((Object)AutomatonGraphmlCommon.KeyDef.INVARIANT);
        if (ignoreAssumptionScope) {
            keyDefs.remove((Object)AutomatonGraphmlCommon.KeyDef.ASSUMPTIONSCOPE);
            keyDefs.remove((Object)AutomatonGraphmlCommon.KeyDef.ASSUMPTIONRESULTFUNCTION);
        }
        if (ignoreInvariantScope) {
            keyDefs.remove((Object)AutomatonGraphmlCommon.KeyDef.INVARIANTSCOPE);
        }
        for (AutomatonGraphmlCommon.KeyDef keyDef : keyDefs) {
            if (Objects.equals(this.keyValues.get((Object)keyDef), pLabel.keyValues.get((Object)keyDef))) continue;
            return false;
        }
        return this.scope.mergeWith(pLabel.scope).isPresent();
    }

    @Override
    public int compareTo(TransitionCondition pO) {
        if (this == pO) {
            return 0;
        }
        Iterator<Map.Entry<AutomatonGraphmlCommon.KeyDef, String>> entryIterator = this.keyValues.entrySet().iterator();
        Iterator<Map.Entry<AutomatonGraphmlCommon.KeyDef, String>> otherEntryIterator = pO.keyValues.entrySet().iterator();
        while (entryIterator.hasNext() && otherEntryIterator.hasNext()) {
            Map.Entry<AutomatonGraphmlCommon.KeyDef, String> entry = entryIterator.next();
            Map.Entry<AutomatonGraphmlCommon.KeyDef, String> otherEntry = otherEntryIterator.next();
            int compKey = entry.getKey().compareTo(otherEntry.getKey());
            if (compKey != 0) {
                return compKey;
            }
            int compVal = entry.getValue().compareTo(otherEntry.getValue());
            if (compVal == 0) continue;
            return compVal;
        }
        if (!entryIterator.hasNext()) {
            return -1;
        }
        if (!otherEntryIterator.hasNext()) {
            return 1;
        }
        return this.scope.compareTo(pO.scope);
    }

    public static TransitionCondition empty() {
        return EMPTY;
    }

    public TransitionCondition withScope(Scope pScope) {
        if (pScope == this.scope) {
            return this;
        }
        return new TransitionCondition(this.keyValues, pScope);
    }

    private static boolean isGlobalVarDecl(@Nullable ASimpleDeclaration pDecl) {
        if (pDecl instanceof AVariableDeclaration) {
            AVariableDeclaration varDecl = (AVariableDeclaration)pDecl;
            return varDecl.isGlobal();
        }
        return false;
    }

    static class Scope
    implements Comparable<Scope> {
        private final Optional<String> functionName;
        private final ImmutableMap<String, ASimpleDeclaration> usedDeclarations;

        private Scope(Optional<String> pFunctionName, Map<String, ASimpleDeclaration> pUsedDeclarations) {
            this.functionName = pFunctionName;
            this.usedDeclarations = ImmutableMap.copyOf(pUsedDeclarations);
            for (ASimpleDeclaration decl : pUsedDeclarations.values()) {
                if (!(decl instanceof AVariableDeclaration)) continue;
                AVariableDeclaration varDecl = (AVariableDeclaration)decl;
                Preconditions.checkArgument((varDecl.isGlobal() || this.functionName.isPresent() ? 1 : 0) != 0, (Object)"Cannot create a global scope with non-global variable declarations.");
            }
        }

        public boolean isGlobal() {
            return !this.functionName.isPresent();
        }

        public String getFunctionName() {
            return this.functionName.orElseThrow();
        }

        public Collection<ASimpleDeclaration> getUsedDeclarations() {
            return this.usedDeclarations.values();
        }

        public int hashCode() {
            return this.usedDeclarations.hashCode() * 31 + this.functionName.hashCode();
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof Scope) {
                Scope other = (Scope)pOther;
                return this.functionName.equals(other.functionName) && this.usedDeclarations.equals(other.usedDeclarations);
            }
            return false;
        }

        public String toString() {
            Object prefix = this.isGlobal() ? "" : this.getFunctionName() + ": ";
            return (String)prefix + this.usedDeclarations;
        }

        @Override
        public int compareTo(Scope pOther) {
            return ComparisonChain.start().compareTrueFirst(this.isGlobal(), pOther.isGlobal()).compare((Comparable)((Object)this.functionName.orElseThrow()), (Comparable)((Object)pOther.functionName.orElseThrow())).compare(this.usedDeclarations, pOther.usedDeclarations, (a, b) -> {
                UnmodifiableIterator aIt = a.entrySet().iterator();
                UnmodifiableIterator bIt = b.entrySet().iterator();
                while (aIt.hasNext() && bIt.hasNext()) {
                    Map.Entry aEntry = (Map.Entry)aIt.next();
                    Map.Entry bEntry = (Map.Entry)bIt.next();
                    int entryComp = ComparisonChain.start().compare((Comparable)aEntry.getKey(), (Comparable)bEntry.getKey()).compare((Comparable)((Object)((ASimpleDeclaration)aEntry.getValue()).getQualifiedName()), (Comparable)((Object)((ASimpleDeclaration)bEntry.getValue()).getQualifiedName())).result();
                    if (entryComp == 0) continue;
                    return entryComp;
                }
                if (aIt.hasNext()) {
                    return -1;
                }
                if (bIt.hasNext()) {
                    return 1;
                }
                return 0;
            }).result();
        }

        public Optional<Scope> extendBy(Optional<String> pNewFunctionName, Collection<ASimpleDeclaration> pUsedDeclarations) {
            Optional<String> newFunctionName;
            if (pNewFunctionName.isPresent()) {
                if (this.functionName.isPresent() && !this.functionName.orElseThrow().equals(pNewFunctionName.orElseThrow())) {
                    return Optional.empty();
                }
                if (!this.functionName.isPresent() && !this.usedDeclarations.isEmpty()) {
                    return Optional.empty();
                }
                newFunctionName = pNewFunctionName;
            } else {
                if (pUsedDeclarations.isEmpty()) {
                    return Optional.of(this);
                }
                newFunctionName = this.functionName;
            }
            TreeMap<String, ASimpleDeclaration> newUsed = new TreeMap<String, ASimpleDeclaration>((Map<String, ASimpleDeclaration>)this.usedDeclarations);
            for (ASimpleDeclaration decl : pUsedDeclarations) {
                boolean isGlobalVarDecl = TransitionCondition.isGlobalVarDecl(decl);
                if (!isGlobalVarDecl && !newFunctionName.isPresent()) {
                    return Optional.empty();
                }
                String potentiallyAmbiguousName = decl.getOrigName();
                ASimpleDeclaration conflictingDecl = (ASimpleDeclaration)newUsed.get(potentiallyAmbiguousName);
                if (conflictingDecl == null) {
                    newUsed.put(potentiallyAmbiguousName, decl);
                    continue;
                }
                if (decl.equals(conflictingDecl)) continue;
                return Optional.empty();
            }
            return Optional.of(new Scope(newFunctionName, newUsed));
        }

        public Optional<Scope> mergeWith(Scope pOther) {
            return this.extendBy(pOther.functionName, pOther.getUsedDeclarations());
        }
    }
}

