/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessOptions;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class Witness {
    private final AutomatonGraphmlCommon.WitnessType witnessType;
    private final String originFile;
    private final CFA cfa;
    private final VerificationTaskMetaData metaData;
    private final String entryStateNodeId;
    private final Multimap<String, Edge> leavingEdges;
    private final Multimap<String, Edge> enteringEdges;
    private final WitnessOptions witnessOptions;
    private final SetMultimap<String, AutomatonGraphmlCommon.NodeFlag> nodeFlags;
    private final Multimap<String, Targetable.TargetInformation> violatedProperties;
    private final Map<String, ExpressionTree<Object>> stateInvariants;
    private final Map<String, ExpressionTree<Object>> stateQuasiInvariants;
    private final Map<String, String> stateScopes;
    private final Set<String> invariantExportStates;
    private final Multimap<String, ARGState> stateToARGStates;
    private final Multimap<Edge, CFAEdge> edgeToCFAEdges;

    public Witness(AutomatonGraphmlCommon.WitnessType pWitnessType, String pOriginFile, CFA pCfa, VerificationTaskMetaData pMetaData, String pEntryStateNodeId, Multimap<String, Edge> pLeavingEdges, Multimap<String, Edge> pEnteringEdges, WitnessOptions pWitnessOptions, SetMultimap<String, AutomatonGraphmlCommon.NodeFlag> pNodeFlags, Multimap<String, Targetable.TargetInformation> pViolatedProperties, Map<String, ExpressionTree<Object>> pStateInvariants, Map<String, ExpressionTree<Object>> pStateQuasiInvariants, Map<String, String> pStateScopes, Set<String> pInvariantExportStates, Multimap<String, ARGState> pStateToARGStates, Multimap<Edge, CFAEdge> pEdgeToCFAEdges) {
        this.witnessType = pWitnessType;
        this.originFile = pOriginFile;
        this.cfa = pCfa;
        this.metaData = pMetaData;
        this.entryStateNodeId = pEntryStateNodeId;
        this.leavingEdges = ImmutableListMultimap.copyOf(pLeavingEdges);
        this.enteringEdges = ImmutableListMultimap.copyOf(pEnteringEdges);
        this.witnessOptions = pWitnessOptions;
        this.nodeFlags = ImmutableSetMultimap.copyOf(pNodeFlags);
        this.violatedProperties = ImmutableListMultimap.copyOf(pViolatedProperties);
        this.stateInvariants = ImmutableMap.copyOf(pStateInvariants);
        this.stateQuasiInvariants = ImmutableMap.copyOf(pStateQuasiInvariants);
        this.stateScopes = ImmutableMap.copyOf(pStateScopes);
        this.invariantExportStates = ImmutableSet.copyOf(pInvariantExportStates);
        this.stateToARGStates = ImmutableListMultimap.copyOf(pStateToARGStates);
        this.edgeToCFAEdges = ImmutableListMultimap.copyOf(pEdgeToCFAEdges);
    }

    public AutomatonGraphmlCommon.WitnessType getWitnessType() {
        return this.witnessType;
    }

    public String getOriginFile() {
        return this.originFile;
    }

    public CFA getCfa() {
        return this.cfa;
    }

    public VerificationTaskMetaData getMetaData() {
        return this.metaData;
    }

    public String getEntryStateNodeId() {
        return this.entryStateNodeId;
    }

    public Multimap<String, Edge> getLeavingEdges() {
        return this.leavingEdges;
    }

    public Multimap<String, Edge> getEnteringEdges() {
        return this.enteringEdges;
    }

    public WitnessOptions getWitnessOptions() {
        return this.witnessOptions;
    }

    public SetMultimap<String, AutomatonGraphmlCommon.NodeFlag> getNodeFlags() {
        return this.nodeFlags;
    }

    public Multimap<String, Targetable.TargetInformation> getViolatedProperties() {
        return this.violatedProperties;
    }

    public ExpressionTree<Object> getStateInvariant(String pStateId) {
        ExpressionTree<Object> result = this.stateInvariants.get(pStateId);
        if (result == null) {
            return ExpressionTrees.getTrue();
        }
        return result;
    }

    public boolean hasQuasiInvariant(String pEntryStateNodeId) {
        return this.stateQuasiInvariants.containsKey(pEntryStateNodeId);
    }

    public ExpressionTree<Object> getQuasiInvariant(String pNodeId) {
        ExpressionTree<Object> result = this.stateQuasiInvariants.get(pNodeId);
        if (result == null) {
            return ExpressionTrees.getFalse();
        }
        return result;
    }

    public Map<String, String> getStateScopes() {
        return this.stateScopes;
    }

    public Set<String> getInvariantExportStates() {
        return this.invariantExportStates;
    }

    public Collection<ARGState> getARGStatesFor(String id) {
        if (this.stateToARGStates.containsKey((Object)id)) {
            return this.stateToARGStates.get((Object)id);
        }
        return ImmutableList.of();
    }

    public List<CFAEdge> getCFAEdgeFor(Edge edge) {
        if (this.edgeToCFAEdges.containsKey((Object)edge)) {
            return ImmutableList.copyOf((Collection)this.edgeToCFAEdges.get((Object)edge));
        }
        return ImmutableList.of();
    }
}

