/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.DefaultCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.IsConstantExpressionVisitor;
import org.sosy_lab.cpachecker.exceptions.NoException;

class WitnessAssumptionFilter {
    WitnessAssumptionFilter() {
    }

    static CFAEdgeWithAssumptions filterRelevantAssumptions(CFAEdgeWithAssumptions pEdgeWithAssumptions) {
        int originalSize = pEdgeWithAssumptions.getExpStmts().size();
        ImmutableList.Builder expressionStatementsBuilder = ImmutableList.builderWithExpectedSize((int)originalSize);
        for (AExpressionStatement expressionStatement : pEdgeWithAssumptions.getExpStmts()) {
            if (!WitnessAssumptionFilter.isRelevantExpression(expressionStatement.getExpression())) continue;
            expressionStatementsBuilder.add((Object)expressionStatement);
        }
        ImmutableList expressionStatements = expressionStatementsBuilder.build();
        if (expressionStatements.size() == originalSize) {
            return pEdgeWithAssumptions;
        }
        return new CFAEdgeWithAssumptions(pEdgeWithAssumptions.getCFAEdge(), (ImmutableCollection<AExpressionStatement>)expressionStatements, pEdgeWithAssumptions.getComment());
    }

    private static boolean isRelevantExpression(AExpression assumption) {
        if (!(assumption instanceof CBinaryExpression)) {
            return true;
        }
        CBinaryExpression binExpAssumption = (CBinaryExpression)assumption;
        CExpression leftSide = binExpAssumption.getOperand1();
        CExpression rightSide = binExpAssumption.getOperand2();
        CType leftType = leftSide.getExpressionType().getCanonicalType();
        CType rightType = rightSide.getExpressionType().getCanonicalType();
        if (!(leftType instanceof CVoidType) || !(rightType instanceof CVoidType)) {
            boolean rightIsAccepted;
            boolean equalTypes = leftType.equals(rightType);
            boolean leftIsAccepted = equalTypes || leftType instanceof CSimpleType;
            boolean bl = rightIsAccepted = equalTypes || rightType instanceof CSimpleType;
            if (leftIsAccepted && rightIsAccepted) {
                boolean rightIsPointer;
                boolean leftIsConstant = WitnessAssumptionFilter.isConstant(leftSide);
                boolean leftIsPointer = !leftIsConstant && WitnessAssumptionFilter.isEffectivelyPointer(leftSide);
                boolean rightIsConstant = WitnessAssumptionFilter.isConstant(rightSide);
                boolean bl2 = rightIsPointer = !rightIsConstant && WitnessAssumptionFilter.isEffectivelyPointer(rightSide);
                if (!(leftIsPointer && rightIsConstant || leftIsConstant && rightIsPointer)) {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConstant(CExpression pLeftSide) {
        return pLeftSide.accept(IsConstantExpressionVisitor.INSTANCE);
    }

    private static boolean isEffectivelyPointer(CExpression pLeftSide) {
        return pLeftSide.accept(new DefaultCExpressionVisitor<Boolean, NoException>(){

            @Override
            public Boolean visit(CComplexCastExpression pComplexCastExpression) {
                return pComplexCastExpression.getOperand().accept(this);
            }

            @Override
            public Boolean visit(CBinaryExpression pIastBinaryExpression) {
                return pIastBinaryExpression.getOperand1().accept(this) != false || pIastBinaryExpression.getOperand2().accept(this) != false;
            }

            @Override
            public Boolean visit(CCastExpression pIastCastExpression) {
                return pIastCastExpression.getOperand().accept(this);
            }

            @Override
            public Boolean visit(CUnaryExpression pIastUnaryExpression) {
                switch (pIastUnaryExpression.getOperator()) {
                    case MINUS: 
                    case TILDE: {
                        return pIastUnaryExpression.getOperand().accept(this);
                    }
                    case AMPER: {
                        return true;
                    }
                }
                return this.visitDefault(pIastUnaryExpression);
            }

            @Override
            protected Boolean visitDefault(CExpression pExp) {
                CType type = pExp.getExpressionType().getCanonicalType();
                return type instanceof CPointerType || type instanceof CFunctionType;
            }
        });
    }
}

