/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.function.BiPredicate;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ExpressionTreeReportingState;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.GraphBuilder;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.InvariantProvider;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessFactory;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessOptions;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.Simplifier;

public class WitnessExporter {
    protected final WitnessOptions options;
    protected final CFA cfa;
    protected final LogManager logger;
    protected final ExpressionTreeFactory<Object> factory = ExpressionTrees.newFactory();
    protected final Simplifier<Object> simplifier = ExpressionTrees.newSimplifier(this.factory);
    protected final VerificationTaskMetaData verificationTaskMetaData;

    public WitnessExporter(Configuration pConfig, LogManager pLogger, Specification pSpecification, CFA pCFA) throws InvalidConfigurationException {
        Preconditions.checkNotNull((Object)pConfig);
        this.options = new WitnessOptions();
        pConfig.inject((Object)this.options);
        this.cfa = pCFA;
        this.logger = pLogger;
        this.verificationTaskMetaData = new VerificationTaskMetaData(pConfig, pSpecification);
    }

    public ProofInvariantProvider getProofInvariantProvider() {
        return new ProofInvariantProvider(this.cfa, this.factory);
    }

    public Witness generateErrorWitness(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, CounterexampleInfo pCounterExample) throws InterruptedException {
        String defaultFileName = this.getInitialFileName(pRootState);
        WitnessFactory writer = new WitnessFactory(this.options, this.cfa, this.logger, this.verificationTaskMetaData, this.factory, this.simplifier, defaultFileName, AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS, InvariantProvider.TrueInvariantProvider.INSTANCE);
        return writer.produceWitness(pRootState, pIsRelevantState, pIsRelevantEdge, (Predicate<? super ARGState>)Predicates.alwaysFalse(), Optional.empty(), Optional.ofNullable(pCounterExample), GraphBuilder.ARG_PATH);
    }

    public Witness generateTerminationErrorWitness(ARGState pRoot, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, Predicate<? super ARGState> pIsCycleHead, Function<? super ARGState, ExpressionTree<Object>> toQuasiInvariant) throws InterruptedException {
        String defaultFileName = this.getInitialFileName(pRoot);
        WitnessFactory writer = new WitnessFactory(this.options, this.cfa, this.logger, this.verificationTaskMetaData, this.factory, this.simplifier, defaultFileName, AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS, InvariantProvider.TrueInvariantProvider.INSTANCE);
        return writer.produceWitness(pRoot, pIsRelevantState, pIsRelevantEdge, pIsCycleHead, Optional.of(toQuasiInvariant), Optional.empty(), GraphBuilder.ARG_PATH);
    }

    public Witness generateProofWitness(ARGState pRootState, Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, InvariantProvider pInvariantProvider) throws InterruptedException {
        Preconditions.checkNotNull((Object)pRootState);
        Preconditions.checkNotNull(pIsRelevantState);
        Preconditions.checkNotNull(pIsRelevantEdge);
        Preconditions.checkNotNull((Object)pInvariantProvider);
        String defaultFileName = this.getInitialFileName(pRootState);
        WitnessFactory writer = new WitnessFactory(this.options, this.cfa, this.logger, this.verificationTaskMetaData, this.factory, this.simplifier, defaultFileName, AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS, pInvariantProvider);
        return writer.produceWitness(pRootState, pIsRelevantState, pIsRelevantEdge, (Predicate<? super ARGState>)Predicates.alwaysFalse(), Optional.empty(), Optional.empty(), GraphBuilder.CFA_FULL);
    }

    protected String getInitialFileName(ARGState pRootState) {
        ArrayDeque worklist = Queues.newArrayDeque(AbstractStates.extractLocations(pRootState));
        HashSet<CFANode> visited = new HashSet<CFANode>();
        while (!worklist.isEmpty()) {
            CFANode l = (CFANode)worklist.pop();
            visited.add(l);
            for (CFAEdge e : CFAUtils.leavingEdges(l)) {
                ImmutableSet<FileLocation> fileLocations = CFAUtils.getFileLocationsFromCfaEdge(e);
                if (!fileLocations.isEmpty()) {
                    return ((FileLocation)fileLocations.iterator().next()).getFileName().toString();
                }
                if (visited.contains(e.getSuccessor())) continue;
                worklist.push(e.getSuccessor());
            }
        }
        throw new RuntimeException("Could not determine file name based on abstract state!");
    }

    private static final class ProofInvariantProvider
    implements InvariantProvider {
        private final ExpressionTreeFactory<Object> factory;
        private final CFA cfa;

        public ProofInvariantProvider(CFA pCfa, ExpressionTreeFactory<Object> pFactory) {
            this.cfa = pCfa;
            this.factory = pFactory;
        }

        @Override
        public ExpressionTree<Object> provideInvariantFor(CFAEdge pEdge, Optional<? extends Collection<? extends ARGState>> pStates) throws InterruptedException {
            if (!pStates.isPresent()) {
                return ExpressionTrees.getTrue();
            }
            LinkedHashSet stateInvariants = new LinkedHashSet();
            String functionName = pEdge.getSuccessor().getFunctionName();
            for (ARGState aRGState : pStates.get()) {
                LinkedHashSet approximations = new LinkedHashSet();
                for (ExpressionTreeReportingState etrs : AbstractStates.asIterable(aRGState).filter(ExpressionTreeReportingState.class)) {
                    approximations.add(etrs.getFormulaApproximation(this.cfa.getFunctionHead(functionName), pEdge.getSuccessor()));
                }
                stateInvariants.add(this.factory.and(approximations));
            }
            return this.factory.or(stateInvariants);
        }
    }
}

