/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.TestResults;

public class WitnessExporterTest {
    private static final Pattern PROOF_WITNESS_OPTION_PATTERN = Pattern.compile("(cpa.arg.proofWitness\\s*=\\s*)(.+)");
    private static final String SPECIFICATION_OPTION = "specification";
    private static final String TEST_DIR_PATH = "test/programs/witnessValidation/";

    @Test(timeout=90000L)
    public void multivar_true() throws Exception {
        new WitnessTester("multivar.i", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.K_INDUCTION).performTest();
    }

    @Test(timeout=90000L)
    public void multivar_true_2() throws Exception {
        new WitnessTester("multivar.i", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.PREDICATE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void max_true() throws Exception {
        new WitnessTester("max.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.VALUE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void minepump_spec1_product33_false() throws Exception {
        new WitnessTester("minepump_spec1_product33.cil.c", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.PREDICATE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void minepump_spec1_product33_false_2() throws Exception {
        new WitnessTester("minepump_spec1_product33.cil.c", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.K_INDUCTION).performTest();
    }

    @Test(timeout=90000L)
    @Ignore
    public void concurrency_false_fib_bench() throws Exception {
        new WitnessTester("fib_bench-2.i", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.BDD_CONCURRENCY).performTest();
    }

    @Test(timeout=200000L)
    @Ignore
    public void concurrency_false_mix000_power() throws Exception {
        new WitnessTester("mix000_power.oepc.i", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.BDD_CONCURRENCY).performTest();
    }

    @Test(timeout=90000L)
    public void rule60_list2_false() throws Exception {
        new WitnessTester("rule60_list2.i", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.PREDICATE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void rule60_list2_false_2() throws Exception {
        new WitnessTester("rule60_list2.i", CPATestRunner.ExpectedVerdict.FALSE, WitnessGenerationConfig.VALUE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void valueInvariant_true() throws Exception {
        new WitnessTester("valueInvariant.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.VALUE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void valueInvariant_true_2() throws Exception {
        new WitnessTester("valueInvariant.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.BAM).performTest();
    }

    @Test(timeout=90000L)
    public void max_true_2() throws Exception {
        new WitnessTester("max.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.BAM).performTest();
    }

    @Test(timeout=90000L)
    public void weekdays_true() throws Exception {
        new WitnessTester("weekdays.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.VALUE_ANALYSIS).performTest();
    }

    @Test(timeout=90000L)
    public void weekdays_no_termination_true() throws Exception {
        new WitnessTester("weekdays_no_termination.c", CPATestRunner.ExpectedVerdict.TRUE, WitnessGenerationConfig.VALUE_ANALYSIS).performTest();
    }

    private static void performTest(String pFilename, String pSpecification, CPATestRunner.ExpectedVerdict pExpected, WitnessGenerationConfig pGenerationConfig, Map<String, String> pOverrideOptions) throws Exception {
        String fullPath = Path.of(TEST_DIR_PATH, pFilename).toString();
        TempCompressedFilePath witnessPath = new TempCompressedFilePath("witness", ".graphml");
        AutomatonGraphmlCommon.WitnessType witnessType = WitnessExporterTest.generateWitness(fullPath, pExpected, pGenerationConfig, pSpecification, pOverrideOptions, witnessPath);
        WitnessExporterTest.validateWitness(fullPath, pSpecification, pExpected, pOverrideOptions, witnessPath, witnessType);
    }

    private static AutomatonGraphmlCommon.WitnessType generateWitness(String pFilePath, CPATestRunner.ExpectedVerdict pExpected, WitnessGenerationConfig pGenerationConfig, String pSpecification, Map<String, String> pOverrideOptions, TempCompressedFilePath pWitnessPath) throws Exception {
        LinkedHashMap<String, String> overrideOptions = new LinkedHashMap<String, String>(pOverrideOptions);
        overrideOptions.put("counterexample.export.graphml", pWitnessPath.uncompressedFilePath.toString());
        if (pGenerationConfig.equals((Object)WitnessGenerationConfig.K_INDUCTION)) {
            overrideOptions.put("bmc.invariantsExport", pWitnessPath.uncompressedFilePath.toString());
            overrideOptions.put("parallelAlgorithm.configFiles", "config/components/kInduction/kInduction.properties, " + WitnessExporterTest.getInvGenFile(pWitnessPath) + "::supply-reached-refinable");
        } else {
            overrideOptions.put("cpa.arg.proofWitness", pWitnessPath.uncompressedFilePath.toString());
        }
        if (pExpected.equals((Object)CPATestRunner.ExpectedVerdict.TRUE)) {
            overrideOptions.put("cpa.arg.compressWitness", "false");
        }
        Configuration generationConfig = WitnessExporterTest.getProperties(pGenerationConfig.fileName, overrideOptions, pSpecification);
        TestResults results = CPATestRunner.run(generationConfig, pFilePath);
        results.getCheckerResult().writeOutputFiles();
        switch (pExpected) {
            case TRUE: {
                results.assertIsSafe();
                return AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS;
            }
            case FALSE: {
                results.assertIsUnsafe();
                return AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS;
            }
        }
        Truth.assertWithMessage((String)"Cannot determine expected result.").fail();
        throw new AssertionError((Object)"Unreachable code.");
    }

    private static String getInvGenFile(TempCompressedFilePath pWitnessPath) throws IOException {
        Path origInvGenConfigFile = Path.of("test/config/invariantGeneration-witness.properties", new String[0]);
        Path invGenConfigFile = origInvGenConfigFile.resolveSibling(pWitnessPath.uncompressedFilePath.getFileName() + ".properties");
        invGenConfigFile.toFile().deleteOnExit();
        Files.copy(origInvGenConfigFile, invGenConfigFile, new CopyOption[0]);
        List<String> lines = Files.readAllLines(invGenConfigFile);
        try (Writer writer = IO.openOutputFile((Path)invGenConfigFile, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);){
            for (String line : lines) {
                Matcher matcher = PROOF_WITNESS_OPTION_PATTERN.matcher(line);
                if (matcher.matches()) {
                    writer.write(matcher.group(1));
                    writer.write(pWitnessPath.uncompressedFilePath.toString());
                } else {
                    writer.write(line);
                }
                writer.write(System.lineSeparator());
            }
        }
        return invGenConfigFile.toString();
    }

    private static void validateWitness(String pFilePath, String pSpecification, CPATestRunner.ExpectedVerdict pExpected, Map<String, String> pOverrideOptions, TempCompressedFilePath witnessPath, AutomatonGraphmlCommon.WitnessType witnessType) throws Exception {
        String validationConfigFile;
        LinkedHashMap<String, String> overrideOptions = new LinkedHashMap<String, String>(pOverrideOptions);
        String specification = pSpecification;
        switch (witnessType) {
            case CORRECTNESS_WITNESS: {
                validationConfigFile = "correctnessWitnessValidation.properties";
                overrideOptions.put("invariantGeneration.kInduction.invariantsAutomatonFile", witnessPath.uncompressedFilePath.toString());
                break;
            }
            case VIOLATION_WITNESS: {
                validationConfigFile = "violationWitnessValidation.properties";
                specification = Joiner.on((char)',').join((Object)specification, (Object)witnessPath.compressedFilePath.toString(), new Object[0]);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported witness type " + witnessType));
            }
        }
        Configuration validationConfig = WitnessExporterTest.getProperties(validationConfigFile, overrideOptions, specification);
        TestResults results = CPATestRunner.run(validationConfig, pFilePath);
        switch (pExpected) {
            case TRUE: {
                results.assertIsSafe();
                break;
            }
            case FALSE: {
                results.assertIsUnsafe();
                break;
            }
            default: {
                Truth.assertWithMessage((String)"Cannot determine expected result.").fail();
            }
        }
    }

    private static Configuration getProperties(String pConfigFile, Map<String, String> pOverrideOptions, String pSpecification) throws InvalidConfigurationException {
        ConfigurationBuilder configBuilder = TestDataTools.configurationForTest().loadFromResource(WitnessExporterTest.class, pConfigFile);
        if (!Strings.isNullOrEmpty((String)pSpecification)) {
            pOverrideOptions.put(SPECIFICATION_OPTION, pSpecification);
        }
        return configBuilder.setOptions(pOverrideOptions).build();
    }

    private static class WitnessTester {
        private final String programFile;
        private final CPATestRunner.ExpectedVerdict expected;
        private final WitnessGenerationConfig generationConfig;
        private String specificationFile = "config/specification/default.spc";
        private ImmutableMap.Builder<String, String> overrideOptionsBuilder = ImmutableMap.builder();

        private WitnessTester(String pProgramFile, CPATestRunner.ExpectedVerdict pExpected, WitnessGenerationConfig pGenerationConfig) {
            this.programFile = Objects.requireNonNull(pProgramFile);
            this.expected = pExpected;
            this.generationConfig = Objects.requireNonNull(pGenerationConfig);
        }

        @CanIgnoreReturnValue
        public WitnessTester forSpecification(String pSpecificationFile) {
            this.specificationFile = Objects.requireNonNull(pSpecificationFile);
            return this;
        }

        @CanIgnoreReturnValue
        public WitnessTester addOverrideOption(String pOptionName, String pOptionValue) {
            this.overrideOptionsBuilder.put((Object)pOptionName, (Object)pOptionValue);
            return this;
        }

        public void performTest() throws Exception {
            WitnessExporterTest.performTest(this.programFile, this.specificationFile, this.expected, this.generationConfig, (Map<String, String>)this.overrideOptionsBuilder.buildOrThrow());
        }
    }

    private static class TempCompressedFilePath {
        private final Path uncompressedFilePath;
        private final Path compressedFilePath;

        public TempCompressedFilePath(String pPrefix, String pSuffix) throws IOException {
            String compressedSuffix = ".gz";
            this.compressedFilePath = TempFile.builder().prefix(pPrefix).suffix(pSuffix + compressedSuffix).create().toAbsolutePath();
            Path compressedFileNamePath = this.compressedFilePath.getFileName();
            if (compressedFileNamePath == null) {
                throw new AssertionError((Object)"Files obtained from TempFile.builder().create() should always have a file name.");
            }
            String fileName = compressedFileNamePath.toString();
            String uncompressedFileName = fileName.substring(0, fileName.length() - compressedSuffix.length());
            this.uncompressedFilePath = this.compressedFilePath.resolveSibling(uncompressedFileName);
            this.uncompressedFilePath.toFile().deleteOnExit();
        }

        public String toString() {
            return this.compressedFilePath.toString();
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof TempCompressedFilePath) {
                return this.compressedFilePath.equals(((TempCompressedFilePath)pOther).compressedFilePath);
            }
            return false;
        }

        public int hashCode() {
            return this.compressedFilePath.hashCode();
        }
    }

    private static enum WitnessGenerationConfig {
        K_INDUCTION("kInduction"),
        BDD_CONCURRENCY("bddAnalysis-concurrency"),
        PREDICATE_ANALYSIS("predicateAnalysis"),
        VALUE_ANALYSIS("valueAnalysis"),
        BAM("valueAnalysis-predicateAnalysis-bam");

        private final String fileName;

        private WitnessGenerationConfig(String pConfigName) {
            this.fileName = String.format("witnessGeneration-%s.properties", pConfigName);
        }
    }
}

