/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.ASimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.postprocessing.global.CFACloner;
import org.sosy_lab.cpachecker.core.algorithm.fault_localization.by_unsatisfiability.FaultLocalizationInfoWithTraceFormula;
import org.sosy_lab.cpachecker.core.counterexample.CExpressionToOrinalCodeVisitor;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CFAEdgeWithAssumptions;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.acsl.ACSLState;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AdditionalInfoConverter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.AssignsParameterOfOtherFunction;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.DelayedAssignmentsKey;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.EdgeAppender;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.GraphBuilder;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.InvariantProvider;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.TransitionCondition;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessAssumptionFilter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.WitnessOptions;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateAbstractState;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.BiPredicates;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.NumericIdProvider;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.automaton.VerificationTaskMetaData;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.expressions.Simplifier;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultLocalizationInfo;

class WitnessFactory
implements EdgeAppender {
    private static final EnumSet<AutomatonGraphmlCommon.KeyDef> INSUFFICIENT_KEYS = EnumSet.of(AutomatonGraphmlCommon.KeyDef.SOURCECODE, new AutomatonGraphmlCommon.KeyDef[]{AutomatonGraphmlCommon.KeyDef.STARTLINE, AutomatonGraphmlCommon.KeyDef.ENDLINE, AutomatonGraphmlCommon.KeyDef.ORIGINFILE, AutomatonGraphmlCommon.KeyDef.OFFSET, AutomatonGraphmlCommon.KeyDef.ENDOFFSET, AutomatonGraphmlCommon.KeyDef.LINECOLS, AutomatonGraphmlCommon.KeyDef.ASSUMPTIONSCOPE, AutomatonGraphmlCommon.KeyDef.ASSUMPTIONRESULTFUNCTION, AutomatonGraphmlCommon.KeyDef.THREADNAME});
    private final WitnessOptions witnessOptions;
    private final CFA cfa;
    private final LogManager logger;
    private final VerificationTaskMetaData verificationTaskMetaData;
    private final ExpressionTreeFactory<Object> factory;
    private final Simplifier<Object> simplifier;
    private final SetMultimap<String, AutomatonGraphmlCommon.NodeFlag> nodeFlags = LinkedHashMultimap.create();
    private final Multimap<String, Targetable.TargetInformation> violatedProperties = HashMultimap.create();
    private final Map<DelayedAssignmentsKey, CFAEdgeWithAssumptions> delayedAssignments = new HashMap<DelayedAssignmentsKey, CFAEdgeWithAssumptions>();
    private final Multimap<String, Edge> leavingEdges = LinkedHashMultimap.create();
    private final Multimap<String, Edge> enteringEdges = LinkedHashMultimap.create();
    private final Map<String, ExpressionTree<Object>> stateInvariants = new LinkedHashMap<String, ExpressionTree<Object>>();
    private final Map<String, ExpressionTree<Object>> stateQuasiInvariants = new LinkedHashMap<String, ExpressionTree<Object>>();
    private final Map<String, String> stateScopes = new LinkedHashMap<String, String>();
    private final Set<String> invariantExportStates = new TreeSet<String>();
    private final Map<Edge, CFANode> loopHeadEnteringEdges = new HashMap<Edge, CFANode>();
    private final Multimap<String, ARGState> stateToARGStates = LinkedHashMultimap.create();
    private final Multimap<Edge, CFAEdge> edgeToCFAEdges = LinkedHashMultimap.create();
    private final String defaultSourcefileName;
    private final AutomatonGraphmlCommon.WitnessType graphType;
    private final InvariantProvider invariantProvider;
    private final Map<CFAEdge, LoopEntryInfo> loopEntryInfoMemo = new HashMap<CFAEdge, LoopEntryInfo>();
    private final Map<CFANode, Boolean> loopProximityMemo = new HashMap<CFANode, Boolean>();
    private final NumericIdProvider numericThreadIdProvider = NumericIdProvider.create();
    private boolean isFunctionScope = false;
    private final Multimap<String, ASimpleDeclaration> seenDeclarations = HashMultimap.create();
    protected Set<AdditionalInfoConverter> additionalInfoConverters = ImmutableSet.of();
    private final Set<CFAEdge> edgesInFault = new HashSet<CFAEdge>();

    private static ARGState getCoveringState(ARGState pChild) {
        ARGState child = pChild;
        if (child.isCovered()) {
            child = child.getCoveringState();
            assert (!child.isCovered());
        }
        return child;
    }

    private static boolean isTmpVariable(AIdExpression exp) {
        return exp.getDeclaration().getQualifiedName().toUpperCase().contains("__CPACHECKER_TMP");
    }

    WitnessFactory(WitnessOptions pOptions, CFA pCfa, LogManager pLogger, VerificationTaskMetaData pMetaData, ExpressionTreeFactory<Object> pFactory, Simplifier<Object> pSimplifier, @Nullable String pDefaultSourceFileName, AutomatonGraphmlCommon.WitnessType pGraphType, InvariantProvider pInvariantProvider) {
        this.witnessOptions = pOptions;
        this.cfa = pCfa;
        this.logger = pLogger;
        this.verificationTaskMetaData = pMetaData;
        this.factory = pFactory;
        this.simplifier = pSimplifier;
        this.defaultSourcefileName = pDefaultSourceFileName;
        this.graphType = pGraphType;
        this.invariantProvider = pInvariantProvider;
    }

    @Override
    public void appendNewEdge(String pFrom, String pTo, CFAEdge pEdge, Optional<Collection<ARGState>> pFromState, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, CFAEdgeWithAdditionalInfo pAdditionalInfo) throws InterruptedException {
        this.attemptSwitchToFunctionScope(pEdge);
        if (pFromState.isPresent()) {
            this.stateToARGStates.putAll((Object)pFrom, (Iterable)pFromState.orElseThrow());
        }
        Collection<TransitionCondition> transitions = this.constructTransitionCondition(pFrom, pTo, pEdge, pFromState, pValueMap, pAdditionalInfo);
        String from = pFrom;
        Iterator transitionIterator = transitions.iterator();
        if (this.nodeFlags.get((Object)pTo).contains((Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE)) {
            transitionIterator = Iterators.limit(transitionIterator, (int)1);
        }
        int i = 0;
        while (transitionIterator.hasNext()) {
            TransitionCondition transition = (TransitionCondition)transitionIterator.next();
            String to = transitionIterator.hasNext() ? String.format("%s_to_%s_intermediate-%d", pFrom, pTo, i) : pTo;
            Edge edge = new Edge(from, to, transition);
            if (i == 0) {
                Optional<CFANode> loopHead;
                if (transition.getMapping().containsKey((Object)AutomatonGraphmlCommon.KeyDef.ENTERLOOPHEAD) && (loopHead = this.entersLoop(pEdge, false)).isPresent()) {
                    this.loopHeadEnteringEdges.put(edge, loopHead.orElseThrow());
                }
                if (this.graphType != AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS) {
                    ExpressionTree<Object> invariant = ExpressionTrees.getTrue();
                    boolean exportInvariant = this.exportInvariant(pEdge, pFromState);
                    if (exportInvariant) {
                        this.invariantExportStates.add(to);
                    }
                    if (exportInvariant || this.isEdgeIrrelevant(edge)) {
                        invariant = this.simplifier.simplify(this.invariantProvider.provideInvariantFor(pEdge, pFromState));
                    }
                    this.addToStateInvariant(pTo, invariant);
                    String functionName = pEdge.getSuccessor().getFunctionName();
                    this.stateScopes.put(pTo, this.isFunctionScope ? functionName : "");
                }
            }
            this.putEdge(edge);
            this.edgeToCFAEdges.put((Object)edge, (Object)pEdge);
            from = to;
            ++i;
        }
    }

    @Override
    public void appendNewEdgeToSink(String pFrom, CFAEdge pEdge, Optional<Collection<ARGState>> pFromState, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, CFAEdgeWithAdditionalInfo pAdditionalInfo) throws InterruptedException {
        this.appendNewEdge(pFrom, "sink", pEdge, pFromState, pValueMap, pAdditionalInfo);
    }

    private void attemptSwitchToFunctionScope(CFAEdge pEdge) {
        if (this.isFunctionScope) {
            return;
        }
        if (AutomatonGraphmlCommon.isMainFunctionEntry(pEdge)) {
            this.isFunctionScope = true;
        }
    }

    private Collection<TransitionCondition> constructTransitionCondition(String pFrom, String pTo, CFAEdge pEdge, Optional<Collection<ARGState>> pFromState, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        if (this.handleAsEpsilonEdge(pEdge, pAdditionalInfo)) {
            return Collections.singletonList(TransitionCondition.empty());
        }
        boolean goesToSink = pTo.equals("sink");
        if (!goesToSink && AutomatonGraphmlCommon.isSplitAssumption(pEdge)) {
            return Collections.singletonList(TransitionCondition.empty());
        }
        boolean isDefaultCase = AutomatonGraphmlCommon.isDefaultCase(pEdge);
        TransitionCondition result = this.getSourceCodeGuards(pEdge, goesToSink, isDefaultCase, Optional.empty(), pAdditionalInfo);
        if (pFromState.isPresent()) {
            return this.extractTransitionForStates(pFrom, pTo, pEdge, pFromState.orElseThrow(), pValueMap, pAdditionalInfo, result, goesToSink, isDefaultCase);
        }
        return Collections.singletonList(result);
    }

    protected boolean handleAsEpsilonEdge(CFAEdge pEdge, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        return !this.isFunctionScope || AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge);
    }

    private TransitionCondition getSourceCodeGuards(CFAEdge pEdge, boolean pGoesToSink, boolean pIsDefaultCase, Optional<String> pAlternativeFunctionEntry, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        FileLocation max;
        TransitionCondition result = TransitionCondition.empty();
        if (this.entersLoop(pEdge, false).isPresent()) {
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ENTERLOOPHEAD, "true");
        }
        if (this.witnessOptions.exportFunctionCallsAndReturns()) {
            String functionName = pAlternativeFunctionEntry.orElse(null);
            CFANode succ = pEdge.getSuccessor();
            if (succ instanceof FunctionEntryNode) {
                functionName = ((FunctionEntryNode)succ).getFunctionDefinition().getOrigName();
            } else if (AutomatonGraphmlCommon.isMainFunctionEntry(pEdge)) {
                functionName = succ.getFunctionName();
            }
            if (functionName != null) {
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, functionName);
            }
        }
        if (this.witnessOptions.exportFunctionCallsAndReturns() && pEdge.getSuccessor() instanceof FunctionExitNode) {
            FunctionEntryNode entryNode = ((FunctionExitNode)pEdge.getSuccessor()).getEntryNode();
            String functionName = entryNode.getFunctionDefinition().getOrigName();
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, functionName);
        }
        if (pEdge instanceof AssumeEdge && !AutomatonGraphmlCommon.isPartOfTerminatingAssumption(pEdge)) {
            AssumeEdge assumeEdge = (AssumeEdge)pEdge;
            if (AutomatonGraphmlCommon.isPointerCallAssumption(assumeEdge)) {
                if (!pGoesToSink && this.isEmptyTransitionPossible(pAdditionalInfo)) {
                    return TransitionCondition.empty();
                }
                if (assumeEdge.getTruthAssumption() && this.witnessOptions.exportFunctionCallsAndReturns()) {
                    FunctionCallEdge callEdge = (FunctionCallEdge)Iterables.getOnlyElement((Iterable)CFAUtils.leavingEdges(assumeEdge.getSuccessor()).filter(FunctionCallEdge.class));
                    FunctionEntryNode in = callEdge.getSuccessor();
                    result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, in.getFunctionName());
                }
            } else if (this.witnessOptions.exportAssumeCaseInfo()) {
                if (assumeEdge.getTruthAssumption() || pGoesToSink || pIsDefaultCase && !pGoesToSink || !AutomatonGraphmlCommon.isPartOfSwitchStatement(assumeEdge)) {
                    AutomatonGraphmlCommon.AssumeCase assumeCase = assumeEdge.getTruthAssumption() != assumeEdge.isSwapped() ? AutomatonGraphmlCommon.AssumeCase.THEN : AutomatonGraphmlCommon.AssumeCase.ELSE;
                    result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.CONTROLCASE, assumeCase.toString());
                } else if (this.isEmptyTransitionPossible(pAdditionalInfo)) {
                    return TransitionCondition.empty();
                }
            }
        }
        Set<FileLocation> locations = AutomatonGraphmlCommon.getFileLocationsFromCfaEdge(pEdge, this.cfa.getMainFunction(), pAdditionalInfo);
        Comparator<FileLocation> nodeOffsetComparator = Comparator.comparingInt(FileLocation::getNodeOffset);
        FileLocation min = locations.isEmpty() ? null : Collections.min(locations, nodeOffsetComparator);
        FileLocation fileLocation = max = locations.isEmpty() ? null : Collections.max(locations, nodeOffsetComparator);
        if (this.witnessOptions.exportLineNumbers() && min != null) {
            if (this.witnessOptions.exportSourceFileName() || !min.getFileName().toString().equals(this.defaultSourcefileName)) {
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ORIGINFILE, min.getFileName().toString());
            }
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.STARTLINE, Integer.toString(min.getStartingLineInOrigin()));
        }
        if (this.witnessOptions.exportLineNumbers() && max != null) {
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ENDLINE, Integer.toString(max.getEndingLineInOrigin()));
        }
        if (this.witnessOptions.exportOffset() && min != null && min.isOffsetRelatedToOrigin()) {
            if (this.witnessOptions.exportSourceFileName() || !min.getFileName().toString().equals(this.defaultSourcefileName)) {
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ORIGINFILE, min.getFileName().toString());
            }
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.OFFSET, Integer.toString(min.getNodeOffset()));
        }
        if (this.witnessOptions.exportOffset() && max != null && max.isOffsetRelatedToOrigin()) {
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ENDOFFSET, Integer.toString(max.getNodeOffset() + max.getNodeLength() - 1));
        }
        if (this.witnessOptions.exportSourcecode()) {
            String sourceCode = pIsDefaultCase && !pGoesToSink ? "default:" : pEdge.getRawStatement().trim();
            if (sourceCode.isEmpty() && !this.isEmptyTransitionPossible(pAdditionalInfo) && pEdge instanceof FunctionReturnEdge) {
                sourceCode = ((FunctionReturnEdge)pEdge).getSummaryEdge().getRawStatement().trim();
            }
            if (!sourceCode.isEmpty()) {
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.SOURCECODE, sourceCode);
            }
        }
        return result;
    }

    protected boolean isEmptyTransitionPossible(CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        return true;
    }

    protected Collection<TransitionCondition> extractTransitionForStates(String pFrom, String pTo, CFAEdge pEdge, Collection<ARGState> pFromStates, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, CFAEdgeWithAdditionalInfo pAdditionalInfo, TransitionCondition pTransitionCondition, boolean pGoesToSink, boolean pIsDefaultCase) {
        TransitionCondition result = pTransitionCondition;
        ArrayList code = new ArrayList();
        Optional<AIdExpression> resultVariable = Optional.empty();
        Optional<Object> resultFunction = Optional.empty();
        String functionName = pEdge.getPredecessor().getFunctionName();
        boolean functionScope = this.isFunctionScope;
        for (ARGState state : pFromStates) {
            AIdExpression idExpression;
            AFunctionCallAssignmentStatement assignment;
            AStatementEdge edge;
            Optional<String> extractedFunctionName;
            CFAEdgeWithAssumptions cfaEdgeWithAssignments = this.getEdgeWithAssignments(pFrom, pEdge, state, pValueMap);
            if (cfaEdgeWithAssignments == null) continue;
            ImmutableList<AExpressionStatement> assignments = cfaEdgeWithAssignments.getExpStmts();
            AssignsParameterOfOtherFunction assignsParameterOfOtherFunction = new AssignsParameterOfOtherFunction(pEdge);
            ImmutableList functionValidAssignments = FluentIterable.from(assignments).filter((com.google.common.base.Predicate)assignsParameterOfOtherFunction).toList();
            if (functionValidAssignments.size() < assignments.size()) {
                cfaEdgeWithAssignments = new CFAEdgeWithAssumptions(pEdge, (ImmutableCollection<AExpressionStatement>)functionValidAssignments, cfaEdgeWithAssignments.getComment());
                FluentIterable<CFAEdge> nextEdges = CFAUtils.leavingEdges(pEdge.getSuccessor());
                if (nextEdges.size() == 1 && state.getChildren().size() == 1) {
                    String keyFrom = pTo;
                    CFAEdge keyEdge = (CFAEdge)Iterables.getOnlyElement(nextEdges);
                    ARGState keyState = (ARGState)Iterables.getOnlyElement(state.getChildren());
                    ImmutableList valueAssignments = FluentIterable.from(assignments).filter(Predicates.not((com.google.common.base.Predicate)assignsParameterOfOtherFunction)).toList();
                    CFAEdgeWithAssumptions valueCFAEdgeWithAssignments = new CFAEdgeWithAssumptions(keyEdge, (ImmutableCollection<AExpressionStatement>)valueAssignments, "");
                    this.delayedAssignments.put(new DelayedAssignmentsKey(keyFrom, keyEdge, keyState), valueCFAEdgeWithAssignments);
                }
            }
            if ((extractedFunctionName = this.extractFunctionNameOfStaticVariables((Collection<AExpressionStatement>)functionValidAssignments)).isPresent()) {
                functionName = extractedFunctionName.orElseThrow();
                functionScope = true;
            }
            assignments = this.getAssignments(cfaEdgeWithAssignments, null);
            if (pEdge instanceof AStatementEdge && (edge = (AStatementEdge)pEdge).getStatement() instanceof AFunctionCallAssignmentStatement && (assignment = (AFunctionCallAssignmentStatement)edge.getStatement()).getLeftHandSide() instanceof AIdExpression && assignment.getFunctionCallExpression().getFunctionNameExpression() instanceof AIdExpression && WitnessFactory.isTmpVariable(idExpression = (AIdExpression)assignment.getLeftHandSide())) {
                assignments = this.getAssignments(cfaEdgeWithAssignments, idExpression);
                resultVariable = Optional.of(idExpression);
                AIdExpression resultFunctionName = (AIdExpression)assignment.getFunctionCallExpression().getFunctionNameExpression();
                resultFunction = resultFunctionName.getDeclaration() != null ? Optional.of(resultFunctionName.getDeclaration().getOrigName()) : Optional.of(resultFunctionName.getName());
            }
            assert (resultVariable.isPresent() == resultFunction.isPresent());
            if (assignments.isEmpty()) continue;
            Collection expressions = assignments.stream().map(AExpressionStatement::getExpression).collect(Collectors.toCollection(ArrayDeque::new));
            TransitionCondition.Scope scope = this.filterExpressionsForScope(pEdge, result.getScope(), functionName, expressions);
            result = result.withScope(scope);
            if (expressions.isEmpty()) continue;
            code.add(this.factory.and(Collections2.transform((Collection)expressions, pExpr -> LeafExpression.of(pExpr))));
        }
        if (this.graphType != AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS && this.witnessOptions.exportAssumptions() && !code.isEmpty()) {
            String assumptionCode = this.getAssumptionAsCode(this.factory.or(code), resultVariable);
            result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ASSUMPTION, assumptionCode + ";");
            if (functionScope) {
                if (this.witnessOptions.revertThreadFunctionRenaming()) {
                    functionName = CFACloner.extractFunctionName(functionName);
                }
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ASSUMPTIONSCOPE, functionName);
            }
            if (resultFunction.isPresent()) {
                result = result.putAndCopy(AutomatonGraphmlCommon.KeyDef.ASSUMPTIONRESULTFUNCTION, (String)resultFunction.orElseThrow());
            }
        }
        result = this.addAdditionalInfo(result, pAdditionalInfo);
        if (this.witnessOptions.exportThreadId() && pFromStates.size() == 1) {
            ARGState state = pFromStates.iterator().next();
            result = this.exportThreadId(result, pEdge, state);
            return this.exportThreadManagement(result, pEdge, state, pGoesToSink, pIsDefaultCase, pAdditionalInfo);
        }
        return Collections.singleton(result);
    }

    private ImmutableList<AExpressionStatement> getAssignments(CFAEdgeWithAssumptions cfaEdgeWithAssignments, @Nullable AIdExpression toIgnore) {
        com.google.common.base.Predicate isGoodVariable = v -> !WitnessFactory.isTmpVariable(v) || v.equals(toIgnore);
        ImmutableList.Builder assignments = ImmutableList.builder();
        for (AExpressionStatement s : cfaEdgeWithAssignments.getExpStmts()) {
            if (!(s.getExpression() instanceof CExpression) || !CFAUtils.getIdExpressionsOfExpression((CExpression)s.getExpression()).allMatch(isGoodVariable)) continue;
            assignments.add((Object)s);
        }
        return assignments.build();
    }

    private Optional<String> extractFunctionNameOfStaticVariables(Collection<AExpressionStatement> functionValidAssignments) {
        for (AExpressionStatement functionValidAssignment : functionValidAssignments) {
            if (!(functionValidAssignment instanceof CExpressionStatement)) continue;
            CExpression expression = (CExpression)functionValidAssignment.getExpression();
            for (CIdExpression idExpression : CFAUtils.getIdExpressionsOfExpression(expression).toSet()) {
                CSimpleDeclaration declaration = idExpression.getDeclaration();
                String qualified = declaration.getQualifiedName();
                if (!declaration.getName().contains("static") || declaration.getOrigName().contains("static") || !qualified.contains("::")) continue;
                return Optional.of(qualified.substring(0, qualified.indexOf("::")));
            }
        }
        return Optional.empty();
    }

    private CFAEdgeWithAssumptions getEdgeWithAssignments(String pFrom, CFAEdge pEdge, ARGState state, Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap) {
        DelayedAssignmentsKey key = new DelayedAssignmentsKey(pFrom, pEdge, state);
        CFAEdgeWithAssumptions currentEdgeWithAssignments = WitnessFactory.getFromValueMap(pValueMap, state, pEdge);
        CFAEdgeWithAssumptions cfaEdgeWithAssignments = this.delayedAssignments.get(key);
        if (pValueMap != null && currentEdgeWithAssignments != null) {
            if (cfaEdgeWithAssignments == null) {
                cfaEdgeWithAssignments = currentEdgeWithAssignments;
            } else {
                ImmutableList.Builder allAssignments = ImmutableList.builder();
                allAssignments.addAll(cfaEdgeWithAssignments.getExpStmts());
                allAssignments.addAll(currentEdgeWithAssignments.getExpStmts());
                cfaEdgeWithAssignments = new CFAEdgeWithAssumptions(pEdge, (ImmutableCollection<AExpressionStatement>)allAssignments.build(), currentEdgeWithAssignments.getComment());
            }
        }
        return cfaEdgeWithAssignments;
    }

    private String getAssumptionAsCode(ExpressionTree<Object> assumption, Optional<AIdExpression> resultVariable) {
        CExpressionToOrinalCodeVisitor transformer = resultVariable.isPresent() ? CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER.substitute((CIdExpression)resultVariable.orElseThrow(), "\\result") : CExpressionToOrinalCodeVisitor.BASIC_TRANSFORMER;
        Function converter = pLeafExpression -> {
            if (pLeafExpression instanceof CExpression) {
                return ((CExpression)pLeafExpression).accept(transformer);
            }
            if (pLeafExpression == null) {
                return "(0)";
            }
            return pLeafExpression.toString();
        };
        if (ExpressionTrees.isAnd(assumption)) {
            return ExpressionTrees.getChildren(assumption).transform(pTree -> ExpressionTrees.convert(pTree, converter)).join(Joiner.on((String)"; "));
        }
        return ExpressionTrees.convert(assumption, converter).toString();
    }

    private TransitionCondition.Scope filterExpressionsForScope(CFAEdge pEdge, TransitionCondition.Scope pScope, String pFunctionName, Collection<AExpression> pExpressions) {
        TransitionCondition.Scope scope = pScope;
        Optional<String> scopeFunctionName = this.isFunctionScope ? Optional.of(pFunctionName) : Optional.empty();
        ImmutableSet declarations = FluentIterable.from(CFAUtils.getAstNodesFromCfaEdge(pEdge)).filter(ASimpleDeclaration.class).toSet();
        for (ASimpleDeclaration declaration : declarations) {
            String ambiguousName = WitnessFactory.getAmbiguousName(declaration, scopeFunctionName);
            this.seenDeclarations.put((Object)ambiguousName, (Object)declaration);
        }
        Optional<TransitionCondition.Scope> extendedScope = scope.extendBy(scopeFunctionName, (Collection<ASimpleDeclaration>)declarations);
        if (extendedScope.isPresent()) {
            scope = extendedScope.orElseThrow();
            Iterator<AExpression> expressionIt = pExpressions.iterator();
            while (expressionIt.hasNext()) {
                declarations = CFAUtils.traverseRecursively(expressionIt.next()).filter(AIdExpression.class).transform(AIdExpression::getDeclaration).filter(ASimpleDeclaration.class).toSet();
                boolean containsAmbiguousVariables = false;
                for (ASimpleDeclaration expressionDeclaration : declarations) {
                    String ambiguousName = WitnessFactory.getAmbiguousName(expressionDeclaration, scopeFunctionName);
                    if (!this.seenDeclarations.get((Object)ambiguousName).stream().anyMatch(decl -> !decl.equals(expressionDeclaration)) || scope.getUsedDeclarations().contains(expressionDeclaration)) continue;
                    containsAmbiguousVariables = true;
                    break;
                }
                if (!containsAmbiguousVariables) {
                    extendedScope = scope.extendBy(scopeFunctionName, (Collection<ASimpleDeclaration>)declarations);
                    if (extendedScope.isPresent()) {
                        scope = extendedScope.orElseThrow();
                        continue;
                    }
                    expressionIt.remove();
                    continue;
                }
                expressionIt.remove();
            }
        } else {
            pExpressions.clear();
        }
        return scope;
    }

    protected TransitionCondition addAdditionalInfo(TransitionCondition pCondition, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        return pCondition;
    }

    private TransitionCondition exportThreadId(TransitionCondition pResult, CFAEdge pEdge, ARGState pState) {
        ThreadingState threadingState = AbstractStates.extractStateByType(pState, ThreadingState.class);
        if (threadingState != null) {
            for (String threadId : threadingState.getThreadIds()) {
                if (!threadingState.getThreadLocation(threadId).getLocationNode().equals(pEdge.getPredecessor())) continue;
                if (this.witnessOptions.exportThreadName()) {
                    pResult = pResult.putAndCopy(AutomatonGraphmlCommon.KeyDef.THREADNAME, threadId);
                }
                pResult = pResult.putAndCopy(AutomatonGraphmlCommon.KeyDef.THREADID, Integer.toString(this.getUniqueThreadNum(threadId)));
                break;
            }
        }
        return pResult;
    }

    private Collection<TransitionCondition> exportThreadManagement(TransitionCondition pResult, CFAEdge pEdge, ARGState pState, boolean pGoesToSink, boolean pIsDefaultCase, CFAEdgeWithAdditionalInfo pAdditionalInfo) {
        AExpression functionNameExp;
        AStatement statement;
        ThreadingState threadingState = AbstractStates.extractStateByType(pState, ThreadingState.class);
        if (threadingState == null) {
            return Collections.singletonList(pResult);
        }
        Optional<String> threadInitialFunctionName = Optional.empty();
        OptionalInt spawnedThreadId = OptionalInt.empty();
        if (pEdge.getEdgeType() == CFAEdgeType.StatementEdge && (statement = ((AStatementEdge)pEdge).getStatement()) instanceof AFunctionCall && (functionNameExp = ((AFunctionCall)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression) {
            String functionName;
            switch (functionName = ((AIdExpression)functionNameExp).getName()) {
                case "pthread_create": {
                    Optional<ARGState> possibleChild = pState.getChildren().stream().filter(c -> pEdge == pState.getEdgeToChild((ARGState)c)).findFirst();
                    if (!possibleChild.isPresent()) {
                        return Collections.singletonList(pResult);
                    }
                    ARGState child = possibleChild.orElseThrow();
                    ThreadingState succThreadingState = AbstractStates.extractStateByType(child, ThreadingState.class);
                    for (String threadId : succThreadingState.getThreadIds()) {
                        if (threadingState.getThreadIds().contains(threadId)) continue;
                        spawnedThreadId = OptionalInt.of(this.getUniqueThreadNum(threadId));
                        pResult = pResult.putAndCopy(AutomatonGraphmlCommon.KeyDef.CREATETHREAD, Integer.toString(spawnedThreadId.orElseThrow()));
                        String calledFunctionName = succThreadingState.getThreadLocation(threadId).getLocationNode().getFunction().getOrigName();
                        threadInitialFunctionName = Optional.of(calledFunctionName);
                    }
                    break;
                }
            }
        }
        ImmutableList.Builder result = ImmutableList.builder();
        result.add((Object)pResult);
        if (threadInitialFunctionName.isPresent()) {
            TransitionCondition extraTransition = this.getSourceCodeGuards(pEdge, pGoesToSink, pIsDefaultCase, threadInitialFunctionName, pAdditionalInfo);
            if (spawnedThreadId.isPresent()) {
                extraTransition = extraTransition.putAndCopy(AutomatonGraphmlCommon.KeyDef.THREADID, Integer.toString(spawnedThreadId.orElseThrow()));
            }
            if (!extraTransition.getMapping().isEmpty()) {
                result.add((Object)extraTransition);
            }
        }
        return result.build();
    }

    private int getUniqueThreadNum(String threadId) {
        return this.numericThreadIdProvider.provideNumericId(threadId);
    }

    private Iterable<ARGState> collectReachableNodes(ARGState pInitialState, Function<? super ARGState, ? extends Iterable<ARGState>> pSuccessorFunction, com.google.common.base.Predicate<? super ARGState> pPathStates, BiPredicate<ARGState, ARGState> pIsRelevantEdge) {
        return Iterables.transform(this.collectReachableEdges(pInitialState, pSuccessorFunction, pPathStates, pIsRelevantEdge), Pair::getFirst);
    }

    private Iterable<Pair<ARGState, Iterable<ARGState>>> collectReachableEdges(final ARGState pInitialState, final Function<? super ARGState, ? extends Iterable<ARGState>> pSuccessorFunction, final com.google.common.base.Predicate<? super ARGState> pPathStates, final BiPredicate<ARGState, ARGState> pIsRelevantEdge) {
        return new Iterable<Pair<ARGState, Iterable<ARGState>>>(){
            private final Set<ARGState> visited = new HashSet<ARGState>();
            private final Deque<ARGState> waitlist = new ArrayDeque<ARGState>();
            {
                this.waitlist.add(pInitialState);
                this.visited.add(pInitialState);
            }

            @Override
            public Iterator<Pair<ARGState, Iterable<ARGState>>> iterator() {
                return new Iterator<Pair<ARGState, Iterable<ARGState>>>(){

                    @Override
                    public boolean hasNext() {
                        return !waitlist.isEmpty();
                    }

                    @Override
                    public Pair<ARGState, Iterable<ARGState>> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (!waitlist.isEmpty());
                        ARGState parent = waitlist.poll();
                        FluentIterable children = FluentIterable.of((Object)parent, (Object[])new ARGState[0]).transformAndConcat(pSuccessorFunction).transform(x$0 -> WitnessFactory.getCoveringState(x$0)).filter(parent.getChildren()::contains);
                        for (ARGState child : children.filter(pPathStates)) {
                            if (!pIsRelevantEdge.test(parent, child) || !visited.add(child)) continue;
                            waitlist.offer(child);
                        }
                        return Pair.of(parent, children);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Removal not supported.");
                    }
                };
            }
        };
    }

    public Witness produceWitness(ARGState pRootState, com.google.common.base.Predicate<? super ARGState> pIsRelevantState, BiPredicate<ARGState, ARGState> pIsRelevantEdge, com.google.common.base.Predicate<? super ARGState> pIsCyclehead, Optional<Function<? super ARGState, ExpressionTree<Object>>> cycleHeadToQuasiInvariant, Optional<CounterexampleInfo> pCounterExample, GraphBuilder pGraphBuilder) throws InterruptedException {
        this.leavingEdges.clear();
        this.enteringEdges.clear();
        this.nodeFlags.clear();
        this.violatedProperties.clear();
        this.stateInvariants.clear();
        this.stateQuasiInvariants.clear();
        this.stateScopes.clear();
        this.invariantExportStates.clear();
        this.stateToARGStates.clear();
        this.edgeToCFAEdges.clear();
        this.edgesInFault.clear();
        BiPredicate<ARGState, ARGState> isRelevantEdge = pIsRelevantEdge;
        ImmutableListMultimap valueMap = ImmutableListMultimap.of();
        Map<ARGState, CFAEdgeWithAdditionalInfo> additionalInfo = this.getAdditionalInfo(pCounterExample);
        this.additionalInfoConverters = this.getAdditionalInfoConverters(pCounterExample);
        if (pCounterExample.isPresent()) {
            CounterexampleInfo cex = pCounterExample.orElseThrow();
            if (cex.isPreciseCounterExample()) {
                Object fInfo;
                ImmutableList<Fault> faults;
                valueMap = Multimaps.transformValues(pCounterExample.orElseThrow().getExactVariableValues(), WitnessAssumptionFilter::filterRelevantAssumptions);
                if (cex instanceof FaultLocalizationInfoWithTraceFormula && !(faults = ((FaultLocalizationInfo)((Object)(fInfo = (FaultLocalizationInfoWithTraceFormula)cex))).getRankedList()).isEmpty()) {
                    Fault bestFault = (Fault)faults.get(0);
                    FluentIterable.from((Iterable)((Object)bestFault)).transform(fc -> fc.correspondingEdge()).copyInto(this.edgesInFault);
                    this.edgesInFault.addAll((Collection<CFAEdge>)((FaultLocalizationInfoWithTraceFormula)((Object)fInfo)).getTraceFormula().getPrecondition().getEdgesForPrecondition());
                    this.edgesInFault.addAll((Collection<CFAEdge>)((FaultLocalizationInfoWithTraceFormula)((Object)fInfo)).getTraceFormula().getPostCondition().getEdgesForPostCondition());
                    this.edgesInFault.addAll((Collection<CFAEdge>)((FaultLocalizationInfoWithTraceFormula)((Object)fInfo)).getTraceFormula().getPostCondition().getIrrelevantEdges());
                    valueMap = Multimaps.filterValues((Multimap)valueMap, v -> this.edgesInFault.contains(v.getCFAEdge()));
                }
            } else {
                isRelevantEdge = BiPredicates.bothSatisfy(pIsRelevantState);
            }
        }
        String entryStateNodeId = pGraphBuilder.getId(pRootState);
        for (ARGState s : this.collectReachableNodes(pRootState, (Function<? super ARGState, ? extends Iterable<ARGState>>)((Function)ARGState::getChildren), pIsRelevantState, isRelevantEdge)) {
            String sourceStateNodeId = pGraphBuilder.getId(s);
            EnumSet<AutomatonGraphmlCommon.NodeFlag> sourceNodeFlags = EnumSet.noneOf(AutomatonGraphmlCommon.NodeFlag.class);
            if (sourceStateNodeId.equals(entryStateNodeId)) {
                sourceNodeFlags.add(AutomatonGraphmlCommon.NodeFlag.ISENTRY);
            }
            if (pIsCyclehead.apply((Object)s)) {
                sourceNodeFlags.add(AutomatonGraphmlCommon.NodeFlag.ISCYCLEHEAD);
                if (cycleHeadToQuasiInvariant.isPresent()) {
                    this.stateQuasiInvariants.put(sourceStateNodeId, (ExpressionTree)cycleHeadToQuasiInvariant.orElseThrow().apply((Object)s));
                }
            }
            sourceNodeFlags.addAll(this.extractNodeFlags(s));
            this.nodeFlags.putAll((Object)sourceStateNodeId, sourceNodeFlags);
            if (this.graphType != AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS) continue;
            this.violatedProperties.putAll((Object)sourceStateNodeId, this.extractViolatedProperties(s));
        }
        this.nodeFlags.put((Object)"sink", (Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE);
        pGraphBuilder.buildGraph(pRootState, pIsRelevantState, isRelevantEdge, (Multimap<ARGState, CFAEdgeWithAssumptions>)valueMap, additionalInfo, this.collectReachableEdges(pRootState, (Function<? super ARGState, ? extends Iterable<ARGState>>)((Function)ARGState::getChildren), pIsRelevantState, isRelevantEdge), this);
        this.removeUnnecessarySinkEdges();
        int sizeBeforeMerging = this.edgeToCFAEdges.size();
        this.mergeEdges(entryStateNodeId, true, (com.google.common.base.Predicate<Edge>)((com.google.common.base.Predicate)this::isEdgeIrrelevant));
        this.mergeEdges(entryStateNodeId, false, (com.google.common.base.Predicate<Edge>)((com.google.common.base.Predicate)this::isEdgeIrrelevantByFaultLocalization));
        int sizeAfterMerging = this.edgeToCFAEdges.size();
        this.logger.logf(Level.ALL, "Witness graph shrinked from %s edges to %s edges when merging edges.", new Object[]{sizeBeforeMerging, sizeAfterMerging});
        this.mergeRedundantSinkEdges();
        return new Witness(this.graphType, this.defaultSourcefileName, this.cfa, this.verificationTaskMetaData, entryStateNodeId, this.leavingEdges, this.enteringEdges, this.witnessOptions, this.nodeFlags, this.violatedProperties, this.stateInvariants, this.stateQuasiInvariants, this.stateScopes, this.invariantExportStates, this.stateToARGStates, this.edgeToCFAEdges);
    }

    private void mergeEdges(String entryStateNodeId, boolean mergeMetaInformation, com.google.common.base.Predicate<Edge> isIrrelevant) throws InterruptedException {
        TreeSet waitlist = new TreeSet(this.leavingEdges.values());
        while (!waitlist.isEmpty()) {
            Edge edge = (Edge)waitlist.pollFirst();
            if (this.leavingEdges.get((Object)edge.getSource()).contains(edge) && isIrrelevant.test((Object)edge)) {
                Iterables.addAll(waitlist, this.mergeNodes(edge, mergeMetaInformation));
                assert (this.leavingEdges.isEmpty() || this.leavingEdges.containsKey((Object)entryStateNodeId));
            }
            if (!mergeMetaInformation) continue;
            this.setLoopHeadInvariantIfApplicable(edge.getTarget());
        }
    }

    protected Map<ARGState, CFAEdgeWithAdditionalInfo> getAdditionalInfo(Optional<CounterexampleInfo> pCounterExample) {
        return ImmutableMap.of();
    }

    protected Set<AdditionalInfoConverter> getAdditionalInfoConverters(Optional<CounterexampleInfo> pCounterExample) {
        return ImmutableSet.of();
    }

    private void removeUnnecessarySinkEdges() {
        Set toRemove = Sets.newIdentityHashSet();
        for (Collection leavingEdgesCollection : this.leavingEdges.asMap().values()) {
            block1: for (Edge edge : leavingEdgesCollection) {
                if (!edge.getTarget().equals("sink")) continue;
                for (Edge otherEdge : leavingEdgesCollection) {
                    if (edge == otherEdge || toRemove.contains(otherEdge) || !edge.getLabel().equals(otherEdge.getLabel()) && !this.isEdgeIrrelevant(edge)) continue;
                    toRemove.add(edge);
                    continue block1;
                }
            }
        }
        for (Edge edge : toRemove) {
            boolean removed = this.removeEdge(edge);
            assert (removed);
        }
    }

    private void mergeRedundantSinkEdges() {
        for (Collection leavingEdgesCollection : this.leavingEdges.asMap().values()) {
            List toSink;
            if (leavingEdgesCollection.size() <= 1 || (toSink = (List)leavingEdgesCollection.stream().filter(e -> e.getTarget().equals("sink")).collect(Collectors.toCollection(ArrayList::new))).size() <= 1) continue;
            ListIterator<Edge> edgeToSinkIterator = toSink.listIterator();
            Set removed = Sets.newIdentityHashSet();
            while (edgeToSinkIterator.hasNext()) {
                Edge edge = (Edge)edgeToSinkIterator.next();
                if (removed.contains(edge)) {
                    edgeToSinkIterator.remove();
                    continue;
                }
                Optional<Object> merged = Optional.empty();
                Edge other = null;
                for (Edge otherEdge : toSink) {
                    if (edge == otherEdge || removed.contains(otherEdge) || !(merged = edge.tryMerge(otherEdge)).isPresent()) continue;
                    other = otherEdge;
                    break;
                }
                if (!merged.isPresent()) continue;
                this.removeEdge(edge);
                this.removeEdge(other);
                edgeToSinkIterator.remove();
                removed.add(other);
                this.putEdge((Edge)merged.orElseThrow());
                this.edgeToCFAEdges.putAll((Object)((Edge)merged.orElseThrow()), (Iterable)this.edgeToCFAEdges.get((Object)edge));
                this.edgeToCFAEdges.putAll((Object)((Edge)merged.orElseThrow()), (Iterable)this.edgeToCFAEdges.get((Object)other));
                this.edgeToCFAEdges.removeAll((Object)edge);
                this.edgeToCFAEdges.removeAll((Object)other);
                edgeToSinkIterator.add((Edge)merged.orElseThrow());
                edgeToSinkIterator.previous();
            }
        }
    }

    private void setLoopHeadInvariantIfApplicable(String pTarget) throws InterruptedException {
        if (!ExpressionTrees.getTrue().equals(this.getStateInvariant(pTarget))) {
            return;
        }
        ExpressionTree<Object> loopHeadInvariant = ExpressionTrees.getFalse();
        String scope = null;
        for (Edge enteringEdge : this.enteringEdges.get((Object)pTarget)) {
            if (enteringEdge.getLabel().getMapping().containsKey((Object)AutomatonGraphmlCommon.KeyDef.ENTERLOOPHEAD)) {
                CFANode loopHead = this.loopHeadEnteringEdges.get(enteringEdge);
                if (loopHead != null) {
                    String functionName = loopHead.getFunctionName();
                    if (scope == null) {
                        scope = functionName;
                    } else if (!scope.equals(functionName)) {
                        return;
                    }
                    if (this.witnessOptions.produceInvariantWitnesses()) {
                        ArrayList<ExpressionTree<Object>> iterableList = new ArrayList<ExpressionTree<Object>>();
                        for (CFAEdge enteringCFAEdge : CFAUtils.enteringEdges(loopHead)) {
                            iterableList.add(this.invariantProvider.provideInvariantFor(enteringCFAEdge, Optional.empty()));
                        }
                        loopHeadInvariant = this.computeInvariantForInvariantWitnesses(iterableList);
                        continue;
                    }
                    for (CFAEdge enteringCFAEdge : CFAUtils.enteringEdges(loopHead)) {
                        loopHeadInvariant = Or.of(loopHeadInvariant, this.invariantProvider.provideInvariantFor(enteringCFAEdge, Optional.empty()));
                    }
                    continue;
                }
                return;
            }
            return;
        }
        this.stateInvariants.put(pTarget, loopHeadInvariant);
        if (scope != null) {
            this.getStateScopes().put(pTarget, scope);
        }
    }

    private ExpressionTree<Object> computeInvariantForInvariantWitnesses(Iterable<ExpressionTree<Object>> expressions) {
        ExpressionTree<Object> mergedInvariant = ExpressionTrees.getFalse();
        boolean trueSkipped = false;
        for (ExpressionTree<Object> invariant : expressions) {
            if (ExpressionTrees.getTrue().equals(invariant)) {
                trueSkipped = true;
                continue;
            }
            mergedInvariant = Or.of(mergedInvariant, invariant);
        }
        if (trueSkipped && ExpressionTrees.getFalse().equals(mergedInvariant)) {
            mergedInvariant = ExpressionTrees.getTrue();
        }
        return mergedInvariant;
    }

    private boolean hasFlagsOrProperties(String pNode) {
        return !this.nodeFlags.get((Object)pNode).isEmpty() || !this.violatedProperties.get((Object)pNode).isEmpty();
    }

    private boolean isIrrelevantNode(String pNode) {
        if (!ExpressionTrees.getTrue().equals(this.getStateInvariant(pNode))) {
            return false;
        }
        if (this.hasFlagsOrProperties(pNode)) {
            return false;
        }
        if (this.enteringEdges.get((Object)pNode).isEmpty()) {
            return false;
        }
        for (Edge edge : this.enteringEdges.get((Object)pNode)) {
            if (edge.getLabel().getMapping().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isEdgeIrrelevantByFaultLocalization(Edge pEdge) {
        if (this.edgesInFault.isEmpty()) {
            return false;
        }
        ImmutableSet importantNodes = Collections3.transformedImmutableSetCopy((Collection)Multimaps.filterValues(this.edgeToCFAEdges, cfaEdge -> this.edgesInFault.contains(cfaEdge)).keySet(), e -> e.getSource());
        if (pEdge.getTarget().equals("sink") && importantNodes.contains(pEdge.getSource())) {
            return false;
        }
        for (CFAEdge cfaEdge2 : this.edgeToCFAEdges.get((Object)pEdge)) {
            if (!this.edgesInFault.contains(cfaEdge2)) continue;
            return false;
        }
        return true;
    }

    private boolean isEdgeIrrelevant(Edge pEdge) {
        String source = pEdge.getSource();
        String target = pEdge.getTarget();
        TransitionCondition label = pEdge.getLabel();
        if (this.isIrrelevantNode(target)) {
            return true;
        }
        ExpressionTree<Object> sourceInv = this.stateQuasiInvariants.get(source);
        ExpressionTree<Object> targetInv = this.stateQuasiInvariants.get(target);
        if (sourceInv != null && targetInv != null && !sourceInv.equals(targetInv)) {
            return false;
        }
        if (label.getMapping().isEmpty()) {
            return true;
        }
        if (source.equals(target)) {
            return false;
        }
        ExpressionTree<Object> sourceTree = this.getStateInvariant(source);
        if (sourceTree != null) {
            String sourceScope = this.stateScopes.get(source);
            String targetScope = this.stateScopes.get(target);
            if (sourceScope != null && targetScope != null && !sourceScope.equals(targetScope)) {
                return false;
            }
        }
        boolean summarizedByPreceedingEdge = Iterables.any((Iterable)this.enteringEdges.get((Object)source), pPrecedingEdge -> pPrecedingEdge.getLabel().summarizes(label));
        if ((!label.hasTransitionRestrictions() || summarizedByPreceedingEdge || label.getMapping().size() == 1 && label.getMapping().containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT)) && this.leavingEdges.get((Object)source).size() == 1) {
            return true;
        }
        if (Iterables.all((Iterable)this.leavingEdges.get((Object)source), pLeavingEdge -> !pLeavingEdge.getLabel().hasTransitionRestrictions())) {
            return true;
        }
        return this.witnessOptions.removeInsufficientEdges() && INSUFFICIENT_KEYS.containsAll(label.getMapping().keySet());
    }

    private Iterable<Edge> mergeNodes(Edge pEdge, boolean pMergeMetaInformation) {
        String nodeToRemove;
        Preconditions.checkArgument((this.isEdgeIrrelevant(pEdge) || this.isEdgeIrrelevantByFaultLocalization(pEdge) ? 1 : 0) != 0);
        boolean intoPredecessor = !this.nodeFlags.get((Object)pEdge.getTarget()).equals(EnumSet.of(AutomatonGraphmlCommon.NodeFlag.ISSINKNODE));
        String nodeToKeep = intoPredecessor ? pEdge.getSource() : pEdge.getTarget();
        String string = nodeToRemove = intoPredecessor ? pEdge.getTarget() : pEdge.getSource();
        if (nodeToKeep.equals(nodeToRemove)) {
            this.removeEdge(pEdge);
            return Iterables.concat((Iterable)this.leavingEdges.get((Object)nodeToKeep), (Iterable)this.enteringEdges.get((Object)nodeToKeep));
        }
        if (this.invariantExportStates.remove(nodeToRemove)) {
            this.invariantExportStates.add(nodeToKeep);
        }
        this.nodeFlags.putAll((Object)nodeToKeep, (Iterable)this.nodeFlags.removeAll((Object)nodeToRemove));
        this.mergeExpressionTreesIntoFirst(nodeToKeep, nodeToRemove);
        if (this.witnessOptions.produceInvariantWitnesses()) {
            this.mergeQuasiInvariantForInvariantWitness(nodeToKeep, nodeToRemove);
        } else {
            this.mergeQuasiInvariant(nodeToKeep, nodeToRemove);
        }
        this.violatedProperties.putAll((Object)nodeToKeep, (Iterable)this.violatedProperties.removeAll((Object)nodeToRemove));
        this.stateToARGStates.putAll((Object)nodeToKeep, (Iterable)this.stateToARGStates.removeAll((Object)nodeToRemove));
        LinkedHashSet<Edge> replacementEdges = new LinkedHashSet<Edge>();
        ImmutableList leavingEdgesToMove = ImmutableList.copyOf((Collection)this.leavingEdges.get((Object)nodeToRemove));
        for (Edge leavingEdge : leavingEdgesToMove) {
            if (pEdge.equals(leavingEdge)) continue;
            TransitionCondition label = pEdge.getLabel();
            if (leavingEdge.getLabel().getMapping().containsKey((Object)AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT)) {
                label = TransitionCondition.empty();
            }
            if (leavingEdge.getLabel().getMapping().containsKey((Object)AutomatonGraphmlCommon.KeyDef.SOURCECODE)) {
                label = label.removeAndCopy(AutomatonGraphmlCommon.KeyDef.ORIGINFILE);
            }
            if (pMergeMetaInformation) {
                label = label.putAllAndCopy(leavingEdge.getLabel());
            }
            Edge replacementEdge = new Edge(nodeToKeep, leavingEdge.getTarget(), label);
            this.putEdge(replacementEdge);
            this.edgeToCFAEdges.putAll((Object)replacementEdge, (Iterable)this.edgeToCFAEdges.get((Object)leavingEdge));
            this.edgeToCFAEdges.removeAll((Object)leavingEdge);
            replacementEdges.add(replacementEdge);
            CFANode loopHead = this.loopHeadEnteringEdges.get(leavingEdge);
            if (loopHead == null) continue;
            this.loopHeadEnteringEdges.remove(leavingEdge);
            this.loopHeadEnteringEdges.put(replacementEdge, loopHead);
        }
        for (Edge leavingEdge : leavingEdgesToMove) {
            boolean removed = this.removeEdge(leavingEdge);
            this.edgeToCFAEdges.removeAll((Object)leavingEdge);
            assert (removed);
        }
        ImmutableList enteringEdgesToMove = ImmutableList.copyOf((Collection)this.enteringEdges.get((Object)nodeToRemove));
        for (Edge enteringEdge : enteringEdgesToMove) {
            if (pEdge.equals(enteringEdge)) continue;
            TransitionCondition label = pMergeMetaInformation ? pEdge.getLabel().putAllAndCopy(enteringEdge.getLabel()) : pEdge.getLabel();
            Edge replacementEdge = new Edge(enteringEdge.getSource(), nodeToKeep, label);
            this.putEdge(replacementEdge);
            this.edgeToCFAEdges.putAll((Object)replacementEdge, (Iterable)this.edgeToCFAEdges.get((Object)pEdge));
            replacementEdges.add(replacementEdge);
            CFANode loopHead = this.loopHeadEnteringEdges.get(enteringEdge);
            if (loopHead == null) continue;
            this.loopHeadEnteringEdges.remove(enteringEdge);
            this.loopHeadEnteringEdges.put(replacementEdge, loopHead);
        }
        for (Edge enteringEdge : enteringEdgesToMove) {
            boolean removed = this.removeEdge(enteringEdge);
            this.edgeToCFAEdges.removeAll((Object)enteringEdge);
            assert (removed) : "could not remove edge: " + enteringEdge;
        }
        this.edgeToCFAEdges.removeAll((Object)pEdge);
        return replacementEdges;
    }

    private void mergeExpressionTreesIntoFirst(String source, String target) {
        ExpressionTree<Object> sourceTree = this.getStateInvariant(source);
        ExpressionTree<Object> targetTree = this.getStateInvariant(target);
        String sourceScope = this.stateScopes.get(source);
        String targetScope = this.stateScopes.get(target);
        if (!ExpressionTrees.getTrue().equals(targetTree) && ExpressionTrees.getTrue().equals(sourceTree) && (sourceScope == null || sourceScope.equals(targetScope)) && this.enteringEdges.get((Object)source).size() <= 1) {
            ExpressionTree<Object> newSourceTree = ExpressionTrees.getFalse();
            if (this.witnessOptions.produceInvariantWitnesses()) {
                newSourceTree = this.computeInvariantForInvariantWitnesses((Iterable<ExpressionTree<Object>>)Collections3.transformedImmutableListCopy((Collection)this.enteringEdges.get((Object)source), e -> this.getStateInvariant(e.getSource())));
            } else {
                for (Edge e2 : this.enteringEdges.get((Object)source)) {
                    newSourceTree = this.factory.or(newSourceTree, this.getStateInvariant(e2.getSource()));
                }
            }
            newSourceTree = this.simplifier.simplify(this.factory.and(targetTree, newSourceTree));
            this.stateInvariants.put(source, newSourceTree);
            sourceTree = newSourceTree;
        }
        String newScope = ExpressionTrees.isConstant(sourceTree) || Objects.equals(sourceScope, targetScope) ? targetScope : (ExpressionTrees.isConstant(targetTree) ? sourceScope : null);
        ExpressionTree<Object> newTree = this.mergeStateInvariantsIntoFirst(source, target);
        if (newTree != null) {
            if (newScope == null && !ExpressionTrees.isConstant(newTree)) {
                this.addToStateInvariant(source, ExpressionTrees.getTrue());
                this.stateScopes.remove(source);
            } else {
                this.stateScopes.put(source, Strings.nullToEmpty((String)newScope));
            }
        }
    }

    private void mergeQuasiInvariant(String pNodeToKeep, String pNodeToRemove) {
        ExpressionTree<Object> fromToKeep = this.getQuasiInvariant(pNodeToKeep);
        ExpressionTree<Object> fromToRemove = this.getQuasiInvariant(pNodeToRemove);
        fromToKeep = this.factory.or(fromToKeep, fromToRemove);
        if (!ExpressionTrees.getFalse().equals(fromToKeep)) {
            this.stateQuasiInvariants.put(pNodeToKeep, fromToKeep);
        }
    }

    private void mergeQuasiInvariantForInvariantWitness(String pNodeToKeep, String pNodeToRemove) {
        ExpressionTree<Object> fromToKeep = this.getQuasiInvariant(pNodeToKeep);
        ExpressionTree<Object> fromToRemove = this.getQuasiInvariant(pNodeToRemove);
        if (ExpressionTrees.getTrue().equals(fromToKeep)) {
            this.stateQuasiInvariants.put(pNodeToKeep, fromToRemove);
        } else if (ExpressionTrees.getTrue().equals(fromToRemove)) {
            this.stateQuasiInvariants.put(pNodeToKeep, fromToKeep);
        } else {
            fromToKeep = this.factory.or(fromToKeep, fromToRemove);
            if (!ExpressionTrees.getFalse().equals(fromToKeep)) {
                this.stateQuasiInvariants.put(pNodeToKeep, fromToKeep);
            }
        }
    }

    private void putEdge(Edge pEdge) {
        assert (this.leavingEdges.size() == this.enteringEdges.size());
        assert (!pEdge.getSource().equals("sink")) : "unexpected edge added to witness (edge should not start with SINK): " + pEdge;
        this.leavingEdges.put((Object)pEdge.getSource(), (Object)pEdge);
        this.enteringEdges.put((Object)pEdge.getTarget(), (Object)pEdge);
        assert (this.leavingEdges.size() == this.enteringEdges.size());
    }

    private boolean removeEdge(Edge pEdge) {
        assert (this.leavingEdges.size() == this.enteringEdges.size());
        if (this.leavingEdges.remove((Object)pEdge.getSource(), (Object)pEdge)) {
            boolean alsoRemoved = this.enteringEdges.remove((Object)pEdge.getTarget(), (Object)pEdge);
            assert (alsoRemoved) : "edge was not removed: " + pEdge;
            assert (this.leavingEdges.size() == this.enteringEdges.size());
            assert (this.nodeFlags.get((Object)pEdge.getTarget()).contains((Object)AutomatonGraphmlCommon.NodeFlag.ISENTRY) || !this.enteringEdges.get((Object)pEdge.getTarget()).isEmpty() || this.leavingEdges.get((Object)pEdge.getTarget()).isEmpty());
            return true;
        }
        return false;
    }

    private Collection<AutomatonGraphmlCommon.NodeFlag> extractNodeFlags(ARGState pState) {
        if (pState.isTarget() && this.graphType != AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS) {
            return Collections.singleton(AutomatonGraphmlCommon.NodeFlag.ISVIOLATION);
        }
        return ImmutableSet.of();
    }

    private Collection<Targetable.TargetInformation> extractViolatedProperties(ARGState pState) {
        ArrayList<Targetable.TargetInformation> result = new ArrayList<Targetable.TargetInformation>();
        if (pState.isTarget()) {
            result.addAll(pState.getTargetInformation());
        }
        return result;
    }

    private void addToStateInvariant(String pStateId, ExpressionTree<Object> pValue) {
        ExpressionTree<Object> prev = this.stateInvariants.get(pStateId);
        if (prev == null) {
            this.stateInvariants.put(pStateId, this.simplifier.simplify(pValue));
            return;
        }
        ExpressionTree<Object> result = this.simplifier.simplify(this.factory.or(prev, pValue));
        this.stateInvariants.put(pStateId, result);
    }

    private @Nullable ExpressionTree<Object> mergeStateInvariantsIntoFirst(String pStateId, String pOtherStateId) {
        ExpressionTree<Object> prev = this.stateInvariants.get(pStateId);
        ExpressionTree<Object> other = this.stateInvariants.get(pOtherStateId);
        if (prev == null && other == null) {
            this.stateInvariants.put(pStateId, ExpressionTrees.getTrue());
            return ExpressionTrees.getTrue();
        }
        if (prev == null || other == null) {
            ExpressionTree<Object> existingTree = prev == null ? other : prev;
            this.stateInvariants.put(pStateId, existingTree);
            return existingTree;
        }
        ExpressionTree<Object> result = null;
        result = this.witnessOptions.produceInvariantWitnesses() ? (ExpressionTrees.getTrue().equals(prev) ? this.simplifier.simplify(other) : (ExpressionTrees.getTrue().equals(other) ? this.simplifier.simplify(prev) : this.simplifier.simplify(this.factory.or(prev, other)))) : this.simplifier.simplify(this.factory.or(prev, other));
        this.stateInvariants.put(pStateId, result);
        return result;
    }

    private boolean exportInvariant(CFAEdge pEdge, Optional<Collection<ARGState>> pFromState) {
        if (pFromState.isPresent() && pFromState.orElseThrow().stream().map(AbstractStates.toState(PredicateAbstractState.class)).filter(s -> s != null).anyMatch(PredicateAbstractState::containsAbstractionState)) {
            return true;
        }
        if (pFromState.isPresent() && pFromState.orElseThrow().stream().map(AbstractStates.toState(ACSLState.class)).filter(s -> s != null).anyMatch(ACSLState::hasAnnotations)) {
            return true;
        }
        if (AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge)) {
            return false;
        }
        if (this.entersLoop(pEdge).isPresent()) {
            return true;
        }
        CFANode referenceNode = pEdge.getSuccessor();
        return FluentIterable.concat(Collections.singleton(referenceNode), (Iterable)CFAUtils.enteringEdges(referenceNode).filter(AssumeEdge.class).transform(CFAEdge::getPredecessor)).anyMatch(n -> this.isInLoopProximity((CFANode)n));
    }

    private boolean isInLoopProximity(CFANode pReferenceNode) {
        ArrayDeque<ImmutableList> waitlist = new ArrayDeque<ImmutableList>();
        HashSet<CFANode> visited = new HashSet<CFANode>();
        waitlist.push(ImmutableList.of((Object)pReferenceNode));
        visited.add(pReferenceNode);
        com.google.common.base.Predicate epsilonEdge = edge -> !(edge instanceof AssumeEdge);
        Predicate<CFANode> loopProximity = pNode -> pNode.isLoopStart();
        if (this.cfa.getAllLoopHeads().isPresent()) {
            loopProximity = loopProximity.and(pNode -> this.cfa.getAllLoopHeads().orElseThrow().contains(pNode));
        }
        while (!waitlist.isEmpty()) {
            List current = (List)waitlist.pop();
            CFANode currentNode = (CFANode)current.get(current.size() - 1);
            Boolean memoized = this.loopProximityMemo.get(currentNode);
            if (memoized != null && !memoized.booleanValue()) continue;
            if (memoized != null && memoized.booleanValue() || loopProximity.test(currentNode)) {
                for (CFANode onTrace : current) {
                    this.loopProximityMemo.put(onTrace, true);
                }
                return true;
            }
            for (CFAEdge enteringEdge : CFAUtils.enteringEdges(currentNode).filter(epsilonEdge)) {
                CFANode predecessor = enteringEdge.getPredecessor();
                if (!visited.add(predecessor)) continue;
                waitlist.push(ImmutableList.builder().addAll((Iterable)current).add((Object)predecessor).build());
            }
        }
        for (CFANode v : visited) {
            this.loopProximityMemo.put(v, false);
        }
        return false;
    }

    private Optional<CFANode> entersLoop(CFAEdge pEdge) {
        return this.entersLoop(pEdge, true);
    }

    private Optional<CFANode> entersLoop(final CFAEdge pEdge, boolean pAllowGoto) {
        class EnterLoopVisitor
        implements CFATraversal.CFAVisitor {
            private final Collection<CFAEdge> previouslyChecked = new ArrayList<CFAEdge>();
            private LoopEntryInfo loopEntryInfo = new LoopEntryInfo();

            EnterLoopVisitor() {
            }

            @Override
            public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                LoopEntryInfo loopEntryInformation = WitnessFactory.this.loopEntryInfoMemo.get(pEdge);
                if (loopEntryInformation != null) {
                    this.loopEntryInfo = loopEntryInformation;
                    return CFATraversal.TraversalProcess.ABORT;
                }
                if (pNode.isLoopStart()) {
                    boolean gotoLoop = false;
                    if (pNode instanceof CFALabelNode) {
                        CFALabelNode node = (CFALabelNode)pNode;
                        for (BlankEdge e : CFAUtils.enteringEdges(pNode).filter(BlankEdge.class)) {
                            if (!e.getDescription().equals("Goto: " + node.getLabel())) continue;
                            gotoLoop = true;
                            break;
                        }
                    }
                    this.loopEntryInfo = new LoopEntryInfo(pNode, gotoLoop);
                    WitnessFactory.this.loopEntryInfoMemo.put(pEdge, this.loopEntryInfo);
                    return CFATraversal.TraversalProcess.ABORT;
                }
                if (pNode.getNumLeavingEdges() > 1) {
                    return CFATraversal.TraversalProcess.ABORT;
                }
                this.previouslyChecked.add(pEdge);
                return CFATraversal.TraversalProcess.CONTINUE;
            }

            @Override
            public CFATraversal.TraversalProcess visitEdge(CFAEdge pCfaEdge) {
                return AutomatonGraphmlCommon.handleAsEpsilonEdge(pCfaEdge) ? CFATraversal.TraversalProcess.CONTINUE : CFATraversal.TraversalProcess.SKIP;
            }
        }
        EnterLoopVisitor enterLoopVisitor = new EnterLoopVisitor();
        CFATraversal.dfs().ignoreFunctionCalls().ignoreSummaryEdges().traverse(pEdge.getSuccessor(), enterLoopVisitor);
        LoopEntryInfo loopEntryInfo = enterLoopVisitor.loopEntryInfo;
        for (CFAEdge e : enterLoopVisitor.previouslyChecked) {
            this.loopEntryInfoMemo.put(e, loopEntryInfo);
        }
        if (!loopEntryInfo.entersLoop() || loopEntryInfo.isGotoLoop() && !pAllowGoto) {
            return Optional.empty();
        }
        return Optional.ofNullable(loopEntryInfo.loopHead);
    }

    private static @Nullable CFAEdgeWithAssumptions getFromValueMap(Multimap<ARGState, CFAEdgeWithAssumptions> pValueMap, ARGState pState, CFAEdge pEdge) {
        Iterable assumptions = pValueMap.get((Object)pState);
        if (Iterables.isEmpty((Iterable)(assumptions = Iterables.filter((Iterable)assumptions, a -> a.getCFAEdge().equals(pEdge))))) {
            return null;
        }
        return (CFAEdgeWithAssumptions)Iterables.getOnlyElement((Iterable)assumptions);
    }

    private static String getAmbiguousName(ASimpleDeclaration pDeclaration, Optional<String> pQualifier) {
        String ambiguousName = pDeclaration.getOrigName();
        if (!pQualifier.isPresent()) {
            return ambiguousName;
        }
        return pQualifier.orElseThrow() + "::" + pDeclaration.getOrigName();
    }

    private ExpressionTree<Object> getStateInvariant(String pStateId) {
        ExpressionTree<Object> result = this.stateInvariants.get(pStateId);
        if (result == null) {
            return ExpressionTrees.getTrue();
        }
        return result;
    }

    private ExpressionTree<Object> getQuasiInvariant(String pNodeId) {
        ExpressionTree<Object> result = this.stateQuasiInvariants.get(pNodeId);
        if (result == null) {
            return ExpressionTrees.getFalse();
        }
        return result;
    }

    private Map<String, String> getStateScopes() {
        return this.stateScopes;
    }

    private static class LoopEntryInfo {
        private final @Nullable CFANode loopHead;
        private final boolean gotoLoop;

        public LoopEntryInfo() {
            this(null, false);
        }

        public LoopEntryInfo(CFANode pLoopHead, boolean pGotoLoop) {
            if (pGotoLoop) {
                Objects.requireNonNull(pLoopHead);
            }
            this.loopHead = pLoopHead;
            this.gotoLoop = pGotoLoop;
        }

        public boolean entersLoop() {
            return this.loopHead != null;
        }

        public CFANode getLoopHead() {
            return this.loopHead;
        }

        public boolean isGotoLoop() {
            return this.gotoLoop;
        }

        public String toString() {
            return String.format("Loop head: %s; Goto: %s", this.loopHead, this.gotoLoop);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof LoopEntryInfo) {
                LoopEntryInfo other = (LoopEntryInfo)pOther;
                return Objects.equals(this.getLoopHead(), other.getLoopHead()) && this.gotoLoop == other.gotoLoop;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.loopHead, this.gotoLoop);
        }
    }
}

