/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.Appender;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.ReportGenerator;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter.WitnessToDotFormatter;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter.WitnessToGraphMLFormatter;
import org.sosy_lab.cpachecker.cpa.slab.SLARGToDotWriter;
import org.sosy_lab.cpachecker.util.NumericIdProvider;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class WitnessToOutputFormatsUtils {
    public static void writeWitness(Path filename, boolean compressFile, Appender content, LogManager logger) {
        try {
            if (compressFile) {
                Path file = filename.resolveSibling(filename.getFileName() + ".gz");
                IO.writeGZIPFile((Path)file, (Charset)Charset.defaultCharset(), (Object)content);
            } else {
                IO.writeFile((Path)filename, (Charset)Charset.defaultCharset(), (Object)content);
            }
        }
        catch (IOException e) {
            logger.logfException(Level.WARNING, (Throwable)e, "Violation witness export to %s failed.", new Object[]{filename});
        }
    }

    public static void writeToGraphMl(Witness witness, Appendable pTarget) throws IOException {
        new WitnessToGraphMLFormatter(witness).appendTo(pTarget);
    }

    public static void writeToDot(Witness witness, Appendable pTarget) throws IOException {
        new WitnessToDotFormatter(witness).appendTo(pTarget);
    }

    public static void witnessToMapsForHTMLReport(Witness witness, Map<String, Map<String, Object>> nodesMap, Map<String, Object> edgesMap) {
        NumericIdProvider idProvider = NumericIdProvider.create();
        String entryStateNode = witness.getEntryStateNodeId();
        HashSet<String> nodes = new HashSet<String>();
        ArrayDeque<String> waitlist = new ArrayDeque<String>();
        waitlist.push(entryStateNode);
        nodes.add(entryStateNode);
        while (!waitlist.isEmpty()) {
            String source = (String)waitlist.pop();
            Map<String, Object> sourceNode = nodesMap.get(source);
            if (sourceNode == null) {
                ExpressionTree<Object> tree;
                sourceNode = new HashMap<String, Object>();
                List nodeIds = (List)witness.getARGStatesFor(source).stream().map(ARGState::getStateId).collect(ImmutableList.toImmutableList());
                String nodeString = SLARGToDotWriter.generateLocationString(nodeIds).toString();
                StringBuilder labelBuilder = new StringBuilder(source);
                if (!nodeString.isEmpty()) {
                    labelBuilder.append(String.format("%nARG node%s: ", nodeIds.size() == 1 ? "" : "s"));
                    labelBuilder.append(nodeString);
                }
                if (!(tree = witness.getStateInvariant(source)).equals(ExpressionTrees.getTrue())) {
                    sourceNode.put(AutomatonGraphmlCommon.KeyDef.INVARIANT.toString(), tree.toString());
                    String scope = witness.getStateScopes().get(source);
                    labelBuilder.append(System.lineSeparator()).append(tree.toString());
                    if (!Strings.isNullOrEmpty((String)scope) && !tree.equals(ExpressionTrees.getFalse())) {
                        sourceNode.put(AutomatonGraphmlCommon.KeyDef.INVARIANTSCOPE.toString(), scope);
                        labelBuilder.append(System.lineSeparator()).append(scope);
                    }
                }
                sourceNode.put("index", idProvider.provideNumericId(source));
                sourceNode.put("label", labelBuilder.toString());
                sourceNode.put("type", WitnessToOutputFormatsUtils.determineNodeType(witness, source));
                sourceNode.put("func", "main");
                nodesMap.put(source, sourceNode);
            }
            for (Edge edge : witness.getLeavingEdges().get((Object)source)) {
                ExpressionTree<Object> tree = witness.getStateInvariant(edge.getTarget());
                List<CFAEdge> edges = witness.getCFAEdgeFor(edge);
                Map<String, Object> edgeMap = ReportGenerator.createArgEdge(idProvider.provideNumericId(source), idProvider.provideNumericId(edge.getTarget()), edges);
                for (Map.Entry<AutomatonGraphmlCommon.KeyDef, String> e : edge.getLabel().getMapping().entrySet()) {
                    edgeMap.put(e.getKey().toString(), e.getValue());
                }
                edgesMap.put(edge.getSource() + "->" + edge.getTarget(), edgeMap);
                if (!nodes.add(edge.getTarget()) || ExpressionTrees.getFalse().equals(tree)) continue;
                waitlist.push(edge.getTarget());
            }
        }
    }

    private static String determineNodeType(Witness witness, String source) {
        Collection<ARGState> states = witness.getARGStatesFor(source);
        if (!witness.getViolatedProperties().get((Object)source).isEmpty() || states.stream().anyMatch(ARGState::isTarget)) {
            return "target";
        }
        if (!states.stream().allMatch(ARGState::wasExpanded)) {
            return "not-expanded";
        }
        if (states.stream().anyMatch(ARGState::shouldBeHighlighted)) {
            return "highlighted";
        }
        return "";
    }
}

