/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter.WitnessToOutputFormatter;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class WitnessToDotFormatter
extends WitnessToOutputFormatter<String> {
    private Map<String, Collection<String>> nodesToLabel;
    private Map<String, String> nodesToColor;

    public WitnessToDotFormatter(Witness pWitness) {
        super(pWitness);
    }

    @Override
    protected void initialize(Appendable pTarget) throws IOException {
        this.nodesToLabel = new LinkedHashMap<String, Collection<String>>();
        this.nodesToColor = new LinkedHashMap<String, String>();
        pTarget.append("digraph WITNESS {\n");
    }

    @Override
    protected void finish(Appendable pTarget) throws IOException {
        for (Map.Entry<String, Collection<String>> entry : this.nodesToLabel.entrySet()) {
            String nodeId = entry.getKey();
            String color = this.nodesToColor.getOrDefault(nodeId, "");
            pTarget.append(nodeId).append(" [label=\"").append(Joiner.on((String)"\\n").join((Iterable)entry.getValue())).append("\"").append(color).append("];\n");
        }
        pTarget.append("\n}");
    }

    private static String eq(Object o1, Object o2) {
        Object o2str = o2.toString();
        if (((String)o2str).contains(" ")) {
            o2str = "\\\"" + (String)o2str + "\\\"";
        }
        return String.format("%s=%s", o1, o2str);
    }

    @Override
    protected String createNewNode(String pNodeId, Appendable pTarget) throws IOException {
        String nodeId = Integer.toString(this.nodesToLabel.size());
        ArrayList<String> labels = new ArrayList<String>();
        labels.add(pNodeId);
        for (AutomatonGraphmlCommon.NodeFlag f : this.witness.getNodeFlags().get((Object)pNodeId)) {
            labels.add(WitnessToDotFormatter.eq((Object)f.key, "true"));
            this.nodesToColor.put(nodeId, this.nodesToColor.getOrDefault(nodeId, "") + " " + WitnessToDotFormatter.getColorForNode(f));
        }
        for (Targetable.TargetInformation violation : this.witness.getViolatedProperties().get((Object)pNodeId)) {
            labels.add(WitnessToDotFormatter.eq((Object)AutomatonGraphmlCommon.KeyDef.VIOLATEDPROPERTY, violation));
        }
        if (this.witness.hasQuasiInvariant(pNodeId)) {
            ExpressionTree<Object> tree = this.witness.getQuasiInvariant(pNodeId);
            labels.add(WitnessToDotFormatter.eq((Object)AutomatonGraphmlCommon.KeyDef.INVARIANT, tree));
        }
        this.nodesToLabel.put(nodeId, labels);
        return nodeId;
    }

    private static String getColorForNode(AutomatonGraphmlCommon.NodeFlag f) {
        switch (f) {
            case ISFRONTIER: {
                return "color=orange";
            }
            case ISVIOLATION: {
                return "color=red";
            }
            case ISENTRY: {
                return "color=green";
            }
            case ISSINKNODE: {
                return "color=blue";
            }
            case ISCYCLEHEAD: {
                return "shape=doublecircle";
            }
        }
        return "";
    }

    @Override
    protected void createNewEdge(Edge pEdge, String pSourceNode, String pTargetNode, Appendable pTarget) throws IOException {
        ArrayList<String> labels = new ArrayList<String>();
        Object color = "";
        for (Map.Entry<AutomatonGraphmlCommon.KeyDef, String> entry : pEdge.getLabel().getMapping().entrySet()) {
            AutomatonGraphmlCommon.KeyDef keyDef = entry.getKey();
            String value = entry.getValue();
            if (keyDef.keyFor.equals((Object)AutomatonGraphmlCommon.ElementType.EDGE)) {
                labels.add(WitnessToDotFormatter.eq((Object)keyDef, value));
                if (!AutomatonGraphmlCommon.KeyDef.THREADID.equals((Object)keyDef)) continue;
                color = "colorscheme=set19 color=" + value;
                continue;
            }
            if (!keyDef.keyFor.equals((Object)AutomatonGraphmlCommon.ElementType.NODE)) continue;
            this.nodesToLabel.get(pTargetNode).add(WitnessToDotFormatter.eq((Object)keyDef, value));
        }
        pTarget.append(pSourceNode).append(" -> ").append(pTargetNode).append(" [label=\"").append(Joiner.on((String)"\\n").join(labels)).append("\" ").append((CharSequence)color).append("];\n");
    }

    @Override
    protected void addInvariantsData(String pNodeId, ExpressionTree<Object> pTree, @Nullable String pScope, Appendable pTarget) {
        this.nodesToLabel.get(pNodeId).add(WitnessToDotFormatter.eq((Object)AutomatonGraphmlCommon.KeyDef.INVARIANT, pTree));
        if (!Strings.isNullOrEmpty((String)pScope) && !pTree.equals(ExpressionTrees.getFalse())) {
            this.nodesToLabel.get(pNodeId).add(WitnessToDotFormatter.eq((Object)AutomatonGraphmlCommon.KeyDef.INVARIANTSCOPE, pScope));
        }
    }
}

