/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter.WitnessToOutputFormatter;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.w3c.dom.Element;

public class WitnessToGraphMLFormatter
extends WitnessToOutputFormatter<Element> {
    private AutomatonGraphmlCommon.GraphMlBuilder doc;

    public WitnessToGraphMLFormatter(Witness pWitness) {
        super(pWitness);
    }

    @Override
    protected void initialize(Appendable pTarget) throws IOException {
        try {
            this.doc = new AutomatonGraphmlCommon.GraphMlBuilder(this.witness.getWitnessType(), this.witness.getOriginFile(), this.witness.getCfa(), this.witness.getMetaData());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void finish(Appendable pTarget) throws IOException {
        this.doc.appendTo(pTarget);
    }

    @Override
    protected Element createNewNode(String pNodeId, Appendable pTarget) {
        Element result = this.doc.createNodeElement(pNodeId, AutomatonGraphmlCommon.NodeType.ONPATH);
        if (this.witness.getWitnessOptions().exportNodeLabel()) {
            this.doc.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.LABEL, pNodeId);
        }
        for (AutomatonGraphmlCommon.NodeFlag f : this.witness.getNodeFlags().get((Object)pNodeId)) {
            this.doc.addDataElementChild(result, f.key, "true");
        }
        for (Targetable.TargetInformation violation : this.witness.getViolatedProperties().get((Object)pNodeId)) {
            this.doc.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.VIOLATEDPROPERTY, violation.toString());
        }
        if (this.witness.hasQuasiInvariant(pNodeId)) {
            ExpressionTree<Object> tree = this.witness.getQuasiInvariant(pNodeId);
            this.doc.addDataElementChild(result, AutomatonGraphmlCommon.KeyDef.INVARIANT, tree.toString());
        }
        return result;
    }

    @Override
    protected void createNewEdge(Edge pEdge, Element pSourceNode, Element pTargetNode, Appendable pTarget) {
        Element edge = this.doc.createEdgeElement(pEdge.getSource(), pEdge.getTarget());
        for (Map.Entry<AutomatonGraphmlCommon.KeyDef, String> entry : pEdge.getLabel().getMapping().entrySet()) {
            AutomatonGraphmlCommon.KeyDef keyDef = entry.getKey();
            String value = entry.getValue();
            if (keyDef.keyFor.equals((Object)AutomatonGraphmlCommon.ElementType.EDGE)) {
                this.doc.addDataElementChild(edge, keyDef, value);
                continue;
            }
            if (!keyDef.keyFor.equals((Object)AutomatonGraphmlCommon.ElementType.NODE)) continue;
            this.doc.addDataElementChild(pTargetNode, keyDef, value);
        }
    }

    @Override
    protected void addInvariantsData(Element pNode, ExpressionTree<Object> pTree, @Nullable String pScope, Appendable pTarget) {
        this.doc.addDataElementChild(pNode, AutomatonGraphmlCommon.KeyDef.INVARIANT, pTree.toString());
        if (!Strings.isNullOrEmpty((String)pScope) && !pTree.equals(ExpressionTrees.getFalse())) {
            this.doc.addDataElementChild(pNode, AutomatonGraphmlCommon.KeyDef.INVARIANTSCOPE, pScope);
        }
    }
}

