/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.arg.witnessexport.formatter;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Edge;
import org.sosy_lab.cpachecker.cpa.arg.witnessexport.Witness;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public abstract class WitnessToOutputFormatter<T> {
    protected final Witness witness;

    protected WitnessToOutputFormatter(Witness pWitness) {
        this.witness = pWitness;
    }

    public void appendTo(Appendable pTarget) throws IOException {
        this.initialize(pTarget);
        this.traverseGraph(pTarget);
        this.finish(pTarget);
    }

    private void traverseGraph(Appendable pTarget) throws IOException {
        String entryStateNodeId = this.witness.getEntryStateNodeId();
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        ArrayDeque<String> waitlist = new ArrayDeque<String>();
        waitlist.push(entryStateNodeId);
        T entryNode = this.createNewNode(entryStateNodeId, pTarget);
        this.addAndGetInvariantsData(entryNode, entryStateNodeId, pTarget);
        nodes.put(entryStateNodeId, entryNode);
        while (!waitlist.isEmpty()) {
            String source = (String)waitlist.pop();
            for (Edge edge : this.witness.getLeavingEdges().get((Object)source)) {
                Object targetNode = nodes.get(edge.getTarget());
                if (targetNode == null) {
                    targetNode = this.createNewNode(edge.getTarget(), pTarget);
                    ExpressionTree<Object> invariant = this.addAndGetInvariantsData(targetNode, edge.getTarget(), pTarget);
                    if (!ExpressionTrees.getFalse().equals(invariant)) {
                        waitlist.push(edge.getTarget());
                    }
                    nodes.put(edge.getTarget(), targetNode);
                }
                this.createNewEdge(edge, nodes.get(source), targetNode, pTarget);
            }
        }
    }

    private ExpressionTree<Object> addAndGetInvariantsData(T t, String pStateId, Appendable pTarget) {
        if (!this.witness.getInvariantExportStates().contains(pStateId)) {
            return ExpressionTrees.getTrue();
        }
        ExpressionTree<Object> tree = this.witness.getStateInvariant(pStateId);
        if (!tree.equals(ExpressionTrees.getTrue())) {
            this.addInvariantsData(t, tree, this.witness.getStateScopes().get(pStateId), pTarget);
        }
        return tree;
    }

    protected abstract void initialize(Appendable var1) throws IOException;

    protected abstract void finish(Appendable var1) throws IOException;

    protected abstract T createNewNode(String var1, Appendable var2) throws IOException;

    protected abstract void createNewEdge(Edge var1, T var2, T var3, Appendable var4) throws IOException;

    protected abstract void addInvariantsData(T var1, ExpressionTree<Object> var2, @Nullable String var3, Appendable var4);
}

