/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.argReplay;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.argReplay.ARGReplayState;

public class ARGReplayTransferRelation
extends SingleEdgeTransferRelation {
    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState pState, Precision pPrecision, CFAEdge pCfaEdge) {
        Set<ARGState> baseStates = ((ARGReplayState)pState).getStates();
        HashSet<ARGState> successors = new HashSet<ARGState>();
        for (ARGState baseState : baseStates) {
            this.getChildren(pCfaEdge, baseState, successors);
        }
        return ImmutableSet.of((Object)new ARGReplayState(successors, ((ARGReplayState)pState).getCPA()));
    }

    private void getChildren(CFAEdge pCfaEdge, ARGState baseState, Set<ARGState> successors) {
        for (ARGState child : baseState.getChildren()) {
            if (!pCfaEdge.equals(baseState.getEdgeToChild(child))) continue;
            if (child.isCovered()) {
                successors.add(child.getCoveringState());
                continue;
            }
            successors.add(child);
        }
    }
}

