/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.defaults.SingleEdgeTransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionBuilder;
import org.sosy_lab.cpachecker.cpa.assumptions.genericassumptions.GenericAssumptionsState;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.ArithmeticOverflowAssumptionBuilder;

public class GenericAssumptionsTransferRelation
extends SingleEdgeTransferRelation {
    private final List<GenericAssumptionBuilder> assumptionBuilders;

    public GenericAssumptionsTransferRelation(CFA pCFA, LogManager logger, Configuration pConfiguration) throws InvalidConfigurationException {
        this.assumptionBuilders = ImmutableList.of((Object)new ArithmeticOverflowAssumptionBuilder(pCFA, logger, pConfiguration));
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessorsForEdge(AbstractState el, Precision p, CFAEdge edge) throws CPATransferException {
        ArrayList<CExpression> allAssumptions = new ArrayList<CExpression>();
        for (GenericAssumptionBuilder b : this.assumptionBuilders) {
            allAssumptions.addAll(b.assumptionsForEdge(edge));
        }
        return ImmutableSet.of((Object)new GenericAssumptionsState(allAssumptions));
    }
}

