/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import java.util.Collection;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.AnalysisDirection;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageDomain;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStoragePrecisionAdjustment;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageStop;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaConverter;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.CtoFormulaTypeHandler;
import org.sosy_lab.cpachecker.util.predicates.pathformula.ctoformula.FormulaEncodingOptions;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.Solver;

public class AssumptionStorageCPA
implements ConfigurableProgramAnalysis,
ProofChecker,
AutoCloseable {
    private final AssumptionStorageTransferRelation transferRelation;
    private final FormulaManagerView formulaManager;
    private final AssumptionStorageState topState;
    private final Solver solver;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(AssumptionStorageCPA.class);
    }

    private AssumptionStorageCPA(Configuration config, LogManager logger, ShutdownNotifier pShutdownNotifier, CFA cfa) throws InvalidConfigurationException {
        this.solver = Solver.create(config, logger, pShutdownNotifier);
        this.formulaManager = this.solver.getFormulaManager();
        FormulaEncodingOptions options = new FormulaEncodingOptions(config);
        CtoFormulaTypeHandler typeHandler = new CtoFormulaTypeHandler(logger, cfa.getMachineModel());
        CtoFormulaConverter converter = new CtoFormulaConverter(options, this.formulaManager, cfa.getMachineModel(), cfa.getVarClassification(), logger, pShutdownNotifier, typeHandler, AnalysisDirection.FORWARD);
        BooleanFormulaManagerView bfmgr = this.formulaManager.getBooleanFormulaManager();
        this.topState = new AssumptionStorageState(this.formulaManager, bfmgr.makeTrue(), bfmgr.makeTrue());
        this.transferRelation = new AssumptionStorageTransferRelation(converter, this.formulaManager, this.topState);
    }

    public FormulaManagerView getFormulaManager() {
        return this.formulaManager;
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return new AssumptionStorageDomain();
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.topState;
    }

    @Override
    public MergeOperator getMergeOperator() {
        return MergeSepOperator.getInstance();
    }

    @Override
    public StopOperator getStopOperator() {
        return new AssumptionStorageStop();
    }

    @Override
    public TransferRelation getTransferRelation() {
        return this.transferRelation;
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        return new AssumptionStoragePrecisionAdjustment(this.transferRelation);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pState, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        return true;
    }

    @Override
    public boolean isCoveredBy(AbstractState pState, AbstractState pOtherState) throws CPAException, InterruptedException {
        return true;
    }

    @Override
    public void close() {
        this.solver.close();
    }
}

