/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.DummyCFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageState;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageTransferRelation;
import org.sosy_lab.cpachecker.cpa.location.LocationState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class AssumptionStoragePrecisionAdjustment
implements PrecisionAdjustment {
    private final AssumptionStorageTransferRelation transferRelation;

    public AssumptionStoragePrecisionAdjustment(AssumptionStorageTransferRelation pTransferRelation) {
        this.transferRelation = pTransferRelation;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        return StaticPrecisionAdjustment.getInstance().prec(pState, pPrecision, pStates, pStateProjection, pFullState);
    }

    @Override
    public Optional<? extends AbstractState> strengthen(AbstractState pState, Precision pPrecision, Iterable<AbstractState> pOtherStates) throws CPAException, InterruptedException {
        AssumptionStorageState state = (AssumptionStorageState)pState;
        CFAEdge edge = this.getEdge(pOtherStates);
        return Optional.of(this.transferRelation.strengthen(state.reset(), pOtherStates, edge));
    }

    private CFAEdge getEdge(Iterable<AbstractState> pStates) {
        CFANode successor;
        Optional locationState = FluentIterable.from(pStates).filter(LocationState.class).first().toJavaUtil();
        if (locationState.isPresent()) {
            LocationState ls = (LocationState)locationState.orElseThrow();
            successor = ls.getLocationNode();
            if (successor.getNumEnteringEdges() == 1) {
                return successor.getEnteringEdge(0);
            }
        } else {
            successor = CFANode.newDummyCFANode("__CPAchecker_dummy");
        }
        CFANode predecessor = successor;
        return new DummyCFAEdge(predecessor, successor);
    }
}

