/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.assumptions.storage;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.sosy_lab.common.Appender;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;
import org.sosy_lab.cpachecker.util.predicates.smt.BooleanFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class AssumptionStorageState
implements AbstractState,
Serializable {
    private static final long serialVersionUID = -3738604180058424317L;
    private final transient BooleanFormula assumption;
    private final transient BooleanFormula stopFormula;
    private final transient FormulaManagerView fmgr;

    public AssumptionStorageState(FormulaManagerView pFmgr, BooleanFormula pAssumption, BooleanFormula pStopFormula) {
        this.assumption = (BooleanFormula)Preconditions.checkNotNull((Object)pAssumption);
        this.stopFormula = (BooleanFormula)Preconditions.checkNotNull((Object)pStopFormula);
        this.fmgr = pFmgr;
        assert (!this.fmgr.getBooleanFormulaManager().isFalse(this.assumption));
    }

    public FormulaManagerView getFormulaManager() {
        return this.fmgr;
    }

    public BooleanFormula getAssumption() {
        return this.assumption;
    }

    public Appender getAssumptionAsString() {
        return this.fmgr.dumpFormula(this.assumption);
    }

    public boolean isAssumptionTrue() {
        return this.fmgr.getBooleanFormulaManager().isTrue(this.assumption);
    }

    public boolean isAssumptionFalse() {
        return this.fmgr.getBooleanFormulaManager().isFalse(this.assumption);
    }

    public BooleanFormula getStopFormula() {
        return this.stopFormula;
    }

    public boolean isStopFormulaTrue() {
        return this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula);
    }

    public boolean isStopFormulaFalse() {
        return this.fmgr.getBooleanFormulaManager().isFalse(this.stopFormula);
    }

    @Override
    public String toString() {
        return (this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula) ? "" : "<STOP> ") + "assume: (" + this.assumption + " & " + this.stopFormula + ")";
    }

    public boolean isStop() {
        return !this.fmgr.getBooleanFormulaManager().isTrue(this.stopFormula);
    }

    public AssumptionStorageState join(AssumptionStorageState other) {
        BooleanFormulaManagerView bfmgr = this.fmgr.getBooleanFormulaManager();
        BooleanFormula newStopFormula = this.isStopFormulaTrue() ? other.getStopFormula() : (other.isStopFormulaTrue() ? this.getStopFormula() : bfmgr.or(this.getStopFormula(), other.getStopFormula()));
        return new AssumptionStorageState(this.fmgr, bfmgr.and(this.getAssumption(), other.getAssumption()), newStopFormula);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof AssumptionStorageState) {
            AssumptionStorageState otherElement = (AssumptionStorageState)other;
            return this.assumption.equals(otherElement.assumption) && this.stopFormula.equals(otherElement.stopFormula);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.assumption.hashCode() + 17 * this.stopFormula.hashCode();
    }

    public AssumptionStorageState reset() {
        if (this.isAssumptionTrue() && this.isStopFormulaTrue()) {
            return this;
        }
        BooleanFormula trueFormula = this.fmgr.getBooleanFormulaManager().makeTrue();
        return new AssumptionStorageState(this.fmgr, trueFormula, trueFormula);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        Preconditions.checkState((this.isAssumptionTrue() && this.isStopFormulaTrue() ? 1 : 0) != 0, (Object)"Assumption and stop formula must be true for serialization to be correctly restored");
        out.defaultWriteObject();
    }

    private Object readResolve() {
        FormulaManagerView fManager = GlobalInfo.getInstance().getAssumptionStorageFormulaManager();
        return new AssumptionStorageState(fManager, fManager.getBooleanFormulaManager().makeTrue(), fManager.getBooleanFormulaManager().makeTrue());
    }
}

