/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.ARGUtils;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.cpa.callstack.CallstackState;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.AbstractStates;

@Options(prefix="cpa.arg.automaton")
public class ARGToAutomatonConverter {
    @Option(secure=true, description="which coarse strategy should be applied when analyzing the ARG?")
    private SplitterStrategy splitStrategy = SplitterStrategy.TARGETS;
    @Option(secure=true, description="after determining branches, which one of them should be exported?")
    private BranchExportStrategy selectionStrategy = BranchExportStrategy.LEAVES;
    @Option(secure=true, description="what data should be exported from the ARG nodes? A different strategy might result in a smaller automaton.")
    private DataExportStrategy dataStrategy = DataExportStrategy.LOCATION;
    @Option(secure=true, description="minimum ratio of branch compared to whole program to be exported")
    private double branchRatio = 0.5;
    @Option(secure=true, description="minimum ratio of siblings such that one of them will be exported")
    private double siblingRatio = 0.4;
    @Option(secure=true, description="when using FIRST_BFS, how many nodes should be skipped? ZERO will only export the root itself, MAX_INT will export only LEAFS.")
    private int skipFirstNum = 10;
    private final CBinaryExpressionBuilder cBinaryExpressionBuilder;
    private final Map<ARGState, Integer> sizeCache = new HashMap<ARGState, Integer>();

    public ARGToAutomatonConverter(@Nullable Configuration config, MachineModel machinemodel, LogManager logger) throws InvalidConfigurationException {
        config.inject((Object)this);
        this.cBinaryExpressionBuilder = new CBinaryExpressionBuilder(machinemodel, logger);
    }

    public Automaton getAutomaton(ARGState root, boolean targetsOnly) {
        switch (this.dataStrategy) {
            case LOCATION: {
                return ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)Predicates.alwaysFalse(), targetsOnly);
            }
            case CALLSTACK: {
                return this.getCallstackAutomatonForStates(root, (Iterable<ARGState>)ARGToAutomatonConverter.getLeaves(root, targetsOnly), targetsOnly);
            }
        }
        throw new AssertionError((Object)"unexpected strategy");
    }

    public Iterable<Automaton> getAutomata(ARGState root) {
        switch (this.splitStrategy) {
            case NONE: {
                return Collections.singleton(ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)Predicates.alwaysFalse(), false));
            }
            case GLOBAL_CONDITIONS: {
                return this.getGlobalConditionSplitAutomata(root, this.selectionStrategy);
            }
            case LEAVES: {
                return ARGToAutomatonConverter.getLeaves(root, false).transform(l -> this.getAutomatonForLeaf(root, (ARGState)l));
            }
            case TARGETS: {
                return ARGToAutomatonConverter.getLeaves(root, true).transform(l -> this.getAutomatonForLeaf(root, (ARGState)l));
            }
        }
        throw new AssertionError((Object)"unexpected strategy");
    }

    private static Automaton getLocationAutomatonForStates(ARGState pRoot, Predicate<ARGState> ignoreState, boolean withTargetStates) {
        try {
            return ARGToAutomatonConverter.getLocationAutomatonForStates0(pRoot, ignoreState, withTargetStates);
        }
        catch (InvalidAutomatonException e) {
            throw new AssertionError("unexpected exception", e);
        }
    }

    private static Automaton getLocationAutomatonForStates0(ARGState root, Predicate<ARGState> ignoreState, boolean withTargetStates) throws InvalidAutomatonException {
        Preconditions.checkArgument((!ignoreState.apply((Object)root) ? 1 : 0) != 0);
        Preconditions.checkArgument((!root.isCovered() ? 1 : 0) != 0);
        ImmutableMap variables = ImmutableMap.of();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.add(root);
        ArrayList<AutomatonInternalState> states = new ArrayList<AutomatonInternalState>();
        if (withTargetStates) {
            states.add(AutomatonInternalState.ERROR);
        }
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            if (!finished.add(s)) continue;
            ArrayList<AutomatonTransition> transitions = new ArrayList<AutomatonTransition>();
            ArrayList<AutomatonBoolExpr> locationQueries = new ArrayList<AutomatonBoolExpr>();
            for (ARGState child : s.getChildren()) {
                if (ignoreState.apply((Object)(child = ARGToAutomatonConverter.uncover(child)))) continue;
                CFANode location = AbstractStates.extractLocation(child);
                AutomatonBoolExpr.CPAQuery locationQuery = new AutomatonBoolExpr.CPAQuery("location", "nodenumber==" + location.getNodeNumber());
                locationQueries.add(locationQuery);
                String id = withTargetStates && child.isTarget() ? AutomatonInternalState.ERROR.getName() : ARGToAutomatonConverter.id(child);
                transitions.add(new AutomatonTransition.Builder((AutomatonBoolExpr)locationQuery, id).build());
                waitlist.add(child);
            }
            if (withTargetStates && s.isTarget()) {
                assert (transitions.isEmpty());
                assert (states.contains(AutomatonInternalState.ERROR));
                continue;
            }
            transitions.add(new AutomatonTransition.Builder(ARGToAutomatonConverter.buildOtherwise(locationQueries), AutomatonInternalState.BOTTOM).build());
            boolean hasSeveralChildren = transitions.size() > 1;
            states.add(new AutomatonInternalState(ARGToAutomatonConverter.id(s), transitions, false, hasSeveralChildren, false));
        }
        return new Automaton("ARG", (Map<String, AutomatonVariable>)variables, states, ARGToAutomatonConverter.id(root));
    }

    private static ARGState uncover(ARGState s) {
        while (s.isCovered()) {
            s = s.getCoveringState();
        }
        return s;
    }

    private static Iterable<ARGState> uncover(Iterable<ARGState> states) {
        return Iterables.transform(states, ARGToAutomatonConverter::uncover);
    }

    private static AutomatonBoolExpr buildOtherwise(List<AutomatonBoolExpr> locationQueries) {
        if (locationQueries.isEmpty()) {
            return AutomatonBoolExpr.TRUE;
        }
        AutomatonBoolExpr otherwise = locationQueries.get(0);
        for (AutomatonBoolExpr expr : Iterables.skip(locationQueries, (int)1)) {
            otherwise = new AutomatonBoolExpr.And(otherwise, expr);
        }
        return new AutomatonBoolExpr.Negation(otherwise);
    }

    @Deprecated
    private Iterable<Automaton> getGlobalConditionSplitAutomata(ARGState root, BranchExportStrategy branchExportStrategy) {
        Map<ARGState, BranchingInfo> dependencies = this.getGlobalBranchingTree(root);
        Preconditions.checkState((dependencies.isEmpty() || dependencies.containsKey(root) ? 1 : 0) != 0);
        Map<ARGState, BranchingInfo> loopFreeDependencies = this.getFilteredDependencies(root, dependencies);
        Preconditions.checkState((loopFreeDependencies.isEmpty() || loopFreeDependencies.containsKey(root) ? 1 : 0) != 0);
        this.addBranchInformation(root, loopFreeDependencies);
        this.addParents(loopFreeDependencies);
        return this.collectAutomata(root, loopFreeDependencies, branchExportStrategy);
    }

    private Iterable<Automaton> collectAutomata(ARGState root, Map<ARGState, BranchingInfo> pDependencies, BranchExportStrategy export) {
        switch (export) {
            case NONE: {
                return ImmutableList.of();
            }
            case ALL: {
                return FluentIterable.from(pDependencies.entrySet()).transformAndConcat(entry -> ((BranchingInfo)entry.getValue()).getIgnoreStates()).transform(ignores -> ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)((Predicate)s -> ignores.contains(s)), false));
            }
            case LEAVES: {
                return FluentIterable.from(pDependencies.entrySet()).filter(entry -> ((BranchingInfo)entry.getValue()).getNextStates().isEmpty()).transformAndConcat(entry -> ((BranchingInfo)entry.getValue()).getIgnoreStates()).transform(ignores -> ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)((Predicate)s -> ignores.contains(s)), false));
            }
            case WEIGHTED: {
                return this.getWeightedAutomata(root, pDependencies);
            }
            case FIRST_BFS: {
                return this.getFirstBFSAutomata(root, pDependencies);
            }
        }
        throw new AssertionError((Object)"unexpected export strategy");
    }

    private Iterable<Automaton> getFirstBFSAutomata(ARGState pRoot, Map<ARGState, BranchingInfo> pDependencies) {
        Set<ARGState> statesForExport = this.getTopStatesForAutomata(pRoot, pDependencies);
        HashMultimap sortedPaths = HashMultimap.create();
        for (ARGState state : statesForExport) {
            for (PersistentSet<ARGState> ignores2 : pDependencies.get(state).getIgnoreStates()) {
                sortedPaths.put((Object)ignores2.size(), ignores2);
            }
        }
        ArrayList<PersistentSet> paths = new ArrayList<PersistentSet>();
        for (PersistentSet path : sortedPaths.values()) {
            if (this.isCovered(path, (Multimap<Integer, PersistentSet<ARGState>>)sortedPaths)) continue;
            paths.add(path);
        }
        return FluentIterable.from(paths).transform(ignores -> ARGToAutomatonConverter.getLocationAutomatonForStates(pRoot, (Predicate<ARGState>)((Predicate)s -> ignores.contains(s)), false));
    }

    private boolean isCovered(PersistentSet<ARGState> path, Multimap<Integer, PersistentSet<ARGState>> sortedPaths) {
        Iterator iterator = sortedPaths.keySet().iterator();
        while (iterator.hasNext()) {
            int size = (Integer)iterator.next();
            if (size >= path.size()) continue;
            for (PersistentSet shorterPath : sortedPaths.get((Object)size)) {
                if (!path.asSet().containsAll(shorterPath.asSet())) continue;
                return true;
            }
        }
        return false;
    }

    private Set<ARGState> getTopStatesForAutomata(ARGState root, Map<ARGState, BranchingInfo> pDependencies) {
        LinkedHashSet<ARGState> alwaysExport = new LinkedHashSet<ARGState>();
        LinkedHashSet<ARGState> finished = new LinkedHashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(root);
        while (!waitlist.isEmpty()) {
            if (finished.size() > this.skipFirstNum) {
                alwaysExport.addAll(waitlist);
                break;
            }
            ARGState s = (ARGState)waitlist.pop();
            if (!finished.add(s)) continue;
            BranchingInfo bi = pDependencies.get(s);
            Set<ARGState> children = bi.getNextStates();
            if (children.isEmpty()) {
                alwaysExport.add(s);
            }
            for (ARGState child : children) {
                if (finished.contains(child)) continue;
                waitlist.add(child);
            }
        }
        return alwaysExport;
    }

    private Iterable<Automaton> getWeightedAutomata(ARGState root, Map<ARGState, BranchingInfo> pDependencies) {
        HashSet<ARGState> endStates = new HashSet<ARGState>();
        for (Map.Entry<ARGState, BranchingInfo> entry : pDependencies.entrySet()) {
            if (!entry.getValue().getNextStates().isEmpty()) continue;
            endStates.add(entry.getKey());
        }
        HashMap<ARGState, Boolean> finished = new HashMap<ARGState, Boolean>();
        ArrayList<Automaton> automata = new ArrayList<Automaton>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>(endStates);
        while (!waitlist.isEmpty()) {
            boolean completeExportOfState;
            ARGState s = (ARGState)waitlist.pop();
            if (finished.containsKey(s)) continue;
            BranchingInfo bi = pDependencies.get(s);
            Set<ARGState> children = bi.getNextStates();
            if (!finished.keySet().containsAll(children)) {
                waitlist.add(s);
                continue;
            }
            ImmutableSet finishedChildren = FluentIterable.from(children).filter(c -> (Boolean)finished.get(c)).toSet();
            if (!children.isEmpty() && children.equals(finishedChildren)) {
                completeExportOfState = true;
            } else if (!finishedChildren.isEmpty()) {
                for (PersistentSet<ARGState> ignores : bi.getIgnoreStates()) {
                    automata.add(ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)((Predicate)arg_0 -> ARGToAutomatonConverter.lambda$getWeightedAutomata$12(ignores, (Set)finishedChildren, arg_0)), false));
                }
                completeExportOfState = true;
            } else if (this.shouldExportAutomatonFor(root, s, pDependencies)) {
                for (PersistentSet<ARGState> ignores : bi.getIgnoreStates()) {
                    automata.add(ARGToAutomatonConverter.getLocationAutomatonForStates(root, (Predicate<ARGState>)((Predicate)as -> ignores.contains(as)), false));
                }
                completeExportOfState = true;
            } else {
                completeExportOfState = false;
            }
            finished.put(s, completeExportOfState);
            if (completeExportOfState) continue;
            waitlist.addAll(bi.getParents());
        }
        return automata;
    }

    private boolean shouldExportAutomatonFor(ARGState root, ARGState s, Map<ARGState, BranchingInfo> pDependencies) {
        if (s.equals(root)) {
            return true;
        }
        int rootSize = this.sizeOfBranch(root);
        int branchSize = this.sizeOfBranch(s);
        if ((double)branchSize > this.branchRatio * (double)rootSize) {
            return true;
        }
        ImmutableSet siblings = FluentIterable.from(pDependencies.get(s).getParents()).transformAndConcat(p -> ((BranchingInfo)pDependencies.get(p)).getNextStates()).transform(n -> this.sizeOfBranch((ARGState)n)).toSet();
        return (double)((Integer)Collections.max(siblings) - (Integer)Collections.min(siblings)) > this.siblingRatio * (double)rootSize;
    }

    private int sizeOfBranch(ARGState state) {
        return this.sizeCache.computeIfAbsent(state, this::sizeOfBranch0);
    }

    private int sizeOfBranch0(ARGState state) {
        HashSet<ARGState> reachable = new HashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(state);
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            if (!reachable.add(s)) continue;
            waitlist.addAll(s.getChildren());
        }
        return reachable.size();
    }

    private void addBranchInformation(ARGState root, Map<ARGState, BranchingInfo> dependencies) {
        dependencies.get(root).addIgnoreStates(PersistentSet.of());
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(root);
        HashSet<ARGState> finished = new HashSet<ARGState>();
        while (!waitlist.isEmpty()) {
            ARGState branchingPoint = (ARGState)waitlist.pop();
            assert (dependencies.containsKey(branchingPoint));
            if (!finished.add(branchingPoint)) continue;
            BranchingInfo branch = dependencies.get(branchingPoint);
            Preconditions.checkArgument((boolean)branch.current.equals(branchingPoint));
            for (Map.Entry viaChild : branch.children.entries()) {
                ARGState nextState = (ARGState)viaChild.getValue();
                waitlist.add(nextState);
                BranchingInfo nextBi = dependencies.get(nextState);
                Iterator<PersistentSet<ARGState>> iterator = branch.getIgnoreStates().iterator();
                while (iterator.hasNext()) {
                    PersistentSet<ARGState> ignoreBranch;
                    PersistentSet<ARGState> newIgnoreBranch = ignoreBranch = iterator.next();
                    if (!branch.isPartOfLoop()) {
                        for (ARGState sibling : FluentIterable.from(branchingPoint.getChildren()).filter(s -> !s.equals(viaChild.getKey()))) {
                            newIgnoreBranch = newIgnoreBranch.addAndCopy(ARGToAutomatonConverter.uncover(sibling));
                        }
                    }
                    nextBi.addIgnoreStates(newIgnoreBranch);
                }
            }
        }
    }

    private void addParents(Map<ARGState, BranchingInfo> pDependencies) {
        for (Map.Entry<ARGState, BranchingInfo> entry : pDependencies.entrySet()) {
            for (ARGState nextState : entry.getValue().getNextStates()) {
                pDependencies.get(nextState).addParent(entry.getKey());
            }
        }
    }

    private Map<ARGState, BranchingInfo> getGlobalBranchingTree(ARGState pRoot) {
        Preconditions.checkArgument((!pRoot.isCovered() ? 1 : 0) != 0);
        LinkedHashMap<ARGState, BranchingInfo> branchingTree = new LinkedHashMap<ARGState, BranchingInfo>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.add(pRoot);
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            if (!finished.add(s)) continue;
            ImmutableSetMultimap.Builder childToNext = ImmutableSetMultimap.builder();
            for (ARGState child : ARGToAutomatonConverter.uncover(s.getChildren())) {
                Collection<ARGState> nextStates = this.getNext(child);
                waitlist.addAll(nextStates);
                childToNext.putAll((Object)child, nextStates);
            }
            branchingTree.put(s, new BranchingInfo(s, (ImmutableSetMultimap<ARGState, ARGState>)childToNext.build()));
        }
        return branchingTree;
    }

    private Map<ARGState, BranchingInfo> getFilteredDependencies(ARGState root, Map<ARGState, BranchingInfo> pDependencies) {
        this.markLoopStates(pDependencies);
        LinkedHashMap<ARGState, BranchingInfo> branchingTree = new LinkedHashMap<ARGState, BranchingInfo>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.add(root);
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            Preconditions.checkState((boolean)pDependencies.containsKey(s));
            if (!finished.add(s)) continue;
            ImmutableSetMultimap.Builder childToNext = ImmutableSetMultimap.builder();
            for (ARGState child : ARGToAutomatonConverter.uncover(s.getChildren())) {
                Collection<ARGState> nextStates = this.getNextWithoutLoops(child, s, pDependencies);
                waitlist.addAll(nextStates);
                childToNext.putAll((Object)child, nextStates);
            }
            branchingTree.put(s, new BranchingInfo(s, (ImmutableSetMultimap<ARGState, ARGState>)childToNext.build()));
        }
        this.markLoopStates(branchingTree);
        assert (Iterables.all(branchingTree.values(), bi -> !bi.isPartOfLoop())) : "we should have removed all cyclic dependencies";
        return branchingTree;
    }

    private void markLoopStates(Map<ARGState, BranchingInfo> pDependencies) {
        for (Map.Entry<ARGState, BranchingInfo> entry : pDependencies.entrySet()) {
            if (!this.isPartOfCycle(entry.getKey(), pDependencies)) continue;
            entry.getValue().setPartOfLoop();
        }
    }

    private Collection<ARGState> getNextWithoutLoops(ARGState pChild, ARGState pState, Map<ARGState, BranchingInfo> pDependencies) {
        LinkedHashSet<ARGState> nextStates = new LinkedHashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.addAll((Collection<ARGState>)pDependencies.get((Object)pState).children.get((Object)pChild));
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            Preconditions.checkState((boolean)pDependencies.containsKey(s));
            if (!finished.add(s)) continue;
            BranchingInfo bi = pDependencies.get(s);
            if (bi.isPartOfLoop()) {
                waitlist.addAll(bi.getNextStates());
                continue;
            }
            nextStates.add(s);
        }
        return nextStates;
    }

    private boolean isPartOfCycle(ARGState pRoot, Map<ARGState, BranchingInfo> pDependencies) {
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.addAll(pDependencies.get(pRoot).getNextStates());
        while (!waitlist.isEmpty()) {
            ARGState s = (ARGState)waitlist.pop();
            assert (pDependencies.containsKey(s));
            if (!finished.add(s)) continue;
            if (s.equals(pRoot)) {
                return true;
            }
            waitlist.addAll(pDependencies.get(s).getNextStates());
        }
        return false;
    }

    private Collection<ARGState> getNext(ARGState base) {
        ArrayList<ARGState> next = new ArrayList<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        HashSet<ARGState> finished = new HashSet<ARGState>();
        waitlist.add(base);
        while (!waitlist.isEmpty()) {
            ARGState s = ARGToAutomatonConverter.uncover((ARGState)waitlist.pop());
            if (!finished.add(s)) continue;
            if (s.getChildren().size() > 1 || s.getChildren().isEmpty()) {
                next.add(s);
                continue;
            }
            waitlist.addAll(s.getChildren());
        }
        return next;
    }

    private static FluentIterable<ARGState> getLeaves(ARGState pRoot, boolean targetsOnly) {
        FluentIterable leaves = ARGUtils.getNonCoveredStatesInSubgraph(pRoot).filter(s -> s.getChildren().isEmpty());
        return targetsOnly ? leaves.filter(ARGState::isTarget) : leaves;
    }

    private Automaton getAutomatonForLeaf(ARGState pRoot, ARGState pLeaf) {
        Preconditions.checkArgument((!pRoot.equals(pLeaf) ? 1 : 0) != 0);
        Preconditions.checkArgument((!pLeaf.isCovered() ? 1 : 0) != 0);
        switch (this.dataStrategy) {
            case LOCATION: {
                Collection<ARGState> allStatesOnPaths = ARGToAutomatonConverter.getAllStatesOnPathsTo(pLeaf);
                Preconditions.checkArgument((boolean)allStatesOnPaths.contains(pRoot));
                Preconditions.checkArgument((boolean)allStatesOnPaths.contains(pLeaf));
                return ARGToAutomatonConverter.getLocationAutomatonForStates(pRoot, (Predicate<ARGState>)((Predicate)s -> !allStatesOnPaths.contains(s)), true);
            }
            case CALLSTACK: {
                return this.getCallstackAutomatonForStates(pRoot, Collections.singleton(pLeaf), true);
            }
        }
        throw new AssertionError((Object)"unhandled case");
    }

    private Automaton getCallstackAutomatonForStates(ARGState pRoot, Iterable<ARGState> pLeaves, boolean withTargetStates) {
        try {
            return this.getCallstackAutomatonForStates0(pRoot, pLeaves, withTargetStates);
        }
        catch (InvalidAutomatonException e) {
            throw new AssertionError("unexpected exception", e);
        }
    }

    private Automaton getCallstackAutomatonForStates0(ARGState pRoot, Iterable<ARGState> pLeaves, boolean withTargetStates) throws InvalidAutomatonException {
        LinkedHashMultimap callstacks = LinkedHashMultimap.create();
        LinkedHashMap<CallstackState, CallstackState> inverseCallstacks = new LinkedHashMap<CallstackState, CallstackState>();
        LinkedHashMultimap callstackToLeaves = LinkedHashMultimap.create();
        LinkedHashMultimap callstackToLeafWithParentAssumptions = LinkedHashMultimap.create();
        for (ARGState leaf : pLeaves) {
            CallstackState callstack = AbstractStates.extractStateByType(leaf, CallstackState.class);
            Preconditions.checkNotNull((Object)callstack);
            Preconditions.checkArgument((leaf.getParents().size() == 1 ? 1 : 0) != 0);
            Preconditions.checkArgument((leaf.getParents().iterator().next().getEdgeToChild(leaf) != null ? 1 : 0) != 0);
            if (leaf.getParents().iterator().next().getEdgeToChild(leaf) instanceof FunctionCallEdge) {
                callstack = callstack.getPreviousState();
            }
            callstackToLeaves.put((Object)callstack, (Object)leaf);
            for (ARGState parent : leaf.getParents()) {
                if (!AbstractStates.asIterable(parent).filter(AbstractStateWithAssumptions.class).anyMatch(x -> !x.getAssumptions().isEmpty())) continue;
                callstackToLeafWithParentAssumptions.put((Object)callstack, (Object)leaf);
            }
            CallstackState prev = callstack.getPreviousState();
            while (prev != null) {
                callstacks.put((Object)prev, (Object)callstack);
                inverseCallstacks.put(callstack, prev);
                callstack = prev;
                prev = callstack.getPreviousState();
            }
        }
        ArrayList<AutomatonInternalState> states = new ArrayList<AutomatonInternalState>();
        if (withTargetStates) {
            states.add(AutomatonInternalState.ERROR);
        }
        CallstackState root = AbstractStates.extractStateByType(pRoot, CallstackState.class);
        ArrayDeque<CallstackState> waitlist = new ArrayDeque<CallstackState>();
        HashSet<CFANode> reached = new HashSet<CFANode>();
        HashSet<CallstackState> stacksWithAssumptions = new HashSet<CallstackState>();
        waitlist.push(root);
        reached.add(root.getCallNode());
        while (!waitlist.isEmpty()) {
            CallstackState elem = (CallstackState)waitlist.removeFirst();
            boolean useAll = false;
            ImmutableSet.Builder assumptionsBuilder = ImmutableSet.builder();
            for (ARGState leaf : callstackToLeafWithParentAssumptions.get((Object)elem)) {
                for (ARGState parent : leaf.getParents()) {
                    for (AbstractStateWithAssumptions state : AbstractStates.asIterable(parent).filter(AbstractStateWithAssumptions.class)) {
                        assumptionsBuilder.addAll(state.getAssumptions());
                    }
                }
            }
            ImmutableSet assumptions = assumptionsBuilder.build();
            ArrayList<AutomatonTransition> transitions = new ArrayList<AutomatonTransition>();
            for (ARGState leaf : callstackToLeaves.get((Object)elem)) {
                if (assumptions.isEmpty()) {
                    transitions.add(ARGToAutomatonConverter.makeLocationTransition(AbstractStates.extractLocation(leaf).getNodeNumber(), withTargetStates ? AutomatonInternalState.ERROR.getName() : ARGToAutomatonConverter.id(leaf)));
                    continue;
                }
                ARGState parent = leaf.getParents().iterator().next();
                stacksWithAssumptions.add(elem);
                transitions.add(ARGToAutomatonConverter.makeLocationTransition(AbstractStates.extractLocation(parent).getNodeNumber(), ARGToAutomatonConverter.id(parent), (Collection<AExpression>)assumptions));
                try {
                    transitions.add(ARGToAutomatonConverter.makeLocationTransition(AbstractStates.extractLocation(parent).getNodeNumber(), ARGToAutomatonConverter.id(elem), (Collection<AExpression>)Collections3.transformedImmutableListCopy((Collection)assumptions, x -> this.negateExpression((CExpression)x))));
                }
                catch (ClassCastException e) {
                    throw new AssertionError("Currently there is only support for negating CExpressions", e);
                }
                useAll = true;
            }
            for (CallstackState called : callstacks.get((Object)elem)) {
                if (!reached.contains(called.getCallNode())) {
                    waitlist.add(called);
                    reached.add(called.getCallNode());
                }
                transitions.add(ARGToAutomatonConverter.makeLocationTransition(called.getCallNode().getNodeNumber(), ARGToAutomatonConverter.id(called)));
            }
            CallstackState callee = (CallstackState)inverseCallstacks.get(elem);
            if (callee != null) {
                transitions.add(ARGToAutomatonConverter.makeLocationTransition(elem.getCallNode().getLeavingSummaryEdge().getSuccessor().getNodeNumber(), ARGToAutomatonConverter.id(callee)));
            }
            states.add(new AutomatonInternalState(ARGToAutomatonConverter.id(elem), transitions, false, useAll, false));
        }
        ARGToAutomatonConverter.finishAssumptionHandling(states, (Multimap<CallstackState, ARGState>)callstackToLeaves, stacksWithAssumptions);
        return new Automaton("ARG", (Map<String, AutomatonVariable>)ImmutableMap.of(), states, ARGToAutomatonConverter.id(root));
    }

    private static void finishAssumptionHandling(List<AutomatonInternalState> pStates, Multimap<CallstackState, ARGState> pCallstackToLeaves, Set<CallstackState> pStacksWithAssumptions) {
        for (CallstackState callstack : pStacksWithAssumptions) {
            HashSet<ARGState> parents = new HashSet<ARGState>();
            HashMap<ARGState, CFANode> parentsToLeafNode = new HashMap<ARGState, CFANode>();
            for (ARGState leaf : pCallstackToLeaves.get((Object)callstack)) {
                ARGState parent = leaf.getParents().iterator().next();
                if (!parents.add(parent)) continue;
                CFANode leafNode = AbstractStates.extractLocation(leaf);
                if (parentsToLeafNode.containsKey(parent)) assert (((CFANode)parentsToLeafNode.get(parent)).equals(leafNode)) : "Expected to have only one CFANode for the children(this holds at least when considering overflows with OverflowCPA)";
                parentsToLeafNode.put(parent, AbstractStates.extractLocation(leaf));
            }
            for (ARGState parent : parents) {
                CFANode leafNode = (CFANode)parentsToLeafNode.get(parent);
                ArrayList<AutomatonTransition> transitions = new ArrayList<AutomatonTransition>();
                transitions.add(ARGToAutomatonConverter.makeLocationTransition(leafNode.getNodeNumber(), AutomatonInternalState.ERROR.getName()));
                transitions.add(ARGToAutomatonConverter.makeNegatedLocationTransition(leafNode.getNodeNumber(), ARGToAutomatonConverter.id(callstack)));
                pStates.add(new AutomatonInternalState(ARGToAutomatonConverter.id(parent), transitions));
            }
        }
    }

    private static AutomatonTransition makeLocationTransition(int nodeNumber, String followStateName) {
        return ARGToAutomatonConverter.makeLocationTransition(nodeNumber, followStateName, (Collection<AExpression>)ImmutableList.of());
    }

    private static AutomatonTransition makeLocationTransition(int nodeNumber, String followStateName, Collection<AExpression> assumptions) {
        return ARGToAutomatonConverter.makeLocationTransition(nodeNumber, followStateName, assumptions, false);
    }

    private static AutomatonTransition makeNegatedLocationTransition(int nodeNumber, String followStateName, Collection<AExpression> assumptions) {
        return ARGToAutomatonConverter.makeLocationTransition(nodeNumber, followStateName, assumptions, true);
    }

    private static AutomatonTransition makeNegatedLocationTransition(int nodeNumber, String followStateName) {
        return ARGToAutomatonConverter.makeNegatedLocationTransition(nodeNumber, followStateName, (Collection<AExpression>)ImmutableList.of());
    }

    private static AutomatonTransition makeLocationTransition(int nodeNumber, String followStateName, Collection<AExpression> assumptions, boolean negate) {
        AutomatonBoolExpr.CPAQuery expr = new AutomatonBoolExpr.CPAQuery("location", "nodenumber==" + nodeNumber);
        return new AutomatonTransition.Builder(negate ? new AutomatonBoolExpr.Negation(expr) : expr, followStateName).withAssumptions((List<AExpression>)ImmutableList.copyOf(assumptions)).build();
    }

    private CExpression negateExpression(CExpression expr) {
        try {
            return this.cBinaryExpressionBuilder.negateExpressionAndSimplify(expr);
        }
        catch (UnrecognizedCodeException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Collection<ARGState> getAllStatesOnPathsTo(ARGState pLeaf) {
        LinkedHashSet<ARGState> finished = new LinkedHashSet<ARGState>();
        ArrayDeque<ARGState> waitlist = new ArrayDeque<ARGState>();
        waitlist.add(pLeaf);
        while (!waitlist.isEmpty()) {
            ARGState s = (ARGState)waitlist.pop();
            if (!finished.add(s)) continue;
            waitlist.addAll(s.getParents());
            waitlist.addAll(s.getCoveredByThis());
        }
        return finished;
    }

    private static String toDot(Map<ARGState, BranchingInfo> pDependencies) {
        StringBuilder str = new StringBuilder("digraph BRANCHING_NODES {\n");
        str.append("  node [style=\"filled\" color=\"white\"];\n");
        for (Map.Entry<ARGState, BranchingInfo> entry : pDependencies.entrySet()) {
            String color = entry.getValue().isPartOfLoop() ? "green" : "white";
            String label = ARGToAutomatonConverter.id(entry.getKey()) + "\\n{" + Joiner.on((String)",\\n").join(Iterables.transform(entry.getValue().ignoreStates, ARGToAutomatonConverter::id)) + "}";
            str.append(String.format("  %s [fillcolor=\"%s\", label=\"%s\"];%n", ARGToAutomatonConverter.id(entry.getKey()), color, label));
        }
        for (Map.Entry<ARGState, BranchingInfo> entry : pDependencies.entrySet()) {
            for (Map.Entry viaChild : entry.getValue().children.entries()) {
                str.append(String.format("  %s -> %s [label=\"%s\"];%n", ARGToAutomatonConverter.id(entry.getKey()), ARGToAutomatonConverter.id((ARGState)viaChild.getValue()), ARGToAutomatonConverter.id((ARGState)viaChild.getKey())));
            }
        }
        return str.append("}").toString();
    }

    private static String id(ARGState s) {
        return "S" + s.getStateId() + "_N" + AbstractStates.extractLocation(s).getNodeNumber();
    }

    private static Iterable<String> id(Iterable<ARGState> states) {
        return Iterables.transform(states, ARGToAutomatonConverter::id);
    }

    private static Iterable<String> ids(Iterable<? extends Iterable<ARGState>> iterableOfStates) {
        return Iterables.transform(iterableOfStates, states -> ARGToAutomatonConverter.id(states).toString());
    }

    private static String id(ImmutableMultimap<ARGState, ARGState> children) {
        return "{" + Joiner.on((String)", ").join(Iterables.transform((Iterable)children.keys(), s -> ARGToAutomatonConverter.id(s) + "->" + ARGToAutomatonConverter.id((Iterable<ARGState>)children.get(s)))) + "}";
    }

    private static String id(CallstackState s) {
        return ARGToAutomatonConverter.id(s, false);
    }

    private static String id(CallstackState s, boolean complete) {
        StringBuilder strBuilder = new StringBuilder().append(ARGToAutomatonConverter.currentCallDescription(s));
        if (complete) {
            while (s.getPreviousState() != null) {
                s = s.getPreviousState();
                strBuilder.insert(0, ARGToAutomatonConverter.currentCallDescription(s) + "__");
            }
        }
        return strBuilder.toString();
    }

    private static String currentCallDescription(CallstackState s) {
        return s.getCurrentFunction() + "_N" + s.getCallNode().getNodeNumber() + "_L" + ARGToAutomatonConverter.getCallLineNumber(s);
    }

    private static int getCallLineNumber(CallstackState s) {
        CFANode node = s.getCallNode();
        int position = 0;
        for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
            CFAEdge edge = node.getLeavingEdge(i);
            position = edge.getLineNumber();
            if (edge instanceof FunctionCallEdge) break;
        }
        return position;
    }

    private static /* synthetic */ boolean lambda$getWeightedAutomata$12(PersistentSet ignores, Set finishedChildren, ARGState as) {
        return ignores.contains(as) || finishedChildren.contains(as);
    }

    private static final class BranchingInfo {
        private final ARGState current;
        private final ImmutableSetMultimap<ARGState, ARGState> children;
        private final Set<ARGState> parents = new LinkedHashSet<ARGState>();
        private boolean isPartOfLoop = false;
        private Set<PersistentSet<ARGState>> ignoreStates = new LinkedHashSet<PersistentSet<ARGState>>();

        BranchingInfo(ARGState pCurrent, ImmutableSetMultimap<ARGState, ARGState> pChildren) {
            this.current = pCurrent;
            this.children = pChildren;
        }

        private Set<ARGState> getNextStates() {
            return ImmutableSet.copyOf((Collection)this.children.values());
        }

        private Set<PersistentSet<ARGState>> getIgnoreStates() {
            return this.ignoreStates;
        }

        private void addIgnoreStates(PersistentSet<ARGState> pIgnoreStates) {
            Preconditions.checkNotNull(pIgnoreStates);
            this.ignoreStates.add(pIgnoreStates);
        }

        private boolean isPartOfLoop() {
            return this.isPartOfLoop;
        }

        private void setPartOfLoop() {
            this.isPartOfLoop = true;
        }

        private void addParent(ARGState parent) {
            this.parents.add(parent);
        }

        private Set<ARGState> getParents() {
            return this.parents;
        }

        public String toString() {
            return String.format("BranchingInfo {parents=%s, children=%s, ignore=%s, loop=%s}", ARGToAutomatonConverter.id(this.parents), ARGToAutomatonConverter.id(this.children), ARGToAutomatonConverter.ids(this.ignoreStates), this.isPartOfLoop);
        }
    }

    public static enum DataExportStrategy {
        LOCATION,
        CALLSTACK;

    }

    public static enum BranchExportStrategy {
        NONE,
        ALL,
        LEAVES,
        WEIGHTED,
        FIRST_BFS;

    }

    public static enum SplitterStrategy {
        NONE,
        GLOBAL_CONDITIONS,
        LEAVES,
        TARGETS;

    }
}

