/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="consistent Unix-style line endings")
public class Automaton {
    private final String name;
    private final ImmutableMap<String, AutomatonVariable> initVars;
    private final ImmutableList<AutomatonInternalState> states;
    private final AutomatonInternalState initState;

    public Automaton(String pName, Map<String, AutomatonVariable> pVars, List<AutomatonInternalState> pStates, String pInitialStateName) throws InvalidAutomatonException {
        this.name = pName;
        this.initVars = ImmutableMap.copyOf(pVars);
        this.states = ImmutableList.copyOf(pStates);
        HashMap statesMap = Maps.newHashMapWithExpectedSize((int)pStates.size());
        for (AutomatonInternalState s : pStates) {
            if (statesMap.put(s.getName(), s) == null) continue;
            throw new InvalidAutomatonException("State " + s.getName() + " exists twice in automaton " + pName);
        }
        this.initState = (AutomatonInternalState)statesMap.get(pInitialStateName);
        if (this.initState == null) {
            throw new InvalidAutomatonException("Inital state " + pInitialStateName + " not found in automaton " + pName);
        }
        for (AutomatonInternalState s : pStates) {
            s.setFollowStates(statesMap);
        }
    }

    public List<AutomatonInternalState> getStates() {
        return this.states;
    }

    public String getName() {
        return this.name;
    }

    AutomatonInternalState getInitialState() {
        return this.initState;
    }

    public int getNumberOfStates() {
        return this.states.size();
    }

    public void writeDotFile(Appendable pOut) throws IOException {
        pOut.append("digraph " + this.name + "{\n");
        boolean errorState = false;
        boolean bottomState = false;
        for (AutomatonInternalState s : this.states) {
            String color = this.initState.equals(s) ? "green" : "black";
            pOut.append(Automaton.formatState(s, color));
            for (AutomatonTransition t : s.getTransitions()) {
                pOut.append(Automaton.formatTransition(s, t));
                errorState = errorState || t.getFollowState().equals(AutomatonInternalState.ERROR);
                bottomState = bottomState || t.getFollowState().equals(AutomatonInternalState.BOTTOM);
            }
        }
        if (errorState) {
            pOut.append(Automaton.formatState(AutomatonInternalState.ERROR, "red"));
        }
        if (bottomState) {
            pOut.append(Automaton.formatState(AutomatonInternalState.BOTTOM, "red"));
        }
        pOut.append("}\n");
    }

    private static String formatState(AutomatonInternalState s, String color) {
        String name = s.getName().replace("_predefinedState_", "");
        String shape = s.isTarget() ? "doublecircle" : "circle";
        return String.format("%d [shape=\"" + shape + "\" color=\"%s\" label=\"%s\"]\n", s.getStateId(), color, name);
    }

    private static String formatTransition(AutomatonInternalState sourceState, AutomatonTransition t) {
        return String.format("%d -> %d [label=\"%s\"]\n", sourceState.getStateId(), t.getFollowState().getStateId(), t.toString().replace("\"", "\\\""));
    }

    public ImmutableMap<String, AutomatonVariable> getInitialVariables() {
        return this.initVars;
    }

    public Collection<ExpressionTree<AExpression>> getAllCandidateInvariants() {
        ArrayList<ExpressionTree<AExpression>> invariants = new ArrayList<ExpressionTree<AExpression>>(this.states.size());
        for (AutomatonInternalState state : this.states) {
            for (AutomatonTransition trans : state.getTransitions()) {
                ExpressionTree<AExpression> invariant = trans.getCandidateInvariants();
                if (invariant == ExpressionTrees.getTrue() || invariant == ExpressionTrees.getFalse()) continue;
                invariants.add(invariant);
            }
        }
        return invariants;
    }

    public void assertObserverAutomaton() throws InvalidConfigurationException {
        for (AutomatonInternalState s : this.states) {
            for (AutomatonTransition t : s.getTransitions()) {
                if (t.meetsObserverRequirements()) continue;
                throw new InvalidConfigurationException("The transition \"" + t + "\" in state \"" + s + "\" is not valid for an ObserverAutomaton.");
            }
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("CONTROL AUTOMATON ").append(this.getName()).append("\n\n");
        for (Map.Entry e : this.initVars.entrySet()) {
            str.append(String.format("LOCAL int %s = %s;%n%n", e.getKey(), e.getValue()));
        }
        str.append("INITIAL STATE ").append(this.initState).append(";\n\n");
        for (AutomatonInternalState s : this.states) {
            str.append("STATE ").append(s.isNonDetState() ? "USEALL " : "USEFIRST ").append(s.getName()).append(":\n");
            for (AutomatonTransition t : s.getTransitions()) {
                str.append("    ").append(t);
                if (t.getFollowState() != AutomatonInternalState.BOTTOM && t.getFollowState() != AutomatonInternalState.ERROR) {
                    str.append("GOTO ");
                }
                str.append(t.getFollowState()).append(";\n");
            }
            str.append("\n");
        }
        str.append("END AUTOMATON\n");
        return str.toString();
    }

    public boolean isRelevantForCFA(CFA cfa) {
        for (CFANode node : cfa.getAllNodes()) {
            for (int i = 0; i < node.getNumLeavingEdges(); ++i) {
                CFAEdge edge = node.getLeavingEdge(i);
                for (AutomatonTransition transition : this.initState.getTransitions()) {
                    AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, (Map<String, AutomatonVariable>)ImmutableMap.of(), (List<AbstractState>)ImmutableList.of(), edge, LogManager.createNullLogManager());
                    try {
                        if (transition.getTrigger().eval(args).canNotEvaluate() || !transition.getTrigger().eval(args).getValue().booleanValue()) continue;
                        return true;
                    }
                    catch (CPATransferException cPATransferException) {
                    }
                }
            }
        }
        return false;
    }
}

