/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFAWithACSLAnnotations;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLAnnotation;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicate;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLPredicateToExpressionTreeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.acsl.ACSLTermToCExpressionVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;

public class AutomatonACSLParser {
    private CFAWithACSLAnnotations cfa;
    private LogManager logger;
    private final ACSLPredicateToExpressionTreeVisitor visitor;

    public AutomatonACSLParser(CFAWithACSLAnnotations pCFA, LogManager pLogger) {
        this.cfa = pCFA;
        this.logger = pLogger;
        ACSLTermToCExpressionVisitor termVisitor = new ACSLTermToCExpressionVisitor(this.cfa, this.logger);
        this.visitor = new ACSLPredicateToExpressionTreeVisitor(termVisitor);
    }

    public Automaton parseAsAutomaton() {
        try {
            String automatonName = "ACSLInvariantsAutomaton";
            String initialStateName = "VALID";
            ImmutableList.Builder transitions = ImmutableList.builder();
            for (CFANode node : this.cfa.getAllNodes()) {
                if (node.getNumLeavingEdges() <= 0) continue;
                for (CFAEdge leavingEdge : CFAUtils.leavingEdges(node)) {
                    Collection annotations = this.cfa.getEdgesToAnnotations().get((Object)leavingEdge);
                    if (annotations.isEmpty()) continue;
                    ExpressionTreeFactory factory = ExpressionTrees.newFactory();
                    ArrayList representations = new ArrayList(annotations.size());
                    for (ACSLAnnotation annotation : annotations) {
                        ACSLPredicate predicate = annotation.getPredicateRepresentation();
                        representations.add(predicate.accept(this.visitor));
                    }
                    ExpressionTree<AExpression> inv = factory.and(representations);
                    this.createLocationInvariantsTransitions((ImmutableList.Builder<AutomatonTransition>)transitions, leavingEdge, inv);
                }
            }
            AutomatonInternalState state = new AutomatonInternalState(initialStateName, (List<AutomatonTransition>)transitions.build(), false, true, false);
            return new Automaton(automatonName, (Map<String, AutomatonVariable>)ImmutableMap.of(), (List<AutomatonInternalState>)ImmutableList.of((Object)state), initialStateName);
        }
        catch (InvalidAutomatonException | UnrecognizedCodeException e) {
            throw new RuntimeException("The passed invariants produce an inconsistent automaton", e);
        }
    }

    private void createLocationInvariantsTransitions(ImmutableList.Builder<AutomatonTransition> pTransitions, CFAEdge pEdge, ExpressionTree<AExpression> pInvariant) throws UnrecognizedCodeException {
        CExpression cExpr = pInvariant.accept(new ToCExpressionVisitor(this.cfa.getMachineModel(), this.logger));
        if (!(pInvariant instanceof LeafExpression) || ((LeafExpression)pInvariant).assumeTruth()) {
            cExpr = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger).negateExpressionAndSimplify(cExpr);
        }
        pTransitions.add((Object)this.createAutomatonInvariantErrorTransition(pEdge, (List<AExpression>)ImmutableList.of((Object)cExpr)));
    }

    private AutomatonTransition createAutomatonInvariantErrorTransition(CFAEdge pEdge, List<AExpression> pAssumptions) {
        return new AutomatonTransition.Builder((AutomatonBoolExpr)new AutomatonBoolExpr.MatchCFAEdgeExact(pEdge.getRawStatement()), AutomatonInternalState.ERROR).withAssumptions(pAssumptions).withTargetInformation(new AutomatonExpression.StringExpression("Invariant not valid")).build();
    }

    public static boolean isACSLAnnotatedFile(Path file) throws InvalidConfigurationException {
        try {
            String fileContent = Files.readString(file);
            return fileContent.contains("/*@") || fileContent.contains("//@");
        }
        catch (IOException e) {
            throw new AutomatonGraphmlParser.WitnessParseException(e);
        }
    }

    public boolean areIsomorphicCFAs(CFA other) {
        if (this.cfa.getAllNodes().size() != other.getAllNodes().size()) {
            return false;
        }
        Iterator<CFANode> nodes = this.cfa.getAllNodes().iterator();
        Iterator<CFANode> other_nodes = other.getAllNodes().iterator();
        while (nodes.hasNext()) {
            CFAEdge other_edge;
            CFAEdge edge;
            int i;
            CFANode node = nodes.next();
            CFANode other_node = other_nodes.next();
            if (node.getNumLeavingEdges() != other_node.getNumLeavingEdges() || node.getNumEnteringEdges() != other_node.getNumEnteringEdges()) {
                return false;
            }
            for (i = 0; i < node.getNumEnteringEdges(); ++i) {
                edge = node.getEnteringEdge(i);
                other_edge = other_node.getEnteringEdge(i);
                if (edge.getRawStatement().equals(other_edge.getRawStatement())) continue;
                return false;
            }
            for (i = 0; i < node.getNumLeavingEdges(); ++i) {
                edge = node.getLeavingEdge(i);
                other_edge = other_node.getLeavingEdge(i);
                if (edge.getRawStatement().equals(other_edge.getRawStatement())) continue;
                return false;
            }
        }
        return true;
    }
}

