/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.ACharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CRightHandSideVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatementVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.CParserUtils;

class AutomatonASTComparator {
    static final String JOKER_EXPR = "CPAchecker_AutomatonAnalysis_JokerExpression_Wildcard";
    private static final String NUMBERED_JOKER_EXPR = "CPAchecker_AutomatonAnalysis_JokerExpression_Num";
    private static final Pattern JOKER_PATTERN = Pattern.compile("\\$(\\d+|\\?)");

    AutomatonASTComparator() {
    }

    static ASTMatcher generatePatternAST(String pPattern, CParser parser, Scope scope) throws InvalidAutomatonException, NoException, InterruptedException {
        return CParserUtils.parseSingleStatement(AutomatonASTComparator.replaceJokersInPattern(pPattern), parser, scope).accept(ASTMatcherGenerator.INSTANCE);
    }

    @VisibleForTesting
    static String replaceJokersInPattern(String pPattern) {
        Matcher matcher = JOKER_PATTERN.matcher(pPattern);
        StringBuilder result = new StringBuilder();
        int wildcardCount = 0;
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String match = matcher.group();
            if (match.equals("$?")) {
                result.append(' ').append(JOKER_EXPR).append(wildcardCount++).append(' ');
                continue;
            }
            try {
                int varKey = Integer.parseInt(match.substring(1));
                result.append(' ').append(NUMBERED_JOKER_EXPR).append(varKey).append(' ');
            }
            catch (NumberFormatException e) {
                result.append(match);
            }
        }
        matcher.appendTail(result);
        return result.toString();
    }

    private static class NumberedJokerMatcher
    implements ASTMatcher {
        private final int number;

        public NumberedJokerMatcher(int pNumber) {
            this.number = pNumber;
        }

        @Override
        public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
            pArgs.putTransitionVariable(this.number, pSource);
            return true;
        }

        public String toString() {
            return "$" + this.number;
        }
    }

    private static enum JokerMatcher implements ASTMatcher
    {
        INSTANCE;


        @Override
        public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
            return true;
        }

        public String toString() {
            return "$?";
        }
    }

    private static final class OperandListMatcher
    implements CheckedASTMatcher<CFunctionCallExpression> {
        private final List<ASTMatcher> parameterPatterns;

        OperandListMatcher(List<ASTMatcher> pParameterPatterns) {
            this.parameterPatterns = ImmutableList.copyOf(pParameterPatterns);
        }

        @Override
        public boolean matches(CFunctionCallExpression pSource, AutomatonExpressionArguments pArg) {
            if (this.parameterPatterns.size() != pSource.getParameterExpressions().size()) {
                return false;
            }
            return Streams.zip(this.parameterPatterns.stream(), pSource.getParameterExpressions().stream(), (pattern, parameter) -> pattern.matches((CAstNode)parameter, pArg)).allMatch(match -> match);
        }
    }

    private static final class ASTMatcherGenerator
    extends Enum<ASTMatcherGenerator>
    implements CRightHandSideVisitor<ASTMatcher, NoException>,
    CStatementVisitor<ASTMatcher, NoException> {
        public static final /* enum */ ASTMatcherGenerator INSTANCE = new ASTMatcherGenerator();
        private static final /* synthetic */ ASTMatcherGenerator[] $VALUES;

        public static ASTMatcherGenerator[] values() {
            return (ASTMatcherGenerator[])$VALUES.clone();
        }

        public static ASTMatcherGenerator valueOf(String name) {
            return Enum.valueOf(ASTMatcherGenerator.class, name);
        }

        @Override
        public ASTMatcher visit(CIdExpression exp) {
            String name = exp.getName();
            if (name.startsWith(AutomatonASTComparator.JOKER_EXPR)) {
                return JokerMatcher.INSTANCE;
            }
            if (name.startsWith(AutomatonASTComparator.NUMBERED_JOKER_EXPR)) {
                String s = name.substring(AutomatonASTComparator.NUMBERED_JOKER_EXPR.length());
                int i = Integer.parseInt(s);
                return new NumberedJokerMatcher(i);
            }
            return ASTMatcherGenerator.createMatcher(CIdExpression.class, exp, this.compareField(exp, e -> e.getDeclaration() == null ? e.getName() : e.getDeclaration().getOrigName()));
        }

        @Override
        public ASTMatcher visit(CArraySubscriptExpression exp) {
            return ASTMatcherGenerator.createMatcher(CArraySubscriptExpression.class, exp, this.compareOperand(exp, CArraySubscriptExpression::getArrayExpression), this.compareOperand(exp, CArraySubscriptExpression::getSubscriptExpression));
        }

        @Override
        public ASTMatcher visit(CBinaryExpression exp) {
            return ASTMatcherGenerator.createMatcher(CBinaryExpression.class, exp, this.compareField(exp, CBinaryExpression::getOperator), this.compareOperand(exp, CBinaryExpression::getOperand1), this.compareOperand(exp, CBinaryExpression::getOperand2));
        }

        @Override
        public ASTMatcher visit(CCastExpression exp) {
            return ASTMatcherGenerator.createMatcher(CCastExpression.class, exp, this.compareField(exp, CCastExpression::getExpressionType), this.compareOperand(exp, CCastExpression::getOperand));
        }

        @Override
        public ASTMatcher visit(CComplexCastExpression exp) {
            return ASTMatcherGenerator.createMatcher(CComplexCastExpression.class, exp, this.compareField(exp, CComplexCastExpression::isRealCast), this.compareField(exp, CComplexCastExpression::getType), this.compareOperand(exp, CComplexCastExpression::getOperand));
        }

        @Override
        public ASTMatcher visit(CFieldReference exp) {
            return ASTMatcherGenerator.createMatcher(CFieldReference.class, exp, this.compareField(exp, CFieldReference::getFieldName), this.compareOperand(exp, CFieldReference::getFieldOwner));
        }

        @Override
        public ASTMatcher visit(CCharLiteralExpression exp) {
            return ASTMatcherGenerator.createMatcher(CCharLiteralExpression.class, exp, this.compareField(exp, ACharLiteralExpression::getCharacter));
        }

        @Override
        public ASTMatcher visit(CFloatLiteralExpression exp) {
            return ASTMatcherGenerator.createMatcher(CFloatLiteralExpression.class, exp, this.compareField(exp, AFloatLiteralExpression::getValue));
        }

        @Override
        public ASTMatcher visit(CImaginaryLiteralExpression exp) {
            return ASTMatcherGenerator.createMatcher(CImaginaryLiteralExpression.class, exp, this.compareField(exp, CImaginaryLiteralExpression::getValue));
        }

        @Override
        public ASTMatcher visit(CIntegerLiteralExpression exp) {
            return ASTMatcherGenerator.createMatcher(CIntegerLiteralExpression.class, exp, this.compareField(exp, AIntegerLiteralExpression::getValue));
        }

        @Override
        public ASTMatcher visit(CStringLiteralExpression exp) {
            return ASTMatcherGenerator.createMatcher(CStringLiteralExpression.class, exp, this.compareField(exp, AStringLiteralExpression::getValue));
        }

        @Override
        public ASTMatcher visit(CTypeIdExpression exp) {
            return ASTMatcherGenerator.createMatcher(CTypeIdExpression.class, exp, this.compareField(exp, CTypeIdExpression::getOperator), this.compareField(exp, CTypeIdExpression::getType));
        }

        @Override
        public ASTMatcher visit(CUnaryExpression exp) {
            return ASTMatcherGenerator.createMatcher(CUnaryExpression.class, exp, this.compareField(exp, CUnaryExpression::getOperator), this.compareOperand(exp, CUnaryExpression::getOperand));
        }

        @Override
        public ASTMatcher visit(CPointerExpression exp) {
            return ASTMatcherGenerator.createMatcher(CPointerExpression.class, exp, this.compareOperand(exp, CPointerExpression::getOperand));
        }

        @Override
        public ASTMatcher visit(CAddressOfLabelExpression exp) {
            return ASTMatcherGenerator.createMatcher(CAddressOfLabelExpression.class, exp, this.compareField(exp, CAddressOfLabelExpression::getLabelName));
        }

        @Override
        public ASTMatcher visit(CFunctionCallExpression exp) {
            ArrayList<ASTMatcher> parameterPatterns = new ArrayList<ASTMatcher>(exp.getParameterExpressions().size());
            for (CExpression parameter : exp.getParameterExpressions()) {
                parameterPatterns.add(parameter.accept(this));
            }
            if (parameterPatterns.size() == 1 && parameterPatterns.get(0) == JokerMatcher.INSTANCE) {
                return ASTMatcherGenerator.createMatcher(CFunctionCallExpression.class, exp, this.compareOperand(exp, CFunctionCallExpression::getFunctionNameExpression));
            }
            return ASTMatcherGenerator.createMatcher(CFunctionCallExpression.class, exp, this.compareOperand(exp, CFunctionCallExpression::getFunctionNameExpression), new OperandListMatcher(parameterPatterns));
        }

        @Override
        public ASTMatcher visit(CExpressionStatement stmt) {
            return ASTMatcherGenerator.createMatcher(CExpressionStatement.class, stmt, this.compareOperand(stmt, CExpressionStatement::getExpression));
        }

        private ASTMatcher visit(CAssignment stmt) {
            ASTMatcher rightHandSide = stmt.getRightHandSide().accept(this);
            if (rightHandSide == JokerMatcher.INSTANCE) {
                return ASTMatcherGenerator.createMatcher(CAssignment.class, stmt, this.compareOperand(stmt, CAssignment::getLeftHandSide));
            }
            return ASTMatcherGenerator.createMatcher(CAssignment.class, stmt, this.compareOperand(stmt, CAssignment::getLeftHandSide), (pSource, pArgs) -> rightHandSide.matches(pSource.getRightHandSide(), pArgs));
        }

        @Override
        public ASTMatcher visit(CExpressionAssignmentStatement stmt) {
            return this.visit((CAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(CFunctionCallAssignmentStatement stmt) {
            return this.visit((CAssignment)stmt);
        }

        @Override
        public ASTMatcher visit(CFunctionCallStatement stmt) {
            return ASTMatcherGenerator.createMatcher(CFunctionCallStatement.class, stmt, this.compareOperand(stmt, CFunctionCallStatement::getFunctionCallExpression));
        }

        @SafeVarargs
        private static <T extends CAstNode> ASTMatcher createMatcher(final Class<T> pCls, final T pPattern, final CheckedASTMatcher<T> ... matchers) {
            assert (pCls.isInstance(pPattern));
            return new ASTMatcher(){

                @Override
                public boolean matches(CAstNode pSource, AutomatonExpressionArguments pArgs) {
                    if (pCls.isInstance(pSource)) {
                        CAstNode source = (CAstNode)pCls.cast(pSource);
                        for (CheckedASTMatcher matcher : matchers) {
                            if (matcher.matches(source, pArgs)) continue;
                            return false;
                        }
                        return true;
                    }
                    return false;
                }

                public String toString() {
                    return pPattern.toASTString();
                }
            };
        }

        private <T extends CAstNode> CheckedASTMatcher<T> compareField(T pPattern, Function<T, ?> fieldAccess) {
            Object field = fieldAccess.apply(pPattern);
            return (pSource, pArgs) -> Objects.equals(field, fieldAccess.apply(pSource));
        }

        private <T extends CAstNode> CheckedASTMatcher<T> compareOperand(T pPattern, Function<T, CRightHandSide> operandAccess) {
            ASTMatcher pOperand = operandAccess.apply(pPattern).accept(this);
            return (pSource, pArgs) -> pOperand.matches((CAstNode)operandAccess.apply(pSource), pArgs);
        }

        static {
            $VALUES = new ASTMatcherGenerator[]{INSTANCE};
        }
    }

    private static interface CheckedASTMatcher<T extends CAstNode> {
        public boolean matches(T var1, AutomatonExpressionArguments var2);
    }

    static interface ASTMatcher {
        public boolean matches(CAstNode var1, AutomatonExpressionArguments var2);
    }
}

