/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

abstract class AutomatonAction {
    private static AutomatonExpression.ResultValue<String> defaultResultValue = new AutomatonExpression.ResultValue<String>("");

    private AutomatonAction() {
    }

    abstract AutomatonExpression.ResultValue<?> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    boolean canExecuteOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return true;
    }

    static class CPAModification
    extends AutomatonAction {
        private final String cpaName;
        private final String modificationString;

        public CPAModification(String pCPAName, String pModification) {
            this.cpaName = pCPAName;
            this.modificationString = pModification;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) {
            if (pArgs.replaceVariables(this.modificationString) == null) {
                return false;
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                return true;
            }
            return false;
        }

        @Override
        AutomatonExpression.ResultValue<?> eval(AutomatonExpressionArguments pArgs) {
            String processedModificationString = pArgs.replaceVariables(this.modificationString);
            if (processedModificationString == null) {
                pArgs.getLogger().log(Level.WARNING, new Object[]{"Modification String \"" + this.modificationString + "\" could not be processed (Variable not found)."});
                return new AutomatonExpression.ResultValue("Modification String \"" + this.modificationString + "\" could not be processed (Variable not found).", "AutomatonActionExpr.CPAModification");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    aqe.modifyProperty(processedModificationString);
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA (Element " + aqe + ") on Edge " + pArgs.getCfaEdge().getDescription());
                    return defaultResultValue;
                }
            }
            return new AutomatonExpression.ResultValue("Did not find an element of the CPA \"" + this.cpaName + "\" to be modified.", "AutomatonActionExpr.CPAModification");
        }

        public String toString() {
            return "MODIFY(" + this.cpaName + "(\"" + this.modificationString + "\"))";
        }
    }

    static class SetAssignment
    extends AutomatonAction {
        private final String varId;
        private final boolean action;
        private final String value;

        public SetAssignment(String pVarId, String pValue, boolean pAction) {
            this.varId = pVarId;
            this.action = pAction;
            this.value = pValue;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        AutomatonExpression.ResultValue<?> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            Map<String, AutomatonVariable> vars = pArgs.getAutomatonVariables();
            if (!vars.containsKey(this.varId)) throw new CPATransferException("Automaton variable '\" + varId + \"' does not exist");
            AutomatonVariable automatonVariable = vars.get(this.varId);
            if (!(automatonVariable instanceof AutomatonVariable.AutomatonSetVariable)) throw new CPATransferException("Automaton variable '" + automatonVariable.getName() + "' cannot be used in set modifications");
            String substitutedValue = pArgs.replaceVariables(this.value);
            if (this.action) {
                ((AutomatonVariable.AutomatonSetVariable)automatonVariable).add(substitutedValue);
                return defaultResultValue;
            } else {
                ((AutomatonVariable.AutomatonSetVariable)automatonVariable).remove(substitutedValue);
            }
            return defaultResultValue;
        }

        public String toString() {
            return String.format("DO %s[%s]=%s", this.varId, this.value, this.action);
        }
    }

    static class Assignment
    extends AutomatonAction {
        private final String varId;
        private final AutomatonIntExpr var;

        public Assignment(String pVarId, AutomatonIntExpr pVar) {
            this.varId = pVarId;
            this.var = pVar;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) {
            return !this.var.eval(pArgs).canNotEvaluate();
        }

        @Override
        AutomatonExpression.ResultValue<?> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonVariable automatonVariable;
            AutomatonExpression.ResultValue<Integer> res = this.var.eval(pArgs);
            if (res.canNotEvaluate()) {
                return res;
            }
            Map<String, AutomatonVariable> vars = pArgs.getAutomatonVariables();
            if (vars.containsKey(this.varId)) {
                automatonVariable = vars.get(this.varId);
                if (!(automatonVariable instanceof AutomatonVariable.AutomatonIntVariable)) {
                    throw new CPATransferException("Cannot assign integer expression to variable '" + automatonVariable.getName() + "'");
                }
            } else {
                throw new CPATransferException("Automaton variable '" + this.varId + "' does not exist");
            }
            ((AutomatonVariable.AutomatonIntVariable)automatonVariable).setValue(res.getValue());
            return defaultResultValue;
        }

        public String toString() {
            return String.format("DO %s=%s", this.varId, this.var);
        }
    }

    static class PrintOnce
    extends Print {
        private final Set<String> alreadyPrintedMessages = Sets.newConcurrentHashSet();

        public PrintOnce(List<AutomatonExpression<?>> pArgs) {
            super(pArgs);
        }

        @Override
        protected void print(AutomatonExpressionArguments pArgs, String s) {
            if (this.alreadyPrintedMessages.add(s)) {
                pArgs.appendToLogMessage(s);
            }
        }

        @Override
        public String toString() {
            return "PRINTONCE \"" + Joiner.on((String)"\" \"").join((Iterable)this.toPrint) + "\"";
        }
    }

    static class Print
    extends AutomatonAction {
        protected final List<AutomatonExpression<?>> toPrint;

        public Print(List<AutomatonExpression<?>> pArgs) {
            this.toPrint = pArgs;
        }

        @Override
        boolean canExecuteOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
            for (AutomatonExpression<?> expr : this.toPrint) {
                AutomatonExpression.ResultValue<?> res = expr.eval(pArgs);
                if (!res.canNotEvaluate()) continue;
                return false;
            }
            return true;
        }

        @Override
        AutomatonExpression.ResultValue<?> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            StringBuilder sb = new StringBuilder();
            for (AutomatonExpression<?> expr : this.toPrint) {
                AutomatonExpression.ResultValue<?> res = expr.eval(pArgs);
                if (res.canNotEvaluate()) {
                    return res;
                }
                sb.append(res.getValue().toString());
            }
            this.print(pArgs, sb.toString());
            return defaultResultValue;
        }

        protected void print(AutomatonExpressionArguments pArgs, String s) {
            pArgs.appendToLogMessage(s);
        }

        public String toString() {
            return "PRINT \"" + Joiner.on((String)"\" \"").join(this.toPrint) + "\"";
        }
    }
}

