/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.model.AReturnStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFALabelNode;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCFAEdgeException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.coverage.CoverageData;

interface AutomatonBoolExpr
extends AutomatonExpression<Boolean> {
    public static final AutomatonExpression.ResultValue<Boolean> CONST_TRUE = new AutomatonExpression.ResultValue<Boolean>(Boolean.TRUE);
    public static final AutomatonExpression.ResultValue<Boolean> CONST_FALSE = new AutomatonExpression.ResultValue<Boolean>(Boolean.FALSE);
    public static final AutomatonBoolExpr TRUE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_TRUE;
        }

        public String toString() {
            return "TRUE";
        }
    };
    public static final AutomatonBoolExpr FALSE = new AutomatonBoolExpr(){

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return CONST_FALSE;
        }

        public String toString() {
            return "FALSE";
        }
    };

    @Override
    public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    public static class BoolNotEqTest
    extends BoolBinaryTest {
        public BoolNotEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            super(pA, pB, (a, b) -> !a.equals(b), "!=");
        }
    }

    public static class BoolEqTest
    extends BoolBinaryTest {
        public BoolEqTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            super(pA, pB, (a, b) -> a.equals(b), "==");
        }
    }

    public static abstract class BoolBinaryTest
    implements AutomatonBoolExpr {
        protected final AutomatonBoolExpr a;
        protected final AutomatonBoolExpr b;
        private final String repr;
        private final @Nullable BiFunction<Boolean, Boolean, Boolean> op;

        private BoolBinaryTest(AutomatonBoolExpr pA, AutomatonBoolExpr pB, BiFunction<Boolean, Boolean, Boolean> pOp, String pRepr) {
            this.a = pA;
            this.b = pB;
            this.op = pOp;
            this.repr = pRepr;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (this.op.apply(resA.getValue(), resB.getValue()).booleanValue()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "(" + this.a + " " + this.repr + " " + this.b + ")";
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.repr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof BoolBinaryTest) {
                BoolBinaryTest other = (BoolBinaryTest)o;
                return this.a.equals(other.a) && this.b.equals(other.b) && this.repr.equals(other.repr);
            }
            return false;
        }
    }

    public static class Negation
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr a;

        public Negation(AutomatonBoolExpr pA) {
            this.a = pA;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            if (resA.getValue().booleanValue()) {
                return CONST_FALSE;
            }
            return CONST_TRUE;
        }

        public String toString() {
            return "!" + this.a;
        }

        public AutomatonBoolExpr getA() {
            return this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Negation && this.a.equals(((Negation)o).a);
        }
    }

    public static class And
    extends BoolBinaryTest {
        public And(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            super(pA, pB, null, "&&");
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && !resB.getValue().booleanValue()) {
                    return resB;
                }
                return resA;
            }
            if (!resA.getValue().booleanValue()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (!resB.getValue().booleanValue()) {
                return resB;
            }
            return resA;
        }
    }

    public static class Or
    extends BoolBinaryTest {
        public Or(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
            super(pA, pB, null, "||");
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Boolean> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
                if (!resB.canNotEvaluate() && resB.getValue().booleanValue()) {
                    return resB;
                }
                return resA;
            }
            if (resA.getValue().booleanValue()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Boolean> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            if (resB.getValue().booleanValue()) {
                return resB;
            }
            return resA;
        }
    }

    public static class IntNotEqTest
    extends IntBinaryTest {
        public IntNotEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            super(pA, pB, (a, b) -> !a.equals(b), "!=");
        }
    }

    public static class IntEqTest
    extends IntBinaryTest {
        public IntEqTest(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            super(pA, pB, (a, b) -> a.equals(b), "==");
        }
    }

    public static abstract class IntBinaryTest
    implements AutomatonBoolExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;
        private final BiFunction<Integer, Integer, Boolean> op;
        private final String repr;

        private IntBinaryTest(AutomatonIntExpr pA, AutomatonIntExpr pB, BiFunction<Integer, Integer, Boolean> pOp, String pRepr) {
            this.a = pA;
            this.b = pB;
            this.op = pOp;
            this.repr = pRepr;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resA);
            }
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return new AutomatonExpression.ResultValue<Boolean>(resB);
            }
            if (this.op.apply(resA.getValue(), resB.getValue()).booleanValue()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return String.format("(%s %s %s)", this.a, this.repr, this.b);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.repr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof IntBinaryTest) {
                IntBinaryTest other = (IntBinaryTest)o;
                return this.a.equals(other.a) && this.b.equals(other.b) && this.repr.equals(other.repr);
            }
            return false;
        }
    }

    public static enum CheckAllCpasForTargetState implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getAbstractStates().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.CheckAllCpasForTargetState");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                if (!AbstractStates.isTargetState(ae)) continue;
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "CHECK(IS_TARGET_STATE)";
        }
    }

    public static class CPAQuery
    implements AutomatonBoolExpr {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.CPAQuery");
            }
            LogManager logger = pArgs.getLogger();
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (result instanceof Boolean) {
                        if (((Boolean)result).booleanValue()) {
                            if (logger.wouldBeLogged(Level.FINER)) {
                                String message = "CPA-Check succeeded: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe + "\"";
                                logger.log(Level.FINER, new Object[]{message});
                            }
                            return CONST_TRUE;
                        }
                        if (logger.wouldBeLogged(Level.FINER)) {
                            String message = "CPA-Check failed: ModifiedCheckString: \"" + modifiedQueryString + "\" CPAElement: (" + aqe.getCPAName() + ") \"" + aqe + "\"";
                            logger.log(Level.FINER, new Object[]{message});
                        }
                        return CONST_FALSE;
                    }
                    logger.log(Level.WARNING, new Object[]{"Automaton got a non-Boolean value during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription() + ". Assuming FALSE."});
                    return CONST_FALSE;
                }
                catch (InvalidQueryException e) {
                    logger.logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription());
                    return CONST_FALSE;
                }
            }
            return new AutomatonExpression.ResultValue<Boolean>("No State of CPA \"" + this.cpaName + "\" was found!", "AutomatonBoolExpr.CPAQuery");
        }

        public String toString() {
            return "CHECK(" + this.cpaName + ", \"" + this.queryString + "\")";
        }

        public int hashCode() {
            return Objects.hash(this.cpaName, this.queryString);
        }

        public boolean equals(Object pOther) {
            if (pOther instanceof CPAQuery) {
                CPAQuery other = (CPAQuery)pOther;
                return this.cpaName.equals(other.cpaName) && this.queryString.equals(other.queryString);
            }
            return false;
        }
    }

    public static class ALLCPAQuery
    implements AutomatonBoolExpr {
        private final String queryString;

        public ALLCPAQuery(String pString) {
            this.queryString = pString;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getAbstractStates().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.ALLCPAQuery");
            }
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Boolean>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.ALLCPAQuery");
            }
            int exceptionFreeCallCount = 0;
            for (AbstractState ae : pArgs.getAbstractStates()) {
                if (!(ae instanceof AbstractQueryableState)) continue;
                ++exceptionFreeCallCount;
                AbstractQueryableState aqe = (AbstractQueryableState)ae;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (!(result instanceof Boolean) || !((Boolean)result).booleanValue()) continue;
                    pArgs.getLogger().log(Level.FINER, new Object[]{"CPA-Check succeeded: ModifiedCheckString: \"%s\" CPAElement: (%s) \"%s\"", modifiedQueryString, aqe.getCPAName(), aqe});
                    return CONST_TRUE;
                }
                catch (InvalidQueryException e) {
                    --exceptionFreeCallCount;
                }
            }
            if (exceptionFreeCallCount == 0) {
                return new AutomatonExpression.ResultValue<Boolean>("None of the states sees \"" + modifiedQueryString + "\" as a valid query!", "AutomatonBoolExpr.ALLCPAQuery");
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "CHECK(\"" + this.queryString + "\")";
        }

        public int hashCode() {
            return this.queryString.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ALLCPAQuery && this.queryString.equals(((ALLCPAQuery)o).queryString);
        }
    }

    public static class MatchLocationDescriptor
    implements AutomatonBoolExpr {
        private final FunctionEntryNode mainEntry;
        private final Predicate<FileLocation> matchDescriptor;

        public MatchLocationDescriptor(FunctionEntryNode pMainEntry, Predicate<FileLocation> pDescriptor) {
            Preconditions.checkNotNull(pDescriptor);
            this.mainEntry = pMainEntry;
            this.matchDescriptor = pDescriptor;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return this.eval(pArgs.getCfaEdge()) ? CONST_TRUE : CONST_FALSE;
        }

        protected boolean eval(CFAEdge edge) {
            return AutomatonGraphmlCommon.getFileLocationsFromCfaEdge(edge, this.mainEntry).stream().anyMatch(this.matchDescriptor);
        }

        public String toString() {
            return "MATCH " + this.matchDescriptor;
        }

        public int hashCode() {
            return Objects.hash(this.mainEntry, this.matchDescriptor);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof MatchLocationDescriptor) {
                MatchLocationDescriptor other = (MatchLocationDescriptor)pOther;
                return this.mainEntry.equals(other.mainEntry) && this.matchDescriptor.equals(other.matchDescriptor);
            }
            return false;
        }
    }

    public static enum MatchSplitDeclaration implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFAEdge edge = pArgs.getCfaEdge();
            return AutomatonGraphmlCommon.isSplitDeclaration(edge) ? CONST_TRUE : CONST_FALSE;
        }

        public String toString() {
            return "MATCH SPLIT DECLARATION";
        }
    }

    public static class MatchAnySuccessorEdgesBoolExpr
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr operandExpression;

        MatchAnySuccessorEdgesBoolExpr(AutomatonBoolExpr pOperandExpression) {
            Preconditions.checkNotNull((Object)pOperandExpression);
            this.operandExpression = pOperandExpression;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            FunctionSummaryEdge summaryEdge;
            AFunctionCall call;
            FunctionCallEdge callEdge;
            CFAEdge edge = pArgs.getCfaEdge();
            Object leavingEdges = CFAUtils.leavingEdges(edge.getSuccessor());
            if (edge instanceof FunctionCallEdge && (callEdge = (FunctionCallEdge)edge).getSummaryEdge() != null && (call = (summaryEdge = callEdge.getSummaryEdge()).getExpression()) instanceof AFunctionCallAssignmentStatement) {
                FluentIterable potentialFurtherMatches = CFAUtils.enteringEdges(summaryEdge.getSuccessor()).filter(e -> e instanceof AStatementEdge && call.equals(((AStatementEdge)e).getStatement()) || e instanceof FunctionReturnEdge && summaryEdge.equals(((FunctionReturnEdge)e).getSummaryEdge()));
                leavingEdges = Iterables.concat((Iterable)leavingEdges, (Iterable)potentialFurtherMatches);
            }
            if (Iterables.isEmpty(leavingEdges)) {
                return CONST_FALSE;
            }
            leavingEdges = this.skipSplitDeclarationEdges((Iterable<CFAEdge>)leavingEdges, pArgs);
            AutomatonExpression.ResultValue<Boolean> result = null;
            Iterator iterator = leavingEdges.iterator();
            while (iterator.hasNext()) {
                CFAEdge successorEdge = (CFAEdge)iterator.next();
                result = this.operandExpression.eval(new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), successorEdge, pArgs.getLogger()));
                if (result.canNotEvaluate() || !result.getValue().booleanValue()) continue;
                return result;
            }
            assert (result != null);
            return result;
        }

        private Collection<CFAEdge> skipSplitDeclarationEdges(Iterable<CFAEdge> pEdges, AutomatonExpressionArguments pArgs) throws CPATransferException {
            ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
            for (CFAEdge edge : pEdges) {
                if (CONST_TRUE.equals(MatchSplitDeclaration.INSTANCE.eval(new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), edge, pArgs.getLogger())))) {
                    edges.addAll(this.skipSplitDeclarationEdges((Iterable<CFAEdge>)CFAUtils.leavingEdges(edge.getSuccessor()), pArgs));
                    continue;
                }
                edges.add(edge);
            }
            return edges;
        }

        public String toString() {
            return String.format("MATCH EXISTS SUCCESSOR EDGE (%s)", this.operandExpression);
        }

        public int hashCode() {
            return this.operandExpression.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchAnySuccessorEdgesBoolExpr && this.operandExpression.equals(((MatchAnySuccessorEdgesBoolExpr)o).operandExpression);
        }
    }

    public static class MatchAllSuccessorEdgesBoolExpr
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr operandExpression;

        MatchAllSuccessorEdgesBoolExpr(AutomatonBoolExpr pOperandExpression) {
            Preconditions.checkNotNull((Object)pOperandExpression);
            this.operandExpression = pOperandExpression;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws CPATransferException {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_TRUE;
            }
            AutomatonExpression.ResultValue<Boolean> result = null;
            for (CFAEdge cfaEdge : CFAUtils.leavingEdges(pArgs.getCfaEdge().getSuccessor())) {
                result = this.operandExpression.eval(new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), cfaEdge, pArgs.getLogger()));
                if (!result.canNotEvaluate() && result.getValue().booleanValue()) continue;
                return result;
            }
            assert (result != null);
            return result;
        }

        public String toString() {
            return String.format("MATCH FORALL SUCCESSOR EDGES (%s)", this.operandExpression);
        }

        public int hashCode() {
            return this.operandExpression.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchAllSuccessorEdgesBoolExpr && this.operandExpression.equals(((MatchAllSuccessorEdgesBoolExpr)o).operandExpression);
        }
    }

    public static class MatchAssumeCase
    implements AutomatonBoolExpr {
        private final boolean matchPositiveCase;

        public MatchAssumeCase(boolean pMatchPositiveCase) {
            this.matchPositiveCase = pMatchPositiveCase;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge instanceof AssumeEdge) {
                boolean actualBranchInSource;
                AssumeEdge a = (AssumeEdge)pArgs.getCfaEdge();
                boolean bl = actualBranchInSource = a.getTruthAssumption() != a.isSwapped();
                if (this.matchPositiveCase == actualBranchInSource) {
                    return CONST_TRUE;
                }
            }
            if (this.matchPositiveCase && AutomatonGraphmlCommon.treatAsWhileTrue(edge)) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSUME CASE " + this.matchPositiveCase;
        }

        public int hashCode() {
            return this.matchPositiveCase ? 1 : 0;
        }

        public boolean equals(Object o) {
            return o instanceof MatchAssumeCase && this.matchPositiveCase == ((MatchAssumeCase)o).matchPositiveCase;
        }
    }

    public static enum MatchAssumeEdge implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            return pArgs.getCfaEdge() instanceof AssumeEdge ? CONST_TRUE : CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSUME EDGE";
        }
    }

    public static enum MatchJavaAssert implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge instanceof BlankEdge && edge.getDescription().equals("assert fail")) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH ASSERT";
        }
    }

    public static class MatchCFAEdgeExact
    implements AutomatonBoolExpr {
        private final String pattern;

        public MatchCFAEdgeExact(String pPattern) {
            this.pattern = pPattern;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getRawStatement().equals(this.pattern)) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH \"" + this.pattern + "\"";
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchCFAEdgeExact && this.pattern.equals(((MatchCFAEdgeExact)o).pattern);
        }
    }

    public static class MatchCFAEdgeNodes
    implements AutomatonBoolExpr {
        private final int predecessorNodeNumber;
        private final int successorNodeNumber;

        public MatchCFAEdgeNodes(CFAEdge pEdge) {
            this(pEdge.getPredecessor().getNodeNumber(), pEdge.getSuccessor().getNodeNumber());
        }

        public MatchCFAEdgeNodes(int pPredecessorNodeNumber, int pSuccessorNodeNumber) {
            this.predecessorNodeNumber = pPredecessorNodeNumber;
            this.successorNodeNumber = pSuccessorNodeNumber;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (this.predecessorNodeNumber == pArgs.getCfaEdge().getPredecessor().getNodeNumber() && this.successorNodeNumber == pArgs.getCfaEdge().getSuccessor().getNodeNumber()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH TRANSITION [" + this.predecessorNodeNumber + " -> " + this.successorNodeNumber + "]";
        }

        public int hashCode() {
            return Objects.hash(this.predecessorNodeNumber, this.successorNodeNumber);
        }

        public boolean equals(Object obj) {
            return obj instanceof MatchCFAEdgeNodes && this.predecessorNodeNumber == ((MatchCFAEdgeNodes)obj).predecessorNodeNumber && this.successorNodeNumber == ((MatchCFAEdgeNodes)obj).successorNodeNumber;
        }
    }

    public static class MatchCFAEdgeRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchCFAEdgeRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (this.pattern.matcher(pArgs.getCfaEdge().getRawStatement()).matches()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH [" + this.pattern + "]";
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchCFAEdgeRegEx && this.pattern.equals(((MatchCFAEdgeRegEx)o).pattern);
        }
    }

    public static class MatchCFAEdgeASTComparison
    implements AutomatonBoolExpr {
        private final AutomatonASTComparator.ASTMatcher patternAST;

        public MatchCFAEdgeASTComparison(AutomatonASTComparator.ASTMatcher pPatternAST) {
            this.patternAST = pPatternAST;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) throws UnrecognizedCFAEdgeException {
            Optional<Object> ast = Optional.empty();
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge.getEdgeType().equals((Object)CFAEdgeType.FunctionCallEdge)) {
                return CONST_FALSE;
            }
            ast = edge.getEdgeType().equals((Object)CFAEdgeType.FunctionReturnEdge) ? Optional.of(((FunctionReturnEdge)edge).getSummaryEdge().getExpression()) : edge.getRawAST();
            if (ast.isPresent()) {
                if (!(ast.get() instanceof CAstNode)) {
                    throw new UnrecognizedCFAEdgeException(pArgs.getCfaEdge());
                }
                if (this.patternAST.matches((CAstNode)ast.get(), pArgs)) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH {" + this.patternAST.toString().replaceAll("CPAchecker_AutomatonAnalysis_JokerExpression_Wildcard\\d+", "\\$?") + "}";
        }
    }

    public static class MatchLabelRegEx
    implements AutomatonBoolExpr {
        private final Pattern pattern;

        public MatchLabelRegEx(String pPattern) {
            this.pattern = Pattern.compile(pPattern);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode successorNode = pArgs.getCfaEdge().getSuccessor();
            if (successorNode instanceof CFALabelNode) {
                String label = ((CFALabelNode)successorNode).getLabel();
                if (this.pattern.matcher(label).matches()) {
                    return CONST_TRUE;
                }
                return CONST_FALSE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH LABEL [" + this.pattern + "]";
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchLabelRegEx && this.pattern.equals(((MatchLabelRegEx)o).pattern);
        }
    }

    public static class MatchLabelExact
    implements AutomatonBoolExpr {
        private final String label;

        public MatchLabelExact(String pLabel) {
            this.label = (String)Preconditions.checkNotNull((Object)pLabel);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode successorNode = pArgs.getCfaEdge().getSuccessor();
            if (successorNode instanceof CFALabelNode && this.label.equals(((CFALabelNode)successorNode).getLabel())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH LABEL \"" + this.label + "\"";
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchLabelExact && this.label.equals(((MatchLabelExact)o).label);
        }
    }

    public static class MatchFunctionExit
    implements AutomatonBoolExpr {
        private final String functionName;

        MatchFunctionExit(String pFunctionName) {
            this.functionName = pFunctionName;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFANode succ;
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge instanceof FunctionReturnEdge) {
                FunctionReturnEdge returnEdge = (FunctionReturnEdge)edge;
                if (returnEdge.getPredecessor().getFunction().getOrigName().equals(this.functionName)) {
                    return CONST_TRUE;
                }
            } else if (edge instanceof AReturnStatementEdge) {
                AReturnStatementEdge returnStatementEdge = (AReturnStatementEdge)edge;
                if (returnStatementEdge.getSuccessor().getFunction().getOrigName().equals(this.functionName)) {
                    return CONST_TRUE;
                }
            } else if (edge instanceof BlankEdge && (succ = edge.getSuccessor()) instanceof FunctionExitNode && succ.getNumLeavingEdges() == 0 && succ.getFunction().getOrigName().equals(this.functionName)) {
                assert ("default return".equals(edge.getDescription()));
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH FUNCTION EXIT \"" + this.functionName + "\"";
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchFunctionExit && this.functionName.equals(((MatchFunctionExit)o).functionName);
        }
    }

    public static class MatchFunctionPointerAssumeCase
    implements AutomatonBoolExpr {
        private final MatchAssumeCase matchAssumeCase;
        private final MatchFunctionCall matchFunctionCall;

        public MatchFunctionPointerAssumeCase(MatchAssumeCase pMatchAssumeCase, MatchFunctionCall pMatchFunctionCall) {
            this.matchAssumeCase = pMatchAssumeCase;
            this.matchFunctionCall = pMatchFunctionCall;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            FluentIterable pointerCallEdges;
            Iterator iterator;
            AutomatonExpression.ResultValue<Boolean> assumeMatches = this.matchAssumeCase.eval(pArgs);
            if (assumeMatches.canNotEvaluate() || !assumeMatches.getValue().booleanValue()) {
                return assumeMatches;
            }
            CFAEdge edge = pArgs.getCfaEdge();
            AssumeEdge assumeEdge = (AssumeEdge)edge;
            if (!assumeEdge.getTruthAssumption()) {
                assumeEdge = CFAUtils.getComplimentaryAssumeEdge(assumeEdge);
            }
            if ((iterator = (pointerCallEdges = CFAUtils.leavingEdges(assumeEdge.getSuccessor()).filter(e -> e.getFileLocation().equals(edge.getFileLocation())).filter(FunctionCallEdge.class)).iterator()).hasNext()) {
                CFAEdge pointerCallEdge = (CFAEdge)iterator.next();
                AutomatonExpressionArguments args = new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), pointerCallEdge, pArgs.getLogger());
                return this.matchFunctionCall.eval(args);
            }
            return CONST_FALSE;
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof MatchFunctionPointerAssumeCase) {
                MatchFunctionPointerAssumeCase other = (MatchFunctionPointerAssumeCase)pOther;
                return this.matchAssumeCase.equals(other.matchAssumeCase) && this.matchFunctionCall.equals(other.matchFunctionCall);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.matchAssumeCase, this.matchFunctionCall);
        }

        public String toString() {
            return "MATCH FP-CALL(" + this.matchFunctionCall.functionName + ") BRANCHING CASE " + this.matchAssumeCase.matchPositiveCase;
        }
    }

    public static class MatchFunctionCall
    implements AutomatonBoolExpr {
        private final String functionName;

        MatchFunctionCall(String pFunctionName) {
            this.functionName = pFunctionName;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge.getSuccessor().getFunction().getOrigName().equals(this.functionName) && (edge instanceof FunctionCallEdge || AutomatonGraphmlCommon.isMainFunctionEntry(edge))) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH FUNCTIONCALL \"" + this.functionName + "\"";
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchFunctionCall && this.functionName.equals(((MatchFunctionCall)o).functionName);
        }
    }

    public static class MatchFunctionCallStatement
    implements AutomatonBoolExpr {
        private final String functionName;

        MatchFunctionCallStatement(String pFunctionName) {
            this.functionName = pFunctionName;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            AIdExpression idExpression;
            AFunctionCall functionCall;
            AFunctionCallExpression functionCallExpression;
            AStatement statement;
            CFAEdge edge = pArgs.getCfaEdge();
            if (edge instanceof AStatementEdge && (statement = ((AStatementEdge)edge).getStatement()) instanceof AFunctionCall && (functionCallExpression = (functionCall = (AFunctionCall)statement).getFunctionCallExpression()).getFunctionNameExpression() instanceof AIdExpression && (idExpression = (AIdExpression)functionCallExpression.getFunctionNameExpression()).getDeclaration().getOrigName().equals(this.functionName)) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "MATCH FUNCTION CALL STATEMENT \"" + this.functionName + "\"";
        }

        public int hashCode() {
            return this.functionName.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchFunctionCallStatement && this.functionName.equals(((MatchFunctionCallStatement)o).functionName);
        }
    }

    public static class EpsilonMatch
    implements AutomatonBoolExpr {
        private final AutomatonBoolExpr expr;
        private final boolean forward;
        private final boolean continueAtBranching;

        private EpsilonMatch(AutomatonBoolExpr pExpr, boolean pForward, boolean pContinueAtBranching) {
            Preconditions.checkArgument((!(pExpr instanceof EpsilonMatch) ? 1 : 0) != 0);
            this.expr = Objects.requireNonNull(pExpr);
            this.forward = pForward;
            this.continueAtBranching = pContinueAtBranching;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(final AutomatonExpressionArguments pArgs) throws CPATransferException {
            CFANode startNode;
            AutomatonExpression.ResultValue<Boolean> eval = this.expr.eval(pArgs);
            if (Boolean.TRUE.equals(eval.getValue())) {
                return eval;
            }
            CFAEdge edge = pArgs.getCfaEdge();
            CFATraversal traversal = CFATraversal.dfs().ignoreSummaryEdges();
            if (this.forward) {
                startNode = edge.getSuccessor();
            } else {
                traversal = traversal.backwards();
                startNode = edge.getPredecessor();
            }
            class EpsilonMatchVisitor
            implements CFATraversal.CFAVisitor {
                private AutomatonExpression.ResultValue<Boolean> evaluation;
                private CPATransferException transferException;

                public EpsilonMatchVisitor(AutomatonExpression.ResultValue<Boolean> pEvaluation) {
                    this.evaluation = pEvaluation;
                }

                @Override
                public CFATraversal.TraversalProcess visitEdge(CFAEdge pEdge) {
                    AutomatonExpressionArguments args = new AutomatonExpressionArguments(pArgs.getState(), pArgs.getAutomatonVariables(), pArgs.getAbstractStates(), pEdge, pArgs.getLogger());
                    try {
                        this.evaluation = expr.eval(args);
                    }
                    catch (CPATransferException e) {
                        this.transferException = e;
                        return CFATraversal.TraversalProcess.ABORT;
                    }
                    if (Boolean.TRUE.equals(this.evaluation.getValue())) {
                        return CFATraversal.TraversalProcess.ABORT;
                    }
                    return AutomatonGraphmlCommon.handleAsEpsilonEdge(pEdge) ? CFATraversal.TraversalProcess.CONTINUE : CFATraversal.TraversalProcess.SKIP;
                }

                @Override
                public CFATraversal.TraversalProcess visitNode(CFANode pNode) {
                    if (continueAtBranching) {
                        return CFATraversal.TraversalProcess.CONTINUE;
                    }
                    if (forward && pNode.getNumLeavingEdges() < 2) {
                        return CFATraversal.TraversalProcess.CONTINUE;
                    }
                    if (!forward && pNode.getNumEnteringEdges() < 2) {
                        return CFATraversal.TraversalProcess.CONTINUE;
                    }
                    return CFATraversal.TraversalProcess.SKIP;
                }
            }
            EpsilonMatchVisitor epsilonMatchVisitor = new EpsilonMatchVisitor(eval);
            traversal.traverse(startNode, epsilonMatchVisitor);
            if (epsilonMatchVisitor.transferException != null) {
                throw epsilonMatchVisitor.transferException;
            }
            return epsilonMatchVisitor.evaluation;
        }

        public String toString() {
            if (!this.continueAtBranching) {
                return (this.forward ? "~>" : "<~") + this.expr;
            }
            return (this.forward ? "~>>" : "<<~") + this.expr;
        }

        public int hashCode() {
            return Objects.hash(this.expr, this.forward, this.continueAtBranching);
        }

        public boolean equals(Object o) {
            if (o instanceof EpsilonMatch) {
                EpsilonMatch other = (EpsilonMatch)o;
                return this.expr.equals(other.expr) && this.forward == other.forward && this.continueAtBranching == other.continueAtBranching;
            }
            return false;
        }

        static AutomatonBoolExpr forwardEpsilonMatch(AutomatonBoolExpr pExpr, boolean pContinueAtBranching) {
            return EpsilonMatch.of(pExpr, true, pContinueAtBranching);
        }

        static AutomatonBoolExpr backwardEpsilonMatch(AutomatonBoolExpr pExpr, boolean pContinueAtBranching) {
            return EpsilonMatch.of(pExpr, false, pContinueAtBranching);
        }

        private static AutomatonBoolExpr of(AutomatonBoolExpr pExpr, boolean pForward, boolean pContinueAtBranching) {
            if (pExpr instanceof EpsilonMatch && ((EpsilonMatch)pExpr).forward == pForward) {
                return pExpr;
            }
            return new EpsilonMatch(pExpr, pForward, pContinueAtBranching);
        }
    }

    public static class MatchSuccessor
    implements AutomatonBoolExpr {
        private final ImmutableSet<CFANode> acceptedNodes;

        private MatchSuccessor(ImmutableSet<CFANode> pAcceptedNodes) {
            this.acceptedNodes = pAcceptedNodes;
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (this.acceptedNodes.contains((Object)pArgs.getCfaEdge().getSuccessor())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "SUCCESSOR IN " + this.acceptedNodes;
        }

        public int hashCode() {
            return this.acceptedNodes.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof MatchSuccessor && this.acceptedNodes.equals(((MatchSuccessor)o).acceptedNodes);
        }

        static AutomatonBoolExpr of(CFANode pAcceptedNode) {
            return new MatchSuccessor((ImmutableSet<CFANode>)ImmutableSet.of((Object)pAcceptedNode));
        }

        static AutomatonBoolExpr of(Set<CFANode> pAcceptedNodes) {
            return new MatchSuccessor((ImmutableSet<CFANode>)ImmutableSet.copyOf(pAcceptedNodes));
        }
    }

    public static enum MatchLoopStart implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getSuccessor().isLoopStart()) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "LOOP-START";
        }
    }

    public static enum MatchProgramEntry implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            CFAEdge edge = pArgs.getCfaEdge();
            CFANode predecessor = edge.getPredecessor();
            if (predecessor instanceof FunctionEntryNode && predecessor.getNumEnteringEdges() == 0) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "PROGRAM-ENTRY";
        }
    }

    public static class CheckCoversLines
    implements AutomatonBoolExpr {
        private final ImmutableSet<Integer> linesToCover;

        public CheckCoversLines(Set<Integer> pSet) {
            this.linesToCover = ImmutableSet.copyOf(pSet);
        }

        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getAbstractStates().isEmpty()) {
                return new AutomatonExpression.ResultValue<Boolean>("No CPA elements available", "AutomatonBoolExpr.CheckCoversLines");
            }
            CFAEdge edge = pArgs.getCfaEdge();
            if (!CoverageData.coversLine(edge)) {
                return CONST_FALSE;
            }
            if (this.linesToCover.contains((Object)edge.getFileLocation().getStartingLineInOrigin())) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "COVERS_LINES(" + Joiner.on((char)' ').join(this.linesToCover) + ")";
        }

        public int hashCode() {
            return this.linesToCover.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof CheckCoversLines && this.linesToCover.equals(((CheckCoversLines)o).linesToCover);
        }
    }

    public static enum MatchProgramExit implements AutomatonBoolExpr
    {
        INSTANCE;


        @Override
        public AutomatonExpression.ResultValue<Boolean> eval(AutomatonExpressionArguments pArgs) {
            if (pArgs.getCfaEdge().getSuccessor().getNumLeavingEdges() == 0) {
                return CONST_TRUE;
            }
            return CONST_FALSE;
        }

        public String toString() {
            return "PROGRAM-EXIT";
        }
    }
}

