/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.Objects;
import java.util.logging.Level;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

interface AutomatonExpression<T> {
    public ResultValue<T> eval(AutomatonExpressionArguments var1) throws CPATransferException;

    public static class ResultValue<resultType> {
        private boolean canNotEvaluate = false;
        private String failureMessage = null;
        private String failureOrigin = null;
        private resultType value = null;

        public ResultValue(resultType value) {
            this.value = value;
        }

        public ResultValue(String failureMessage, String failureOrigin) {
            this.canNotEvaluate = true;
            this.failureMessage = failureMessage;
            this.failureOrigin = failureOrigin;
        }

        public ResultValue(ResultValue<?> pRes) {
            assert (pRes.canNotEvaluate);
            this.canNotEvaluate = true;
            this.failureMessage = pRes.failureMessage;
            this.failureOrigin = pRes.failureOrigin;
        }

        boolean canNotEvaluate() {
            return this.canNotEvaluate;
        }

        String getFailureMessage() {
            return this.failureMessage;
        }

        String getFailureOrigin() {
            return this.failureOrigin;
        }

        resultType getValue() {
            return this.value;
        }

        public String toString() {
            if (this.canNotEvaluate()) {
                return String.format("not evaluated (%s)", this.failureMessage);
            }
            return this.getValue().toString();
        }
    }

    public static class CPAQuery
    implements AutomatonExpression<String> {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public ResultValue<String> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new ResultValue<String>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonBoolExpr.CPAQuery");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    return new ResultValue<String>(result.toString());
                }
                catch (InvalidQueryException e) {
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, "Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription());
                    return new ResultValue<String>("Automaton encountered an Exception during Query of the " + this.cpaName + " CPA on Edge " + pArgs.getCfaEdge().getDescription(), "AutomatonExpression.CPAQuery");
                }
            }
            return new ResultValue<String>("No State of CPA \"" + this.cpaName + "\" was found!", "AutomatonExpression.CPAQuery");
        }

        public String toString() {
            return "EVAL(" + this.cpaName + "(\"" + this.queryString + "\"))";
        }

        public int hashCode() {
            return Objects.hash(this.cpaName, this.queryString);
        }

        public boolean equals(Object o) {
            if (o instanceof CPAQuery) {
                CPAQuery other = (CPAQuery)o;
                return this.cpaName.equals(other.cpaName) && this.queryString.equals(other.queryString);
            }
            return false;
        }
    }

    public static class StringExpression
    implements AutomatonExpression<String> {
        private String toPrint;

        public StringExpression(String pString) {
            this.toPrint = pString;
        }

        @Override
        public ResultValue<String> eval(AutomatonExpressionArguments pArgs) {
            String str = this.toPrint.replaceAll("\\$[rR]aw[Ss]tatement", pArgs.getCfaEdge().getRawStatement());
            str = str.replaceAll("\\$[Ll]ine", String.valueOf(pArgs.getCfaEdge().getLineNumber()));
            str = str.replaceAll("\\$[Ll]ocation", pArgs.getCfaEdge().getFileLocation().toString());
            str = str.replaceAll("\\$[Ff]ile", pArgs.getCfaEdge().getFileLocation().getFileName().toString());
            str = str.replaceAll("\\$[Ss]tates", pArgs.getAbstractStates().toString());
            if ((str = pArgs.replaceVariables(str)) == null) {
                return new ResultValue<String>("Failure in Variable Replacement in String \"" + this.toPrint + "\"", "ActionExpr.Print");
            }
            return new ResultValue<String>(str);
        }

        public String toString() {
            return this.toPrint;
        }

        public int hashCode() {
            return this.toPrint.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof StringExpression && this.toPrint.equals(((StringExpression)o).toPrint);
        }
    }
}

