/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.SubstitutingCAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;

class AutomatonExpressionArguments {
    private Map<String, AutomatonVariable> automatonVariables;
    private Map<Integer, AAstNode> transitionVariables = new HashMap<Integer, AAstNode>();
    private List<AbstractState> abstractStates;
    private AutomatonState state;
    private CFAEdge cfaEdge;
    private LogManager logger;
    private String transitionLogMessages = "";
    static final Pattern AUTOMATON_VARS_PATTERN = Pattern.compile("\\$\\$[a-zA-Z]\\w*");
    static final Pattern TRANSITION_VARS_PATTERN = Pattern.compile("\\$\\d+");

    AutomatonExpressionArguments(AutomatonState pState, Map<String, AutomatonVariable> pAutomatonVariables, List<AbstractState> pAbstractStates, CFAEdge pCfaEdge, LogManager pLogger) {
        this.automatonVariables = pAutomatonVariables == null ? ImmutableMap.of() : pAutomatonVariables;
        this.abstractStates = pAbstractStates == null ? ImmutableList.of() : pAbstractStates;
        this.cfaEdge = pCfaEdge;
        this.logger = pLogger;
        this.state = pState;
    }

    void setAutomatonVariables(Map<String, AutomatonVariable> pAutomatonVariables) {
        this.automatonVariables = pAutomatonVariables;
    }

    Map<String, AutomatonVariable> getAutomatonVariables() {
        return this.automatonVariables;
    }

    List<AbstractState> getAbstractStates() {
        return this.abstractStates;
    }

    CFAEdge getCfaEdge() {
        return this.cfaEdge;
    }

    LogManager getLogger() {
        return this.logger;
    }

    void appendToLogMessage(String message) {
        this.transitionLogMessages = this.transitionLogMessages + message;
    }

    void appendToLogMessage(int message) {
        this.transitionLogMessages = this.transitionLogMessages + message;
    }

    String getLogMessage() {
        return this.transitionLogMessages;
    }

    public void clearLogMessage() {
        this.transitionLogMessages = "";
    }

    void clearTransitionVariables() {
        this.transitionVariables.clear();
    }

    AAstNode getTransitionVariable(int key) {
        return this.transitionVariables.get(key);
    }

    void putTransitionVariable(int key, AAstNode value) {
        this.transitionVariables.put(key, value);
    }

    String replaceVariables(String pSourceString) {
        Matcher matcher = TRANSITION_VARS_PATTERN.matcher(pSourceString);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String key = matcher.group().substring(1);
            try {
                int varKey = Integer.parseInt(key);
                AAstNode var = this.getTransitionVariable(varKey);
                if (var == null) {
                    this.getLogger().log(Level.WARNING, new Object[]{"could not replace the transition variable $" + varKey + " (not found)."});
                    return null;
                }
                result.append(var.toASTString());
            }
            catch (NumberFormatException e) {
                this.getLogger().log(Level.WARNING, new Object[]{"could not parse the int in " + matcher.group() + " , leaving it untouched"});
                result.append(matcher.group());
            }
        }
        matcher.appendTail(result);
        matcher = AUTOMATON_VARS_PATTERN.matcher(result.toString());
        result = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(result, "");
            String varName = matcher.group().substring(2);
            AutomatonVariable variable = this.getAutomatonVariables().get(varName);
            if (variable == null) {
                this.getLogger().log(Level.WARNING, new Object[]{"could not replace the Automaton variable reference " + varName + " (not found)."});
                return null;
            }
            result.append(variable.getValue());
        }
        matcher.appendTail(result);
        return result.toString();
    }

    public AutomatonState getState() {
        return this.state;
    }

    public Map<Integer, AAstNode> getTransitionVariables() {
        return this.transitionVariables;
    }

    public void putTransitionVariables(Map<Integer, AAstNode> pTransitionVariables) {
        this.transitionVariables.putAll(pTransitionVariables);
    }

    private AutomatonVariable getAutomatonVariable(String name) {
        String varName;
        AutomatonVariable variable;
        Matcher matcher = AUTOMATON_VARS_PATTERN.matcher(name);
        if (matcher.find() && (variable = this.automatonVariables.get(varName = matcher.group().substring(2))) != null) {
            return variable;
        }
        return null;
    }

    private CAstNode getTransitionVariable(String name) {
        Matcher matcher = TRANSITION_VARS_PATTERN.matcher(name);
        if (matcher.find()) {
            String varId = matcher.group().substring(1);
            try {
                return (CAstNode)this.transitionVariables.get(Integer.parseInt(varId));
            }
            catch (NumberFormatException e) {
                this.logger.log(Level.WARNING, new Object[]{"could not parse the int in transition variable " + varId});
            }
        }
        return null;
    }

    private CAstNode findSubstitute(CAstNode pNode) {
        if (pNode instanceof CIdExpression) {
            String idName = ((CIdExpression)pNode).getName();
            AutomatonVariable automatonVariable = this.getAutomatonVariable(idName);
            if (automatonVariable != null) {
                return new CIntegerLiteralExpression(pNode.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(automatonVariable.getValue()));
            }
            if (idName.equals("false")) {
                return CIntegerLiteralExpression.ZERO;
            }
            return this.getTransitionVariable(idName);
        }
        if (pNode instanceof CArraySubscriptExpression) {
            CArraySubscriptExpression expr = (CArraySubscriptExpression)pNode;
            String arrayExpr = expr.getArrayExpression().toASTString();
            String subscriptExpr = expr.getSubscriptExpression().toASTString();
            AutomatonVariable automatonVariable = this.getAutomatonVariable(arrayExpr);
            if (automatonVariable != null && automatonVariable instanceof AutomatonVariable.AutomatonSetVariable) {
                String name = subscriptExpr;
                CAstNode transitionVariable = this.getTransitionVariable(subscriptExpr);
                if (transitionVariable != null) {
                    name = transitionVariable.toASTString();
                }
                return new CIntegerLiteralExpression(pNode.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(((AutomatonVariable.AutomatonSetVariable)automatonVariable).contains(name) ? 1L : 0L));
            }
        } else if (pNode instanceof CBinaryExpression) {
            CBinaryExpression expr = (CBinaryExpression)pNode;
            CExpression op1 = (CExpression)this.findSubstitute(expr.getOperand1());
            CExpression op2 = (CExpression)this.findSubstitute(expr.getOperand2());
            if (op1 == null) {
                op1 = expr.getOperand1();
            }
            if (op2 == null) {
                op2 = expr.getOperand2();
            }
            if (expr.getExpressionType() instanceof CProblemType && op1.getExpressionType().getCanonicalType().equals(op2.getExpressionType().getCanonicalType())) {
                return new CBinaryExpression(expr.getFileLocation(), op1.getExpressionType().getCanonicalType(), op1.getExpressionType().getCanonicalType(), op1, op2, expr.getOperator());
            }
        } else if (pNode instanceof CFieldReference) {
            CFieldReference expr = (CFieldReference)pNode;
            String fieldOwner = expr.getFieldOwner().toASTString();
            String fieldName = expr.getFieldName();
            AutomatonVariable automatonVariable = this.getAutomatonVariable(fieldOwner);
            if (automatonVariable != null && automatonVariable instanceof AutomatonVariable.AutomatonSetVariable && fieldName.toLowerCase().equals("empty")) {
                return new CIntegerLiteralExpression(pNode.getFileLocation(), CNumericTypes.INT, BigInteger.valueOf(((AutomatonVariable.AutomatonSetVariable)automatonVariable).isEmpty() ? 1L : 0L));
            }
        }
        return null;
    }

    public ImmutableList<AExpression> instantiateAssumptions(ImmutableList<AExpression> pAssumptions) {
        ImmutableList.Builder builder = ImmutableList.builder();
        SubstitutingCAstNodeVisitor visitor = new SubstitutingCAstNodeVisitor(this::findSubstitute);
        for (AExpression expr : pAssumptions) {
            if (expr instanceof CExpression) {
                CExpression substitutedExpr = (CExpression)((CExpression)expr).accept(visitor);
                if (substitutedExpr.getExpressionType() instanceof CProblemType) {
                    this.logger.log(Level.WARNING, new Object[]{"Type of automaton assumption '" + substitutedExpr + "' cannot be evaluated"});
                }
                builder.add((Object)substitutedExpr);
                continue;
            }
            this.logger.log(Level.WARNING, new Object[]{"could not instantiate transition assumption"});
            builder.add((Object)expr);
        }
        return builder.build();
    }
}

