/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.truth.Truth;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

@RunWith(value=Parameterized.class)
public class AutomatonFilesTest {
    @Parameterized.Parameter(value=0)
    public Path automatonFile;

    @Parameterized.Parameters(name="{0}")
    public static Object[] getAutomata() throws IOException {
        try (Stream<Path> configFiles = Files.walk(Path.of("config/specification", new String[0]), new FileVisitOption[0]);){
            Object[] objectArray = configFiles.filter(path -> path.getFileName().toString().endsWith(".spc")).sorted().toArray();
            return objectArray;
        }
    }

    @Test
    public void parse() throws InvalidConfigurationException {
        List<Automaton> automata = AutomatonParser.parseAutomatonFile(this.automatonFile, TestDataTools.configurationForTest().build(), LogManager.createTestLogManager(), MachineModel.LINUX32, CProgramScope.empty(), Language.C, ShutdownNotifier.createDummy());
        Truth.assertWithMessage((String)"automata from file %s,", (Object[])new Object[]{this.automatonFile}).that(automata).isNotEmpty();
    }
}

