/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.io.ByteSource;
import com.google.common.io.MoreFiles;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParserState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonIntExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.GraphMLState;
import org.sosy_lab.cpachecker.cpa.automaton.GraphMLTransition;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.cpa.automaton.InvariantsSpecificationAutomatonBuilder;
import org.sosy_lab.cpachecker.cpa.automaton.SourceLocationMatcher;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.CParserUtils;
import org.sosy_lab.cpachecker.util.NumericIdProvider;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.DefaultExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.ToCExpressionVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Options(prefix="witness")
public class AutomatonGraphmlParser {
    private static final Pattern VALID_HASH_PATTERN = Pattern.compile("([\\da-f]{40})|([\\da-f]{64})");
    private static final String AMBIGUOUS_TYPE_ERROR_MESSAGE = "Witness type must be unambiguous";
    private static final GraphMLTransition.GraphMLThread DEFAULT_THREAD = GraphMLTransition.createThread(0, "__CPAchecker_default_thread");
    private static final String THREAD_ID_VAR_NAME = AutomatonGraphmlCommon.KeyDef.THREADID.toString().toUpperCase();
    private static final String TOO_MANY_GRAPHS_ERROR_MESSAGE = "The witness file must describe exactly one witness automaton.";
    private static final String INVALID_AUTOMATON_ERROR_MESSAGE = "The witness automaton provided is invalid!";
    private static final String UNKNOWN_VARIABLE_WARNING_MESSAGE = "Expression <%s> contains unknown variables: %s";
    private static final String DISTANCE_TO_VIOLATION = "__DISTANCE_TO_VIOLATION";
    public static final String WITNESS_AUTOMATON_NAME = "WitnessAutomaton";
    @Option(secure=true, description="Consider assumptions that are provided with the path automaton?")
    private boolean considerAssumptions = true;
    @Option(secure=true, description="Represent sink states by bottom state instead of break state")
    private boolean stopNotBreakAtSinkStates = true;
    @Option(secure=true, description="Match the line numbers within the origin (mapping done by preprocessor line markers).")
    private boolean matchOriginLine = true;
    @Option(secure=true, description="Match the character offset within the file.")
    private boolean matchOffset = true;
    @Option(secure=true, description="Match the branching information at a branching location.")
    private boolean matchAssumeCase = true;
    @Option(secure=true, description="Check that the value of the programhash field of the witness matches the SHA-256 hash value computed for the source code.")
    private boolean checkProgramHash = true;
    @Option(secure=true, description="Enforce strict validity checks regarding the witness format, such as checking for the presence of required fields.")
    private boolean strictChecking = true;
    @Option(secure=true, description="This option can be used to ensure that no correctness witnesses are checked.")
    private boolean noCorrectnessValidation = false;
    @Option(secure=true, description="This option can be used to ensure that no violation witnesses are checked.")
    private boolean noViolationValidation = false;
    @Option(secure=true, description="File for exporting the witness automaton in DOT format.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path automatonDumpFile = null;
    @Option(secure=true, name="invariantsSpecificationAutomaton", description="Validate correctness witness by specifying an invariants specification automaton")
    private InvariantsSpecificationAutomatonBuilder invariantsSpecAutomaton = InvariantsSpecificationAutomatonBuilder.NO_ISA;
    @Option(secure=true, name="optimizeInvariantsSpecificationAutomaton", description="remove assumptions from transitions in the ISA where they are not strictly neccessary.This option is intended to be used with an ISA (c.f. option witness.invariantsSpecificationAutomaton)")
    private boolean optimizeISA = true;
    @Option(secure=true, name="checkInvariantViolations", description="remove assumptions from transitions in the ISA where they are not strictly neccessary.This option is intended to be used with an ISA (c.f. option witness.invariantsSpecificationAutomaton)")
    private boolean checkInvariantViolations = true;
    @Option(secure=true, name="useInvariantsAsAssumptions", description="remove assumptions from transitions in the ISA where they are not strictly neccessary.This option is intended to be used with an ISA (c.f. option witness.invariantsSpecificationAutomaton)")
    private boolean useInvariantsAsAssumptions = true;
    private Scope scope;
    private final LogManager logger;
    private final Configuration config;
    private final ShutdownNotifier shutdownNotifier;
    private final CFA cfa;
    private final CParserUtils.ParserTools parserTools;
    private final Map<GraphMLState, ExpressionTree<AExpression>> stateInvariantsMap;

    public AutomatonGraphmlParser(Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier, CFA pCFA, Scope pScope) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.scope = pScope;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.cfa = pCFA;
        this.config = pConfig;
        this.parserTools = CParserUtils.ParserTools.create(ExpressionTrees.newFactory(), this.cfa.getMachineModel(), this.logger);
        this.stateInvariantsMap = new HashMap<GraphMLState, ExpressionTree<AExpression>>();
    }

    public Automaton parseAutomatonFile(Path pInputFile) throws InvalidConfigurationException, InterruptedException {
        return AutomatonGraphmlParser.handlePotentiallyGZippedInput(MoreFiles.asByteSource((Path)pInputFile, (OpenOption[])new OpenOption[0]), inputStream -> this.parseAutomatonFile(inputStream), e -> new WitnessParseException((Throwable)e));
    }

    private Automaton parseAutomatonFile(InputStream pInputStream) throws InvalidConfigurationException, IOException, InterruptedException {
        Automaton automaton;
        CParser cparser = CParser.Factory.getParser(LogManager.createNullLogManager(), CParser.Factory.getOptions(this.config), this.cfa.getMachineModel(), this.shutdownNotifier);
        AutomatonGraphmlParserState graphMLParserState = this.setupGraphMLParser(pInputStream);
        AutomatonGraphmlCommon.WitnessType graphType = graphMLParserState.getWitnessType();
        if (this.noCorrectnessValidation && graphType.equals((Object)AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS) || this.noViolationValidation && graphType.equals((Object)AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS)) {
            throw new IOException(String.format("Checking for %s is disabled in current configuration", new Object[]{graphType}));
        }
        this.parseTransitions(cparser, graphMLParserState);
        ArrayList<AutomatonInternalState> automatonStates = new ArrayList<AutomatonInternalState>();
        for (GraphMLState state : graphMLParserState.getStates()) {
            automatonStates.add(this.createAutomatonState(graphMLParserState, state));
        }
        try {
            automaton = new Automaton(graphMLParserState.getAutomatonName(), graphMLParserState.getAutomatonVariables(), automatonStates, graphMLParserState.getEntryState().getId());
        }
        catch (InvalidAutomatonException e) {
            throw new WitnessParseException(INVALID_AUTOMATON_ERROR_MESSAGE, e);
        }
        automaton = this.invariantsSpecAutomaton.build(automaton, this.config, this.logger, this.shutdownNotifier, this.cfa);
        if (this.automatonDumpFile != null) {
            try (Writer w2 = IO.openOutputFile((Path)this.automatonDumpFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                automaton.writeDotFile(w2);
            }
            catch (IOException w2) {
                // empty catch block
            }
            Path automatonFile = this.automatonDumpFile.resolveSibling(this.automatonDumpFile.getFileName() + ".spc");
            try (Writer w = IO.openOutputFile((Path)automatonFile, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                w.write(automaton.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return automaton;
    }

    private AutomatonInternalState createAutomatonState(AutomatonGraphmlParserState pGraphMLParserState, GraphMLState pState) throws WitnessParseException {
        List<AutomatonTransition> transitions = pGraphMLParserState.getStateTransitions(pState);
        AutomatonBoolExpr stutterCondition = pGraphMLParserState.getStutterConditions().get(pState);
        if (stutterCondition == null) {
            stutterCondition = AutomatonBoolExpr.TRUE;
        }
        if (this.invariantsSpecAutomaton == InvariantsSpecificationAutomatonBuilder.WITNESSBASED_ISA && pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS && this.stateInvariantsMap.containsKey(pState)) {
            ExpressionTree<AExpression> invariant = this.stateInvariantsMap.get(pState);
            try {
                this.createAutomatonInvariantsTransitions(transitions, stutterCondition, (List<AutomatonAction>)ImmutableList.of(), invariant, pState, pState);
            }
            catch (UnrecognizedCodeException e) {
                throw new WitnessParseException("Unable to parse invariant to CExpression");
            }
        } else {
            transitions.add(AutomatonGraphmlParser.createAutomatonTransition(stutterCondition, (List<AutomatonBoolExpr>)ImmutableList.of(), (List<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), (List<AutomatonAction>)ImmutableList.of(), pState, pState.isViolationState(), this.stopNotBreakAtSinkStates));
        }
        if (pState.isViolationState()) {
            AutomatonBoolExpr otherAutomataSafe = AutomatonGraphmlParser.createViolationAssertion();
            List<AutomatonBoolExpr> assertions = Collections.singletonList(otherAutomataSafe);
            transitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonBoolExpr.TRUE, assertions, (List<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), (List<AutomatonAction>)ImmutableList.of(), pState, true, this.stopNotBreakAtSinkStates));
        }
        if (pState.isEntryState() && pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS) {
            AutomatonVariable.AutomatonIntVariable distanceVariable = (AutomatonVariable.AutomatonIntVariable)AutomatonVariable.createAutomatonVariable("int", DISTANCE_TO_VIOLATION, new String[0]);
            distanceVariable.setValue(pGraphMLParserState.getDistance(pState));
            pGraphMLParserState.getAutomatonVariables().put(DISTANCE_TO_VIOLATION, distanceVariable);
        }
        AutomatonInternalState automatonState = new AutomatonInternalState(pState.getId(), transitions, false, true, pState.isCycleHead());
        return automatonState;
    }

    private void parseTransitions(CParser pCParser, AutomatonGraphmlParserState pGraphMLParserState) throws WitnessParseException, InterruptedException {
        HashSet visitedTransitions = new HashSet();
        ArrayDeque<GraphMLTransition> waitingTransitions = new ArrayDeque<GraphMLTransition>();
        waitingTransitions.addAll((Collection<GraphMLTransition>)pGraphMLParserState.getLeavingTransitions().get((Object)pGraphMLParserState.getEntryState()));
        visitedTransitions.addAll(waitingTransitions);
        while (!waitingTransitions.isEmpty()) {
            GraphMLTransition transition = (GraphMLTransition)waitingTransitions.poll();
            this.parseTransition(pCParser, pGraphMLParserState, transition);
            ImmutableCollection successorTransitions = pGraphMLParserState.getLeavingTransitions().get((Object)transition.getTarget());
            for (GraphMLTransition successorTransition : successorTransitions) {
                if (!visitedTransitions.add(successorTransition)) continue;
                waitingTransitions.add(successorTransition);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void parseTransition(CParser pCParser, AutomatonGraphmlParserState pGraphMLParserState, GraphMLTransition pTransition) throws WitnessParseException, InterruptedException {
        void var15_19;
        if (pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS && pTransition.getTarget().isSinkState()) {
            throw new WitnessParseException("Proof witnesses do not allow sink nodes.");
        }
        List<AutomatonAction> actions2 = AutomatonGraphmlParser.getTransitionActions(pGraphMLParserState, pTransition);
        List<AutomatonTransition> transitions = pGraphMLParserState.getStateTransitions(pTransition.getSource());
        Deque<String> newStack = this.handleCallStack(pGraphMLParserState, pTransition);
        List<AExpression> assumptions = this.getAssumptions(pCParser, pGraphMLParserState, pTransition, newStack);
        if (pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS && !assumptions.isEmpty()) {
            throw new WitnessParseException("Assumptions are not allowed for correctness witnesses.");
        }
        GraphMLTransition.GraphMLThread thread = pTransition.getThread();
        ExpressionTree<AExpression> candidateInvariants = this.getInvariants(pCParser, pGraphMLParserState, pTransition, newStack);
        if (!ExpressionTrees.getTrue().equals(candidateInvariants) && pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS && !pGraphMLParserState.getSpecificationTypes().contains((Object)Property.CommonVerificationProperty.TERMINATION)) {
            throw new WitnessParseException("Invariants are not allowed for violation witnesses.");
        }
        ArrayList<Function<AutomatonBoolExpr, AutomatonBoolExpr>> conditionTransformations = new ArrayList<Function<AutomatonBoolExpr, AutomatonBoolExpr>>();
        if (this.matchOriginLine) {
            conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, this.getLocationMatcher(pTransition.getLineMatcherPredicate())));
        }
        if (this.matchOffset) {
            conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, this.getLocationMatcher(pTransition.getOffsetMatcherPredicate())));
        }
        if (pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS && pTransition.getExplicitAssumptionResultFunction().isPresent()) {
            String resultFunctionName = this.getFunction(pGraphMLParserState, thread, pTransition.getExplicitAssumptionResultFunction()).orElseThrow();
            conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, new AutomatonBoolExpr.MatchFunctionCallStatement(resultFunctionName)));
        }
        if (pTransition.getFunctionExit().isPresent()) {
            String function = this.getFunction(pGraphMLParserState, thread, pTransition.getFunctionExit()).orElseThrow();
            conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, AutomatonGraphmlParser.getFunctionExitMatcher(function)));
        }
        Function<Object, Object> applyMatchFunctionEntry = Function.identity();
        if (pTransition.getFunctionEntry().isPresent()) {
            String function = this.getFunction(pGraphMLParserState, thread, pTransition.getFunctionEntry()).orElseThrow();
            applyMatchFunctionEntry = condition -> AutomatonGraphmlParser.and(condition, AutomatonGraphmlParser.getFunctionCallMatcher(function));
            conditionTransformations.add(applyMatchFunctionEntry);
        }
        if (this.matchAssumeCase) {
            conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, pTransition.getAssumeCaseMatcher()));
        }
        if (pTransition.entersLoopHead()) {
            conditionTransformations.add(condition -> {
                AutomatonBoolExpr conditionA = AutomatonGraphmlParser.and(condition, AutomatonBoolExpr.EpsilonMatch.forwardEpsilonMatch(AutomatonBoolExpr.MatchLoopStart.INSTANCE, true));
                if (pTransition.getTarget().getInvariants().isEmpty()) {
                    return conditionA;
                }
                AutomatonBoolExpr conditionB = AutomatonGraphmlParser.and(AutomatonBoolExpr.EpsilonMatch.backwardEpsilonMatch(condition, true), AutomatonBoolExpr.MatchLoopStart.INSTANCE);
                return AutomatonGraphmlParser.or(conditionA, conditionB);
            });
        }
        conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, AutomatonGraphmlParser.not(AutomatonBoolExpr.MatchProgramEntry.INSTANCE)));
        conditionTransformations.add(condition -> AutomatonGraphmlParser.and(condition, AutomatonGraphmlParser.not(AutomatonBoolExpr.MatchSplitDeclaration.INSTANCE)));
        AutomatonBoolExpr transitionCondition = AutomatonBoolExpr.TRUE;
        AutomatonBoolExpr transitionConditionWithoutFunctionEntry = AutomatonBoolExpr.TRUE;
        for (Function function : conditionTransformations) {
            transitionCondition = (AutomatonBoolExpr)function.apply(transitionCondition);
            if (function == applyMatchFunctionEntry) continue;
            transitionConditionWithoutFunctionEntry = (AutomatonBoolExpr)function.apply(transitionConditionWithoutFunctionEntry);
        }
        AutomatonBoolExpr fpElseTrigger = null;
        if (pTransition.getFunctionEntry().isPresent() && pGraphMLParserState.getWitnessType() != AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS) {
            fpElseTrigger = AutomatonGraphmlParser.and(transitionConditionWithoutFunctionEntry, AutomatonGraphmlParser.getFunctionPointerAssumeCaseMatcher(this.getFunction(pGraphMLParserState, thread, pTransition.getFunctionEntry()).orElseThrow(), pTransition.getTarget().isSinkState()));
            transitions.add(AutomatonGraphmlParser.createAutomatonSinkTransition(fpElseTrigger, (List<AutomatonBoolExpr>)ImmutableList.of(), actions2, false, this.stopNotBreakAtSinkStates));
        }
        AutomatonBoolExpr automatonBoolExpr = pGraphMLParserState.getStutterConditions().get(pTransition.getSource());
        AutomatonBoolExpr additionalStutterCondition = AutomatonGraphmlParser.not(transitionCondition);
        if (fpElseTrigger != null) {
            additionalStutterCondition = AutomatonGraphmlParser.and(additionalStutterCondition, AutomatonGraphmlParser.not(fpElseTrigger));
        }
        if (automatonBoolExpr == null) {
            AutomatonBoolExpr automatonBoolExpr2 = additionalStutterCondition;
        } else {
            AutomatonBoolExpr automatonBoolExpr3 = AutomatonGraphmlParser.and(automatonBoolExpr, additionalStutterCondition);
        }
        pGraphMLParserState.getStutterConditions().put(pTransition.getSource(), (AutomatonBoolExpr)var15_19);
        if (this.invariantsSpecAutomaton == InvariantsSpecificationAutomatonBuilder.WITNESSBASED_ISA && pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.CORRECTNESS_WITNESS && !candidateInvariants.equals(ExpressionTrees.getTrue())) {
            try {
                this.createAutomatonInvariantsTransitions(transitions, transitionCondition, actions2, candidateInvariants, pTransition.getSource(), pTransition.getTarget());
                ExpressionTree<Object> stateInvariantsMapEntry = ExpressionTrees.getTrue();
                for (Map.Entry<GraphMLState, ExpressionTree<AExpression>> entry : this.stateInvariantsMap.entrySet()) {
                    ExpressionTree<AExpression> invariantAtTargetState;
                    if (!entry.getKey().equals(pTransition.getTarget()) || (invariantAtTargetState = this.stateInvariantsMap.get(entry.getKey())) == null || invariantAtTargetState.equals(candidateInvariants)) continue;
                    stateInvariantsMapEntry = invariantAtTargetState;
                }
                this.stateInvariantsMap.put(pTransition.getTarget(), And.of(stateInvariantsMapEntry, candidateInvariants));
                return;
            }
            catch (UnrecognizedCodeException e) {
                throw new WitnessParseException("Unable to parse invariants to CExpressions");
            }
        }
        transitions.add(AutomatonGraphmlParser.createAutomatonTransition(transitionCondition, (List<AutomatonBoolExpr>)ImmutableList.of(), assumptions, candidateInvariants, actions2, pTransition.getTarget(), pTransition.getTarget().isViolationState(), this.stopNotBreakAtSinkStates));
        if (!assumptions.isEmpty() || !actions2.isEmpty() || !candidateInvariants.equals(ExpressionTrees.getTrue()) || pTransition.getTarget().isViolationState()) {
            boolean sourceIsViolationNode = pTransition.getSource().isViolationState();
            transitions.add(AutomatonGraphmlParser.createAutomatonTransition(AutomatonGraphmlParser.and(transitionCondition, new AutomatonBoolExpr.MatchAnySuccessorEdgesBoolExpr(transitionCondition)), (List<AutomatonBoolExpr>)ImmutableList.of(), (List<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), (List<AutomatonAction>)ImmutableList.of(), pTransition.getSource(), sourceIsViolationNode, this.stopNotBreakAtSinkStates));
        }
    }

    private ExpressionTree<AExpression> getInvariants(CParser pCParser, AutomatonGraphmlParserState pGraphMLParserState, GraphMLTransition pTransition, Deque<String> pCallstack) throws WitnessParseException, InterruptedException {
        if (!pTransition.getTarget().getInvariants().isEmpty()) {
            GraphMLTransition.GraphMLThread thread = pTransition.getThread();
            Optional<String> explicitInvariantScope = this.getFunction(pGraphMLParserState, thread, pTransition.getTarget().getExplicitInvariantScope());
            Scope candidateScope = this.determineScope(explicitInvariantScope, pCallstack, this.getLocationMatcherPredicate(pTransition));
            Optional<String> explicitAssumptionResultFunction = this.getFunction(pGraphMLParserState, thread, pTransition.getExplicitAssumptionResultFunction());
            Optional<String> resultFunction = this.determineResultFunction(explicitAssumptionResultFunction, this.scope);
            ExpressionTree<AExpression> invariant = CParserUtils.parseStatementsAsExpressionTree(pTransition.getTarget().getInvariants(), resultFunction, pCParser, candidateScope, this.parserTools);
            invariant = this.logAndRemoveUnknown(invariant);
            return invariant;
        }
        return ExpressionTrees.getTrue();
    }

    private List<AExpression> getAssumptions(CParser pCParser, AutomatonGraphmlParserState pGraphMLParserState, GraphMLTransition pTransition, Deque<String> pCallstack) throws WitnessParseException, InterruptedException {
        if (this.considerAssumptions) {
            GraphMLTransition.GraphMLThread thread = pTransition.getThread();
            Optional<String> explicitAssumptionScope = this.getFunction(pGraphMLParserState, thread, pTransition.getExplicitAssumptionScope());
            Scope assumptionScope = this.determineScope(explicitAssumptionScope, pCallstack, this.getLocationMatcherPredicate(pTransition));
            Optional<String> explicitAssumptionResultFunction = this.getFunction(pGraphMLParserState, thread, pTransition.getExplicitAssumptionResultFunction());
            Optional<String> assumptionResultFunction = this.determineResultFunction(explicitAssumptionResultFunction, assumptionScope);
            try {
                List<AExpression> assumptions = CParserUtils.convertStatementsToAssumptions(CParserUtils.parseStatements(pTransition.getAssumptions(), assumptionResultFunction, pCParser, assumptionScope, this.parserTools), this.cfa.getMachineModel(), this.logger);
                return this.logAndRemoveUnknown(assumptions);
            }
            catch (InvalidAutomatonException e) {
                String reason = e.getMessage();
                if (e.getCause() instanceof ParserException) {
                    reason = String.format("Cannot parse <%s>", Joiner.on((String)" ").join(pTransition.getAssumptions()));
                }
                throw new WitnessParseException("The witness automaton provided is invalid! Reason: " + reason, e);
            }
        }
        return ImmutableList.of();
    }

    private List<AExpression> logAndRemoveUnknown(List<AExpression> pAssumptions) {
        ArrayList<AExpression> filteredAssumptions = new ArrayList<AExpression>();
        for (AExpression assumption : pAssumptions) {
            Set<AIdExpression> unknown = AutomatonGraphmlParser.getUnknownVariables(assumption);
            if (unknown.isEmpty()) {
                filteredAssumptions.add(assumption);
                continue;
            }
            this.logger.log(Level.WARNING, new Object[]{String.format(UNKNOWN_VARIABLE_WARNING_MESSAGE, assumption, unknown)});
        }
        return filteredAssumptions;
    }

    private ExpressionTree<AExpression> logAndRemoveUnknown(ExpressionTree<AExpression> invariant) {
        FluentIterable expressions = FluentIterable.from(ExpressionTrees.traverseRecursively(invariant)).filter(ExpressionTrees::isLeaf).filter(Predicates.not(ExpressionTrees::isConstant)).transform(leaf -> (AExpression)((LeafExpression)leaf).getExpression());
        LinkedHashMultimap invalid = LinkedHashMultimap.create();
        for (AExpression assumption : expressions) {
            Set<AIdExpression> unknown = AutomatonGraphmlParser.getUnknownVariables(assumption);
            if (unknown.isEmpty()) continue;
            invalid.putAll((Object)assumption, unknown);
        }
        if (!invalid.isEmpty()) {
            for (Map.Entry invalidExpression : invalid.asMap().entrySet()) {
                this.logger.log(Level.WARNING, new Object[]{String.format(UNKNOWN_VARIABLE_WARNING_MESSAGE, invalidExpression.getKey(), invalidExpression.getValue())});
            }
            invariant = invariant.accept(new DefaultExpressionTreeVisitor<AExpression, ExpressionTree<AExpression>, RuntimeException>((Multimap)invalid){
                final /* synthetic */ Multimap val$invalid;
                {
                    this.val$invalid = multimap;
                }

                @Override
                public ExpressionTree<AExpression> visit(LeafExpression<AExpression> pLeafExpression) throws RuntimeException {
                    return this.val$invalid.containsKey((Object)pLeafExpression.getExpression()) ? ExpressionTrees.getTrue() : pLeafExpression;
                }

                @Override
                protected ExpressionTree<AExpression> visitDefault(ExpressionTree<AExpression> pExpressionTree) throws RuntimeException {
                    return pExpressionTree;
                }
            });
        }
        return invariant;
    }

    private static Set<AIdExpression> getUnknownVariables(AExpression pExpression) {
        return CFAUtils.traverseRecursively(pExpression).filter(AIdExpression.class).filter(id -> id.getDeclaration() == null).toSet();
    }

    private Optional<String> getFunction(AutomatonGraphmlParserState pGraphmlParserState, GraphMLTransition.GraphMLThread pThread, Optional<String> pFunctionName) throws WitnessParseException {
        if (!pFunctionName.isPresent() || !this.cfa.getAllFunctionNames().contains(pFunctionName.orElseThrow())) {
            return pFunctionName;
        }
        if (pFunctionName.isPresent()) {
            return pFunctionName;
        }
        throw new WitnessParseException(String.format("Unable to assign function <%s> to thread <%s>.", pFunctionName.orElseThrow(), pThread));
    }

    private Predicate<FileLocation> getLocationMatcherPredicate(GraphMLTransition pTransition) {
        Optional<Predicate<FileLocation>> lineMatcherPredicate;
        Optional<Predicate<FileLocation>> offsetMatcherPredicate;
        Object locationMatcherPredicate = Predicates.alwaysTrue();
        if (this.matchOffset && (offsetMatcherPredicate = pTransition.getOffsetMatcherPredicate()).isPresent()) {
            locationMatcherPredicate = locationMatcherPredicate.and(offsetMatcherPredicate.orElseThrow());
        }
        if (this.matchOriginLine && (lineMatcherPredicate = pTransition.getLineMatcherPredicate()).isPresent()) {
            locationMatcherPredicate = locationMatcherPredicate.and(lineMatcherPredicate.orElseThrow());
        }
        return locationMatcherPredicate;
    }

    private Deque<String> handleCallStack(AutomatonGraphmlParserState pGraphMLParserState, GraphMLTransition pTransition) throws WitnessParseException {
        Optional<String> functionExit;
        Deque<String> currentStack;
        GraphMLTransition.GraphMLThread thread = pTransition.getThread();
        Deque<String> newStack = currentStack = pGraphMLParserState.getOrCreateStack(thread, pTransition.getSource());
        Optional<String> functionEntry = this.getFunction(pGraphMLParserState, thread, pTransition.getFunctionEntry());
        if (!functionEntry.isPresent() && pTransition.getSource().isEntryState()) {
            functionEntry = this.getFunction(pGraphMLParserState, thread, Optional.of(this.cfa.getMainFunction().getFunctionName()));
        }
        if (!Objects.equals(functionEntry, functionExit = this.getFunction(pGraphMLParserState, thread, pTransition.getFunctionExit()))) {
            if (functionExit.isPresent()) {
                if (newStack.isEmpty()) {
                    this.logger.log(Level.WARNING, new Object[]{"Trying to return from function", functionExit.orElseThrow(), "although no function is on the stack."});
                } else {
                    String oldFunction = (newStack = new ArrayDeque<String>(newStack)).pop();
                    if (!oldFunction.equals(functionExit.orElseThrow())) {
                        this.logger.log(Level.WARNING, new Object[]{String.format("Trying to return from function %s, but current function on call stack is %s", functionExit.orElseThrow(), oldFunction)});
                    } else if (newStack.isEmpty()) {
                        pGraphMLParserState.releaseFunctions(thread);
                    }
                }
            }
            if (functionEntry.isPresent()) {
                newStack = new ArrayDeque<String>(newStack);
                newStack.push(functionEntry.orElseThrow());
            }
        }
        pGraphMLParserState.putStack(thread, pTransition.getTarget(), newStack);
        if (functionEntry.isPresent() && functionEntry.equals(functionExit) && (newStack.isEmpty() || !newStack.peek().equals(functionExit.orElseThrow()))) {
            newStack = new ArrayDeque<String>(newStack);
        }
        return newStack;
    }

    private static List<AutomatonAction> getTransitionActions(AutomatonGraphmlParserState pGraphMLParserState, GraphMLTransition pTransition) {
        Optional<AutomatonAction> threadAssignment;
        ImmutableList.Builder actionBuilder = ImmutableList.builder();
        if (pGraphMLParserState.getWitnessType() == AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS) {
            actionBuilder.add((Object)new AutomatonAction.Assignment(DISTANCE_TO_VIOLATION, new AutomatonIntExpr.Constant(-pGraphMLParserState.getDistance(pTransition.getTarget()))));
        }
        if ((threadAssignment = pTransition.getThreadAssignment()).isPresent()) {
            actionBuilder.add((Object)threadAssignment.orElseThrow());
        }
        return actionBuilder.build();
    }

    private AutomatonGraphmlParserState setupGraphMLParser(InputStream pInputStream) throws IOException, WitnessParseException {
        AutomatonGraphmlParserState state;
        GraphMLDocumentData docDat = this.parseXML(pInputStream);
        this.checkFields(docDat.getGraph());
        AutomatonGraphmlCommon.WitnessType graphType = this.getWitnessType(docDat.getGraph());
        Set<Property> specType = this.getSpecAsProperties(docDat.getGraph());
        Node nameAttribute = docDat.getGraph().getAttributes().getNamedItem("name");
        Object automatonName = WITNESS_AUTOMATON_NAME;
        if (nameAttribute != null) {
            automatonName = (String)automatonName + "_" + nameAttribute.getTextContent();
        }
        LinkedHashMap<String, GraphMLState> states = new LinkedHashMap<String, GraphMLState>();
        LinkedHashMultimap enteringTransitions = LinkedHashMultimap.create();
        LinkedHashMultimap leavingTransitions = LinkedHashMultimap.create();
        NumericIdProvider numericIdProvider = NumericIdProvider.create();
        LinkedHashSet<GraphMLState> entryStates = new LinkedHashSet<GraphMLState>();
        for (Node transition : docDat.getTransitions()) {
            this.collectEdgeData(docDat, states, entryStates, (Multimap<GraphMLState, GraphMLTransition>)leavingTransitions, (Multimap<GraphMLState, GraphMLTransition>)enteringTransitions, numericIdProvider, transition);
        }
        if (states.size() < docDat.idToNodeMap.size()) {
            for (String stateId : docDat.idToNodeMap.keySet()) {
                if (states.containsKey(stateId)) continue;
                states.put(stateId, this.parseState(docDat, states, stateId, Optional.empty()));
            }
        }
        if ((state = AutomatonGraphmlParserState.initialize((String)automatonName, graphType, specType, states.values(), (Multimap<GraphMLState, GraphMLTransition>)enteringTransitions, (Multimap<GraphMLState, GraphMLTransition>)leavingTransitions, this.cfa.getAllFunctionNames())).getWitnessType() == AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS && !state.isEntryConnectedToViolation()) {
            this.logger.log(Level.WARNING, new Object[]{String.format("There is no path from the entry state %s to a state explicitly marked as violation state. Distance-to-violation waitlist order will not work and witness validation may fail to confirm this witness.", state.getEntryState())});
        }
        if (state.getLeavingTransitions().values().stream().anyMatch(t -> t.getThreadAssignment().isPresent())) {
            state.getAutomatonVariables().put(THREAD_ID_VAR_NAME, AutomatonVariable.createAutomatonVariable("int", THREAD_ID_VAR_NAME, new String[0]));
        }
        return state;
    }

    private GraphMLDocumentData parseXML(InputStream pInputStream) throws WitnessParseException, IOException {
        Document doc;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(pInputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new WitnessParseException(e);
        }
        return new GraphMLDocumentData(doc);
    }

    private void checkFields(Node graphNode) throws IOException, WitnessParseException {
        this.checkHashSum(GraphMLDocumentData.getDataOnNode(graphNode, AutomatonGraphmlCommon.KeyDef.PROGRAMHASH));
        this.checkArchitecture(GraphMLDocumentData.getDataOnNode(graphNode, AutomatonGraphmlCommon.KeyDef.ARCHITECTURE));
        if (this.strictChecking) {
            AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.WITNESS_TYPE);
            AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.SOURCECODELANGUAGE);
            AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.PRODUCER);
            AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.SPECIFICATION);
            AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.PROGRAMFILE);
        }
    }

    private static AutomatonBoolExpr getFunctionCallMatcher(String pEnteredFunction) {
        AutomatonBoolExpr.MatchFunctionCall functionEntryMatcher = new AutomatonBoolExpr.MatchFunctionCall(pEnteredFunction);
        return functionEntryMatcher;
    }

    private static AutomatonBoolExpr getFunctionPointerAssumeCaseMatcher(String pEnteredFunction, boolean pIsSinkNode) {
        AutomatonBoolExpr.MatchFunctionPointerAssumeCase functionPointerAssumeCaseMatcher = new AutomatonBoolExpr.MatchFunctionPointerAssumeCase(new AutomatonBoolExpr.MatchAssumeCase(pIsSinkNode), new AutomatonBoolExpr.MatchFunctionCall(pEnteredFunction));
        return functionPointerAssumeCaseMatcher;
    }

    private static AutomatonBoolExpr getFunctionExitMatcher(String pExitedFunction) {
        AutomatonBoolExpr functionExitMatcher = AutomatonGraphmlParser.or(AutomatonBoolExpr.EpsilonMatch.forwardEpsilonMatch(new AutomatonBoolExpr.MatchFunctionExit(pExitedFunction), false), new AutomatonBoolExpr.MatchFunctionCallStatement(pExitedFunction));
        return functionExitMatcher;
    }

    private static boolean entersLoopHead(Node pTransition) throws WitnessParseException {
        Set<String> loopHeadFlags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ENTERLOOPHEAD);
        if (!loopHeadFlags.isEmpty()) {
            ImmutableSet loopHeadFlagValues = Collections3.transformedImmutableSetCopy(loopHeadFlags, Boolean::parseBoolean);
            if (loopHeadFlagValues.size() > 1) {
                throw new WitnessParseException("Conflicting values for the flag " + AutomatonGraphmlCommon.KeyDef.ENTERLOOPHEAD + ": " + loopHeadFlags);
            }
            if (((Boolean)loopHeadFlagValues.iterator().next()).booleanValue()) {
                return true;
            }
        }
        return false;
    }

    private AutomatonBoolExpr getLocationMatcher(Optional<Predicate<FileLocation>> pMatcherPredicate) {
        if (!pMatcherPredicate.isPresent()) {
            return AutomatonBoolExpr.TRUE;
        }
        return new AutomatonBoolExpr.MatchLocationDescriptor(this.cfa.getMainFunction(), pMatcherPredicate.orElseThrow());
    }

    private static Optional<Predicate<FileLocation>> getOriginLineMatcherPredicate(Node pTransition) throws WitnessParseException {
        Set<String> originFileTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ORIGINFILE);
        AutomatonGraphmlParser.checkParsable(originFileTags.size() < 2, "At most one origin-file data tag must be provided for an edge.");
        Set<String> startLineTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.STARTLINE);
        AutomatonGraphmlParser.checkParsable(startLineTags.size() < 2, "At most one startline data tag must be provided for each edge.");
        Set<String> endLineTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ENDLINE);
        AutomatonGraphmlParser.checkParsable(endLineTags.size() < 2, "At most one endline data tag must be provided for each edge.");
        int startLine = 0;
        if (!startLineTags.isEmpty()) {
            startLine = Integer.parseInt(startLineTags.iterator().next());
        }
        int endLine = 0;
        if (!endLineTags.isEmpty()) {
            endLine = Integer.parseInt(endLineTags.iterator().next());
        }
        if (startLine < 1 && endLine > 1) {
            startLine = endLine;
        }
        if (endLine < 1 && startLine >= 1) {
            endLine = startLine;
        }
        if (endLine < startLine) {
            return Optional.of(Predicates.alwaysFalse());
        }
        if (startLine > 0) {
            Optional<String> matchOriginFileName = originFileTags.isEmpty() ? Optional.empty() : Optional.of(originFileTags.iterator().next());
            SourceLocationMatcher.LineMatcher originDescriptor = new SourceLocationMatcher.LineMatcher(matchOriginFileName, startLine, endLine);
            return Optional.of(originDescriptor);
        }
        return Optional.empty();
    }

    private static Optional<Predicate<FileLocation>> getOffsetMatcherPredicate(Node pTransition) throws WitnessParseException {
        Set<String> originFileTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ORIGINFILE);
        AutomatonGraphmlParser.checkParsable(originFileTags.size() < 2, "At most one origin-file data tag must be provided for an edge.");
        Set<String> offsetTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.OFFSET);
        AutomatonGraphmlParser.checkParsable(offsetTags.size() < 2, "At most one offset data tag must be provided for each edge.");
        Set<String> endoffsetTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ENDOFFSET);
        AutomatonGraphmlParser.checkParsable(endoffsetTags.size() < 2, "At most one endoffset data tag must be provided for each edge.");
        int offset = -1;
        if (!offsetTags.isEmpty()) {
            offset = Integer.parseInt(offsetTags.iterator().next());
        }
        int endoffset = -1;
        if (!endoffsetTags.isEmpty()) {
            endoffset = Integer.parseInt(endoffsetTags.iterator().next());
        }
        if (offset < 0 && endoffset > 0) {
            offset = endoffset;
        }
        if (endoffset < 0 && offset >= 0) {
            endoffset = offset;
        }
        if (endoffset < offset) {
            return Optional.of(Predicates.alwaysFalse());
        }
        if (offset >= 0) {
            Optional<String> matchOriginFileName = originFileTags.isEmpty() ? Optional.empty() : Optional.of(originFileTags.iterator().next());
            SourceLocationMatcher.OffsetMatcher originDescriptor = new SourceLocationMatcher.OffsetMatcher(matchOriginFileName, offset, endoffset);
            return Optional.of(originDescriptor);
        }
        return Optional.empty();
    }

    private static AutomatonBoolExpr getAssumeCaseMatcher(Node pTransition) throws WitnessParseException {
        Set<String> assumeCaseTags = GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.CONTROLCASE);
        if (!assumeCaseTags.isEmpty()) {
            boolean assumeCase;
            AutomatonGraphmlParser.checkParsable(assumeCaseTags.size() < 2, "At most one assume-case tag must be provided for each transition.");
            String assumeCaseStr = assumeCaseTags.iterator().next();
            if (assumeCaseStr.equalsIgnoreCase(AutomatonGraphmlCommon.AssumeCase.THEN.toString())) {
                assumeCase = true;
            } else if (assumeCaseStr.equalsIgnoreCase(AutomatonGraphmlCommon.AssumeCase.ELSE.toString())) {
                assumeCase = false;
            } else {
                throw new WitnessParseException("Unrecognized assume case: " + assumeCaseStr);
            }
            return new AutomatonBoolExpr.MatchAssumeCase(assumeCase);
        }
        return AutomatonBoolExpr.TRUE;
    }

    private static Optional<GraphMLTransition.GraphMLThread> getThread(Node pTransition, NumericIdProvider pNumericIdProvider) throws WitnessParseException {
        return AutomatonGraphmlParser.parseThreadId(pTransition, pNumericIdProvider, AutomatonGraphmlCommon.KeyDef.THREADID, "At most one threadId tag must be provided for each transition.");
    }

    private static Optional<GraphMLTransition.GraphMLThread> parseThreadId(Node pTransition, NumericIdProvider pNumericIdProvider, AutomatonGraphmlCommon.KeyDef pKey, String pErrorMessage) throws WitnessParseException {
        Set<String> threadIdTags = GraphMLDocumentData.getDataOnNode(pTransition, pKey);
        if (!threadIdTags.isEmpty()) {
            AutomatonGraphmlParser.checkParsable(threadIdTags.size() < 2, pErrorMessage);
            String threadId = threadIdTags.iterator().next();
            return Optional.of(GraphMLTransition.createThread(pNumericIdProvider.provideNumericId(threadId), threadId));
        }
        return Optional.empty();
    }

    private static AutomatonAction getThreadIdAssignment(int pThreadId) {
        AutomatonIntExpr.Constant expr = new AutomatonIntExpr.Constant(pThreadId);
        return new AutomatonAction.Assignment(THREAD_ID_VAR_NAME, expr);
    }

    private void collectEdgeData(GraphMLDocumentData pDocDat, Map<String, GraphMLState> pStates, Set<GraphMLState> pEntryStates, Multimap<GraphMLState, GraphMLTransition> pLeavingEdges, Multimap<GraphMLState, GraphMLTransition> pEnteringEdges, NumericIdProvider pNumericThreadIdProvider, Node pTransition) throws WitnessParseException {
        String sourceStateId = GraphMLDocumentData.getAttributeValue(pTransition, "source", "Every transition needs a source!");
        GraphMLState source = this.parseState(pDocDat, pStates, sourceStateId, Optional.of(pTransition));
        String targetStateId = GraphMLDocumentData.getAttributeValue(pTransition, "target", "Every transition needs a target!");
        GraphMLState target = this.parseState(pDocDat, pStates, targetStateId, Optional.of(pTransition));
        Optional<String> functionEntry = AutomatonGraphmlParser.parseSingleDataValue(pTransition, AutomatonGraphmlCommon.KeyDef.FUNCTIONENTRY, "At most one function can be entered by one transition.");
        Optional<String> functionExit = AutomatonGraphmlParser.parseSingleDataValue(pTransition, AutomatonGraphmlCommon.KeyDef.FUNCTIONEXIT, "At most one function can be exited by one transition.");
        Optional<String> explicitAssumptionScope = AutomatonGraphmlParser.parseSingleDataValue(pTransition, AutomatonGraphmlCommon.KeyDef.ASSUMPTIONSCOPE, "At most one explicit assumption scope must be provided for a transition.");
        Optional<String> assumptionResultFunction = AutomatonGraphmlParser.parseSingleDataValue(pTransition, AutomatonGraphmlCommon.KeyDef.ASSUMPTIONRESULTFUNCTION, "At most one result function must be provided for a transition.");
        Optional<GraphMLTransition.GraphMLThread> thread = AutomatonGraphmlParser.getThread(pTransition, pNumericThreadIdProvider);
        Optional<AutomatonAction> threadIdAssignment = thread.isPresent() ? Optional.of(AutomatonGraphmlParser.getThreadIdAssignment(thread.orElseThrow().getId())) : Optional.empty();
        GraphMLTransition transition = new GraphMLTransition(source, target, functionEntry, functionExit, AutomatonGraphmlParser.getOffsetMatcherPredicate(pTransition), AutomatonGraphmlParser.getOriginLineMatcherPredicate(pTransition), AutomatonGraphmlParser.getAssumeCaseMatcher(pTransition), thread.orElse(DEFAULT_THREAD), threadIdAssignment, GraphMLDocumentData.getDataOnNode(pTransition, AutomatonGraphmlCommon.KeyDef.ASSUMPTION), explicitAssumptionScope, assumptionResultFunction, AutomatonGraphmlParser.entersLoopHead(pTransition));
        pLeavingEdges.put((Object)source, (Object)transition);
        pEnteringEdges.put((Object)target, (Object)transition);
        Element sourceStateNode = pDocDat.getNodeWithId(sourceStateId);
        if (sourceStateNode == null) {
            throw new WitnessParseException(String.format("Source %s of transition %s does not exist.", sourceStateId, AutomatonGraphmlParser.transitionToString(pTransition)));
        }
        Element targetStateNode = pDocDat.getNodeWithId(targetStateId);
        if (targetStateNode == null) {
            throw new WitnessParseException(String.format("Target %s of transition %s does not exist.", targetStateId, AutomatonGraphmlParser.transitionToString(pTransition)));
        }
        if (source.isViolationState()) {
            this.logger.log(Level.WARNING, new Object[]{String.format("Source %s of transition %s is a violation state. No outgoing edges expected.", sourceStateId, AutomatonGraphmlParser.transitionToString(pTransition))});
        }
        if (source.isSinkState()) {
            this.logger.log(Level.WARNING, new Object[]{String.format("Source %s of transition %s is a sink state. No outgoing edges expected.", sourceStateId, AutomatonGraphmlParser.transitionToString(pTransition))});
        }
        if (source.isEntryState()) {
            pEntryStates.add(source);
        }
        if (target.isEntryState()) {
            pEntryStates.add(target);
        }
    }

    private GraphMLState parseState(GraphMLDocumentData pDocDat, Map<String, GraphMLState> pStates, String pStateId, Optional<Node> pReference) throws WitnessParseException {
        GraphMLState result = pStates.get(pStateId);
        if (result != null) {
            return result;
        }
        Element stateNode = pDocDat.getNodeWithId(pStateId);
        if (stateNode == null) {
            String message = pReference.isPresent() ? String.format("The state with id <%s> does not exist, but is referenced in the transition <%s>", pStateId, AutomatonGraphmlParser.transitionToString(pReference.orElseThrow())) : String.format("The state with if <%s> does not exist.", pStateId);
            throw new WitnessParseException(message);
        }
        Set<String> candidates = GraphMLDocumentData.getDataOnNode(stateNode, AutomatonGraphmlCommon.KeyDef.INVARIANT);
        Optional<String> candidateScope = AutomatonGraphmlParser.parseSingleDataValue(stateNode, AutomatonGraphmlCommon.KeyDef.INVARIANTSCOPE, "At most one explicit invariant scope must be provided for a state.");
        result = new GraphMLState(pStateId, candidates, candidateScope, pDocDat.getNodeFlags(stateNode));
        pStates.put(pStateId, result);
        return result;
    }

    private static Optional<String> parseSingleDataValue(Node pEdge, AutomatonGraphmlCommon.KeyDef pKey, String pErrorMessage) throws WitnessParseException {
        Set<String> values = GraphMLDocumentData.getDataOnNode(pEdge, pKey);
        AutomatonGraphmlParser.checkParsable(values.size() <= 1, pErrorMessage);
        String value = (String)Iterables.getOnlyElement(values, null);
        return Optional.ofNullable(value);
    }

    private AutomatonGraphmlCommon.WitnessType getWitnessType(Node pAutomaton) throws WitnessParseException {
        AutomatonGraphmlCommon.WitnessType witnessType;
        Set<String> witnessTypeText = GraphMLDocumentData.getDataOnNode(pAutomaton, AutomatonGraphmlCommon.KeyDef.WITNESS_TYPE);
        if (witnessTypeText.isEmpty()) {
            witnessType = AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS;
        } else {
            if (witnessTypeText.size() > 1) {
                throw new WitnessParseException(AMBIGUOUS_TYPE_ERROR_MESSAGE);
            }
            String witnessTypeToParse = witnessTypeText.iterator().next().trim();
            Optional<AutomatonGraphmlCommon.WitnessType> parsedGraphType = AutomatonGraphmlCommon.WitnessType.tryParse(witnessTypeToParse);
            if (parsedGraphType.isPresent()) {
                witnessType = parsedGraphType.orElseThrow();
            } else {
                witnessType = AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS;
                this.logger.log(Level.WARNING, new Object[]{String.format("Unknown witness type %s, assuming %s instead.", new Object[]{witnessTypeToParse, witnessType})});
            }
        }
        return witnessType;
    }

    private Set<Property> getSpecAsProperties(Node pAutomaton) {
        Set<String> specText = GraphMLDocumentData.getDataOnNode(pAutomaton, AutomatonGraphmlCommon.KeyDef.SPECIFICATION);
        if (specText.isEmpty()) {
            return ImmutableSet.of((Object)Property.CommonVerificationProperty.REACHABILITY);
        }
        ImmutableSet.Builder properties = ImmutableSet.builderWithExpectedSize((int)specText.size());
        for (String prop : specText) {
            try {
                properties.add((Object)this.getProperty(prop));
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException e) {
                this.logger.logf(Level.WARNING, "Cannot map specification %s to property type. Will ignore it.", new Object[]{prop});
            }
        }
        return properties.build();
    }

    private Property getProperty(String pProperty) {
        String prop;
        if (pProperty.trim().startsWith("CHECK")) {
            prop = pProperty.substring(pProperty.indexOf(",") + 1, pProperty.lastIndexOf(")")).trim();
            if (prop.startsWith("LTL")) {
                prop = prop.substring(prop.indexOf("(") + 1, prop.lastIndexOf(")"));
            }
        } else {
            prop = pProperty;
        }
        for (Property.CommonVerificationProperty propType : Property.CommonVerificationProperty.values()) {
            if (!propType.toString().equals(prop)) continue;
            return propType;
        }
        return Property.CommonVerificationProperty.valueOf(prop.trim());
    }

    private static String transitionToString(Node pTransition) {
        Node id;
        if (pTransition == null) {
            return "null";
        }
        NamedNodeMap attributes = pTransition.getAttributes();
        if (attributes != null && (id = attributes.getNamedItem("id")) != null) {
            return id.getNodeValue();
        }
        return pTransition.toString();
    }

    private static void checkRequiredField(Node pGraphNode, AutomatonGraphmlCommon.KeyDef pKey) throws WitnessParseException {
        AutomatonGraphmlParser.checkRequiredField(pGraphNode, pKey, false);
    }

    private static void checkRequiredField(Node pGraphNode, AutomatonGraphmlCommon.KeyDef pKey, boolean pAcceptEmpty) throws WitnessParseException {
        FluentIterable data = GraphMLDocumentData.getDataOnNode(pGraphNode, pKey);
        if (Iterables.isEmpty(data)) {
            throw new WitnessParseException(String.format("The witness does not contain the required field '%s'", pKey.id));
        }
        if (!pAcceptEmpty) {
            data = FluentIterable.from(data).filter(s -> !s.trim().isEmpty());
        }
        if (Iterables.isEmpty(data)) {
            throw new WitnessParseException(String.format("The witness does not contain a non-empty entry for the required field '%s'", pKey.id));
        }
    }

    private void checkHashSum(Set<String> pProgramHashes) throws IOException, WitnessParseException {
        if (pProgramHashes.isEmpty()) {
            String message = this.checkProgramHash ? "Witness does not contain the SHA-256 hash value of the program and may therefore be unrelated to the verification task it is being validated against." : "Witness does not contain the SHA-256 hash value of the program.";
            if (this.strictChecking) {
                throw new WitnessParseException(message);
            }
            this.logger.log(Level.WARNING, new Object[]{message});
        } else {
            ImmutableSet programHashes = FluentIterable.from(pProgramHashes).transform(String::trim).transform(String::toLowerCase).toSet();
            ArrayList<String> invalidHashes = new ArrayList<String>(programHashes.size());
            for (Object programHashInWitness : programHashes) {
                if (VALID_HASH_PATTERN.matcher((CharSequence)programHashInWitness).matches()) continue;
                invalidHashes.add((String)programHashInWitness);
            }
            if (!invalidHashes.isEmpty()) {
                StringBuilder messageBuilder = new StringBuilder();
                if (invalidHashes.size() == 1) {
                    messageBuilder.append("The value <");
                    messageBuilder.append((String)invalidHashes.iterator().next());
                    messageBuilder.append("> given as hash value of the program source code is not a valid SHA-256 hash value for any program.");
                } else {
                    messageBuilder.append("None of the following values given as hash values of the program source code is a valid SHA-256 hash value for any program: ");
                    for (String invalidHash : invalidHashes) {
                        messageBuilder.append("<");
                        messageBuilder.append(invalidHash);
                        messageBuilder.append(">");
                        messageBuilder.append(", ");
                    }
                    messageBuilder.setLength(messageBuilder.length() - 2);
                }
                if (this.strictChecking) {
                    throw new WitnessParseException(messageBuilder.toString());
                }
                this.logger.log(Level.WARNING, new Object[]{messageBuilder.toString()});
            }
            if (this.checkProgramHash) {
                for (Path programFile : this.cfa.getFileNames()) {
                    String actualProgramHash = AutomatonGraphmlCommon.computeSha1Hash(programFile).toLowerCase();
                    String actualSha256Programhash = AutomatonGraphmlCommon.computeHash(programFile).toLowerCase();
                    if (programHashes.contains(actualProgramHash) || programHashes.contains(actualSha256Programhash)) continue;
                    throw new WitnessParseException("Neiter the SHA-1 hash value of given verification-task source-code file (" + actualProgramHash + ") nor the corresponding SHA-256 hash value (" + actualSha256Programhash + ") match the program hash value given in the witness. The witness is likely unrelated to the verification task.");
                }
            }
        }
    }

    private void checkArchitecture(Set<String> pArchitecture) throws WitnessParseException {
        if (pArchitecture.isEmpty()) {
            String message = "Witness does not contain the architecture assumed for the verification task. If the architecture assumed by the witness differs from the architecture assumed by the validator, meaningful validation results cannot be guaranteed.";
            if (this.strictChecking) {
                throw new WitnessParseException(message);
            }
            this.logger.log(Level.WARNING, new Object[]{message});
        } else if (!pArchitecture.contains(AutomatonGraphmlCommon.getArchitecture(this.cfa.getMachineModel()))) {
            throw new WitnessParseException("The architecture assumed for the given verification-task differs  from the architecture assumed by the witness.  Witness validation is meaningless.");
        }
    }

    private Optional<String> determineResultFunction(Optional<String> pResultFunction, Scope pScope) {
        CProgramScope functionScope;
        if (pResultFunction.isPresent()) {
            return pResultFunction;
        }
        if (pScope instanceof CProgramScope && !(functionScope = (CProgramScope)pScope).isGlobalScope()) {
            return Optional.of(functionScope.getCurrentFunctionName());
        }
        return Optional.empty();
    }

    private Scope determineScope(Optional<String> pExplicitScope, Deque<String> pFunctionStack, Predicate<FileLocation> pLocationDescriptor) {
        Scope result = this.scope;
        if (result instanceof CProgramScope) {
            result = ((CProgramScope)result).withLocationDescriptor(pLocationDescriptor);
            if (pExplicitScope.isPresent() || !pFunctionStack.isEmpty()) {
                String functionName = pExplicitScope.isPresent() ? pExplicitScope.orElseThrow() : pFunctionStack.peek();
                result = ((CProgramScope)result).withFunctionScope(functionName);
            }
        }
        return result;
    }

    private static AutomatonBoolExpr createViolationAssertion() {
        return AutomatonGraphmlParser.not(new AutomatonBoolExpr.ALLCPAQuery("internalStateIsTarget"));
    }

    private static AutomatonTransition createAutomatonTransition(AutomatonBoolExpr pTriggers, List<AutomatonBoolExpr> pAssertions, List<AExpression> pAssumptions, ExpressionTree<AExpression> pCandidateInvariants, List<AutomatonAction> pActions, GraphMLState pTargetState, boolean pLeadsToViolationNode, boolean pSinkAsBottomNotBreak) {
        if (pTargetState.isSinkState()) {
            return AutomatonGraphmlParser.createAutomatonSinkTransition(pTriggers, pAssertions, pActions, pLeadsToViolationNode, pSinkAsBottomNotBreak);
        }
        AutomatonTransition.Builder builder = new AutomatonTransition.Builder(pTriggers, pTargetState.getId()).withAssertions((List<AutomatonBoolExpr>)(pLeadsToViolationNode ? ImmutableList.builder().addAll(pAssertions).add((Object)AutomatonGraphmlParser.createViolationAssertion()).build() : pAssertions)).withAssumptions(pAssumptions).withCandidateInvariants(pCandidateInvariants).withActions(pActions);
        if (pLeadsToViolationNode) {
            return new TargetInformationCopyingAutomatonTransition(builder);
        }
        return builder.build();
    }

    private static AutomatonTransition createAutomatonSinkTransition(AutomatonBoolExpr pTriggers, List<AutomatonBoolExpr> pAssertions, List<AutomatonAction> pActions, boolean pLeadsToViolationNode, boolean pSinkAsBottomNotBreak) {
        AutomatonTransition.Builder builder = new AutomatonTransition.Builder(pTriggers, pSinkAsBottomNotBreak ? AutomatonInternalState.BOTTOM : AutomatonInternalState.BREAK).withAssertions(pAssertions).withActions(pActions);
        if (pLeadsToViolationNode) {
            return new TargetInformationCopyingAutomatonTransition(builder);
        }
        return builder.build();
    }

    private static AutomatonTransition createAutomatonInvariantErrorTransition(AutomatonBoolExpr pTriggers, List<AExpression> pAssumptions) {
        AutomatonInternalState followErrorState = AutomatonInternalState.ERROR;
        return new AutomatonTransition.Builder(pTriggers, followErrorState).withAssumptions(pAssumptions).withTargetInformation(new AutomatonExpression.StringExpression("Invariant not valid")).build();
    }

    private void createAutomatonInvariantsTransitions(List<AutomatonTransition> pTransitions, AutomatonBoolExpr pTransitionCondition, List<AutomatonAction> pActions, ExpressionTree<AExpression> pInvariant, GraphMLState pSourceState, GraphMLState pTargetState) throws UnrecognizedCodeException {
        CExpression cExpr = pInvariant.accept(new ToCExpressionVisitor(this.cfa.getMachineModel(), this.logger));
        if (pInvariant instanceof LeafExpression && !((LeafExpression)pInvariant).assumeTruth()) {
            cExpr = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger).negateExpressionAndSimplify(cExpr);
        }
        CBinaryExpression negCExpr = new CBinaryExpressionBuilder(this.cfa.getMachineModel(), this.logger).negateExpressionAndSimplify(cExpr);
        List<AExpression> assumptionWithNegCExpr = Collections.singletonList(negCExpr);
        ImmutableList assumptionWithCExpr = Collections.singletonList(cExpr);
        if (this.optimizeISA) {
            ArrayList<CFAEdge> stateChangingEdges = new ArrayList<CFAEdge>();
            ArrayList<CFAEdge> nonStateChangingEdges = new ArrayList<CFAEdge>();
            for (CFANode node : this.cfa.getAllNodes()) {
                for (CFAEdge edge : CFAUtils.leavingEdges(node)) {
                    if (EnumSet.of(CFAEdgeType.BlankEdge, CFAEdgeType.AssumeEdge).contains((Object)edge.getEdgeType())) {
                        nonStateChangingEdges.add(edge);
                        continue;
                    }
                    stateChangingEdges.add(edge);
                }
            }
            AutomatonBoolExpr changingTransition = AutomatonGraphmlParser.and(pTransitionCondition, this.matchAnyEdgeOf(stateChangingEdges));
            AutomatonBoolExpr nonChangingTransition = AutomatonGraphmlParser.and(pTransitionCondition, this.matchAnyEdgeOf(nonStateChangingEdges));
            if (this.checkInvariantViolations) {
                pTransitions.add(AutomatonGraphmlParser.createAutomatonInvariantErrorTransition(changingTransition, assumptionWithNegCExpr));
            }
            if (pSourceState.getInvariants().equals(pTargetState.getInvariants())) {
                pTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(changingTransition, (List<AutomatonBoolExpr>)ImmutableList.of(), (List<AExpression>)(this.useInvariantsAsAssumptions ? assumptionWithCExpr : ImmutableList.of()), pInvariant, pActions, pTargetState, pTargetState.isViolationState(), this.stopNotBreakAtSinkStates));
                pTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(nonChangingTransition, (List<AutomatonBoolExpr>)ImmutableList.of(), (List<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), (List<AutomatonAction>)ImmutableList.of(), pTargetState, pTargetState.isViolationState(), this.stopNotBreakAtSinkStates));
            }
        }
        if (!this.optimizeISA && this.checkInvariantViolations) {
            pTransitions.add(AutomatonGraphmlParser.createAutomatonInvariantErrorTransition(pTransitionCondition, assumptionWithNegCExpr));
        }
        if (!this.optimizeISA || !pSourceState.getInvariants().equals(pTargetState.getInvariants())) {
            pTransitions.add(AutomatonGraphmlParser.createAutomatonTransition(pTransitionCondition, (List<AutomatonBoolExpr>)ImmutableList.of(), (List<AExpression>)(this.useInvariantsAsAssumptions ? assumptionWithCExpr : ImmutableList.of()), pInvariant, pActions, pTargetState, pTargetState.isViolationState(), this.stopNotBreakAtSinkStates));
        }
    }

    private AutomatonBoolExpr matchAnyEdgeOf(List<CFAEdge> stateChangingEdges) {
        AutomatonBoolExpr.MatchCFAEdgeNodes result = null;
        for (CFAEdge edge : stateChangingEdges) {
            AutomatonBoolExpr.MatchCFAEdgeNodes edgeTransition = new AutomatonBoolExpr.MatchCFAEdgeNodes(edge);
            result = result == null ? edgeTransition : AutomatonGraphmlParser.or(result, edgeTransition);
        }
        return result;
    }

    public static boolean isGraphmlAutomatonFromConfiguration(Path pPath) throws InvalidConfigurationException {
        try {
            return AutomatonGraphmlParser.isGraphmlAutomaton(pPath);
        }
        catch (FileNotFoundException e) {
            throw new WitnessParseException("Invalid witness file provided! File not found: " + pPath);
        }
        catch (IOException e) {
            throw new WitnessParseException(e);
        }
    }

    public static boolean isGraphmlAutomaton(Path pPath) throws IOException {
        SAXParser saxParser;
        try {
            saxParser = SAXParserFactory.newInstance().newSAXParser();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new AssertionError("SAX parser configured incorrectly. Could not determine whether or not the file describes a witness automaton.", e);
        }
        DefaultHandler defaultHandler = new DefaultHandler();
        try {
            try (InputStream input = Files.newInputStream(pPath, new OpenOption[0]);
                 GZIPInputStream zipInput = new GZIPInputStream(input);){
                saxParser.parse((InputStream)zipInput, defaultHandler);
            }
            catch (IOException e) {
                try (InputStream plainInput = Files.newInputStream(pPath, new OpenOption[0]);){
                    saxParser.parse(plainInput, defaultHandler);
                }
            }
            return true;
        }
        catch (SAXException e) {
            return false;
        }
    }

    public static AutomatonGraphmlCommon.WitnessType getWitnessType(Path pPath) throws InvalidConfigurationException, InterruptedException {
        return AutomatonGraphmlParser.handlePotentiallyGZippedInput(MoreFiles.asByteSource((Path)pPath, (OpenOption[])new OpenOption[0]), inputStream -> AutomatonGraphmlParser.getWitnessType(inputStream), e -> new WitnessParseException((Throwable)e));
    }

    private static AutomatonGraphmlCommon.WitnessType getWitnessType(InputStream pInputStream) throws InvalidConfigurationException, IOException {
        AutomatonGraphmlCommon.WitnessType graphType;
        Document doc;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            doc = docBuilder.parse(pInputStream);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new WitnessParseException(e);
        }
        NodeList graphs = doc.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.GRAPH.toString());
        AutomatonGraphmlParser.checkParsable(graphs.getLength() == 1, TOO_MANY_GRAPHS_ERROR_MESSAGE);
        Node graphNode = graphs.item(0);
        AutomatonGraphmlParser.checkRequiredField(graphNode, AutomatonGraphmlCommon.KeyDef.WITNESS_TYPE);
        Set<String> graphTypeText = GraphMLDocumentData.getDataOnNode(graphNode, AutomatonGraphmlCommon.KeyDef.WITNESS_TYPE);
        if (graphTypeText.isEmpty()) {
            graphType = AutomatonGraphmlCommon.WitnessType.VIOLATION_WITNESS;
        } else {
            if (graphTypeText.size() > 1) {
                throw new WitnessParseException(AMBIGUOUS_TYPE_ERROR_MESSAGE);
            }
            String witnessTypeToParse = graphTypeText.iterator().next().trim();
            Optional<AutomatonGraphmlCommon.WitnessType> parsedWitnessType = AutomatonGraphmlCommon.WitnessType.tryParse(witnessTypeToParse);
            if (parsedWitnessType.isPresent()) {
                graphType = parsedWitnessType.orElseThrow();
            } else {
                throw new WitnessParseException("Witness type not recognized: " + witnessTypeToParse);
            }
        }
        return graphType;
    }

    private static AutomatonBoolExpr not(AutomatonBoolExpr pA) {
        if (pA.equals(AutomatonBoolExpr.TRUE)) {
            return AutomatonBoolExpr.FALSE;
        }
        if (pA.equals(AutomatonBoolExpr.FALSE)) {
            return AutomatonBoolExpr.TRUE;
        }
        return new AutomatonBoolExpr.Negation(pA);
    }

    private static AutomatonBoolExpr and(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
        if (pA.equals(AutomatonBoolExpr.TRUE) || pB.equals(AutomatonBoolExpr.FALSE)) {
            return pB;
        }
        if (pB.equals(AutomatonBoolExpr.TRUE) || pA.equals(AutomatonBoolExpr.FALSE)) {
            return pA;
        }
        return new AutomatonBoolExpr.And(pA, pB);
    }

    private static AutomatonBoolExpr or(AutomatonBoolExpr pA, AutomatonBoolExpr pB) {
        if (pA.equals(AutomatonBoolExpr.TRUE) || pB.equals(AutomatonBoolExpr.FALSE)) {
            return pA;
        }
        if (pB.equals(AutomatonBoolExpr.TRUE) || pA.equals(AutomatonBoolExpr.FALSE)) {
            return pB;
        }
        return new AutomatonBoolExpr.Or(pA, pB);
    }

    private static void checkParsable(boolean pParsable, String pMessage) throws WitnessParseException {
        if (!pParsable) {
            throw new WitnessParseException(pMessage);
        }
    }

    private static String getMessage(Throwable pException) {
        Object message = pException.getMessage();
        if (message == null) {
            message = "Exception occurred, but details are unknown: " + pException;
        }
        if (pException instanceof IOException) {
            return String.format("Error while accessing witness file: %s!", message);
        }
        return message;
    }

    /*
     * Exception decompiling
     */
    private static <T, E extends Throwable> T handlePotentiallyGZippedInput(ByteSource pInputSource, InputHandler<T, E> pInputHandler, Function<IOException, E> pExceptionHandler) throws E, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Iterable<Node> asIterable(final NodeList pNodeList) {
        return new Iterable<Node>(){
            private Integer length = null;

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        if (length == null) {
                            length = pNodeList.getLength();
                        }
                        return this.index < length;
                    }

                    @Override
                    public Node next() {
                        return pNodeList.item(this.index++);
                    }
                };
            }
        };
    }

    private static interface InputHandler<T, E extends Throwable> {
        public T handleInput(InputStream var1) throws E, IOException, InterruptedException;
    }

    public static class WitnessParseException
    extends InvalidConfigurationException {
        private static final String PARSE_EXCEPTION_MESSAGE_PREFIX = "Cannot parse witness: ";
        private static final long serialVersionUID = -6357416712866877118L;

        public WitnessParseException(String pMessage) {
            super(PARSE_EXCEPTION_MESSAGE_PREFIX + pMessage);
        }

        public WitnessParseException(String pMessage, Exception pCause) {
            super(PARSE_EXCEPTION_MESSAGE_PREFIX + pMessage, (Throwable)pCause);
        }

        public WitnessParseException(Throwable pCause) {
            super(PARSE_EXCEPTION_MESSAGE_PREFIX + AutomatonGraphmlParser.getMessage(pCause), pCause);
        }
    }

    private static class GraphMLDocumentData {
        private final Node graph;
        private final ImmutableMap<String, Element> idToNodeMap;
        private final Iterable<Node> transitions;

        public GraphMLDocumentData(Document pDocument) throws WitnessParseException {
            NodeList graphs = pDocument.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.GRAPH.toString());
            AutomatonGraphmlParser.checkParsable(graphs.getLength() == 1, AutomatonGraphmlParser.TOO_MANY_GRAPHS_ERROR_MESSAGE);
            this.graph = Objects.requireNonNull(graphs.item(0));
            ImmutableMap.Builder idToNodeMapBuilder = ImmutableMap.builder();
            NodeList nodes = pDocument.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.NODE.toString());
            for (Node stateNode : AutomatonGraphmlParser.asIterable(nodes)) {
                String stateId = GraphMLDocumentData.getAttributeValue(stateNode, "id", "Every state needs an ID!");
                idToNodeMapBuilder.put((Object)stateId, (Object)((Element)stateNode));
            }
            this.idToNodeMap = idToNodeMapBuilder.buildOrThrow();
            this.transitions = AutomatonGraphmlParser.asIterable(pDocument.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.EDGE.toString()));
        }

        public Node getGraph() {
            return this.graph;
        }

        public Iterable<Node> getTransitions() {
            return this.transitions;
        }

        public EnumSet<AutomatonGraphmlCommon.NodeFlag> getNodeFlags(Element pStateNode) {
            EnumSet<AutomatonGraphmlCommon.NodeFlag> result = EnumSet.noneOf(AutomatonGraphmlCommon.NodeFlag.class);
            NodeList dataChilds = pStateNode.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.DATA.toString());
            for (Node dataChild : AutomatonGraphmlParser.asIterable(dataChilds)) {
                Node attribute = dataChild.getAttributes().getNamedItem("key");
                Preconditions.checkNotNull((Object)attribute, (Object)"Every data element must have a key attribute!");
                String key = attribute.getTextContent();
                AutomatonGraphmlCommon.NodeFlag flag = AutomatonGraphmlCommon.NodeFlag.getNodeFlagByKey(key);
                if (flag == null) continue;
                result.add(flag);
            }
            return result;
        }

        private static String getAttributeValue(Node of, String attributeName, String exceptionMessage) throws WitnessParseException {
            Node attribute = of.getAttributes().getNamedItem(attributeName);
            if (attribute == null) {
                throw new WitnessParseException(exceptionMessage);
            }
            return attribute.getTextContent();
        }

        private @Nullable Element getNodeWithId(String nodeId) {
            Element result = (Element)this.idToNodeMap.get((Object)nodeId);
            if (result == null || !result.getTagName().equals(AutomatonGraphmlCommon.GraphMLTag.NODE.toString())) {
                return null;
            }
            return result;
        }

        private static Set<String> getDataOnNode(Node node, AutomatonGraphmlCommon.KeyDef dataKey) {
            Preconditions.checkNotNull((Object)node);
            Preconditions.checkArgument((node.getNodeType() == 1 ? 1 : 0) != 0);
            Set<Node> dataNodes = GraphMLDocumentData.findKeyedDataNode((Element)node, dataKey);
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            for (Node n : dataNodes) {
                result.add(n.getTextContent());
            }
            return result;
        }

        private static Set<Node> findKeyedDataNode(Element of, AutomatonGraphmlCommon.KeyDef dataKey) {
            LinkedHashSet<Node> result = new LinkedHashSet<Node>();
            LinkedHashSet<Node> alternative = null;
            NodeList dataChilds = of.getElementsByTagName(AutomatonGraphmlCommon.GraphMLTag.DATA.toString());
            for (Node dataChild : AutomatonGraphmlParser.asIterable(dataChilds)) {
                Node attribute = dataChild.getAttributes().getNamedItem("key");
                Preconditions.checkNotNull((Object)attribute, (Object)"Every data element must have a key attribute!");
                String nodeKey = attribute.getTextContent();
                if (nodeKey.equals(dataKey.id)) {
                    result.add(dataChild);
                    alternative = null;
                }
                if (alternative != null || !result.isEmpty() || !dataKey.equals((Object)AutomatonGraphmlCommon.KeyDef.WITNESS_TYPE) || !nodeKey.equals("type")) continue;
                alternative = new LinkedHashSet<Node>();
                alternative.add(dataChild);
            }
            if (result.isEmpty() && alternative != null) {
                return alternative;
            }
            return result;
        }
    }

    private static class TargetInformationCopyingAutomatonTransition
    extends AutomatonTransition {
        private TargetInformationCopyingAutomatonTransition(AutomatonTransition.Builder pBuilder) {
            super(pBuilder);
        }

        @Override
        public String getTargetInformation(AutomatonExpressionArguments pArgs) {
            String own = this.getFollowState().isTarget() ? super.getTargetInformation(pArgs) : null;
            LinkedHashSet<String> targetInformationDescriptions = new LinkedHashSet<String>();
            if (!Strings.isNullOrEmpty((String)own)) {
                targetInformationDescriptions.add(own);
            }
            for (AutomatonState other : FluentIterable.from(pArgs.getAbstractStates()).filter(AutomatonState.class)) {
                if (other == pArgs.getState() || !other.getInternalState().isTarget()) continue;
                other.getOptionalTargetInformation().map(Object::toString).filter(s -> !s.isEmpty()).ifPresent(targetInformationDescriptions::add);
            }
            if (targetInformationDescriptions.isEmpty() && own == null) {
                return null;
            }
            return Joiner.on((char)',').join(targetInformationDescriptions);
        }
    }
}

