/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.core.specification.Property;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonGraphmlParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.GraphMLState;
import org.sosy_lab.cpachecker.cpa.automaton.GraphMLTransition;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

public class AutomatonGraphmlParserState {
    private static final String CLONED_FUNCTION_INFIX = "__cloned_function__";
    protected static final Pattern CLONED_FUNCTION_NAME_PATTERN = Pattern.compile("(.+)(__cloned_function__)(\\d+)");
    private final String automatonName;
    private final AutomatonGraphmlCommon.WitnessType witnessType;
    private final ImmutableSet<Property> specificationTypes;
    private final GraphMLState entryState;
    private final ImmutableSet<GraphMLState> states;
    private final ImmutableListMultimap<GraphMLState, GraphMLTransition> leavingTransitions;
    private final ImmutableListMultimap<GraphMLState, GraphMLTransition> enteringTransitions;
    private final Map<GraphMLState, Integer> distances;
    private final Map<GraphMLState, AutomatonBoolExpr> stutterConditions = new HashMap<GraphMLState, AutomatonBoolExpr>();
    private final Map<String, AutomatonVariable> automatonVariables = new HashMap<String, AutomatonVariable>();
    private final Map<GraphMLTransition.GraphMLThread, Map<GraphMLState, Deque<String>>> stacks = new HashMap<GraphMLTransition.GraphMLThread, Map<GraphMLState, Deque<String>>>();
    private final Map<GraphMLState, List<AutomatonTransition>> stateTransitions = new HashMap<GraphMLState, List<AutomatonTransition>>();

    private AutomatonGraphmlParserState(String pAutomatonName, AutomatonGraphmlCommon.WitnessType pWitnessType, ImmutableSet<Property> pSpecificationTypes, ImmutableSet<GraphMLState> pStates, ImmutableListMultimap<GraphMLState, GraphMLTransition> pEnteringTransitions, ImmutableListMultimap<GraphMLState, GraphMLTransition> pLeavingTransitions, ImmutableSet<String> pFunctionNames) throws AutomatonGraphmlParser.WitnessParseException {
        this.automatonName = Objects.requireNonNull(pAutomatonName);
        this.witnessType = Objects.requireNonNull(pWitnessType);
        this.specificationTypes = Objects.requireNonNull(pSpecificationTypes);
        FluentIterable filterableStates = FluentIterable.from(pStates);
        FluentIterable entryStates = filterableStates.filter(GraphMLState::isEntryState);
        if (entryStates.size() != 1) {
            throw new AutomatonGraphmlParser.WitnessParseException("There must be exactly one entry state. Found entry states: " + entryStates);
        }
        this.entryState = Objects.requireNonNull((GraphMLState)entryStates.get(0));
        this.states = Objects.requireNonNull(pStates);
        this.enteringTransitions = Objects.requireNonNull(pEnteringTransitions);
        this.leavingTransitions = Objects.requireNonNull(pLeavingTransitions);
        this.distances = AutomatonGraphmlParserState.determineDistanceToViolation(pEnteringTransitions, (Iterable<GraphMLState>)filterableStates.filter(GraphMLState::isViolationState), (Iterable<GraphMLState>)filterableStates.filter(GraphMLState::isSinkState));
    }

    private static Map<GraphMLState, Integer> determineDistanceToViolation(Multimap<GraphMLState, GraphMLTransition> pEnteringTransitions, Iterable<GraphMLState> pViolationStates, Iterable<GraphMLState> pSinkStates) {
        ArrayDeque<GraphMLState> waitlist = new ArrayDeque<GraphMLState>();
        HashMap<GraphMLState, Integer> distances = new HashMap<GraphMLState, Integer>();
        for (GraphMLState violationState : pViolationStates) {
            waitlist.add(violationState);
            distances.put(violationState, 0);
        }
        while (!waitlist.isEmpty()) {
            GraphMLState current = (GraphMLState)waitlist.poll();
            int newDistance = (Integer)distances.get(current) + 1;
            for (GraphMLTransition enteringTransition : pEnteringTransitions.get((Object)current)) {
                GraphMLState sourceState = enteringTransition.getSource();
                Integer oldDistance = (Integer)distances.get(sourceState);
                if (oldDistance != null && oldDistance <= newDistance) continue;
                distances.put(enteringTransition.getSource(), newDistance);
                waitlist.offer(enteringTransition.getSource());
            }
        }
        for (GraphMLState sinkStateId : pSinkStates) {
            distances.put(sinkStateId, -1);
        }
        return distances;
    }

    public static AutomatonGraphmlParserState initialize(String pAutomatonName, AutomatonGraphmlCommon.WitnessType pWitnessType, Set<Property> pSpecificationTypes, Iterable<GraphMLState> pStates, Multimap<GraphMLState, GraphMLTransition> pEnteringTransitions, Multimap<GraphMLState, GraphMLTransition> pLeavingTransitions, Set<String> pFunctionNames) throws AutomatonGraphmlParser.WitnessParseException {
        return new AutomatonGraphmlParserState(pAutomatonName, pWitnessType, (ImmutableSet<Property>)ImmutableSet.copyOf(pSpecificationTypes), (ImmutableSet<GraphMLState>)ImmutableSet.copyOf(pStates), (ImmutableListMultimap<GraphMLState, GraphMLTransition>)ImmutableListMultimap.copyOf(pEnteringTransitions), (ImmutableListMultimap<GraphMLState, GraphMLTransition>)ImmutableListMultimap.copyOf(pLeavingTransitions), (ImmutableSet<String>)ImmutableSet.copyOf(pFunctionNames));
    }

    public String getAutomatonName() {
        return this.automatonName;
    }

    public AutomatonGraphmlCommon.WitnessType getWitnessType() {
        return this.witnessType;
    }

    public ImmutableSet<Property> getSpecificationTypes() {
        return this.specificationTypes;
    }

    public GraphMLState getEntryState() {
        return this.entryState;
    }

    public ImmutableSet<GraphMLState> getStates() {
        return this.states;
    }

    public ImmutableMultimap<GraphMLState, GraphMLTransition> getEnteringTransitions() {
        return this.enteringTransitions;
    }

    public ImmutableMultimap<GraphMLState, GraphMLTransition> getLeavingTransitions() {
        return this.leavingTransitions;
    }

    public int getDistance(GraphMLState pState) {
        Integer distance = this.distances.get(pState);
        if (distance == null) {
            return Integer.MAX_VALUE;
        }
        return distance;
    }

    public Map<GraphMLState, AutomatonBoolExpr> getStutterConditions() {
        return this.stutterConditions;
    }

    public Map<String, AutomatonVariable> getAutomatonVariables() {
        return this.automatonVariables;
    }

    private Map<GraphMLState, Deque<String>> getOrCreateThreadStacks(GraphMLTransition.GraphMLThread pThread) {
        Map<GraphMLState, Deque<String>> threadStacks = this.stacks.get(pThread);
        if (threadStacks == null) {
            threadStacks = new HashMap<GraphMLState, Deque<String>>();
            this.stacks.put(pThread, threadStacks);
        }
        return threadStacks;
    }

    public Deque<String> getOrCreateStack(GraphMLTransition.GraphMLThread pThread, GraphMLState pState) {
        Objects.requireNonNull(pState);
        Map<GraphMLState, Deque<String>> threadStacks = this.getOrCreateThreadStacks(pThread);
        Deque<String> stack = threadStacks.get(pState);
        if (stack == null) {
            stack = new ArrayDeque<String>();
            threadStacks.put(pState, stack);
        }
        return stack;
    }

    public void putStack(GraphMLTransition.GraphMLThread pThread, GraphMLState pState, Deque<String> pStack) {
        Objects.requireNonNull(pStack);
        this.getOrCreateThreadStacks(pThread).put(pState, pStack);
    }

    public void releaseFunctions(GraphMLTransition.GraphMLThread pThread) {
    }

    public List<AutomatonTransition> getStateTransitions(GraphMLState pGraphMLState) {
        List<AutomatonTransition> result = this.stateTransitions.get(pGraphMLState);
        if (result == null) {
            result = new ArrayList<AutomatonTransition>(4);
            this.stateTransitions.put(pGraphMLState, result);
        }
        return result;
    }

    public boolean isEntryConnectedToViolation() {
        return this.distances.get(this.getEntryState()) != null;
    }
}

