/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.regex.Pattern;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.value.type.NumericValue;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;

interface AutomatonIntExpr
extends AutomatonExpression<Integer> {
    @Override
    public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments var1);

    public static class Minus
    extends BinaryAutomatonIntExpr {
        public Minus(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            super(pA, pB, (a, b) -> a - b, "-");
        }
    }

    public static class Plus
    extends BinaryAutomatonIntExpr {
        public Plus(AutomatonIntExpr pA, AutomatonIntExpr pB) {
            super(pA, pB, (a, b) -> a + b, "+");
        }
    }

    public static class BinaryAutomatonIntExpr
    implements AutomatonIntExpr {
        private final AutomatonIntExpr a;
        private final AutomatonIntExpr b;
        private final BiFunction<Integer, Integer, Integer> op;
        private final String repr;

        private BinaryAutomatonIntExpr(AutomatonIntExpr pA, AutomatonIntExpr pB, BiFunction<Integer, Integer, Integer> pOp, String pRepr) {
            this.a = pA;
            this.b = pB;
            this.op = pOp;
            this.repr = pRepr;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            AutomatonExpression.ResultValue<Integer> resA = this.a.eval(pArgs);
            if (resA.canNotEvaluate()) {
                return resA;
            }
            AutomatonExpression.ResultValue<Integer> resB = this.b.eval(pArgs);
            if (resB.canNotEvaluate()) {
                return resB;
            }
            return new AutomatonExpression.ResultValue<Integer>(this.op.apply(resA.getValue(), resB.getValue()));
        }

        public String toString() {
            return String.format("(%s %s %s)", this.a, this.repr, this.b);
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b, this.repr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof BinaryAutomatonIntExpr) {
                BinaryAutomatonIntExpr other = (BinaryAutomatonIntExpr)o;
                return this.a.equals(other.a) && this.b.equals(other.b) && this.repr.equals(other.repr);
            }
            return false;
        }
    }

    public static class CPAQuery
    implements AutomatonIntExpr {
        private final String cpaName;
        private final String queryString;

        public CPAQuery(String pCPAName, String pQuery) {
            this.cpaName = pCPAName;
            this.queryString = pQuery;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            String modifiedQueryString = pArgs.replaceVariables(this.queryString);
            if (modifiedQueryString == null) {
                return new AutomatonExpression.ResultValue<Integer>("Failed to modify queryString \"" + this.queryString + "\"", "AutomatonIntExpr.CPAQuery");
            }
            for (AbstractState ae : pArgs.getAbstractStates()) {
                AbstractQueryableState aqe;
                if (!(ae instanceof AbstractQueryableState) || !(aqe = (AbstractQueryableState)ae).getCPAName().equals(this.cpaName)) continue;
                try {
                    Object result = aqe.evaluateProperty(modifiedQueryString);
                    if (result instanceof NumericValue) {
                        result = ((NumericValue)result).getNumber();
                    }
                    String message = String.format("CPA-Check succeeded: ModifiedCheckString: \"%s\" CPAElement: (%s) \"%s\"", modifiedQueryString, aqe.getCPAName(), aqe);
                    if (result instanceof Integer) {
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                        return new AutomatonExpression.ResultValue<Integer>((Integer)result);
                    }
                    if (result instanceof Long) {
                        pArgs.getLogger().log(Level.FINER, new Object[]{message});
                        return new AutomatonExpression.ResultValue<Integer>(((Long)result).intValue());
                    }
                    String failureMessage = String.format("Automaton got a non-Numeric value during Query of the %s CPA on Edge %s.", this.cpaName, pArgs.getCfaEdge().getDescription());
                    pArgs.getLogger().log(Level.WARNING, new Object[]{failureMessage});
                    return new AutomatonExpression.ResultValue<Integer>(failureMessage, "AutomatonIntExpr.CPAQuery");
                }
                catch (InvalidQueryException e) {
                    String errorMessage = String.format("Automaton encountered an Exception during Query of the %s CPA on Edge %s.", this.cpaName, pArgs.getCfaEdge().getDescription());
                    pArgs.getLogger().logException(Level.WARNING, (Throwable)e, errorMessage);
                    return new AutomatonExpression.ResultValue<Integer>(errorMessage, "AutomatonIntExpr.CPAQuery");
                }
            }
            String cpaNotAvailableMessage = String.format("Did not find the CPA to be queried %s CPA on Edge %s.", this.cpaName, pArgs.getCfaEdge().getDescription());
            pArgs.getLogger().log(Level.WARNING, new Object[]{cpaNotAvailableMessage});
            return new AutomatonExpression.ResultValue<Integer>(cpaNotAvailableMessage, "AutomatonIntExpr.CPAQuery");
        }

        public int hashCode() {
            return Objects.hash(this.cpaName, this.queryString);
        }

        public boolean equals(Object o) {
            if (o instanceof CPAQuery) {
                CPAQuery other = (CPAQuery)o;
                return this.cpaName.equals(other.cpaName) && this.queryString.equals(other.queryString);
            }
            return false;
        }
    }

    public static class VarAccess
    implements AutomatonIntExpr {
        private final String varId;
        private static final Pattern TRANSITION_VARS_PATTERN = Pattern.compile("\\$\\d+");

        public VarAccess(String pId) {
            if (pId.startsWith("$$")) {
                Integer.parseInt(pId.substring(2));
            }
            this.varId = pId;
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            if (TRANSITION_VARS_PATTERN.matcher(this.varId).matches()) {
                int key = Integer.parseInt(this.varId.substring(1));
                String val = pArgs.getTransitionVariable(key).toASTString();
                if (val == null) {
                    return this.logAndReturn(pArgs, "could not find the transition variable $%s.", key);
                }
                try {
                    int value = Integer.parseInt(val);
                    return new AutomatonExpression.ResultValue<Integer>(value);
                }
                catch (NumberFormatException e) {
                    return this.logAndReturn(pArgs, "could not parse the contents of transition variable $%s=\"%s\".", key, val);
                }
            }
            if (this.varId.equals("$line")) {
                return new AutomatonExpression.ResultValue<Integer>(pArgs.getCfaEdge().getLineNumber());
            }
            AutomatonVariable variable = pArgs.getAutomatonVariables().get(this.varId);
            if (variable != null) {
                return new AutomatonExpression.ResultValue<Integer>(variable.getValue());
            }
            return this.logAndReturn(pArgs, "could not find the automaton variable %s.", this.varId);
        }

        @FormatMethod
        private AutomatonExpression.ResultValue<Integer> logAndReturn(AutomatonExpressionArguments pArgs, @FormatString String message, Object ... pObjects) {
            pArgs.getLogger().logf(Level.WARNING, message, pObjects);
            return new AutomatonExpression.ResultValue<Integer>(message, "AutomatonIntExpr.VarAccess");
        }

        public String toString() {
            return this.varId;
        }

        public int hashCode() {
            return this.varId.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof VarAccess && this.varId.equals(((VarAccess)o).varId);
        }
    }

    public static class Constant
    implements AutomatonIntExpr {
        private final AutomatonExpression.ResultValue<Integer> constantResult;

        public Constant(int pI) {
            this.constantResult = new AutomatonExpression.ResultValue<Integer>(pI);
        }

        public Constant(String pI) {
            this(Integer.parseInt(pI));
        }

        public int getIntValue() {
            return this.constantResult.getValue();
        }

        @Override
        public AutomatonExpression.ResultValue<Integer> eval(AutomatonExpressionArguments pArgs) {
            return this.constantResult;
        }

        public String toString() {
            return this.constantResult.toString();
        }

        public int hashCode() {
            return this.constantResult.getValue();
        }

        public boolean equals(Object o) {
            return o instanceof Constant && this.constantResult.getValue().equals(((Constant)o).constantResult.getValue());
        }
    }
}

