/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;

public class AutomatonInternalState {
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();
    private final int stateId = idGenerator.getFreshId();
    static final AutomatonInternalState BOTTOM = new AutomatonInternalState("_predefinedState_BOTTOM", (List)ImmutableList.of()){

        @Override
        public String toString() {
            return "STOP";
        }
    };
    static final AutomatonInternalState ERROR = new AutomatonInternalState("_predefinedState_ERROR", (List)Collections.singletonList(new AutomatonTransition.Builder(AutomatonBoolExpr.TRUE, BOTTOM).withTargetInformation(new AutomatonExpression.StringExpression("")).build()), true, false, false){

        @Override
        public String toString() {
            return "ERROR";
        }
    };
    static final AutomatonInternalState BREAK = new AutomatonInternalState("_predefinedState_BREAK", Collections.singletonList(new AutomatonTransition.Builder(AutomatonBoolExpr.TRUE, BOTTOM).build()), false, false, false);
    private final String name;
    private final ImmutableList<AutomatonTransition> transitions;
    private final boolean mIsTarget;
    private final boolean mAllTransitions;
    private final boolean isCycleStart;

    public AutomatonInternalState(String pName, List<AutomatonTransition> pTransitions, boolean pIsTarget, boolean pAllTransitions, boolean pIsCycleStart) {
        this.name = pName;
        this.transitions = ImmutableList.copyOf(pTransitions);
        this.mIsTarget = pIsTarget;
        this.mAllTransitions = pAllTransitions;
        this.isCycleStart = pIsCycleStart;
    }

    public AutomatonInternalState(String pName, List<AutomatonTransition> pTransitions, boolean pIsTarget, boolean pAllTransitions) {
        this(pName, pTransitions, pIsTarget, pAllTransitions, false);
    }

    public AutomatonInternalState(String pName, List<AutomatonTransition> pTransitions) {
        this(pName, pTransitions, false, false, false);
    }

    public boolean isNonDetState() {
        return this.mAllTransitions;
    }

    public boolean isNontrivialCycleStart() {
        return this.isCycleStart;
    }

    void setFollowStates(Map<String, AutomatonInternalState> pAllStates) throws InvalidAutomatonException {
        for (AutomatonTransition t : this.transitions) {
            t.setFollowState(pAllStates);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getStateId() {
        return this.stateId;
    }

    public boolean isTarget() {
        return this.mIsTarget;
    }

    public boolean isFinalSelfLoopingState() {
        AutomatonTransition tr;
        return this.transitions.size() == 1 && (tr = (AutomatonTransition)this.transitions.get(0)).getFollowState().equals(this);
    }

    public ImmutableList<AutomatonTransition> getTransitions() {
        return this.transitions;
    }

    public String toString() {
        return this.name;
    }

    public boolean nontriviallyMatches(CFAEdge pEdge, LogManager pLogger) {
        for (AutomatonTransition trans : this.transitions) {
            if (!trans.nontriviallyMatches(pEdge, pLogger)) continue;
            return true;
        }
        return false;
    }

    public boolean nontriviallyMatchesAndEndsIn(CFAEdge pEdge, String pSuccessorName, LogManager pLogger) {
        for (AutomatonTransition trans : this.transitions) {
            if (!trans.getFollowState().getName().equals(pSuccessorName) || !trans.nontriviallyMatches(pEdge, pLogger)) continue;
            return true;
        }
        return false;
    }
}

