/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharSource;
import com.google.common.io.CharStreams;
import com.google.common.io.MoreFiles;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.StringSubject;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java_cup.runtime.ComplexSymbolFactory;
import java_cup.runtime.Symbol;
import java_cup.runtime.SymbolFactory;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonASTComparator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonScanner;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.CParserUtils;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class AutomatonInternalTest {
    private final LogManager logger = LogManager.createTestLogManager();
    private final CParser parser;
    private static final Path defaultSpecPath = Path.of("test/config/automata/defaultSpecification.spc", new String[0]);
    private static final CharSource defaultSpec = MoreFiles.asCharSource((Path)defaultSpecPath, (Charset)StandardCharsets.UTF_8, (OpenOption[])new OpenOption[0]);

    public AutomatonInternalTest() {
        CParser.ParserOptions options = CParser.Factory.getDefaultOptions();
        this.parser = CParser.Factory.getParser(this.logger, options, MachineModel.LINUX32, ShutdownNotifier.createDummy());
    }

    @Test
    public void testScanner() throws IOException {
        ComplexSymbolFactory sf1 = new ComplexSymbolFactory();
        try (BufferedReader input = defaultSpec.openBufferedStream();){
            AutomatonScanner s = new AutomatonScanner(input, defaultSpecPath, this.logger, sf1);
            Symbol symb = s.next_token();
            while (symb.sym != 0) {
                symb = s.next_token();
            }
        }
    }

    @Test
    public void testParser() throws Exception {
        ComplexSymbolFactory sf = new ComplexSymbolFactory();
        try (BufferedReader input = defaultSpec.openBufferedStream();){
            AutomatonScanner scanner = new AutomatonScanner(input, defaultSpecPath, this.logger, sf);
            Symbol symbol = new AutomatonParser(scanner, (SymbolFactory)sf, this.logger, this.parser, MachineModel.LINUX32, CProgramScope.empty()).parse();
            List as = (List)symbol.value;
            for (Automaton a : as) {
                a.writeDotFile(CharStreams.nullWriter());
            }
        }
    }

    @Test
    public void testAndOr() throws CPATransferException {
        AutomatonBoolExpr.CPAQuery cannot = new AutomatonBoolExpr.CPAQuery("none", "none");
        ImmutableMap vars = ImmutableMap.of();
        ImmutableList elements = ImmutableList.of();
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, (Map<String, AutomatonVariable>)vars, (List<AbstractState>)elements, null, null);
        AutomatonBoolExpr myTrue = AutomatonBoolExpr.TRUE;
        AutomatonBoolExpr myFalse = AutomatonBoolExpr.FALSE;
        AutomatonBoolExpr.BoolBinaryTest ex = new AutomatonBoolExpr.And(myTrue, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.And(myTrue, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.And(myTrue, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.And(myFalse, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.And(myFalse, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.And(myFalse, cannot);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.And(cannot, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.And(cannot, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.And(cannot, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(myTrue, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.Or(myTrue, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.Or(myTrue, cannot);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.Or(myFalse, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.Or(myFalse, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isFalse();
        ex = new AutomatonBoolExpr.Or(myFalse, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(cannot, myTrue);
        Truth.assertThat((Boolean)ex.eval(args).getValue()).isTrue();
        ex = new AutomatonBoolExpr.Or(cannot, myFalse);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
        ex = new AutomatonBoolExpr.Or(cannot, cannot);
        Truth.assertThat((Boolean)ex.eval(args).canNotEvaluate()).isTrue();
    }

    @Test
    public void testJokerReplacementInPattern() {
        String result = AutomatonASTComparator.replaceJokersInPattern("$20 = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num20  =  CPAchecker_AutomatonAnalysis_JokerExpression");
        result = AutomatonASTComparator.replaceJokersInPattern("$1 = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num1  =  CPAchecker_AutomatonAnalysis_JokerExpression");
        result = AutomatonASTComparator.replaceJokersInPattern("$? = $?");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Wildcard0  =  CPAchecker_AutomatonAnalysis_JokerExpression_Wildcard1");
        result = AutomatonASTComparator.replaceJokersInPattern("$1 = $5");
        Truth.assertThat((String)result).contains((CharSequence)"CPAchecker_AutomatonAnalysis_JokerExpression_Num1  =  CPAchecker_AutomatonAnalysis_JokerExpression_Num5 ");
    }

    @Test
    public void testJokerReplacementInAST() throws InterruptedException {
        String pattern = "$20 = $5($1, $?);";
        String source = "var1 = function(var2, egal);";
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").andVariable(20).isEqualTo((Object)"var1");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").andVariable(1).isEqualTo((Object)"var2");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$20 = $5($1, $?);")).matches("var1 = function(var2, egal);").andVariable(5).isEqualTo((Object)"function");
    }

    @Test
    public void transitionVariableReplacement() {
        LogManager mockLogger = (LogManager)Mockito.mock(LogManager.class);
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, null, null, null, mockLogger);
        args.putTransitionVariable(1, TestDataTools.makeVariable("hi", CNumericTypes.INT));
        args.putTransitionVariable(2, TestDataTools.makeVariable("hello", CNumericTypes.INT));
        String result = args.replaceVariables("$1 == $2");
        Truth.assertThat((String)result).isEqualTo((Object)"hi == hello");
        result = args.replaceVariables("$1 == $1");
        Truth.assertThat((String)result).isEqualTo((Object)"hi == hi");
        result = args.replaceVariables("$1 == $5");
        Truth.assertThat((String)result).isNull();
        ((LogManager)Mockito.verify((Object)mockLogger)).log((Level)ArgumentMatchers.eq((Object)Level.WARNING), (Object[])ArgumentMatchers.any());
    }

    @Test
    public void automataVariableReplacement() {
        LogManager mockLogger = (LogManager)Mockito.mock(LogManager.class);
        HashMap<String, AutomatonVariable> automatonVariables = new HashMap<String, AutomatonVariable>();
        AutomatonVariable intVar1 = AutomatonVariable.createAutomatonVariable("int", "intVar1", new String[0]);
        AutomatonVariable intVar2 = AutomatonVariable.createAutomatonVariable("Integer", "intVar2", new String[0]);
        ((AutomatonVariable.AutomatonIntVariable)intVar2).setValue(10);
        AutomatonVariable setVar1 = AutomatonVariable.createAutomatonVariable("Set", "setVar1", "int");
        AutomatonVariable setVar2 = AutomatonVariable.createAutomatonVariable("SET", "setVar2", "string", "elem1, elem2");
        automatonVariables.putAll((Map<String, AutomatonVariable>)ImmutableMap.of((Object)intVar1.getName(), (Object)intVar1, (Object)intVar2.getName(), (Object)intVar2, (Object)setVar1.getName(), (Object)setVar1, (Object)setVar2.getName(), (Object)setVar2));
        AutomatonExpressionArguments args = new AutomatonExpressionArguments(null, automatonVariables, null, null, mockLogger);
        args.putTransitionVariable(1, TestDataTools.makeVariable("programVar", CNumericTypes.INT));
        String result = args.replaceVariables("$1 == $$intVar1");
        Truth.assertThat((String)result).isEqualTo((Object)"programVar == 0");
        result = args.replaceVariables("$$intVar2 == 0");
        Truth.assertThat((String)result).isEqualTo((Object)"10 == 0");
        ((AutomatonVariable.AutomatonIntVariable)intVar1).setValue(5);
        result = args.replaceVariables("$1 + $$intVar1");
        Truth.assertThat((String)result).isEqualTo((Object)"programVar + 5");
        result = args.replaceVariables("$$setVar1");
        Truth.assertThat((String)result).isEqualTo((Object)"0");
        result = args.replaceVariables("$$setVar2");
        Truth.assertThat((String)result).isEqualTo((Object)"1");
        ((AutomatonVariable.AutomatonSetVariable)setVar1).add(1);
        result = args.replaceVariables("$$setVar1");
        Truth.assertThat((String)result).isEqualTo((Object)"1");
        ((AutomatonVariable.AutomatonSetVariable)setVar2).remove("elem1");
        ((AutomatonVariable.AutomatonSetVariable)setVar2).remove("elem2");
        result = args.replaceVariables("$$setVar2");
        Truth.assertThat((String)result).isEqualTo((Object)"0");
        result = args.replaceVariables("$1 == $$intVar3");
        Truth.assertThat((String)result).isNull();
        ((LogManager)Mockito.verify((Object)mockLogger)).log((Level)ArgumentMatchers.eq((Object)Level.WARNING), (Object[])ArgumentMatchers.any());
    }

    @Test
    public void testASTcomparison() throws InterruptedException {
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x= $?;")).matches("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x= 10;")).doesNotMatch("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$? =10;")).doesNotMatch("x=5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?=$?;")).matches("x  = 5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"b    = 5;")).doesNotMatch("a = 5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"init($?);")).matches("init(a);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"init($?);")).matches("init();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"init($1);")).doesNotMatch("init();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"init($?, b);")).matches("init(a, b);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"init($?, c);")).doesNotMatch("init(a, b);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x=$?")).matches("x = 5;");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x=$?;")).matches("x = 5");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$12345678901;")).doesNotMatch("x");
    }

    @Test
    public void testAstMatcherParameters() throws InterruptedException {
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f();")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f();")).doesNotMatch("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f();")).doesNotMatch("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($1);")).doesNotMatch("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($1);")).matches("f(x);").andVariable(1).isEqualTo((Object)"x");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($1);")).doesNotMatch("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f($?);")).matches("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f(x, $?);")).doesNotMatch("f(x);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f(x, $?);")).matches("f(x, y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"f(x, $?);")).doesNotMatch("f(x, y, z);");
    }

    @Test
    public void testAstMatcherFunctionCall() throws InterruptedException {
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?();")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?();")).doesNotMatch("x = f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$1();")).matches("f();").andVariable(1).isEqualTo((Object)"f");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x = $?();")).doesNotMatch("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x = $?();")).matches("x = f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"x = $1();")).matches("x = f();").andVariable(1).isEqualTo((Object)"f");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?($?);")).matches("f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?($?);")).matches("f(y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?($?);")).matches("f(y, z);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$?($?);")).doesNotMatch("x = f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$? = $1($?);")).matches("x = f();");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$? = $1($?);")).matches("x = f(y);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$? = $1($?);")).matches("x = f(y, z);");
        ((ASTMatcherSubject)Truth.assert_().about((x$0, x$1) -> new ASTMatcherSubject(x$0, (String)x$1)).that((Object)"$? = $1($?);")).doesNotMatch("f();");
    }

    private static interface Matches {
        public StringSubject andVariable(int var1);
    }

    @SuppressFBWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private class ASTMatcherSubject
    extends Subject {
        private final String pattern;
        private final AutomatonExpressionArguments args;

        public ASTMatcherSubject(FailureMetadata pMetadata, String pPattern) {
            super(pMetadata, (Object)pPattern);
            this.args = new AutomatonExpressionArguments(null, null, null, null, null);
            this.pattern = pPattern;
        }

        private boolean matches0(String src) throws InvalidAutomatonException, InterruptedException {
            CStatement sourceAST;
            try {
                sourceAST = CParserUtils.parseSingleStatement(src, AutomatonInternalTest.this.parser, CProgramScope.empty());
            }
            catch (InvalidAutomatonException e) {
                throw new RuntimeException("Cannot parse source code for test", e);
            }
            AutomatonASTComparator.ASTMatcher matcher = AutomatonASTComparator.generatePatternAST(this.pattern, AutomatonInternalTest.this.parser, CProgramScope.empty());
            return matcher.matches(sourceAST, this.args);
        }

        public Matches matches(String src) throws InterruptedException {
            boolean matches;
            try {
                matches = this.matches0(src);
            }
            catch (InvalidAutomatonException e) {
                this.failWithoutActual(Fact.simpleFact((String)"expected to be a valid pattern"), new Fact[]{Fact.fact((String)"but was", (Object)this.pattern), Fact.fact((String)"which cannot be parsed", (Object)e)});
                return new Matches(){

                    @Override
                    public StringSubject andVariable(int pVar) {
                        return ASTMatcherSubject.this.ignoreCheck().that("");
                    }
                };
            }
            if (!matches) {
                this.failWithActual(Fact.fact((String)"expected to match", (Object)src), new Fact[0]);
                return new Matches(){

                    @Override
                    public StringSubject andVariable(int pVar) {
                        return ASTMatcherSubject.this.ignoreCheck().that("");
                    }
                };
            }
            return new Matches(){

                @Override
                public StringSubject andVariable(int pVar) {
                    ASTMatcherSubject.this.check("getTransitionVariables()", new Object[0]).that(ASTMatcherSubject.this.args.getTransitionVariables()).containsKey((Object)pVar);
                    return ASTMatcherSubject.this.check("transition variable $%s", new Object[]{pVar}).that(ASTMatcherSubject.this.args.getTransitionVariable(pVar).toASTString());
                }
            };
        }

        public void doesNotMatch(String src) throws InterruptedException {
            try {
                if (this.matches0(src)) {
                    if (this.args.getTransitionVariables().isEmpty()) {
                        this.failWithActual(Fact.fact((String)"expected to not match", (Object)src), new Fact[0]);
                    } else {
                        this.failWithoutActual(Fact.fact((String)"expected to not match", (Object)src), new Fact[]{Fact.fact((String)"but was", (Object)this.pattern), Fact.fact((String)"with transition variables", this.args.getTransitionVariables())});
                    }
                }
            }
            catch (InvalidAutomatonException e) {
                this.failWithoutActual(Fact.simpleFact((String)"expected to be a valid pattern"), new Fact[]{Fact.fact((String)"but was", (Object)this.pattern), Fact.fact((String)"which cannot be parsed", (Object)e)});
            }
        }
    }
}

