/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.core.specification.Specification;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public enum AutomatonInvariantsUtils {


    public static void checkForMissedInvariants(Specification pAutomataAsSpec, UnmodifiableReachedSet pReachedSet) throws CPAException {
        LinkedHashSet automatonStatesWithInvariants = new LinkedHashSet();
        for (Automaton aut : pAutomataAsSpec.getSpecificationAutomata()) {
            aut.getStates().stream().map(AutomatonInternalState::getTransitions).flatMap(Collection::stream).forEach(x -> {
                ExpressionTree<AExpression> exprTree = x.getCandidateInvariants();
                if (!exprTree.equals(ExpressionTrees.getTrue())) {
                    automatonStatesWithInvariants.add(x.getFollowState());
                }
            });
        }
        for (AbstractState abstractState : pReachedSet) {
            for (AutomatonState automatonState : AbstractStates.asIterable(abstractState).filter(AutomatonState.class)) {
                automatonStatesWithInvariants.remove(automatonState.getInternalState());
            }
        }
        if (!automatonStatesWithInvariants.isEmpty()) {
            throw new CPAException(String.format("There are unaccounted invariants in the witness(es)!(Invariants of the following states: %s)", ((Object)automatonStatesWithInvariants).toString()));
        }
    }
}

