/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.core.interfaces.AbstractQueryableState;
import org.sosy_lab.cpachecker.core.interfaces.AbstractStateWithAssumptions;
import org.sosy_lab.cpachecker.core.interfaces.Graphable;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTargetInformation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.exceptions.InvalidQueryException;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.globalinfo.GlobalInfo;

public class AutomatonState
implements AbstractQueryableState,
Targetable,
Serializable,
AbstractStateWithAssumptions,
Graphable {
    private static final long serialVersionUID = -4665039439114057346L;
    private static final String AutomatonAnalysisNamePrefix = "AutomatonAnalysis_";
    static final String INTERNAL_STATE_IS_TARGET_PROPERTY = "internalStateIsTarget";
    private transient Automaton automaton;
    private final Map<String, AutomatonVariable> vars;
    private transient AutomatonInternalState internalState;
    private final ImmutableList<AExpression> assumptions;
    private final transient ExpressionTree<AExpression> candidateInvariants;
    private int matches = 0;
    private int failedMatches = 0;
    private final transient AutomatonTargetInformation targetInformation;
    private final boolean treatErrorAsTarget;

    static AutomatonState automatonStateFactory(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, Automaton pAutomaton, ImmutableList<AExpression> pAssumptions, ExpressionTree<AExpression> pCandidateInvariants, int successfulMatches, int failedMatches, AutomatonTargetInformation targetInformation, boolean pTreatErrorAsTarget) {
        if (pInternalState == AutomatonInternalState.BOTTOM) {
            return new BOTTOM(pAutomaton, pTreatErrorAsTarget);
        }
        return new AutomatonState(pVars, pInternalState, pAutomaton, pAssumptions, pCandidateInvariants, successfulMatches, failedMatches, targetInformation, pTreatErrorAsTarget);
    }

    static AutomatonState automatonStateFactory(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, Automaton pAutomaton, int successfulMatches, int failedMatches, AutomatonTargetInformation targetInformation, boolean pTreatErrorAsTarget) {
        return AutomatonState.automatonStateFactory(pVars, pInternalState, pAutomaton, (ImmutableList<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), successfulMatches, failedMatches, targetInformation, pTreatErrorAsTarget);
    }

    private AutomatonState(Map<String, AutomatonVariable> pVars, AutomatonInternalState pInternalState, Automaton pAutomaton, ImmutableList<AExpression> pAssumptions, ExpressionTree<AExpression> pCandidateInvariants, int successfulMatches, int failedMatches, AutomatonTargetInformation pTargetInformation, boolean pTreatErrorAsTarget) {
        this.vars = (Map)Preconditions.checkNotNull(pVars);
        this.internalState = (AutomatonInternalState)Preconditions.checkNotNull((Object)pInternalState);
        this.automaton = (Automaton)Preconditions.checkNotNull((Object)pAutomaton);
        this.matches = successfulMatches;
        this.failedMatches = failedMatches;
        this.assumptions = pAssumptions;
        this.candidateInvariants = pCandidateInvariants;
        this.treatErrorAsTarget = pTreatErrorAsTarget;
        if (this.internalState.isTarget()) {
            Preconditions.checkNotNull((Object)pTargetInformation);
            this.targetInformation = pTargetInformation;
        } else {
            this.targetInformation = null;
        }
    }

    @Override
    public boolean isTarget() {
        return this.treatErrorAsTarget && this.internalState.isTarget();
    }

    @Override
    public Set<Targetable.TargetInformation> getTargetInformation() throws IllegalStateException {
        Preconditions.checkState((boolean)this.isTarget());
        return ImmutableSet.of((Object)this.targetInformation);
    }

    Optional<AutomatonTargetInformation> getOptionalTargetInformation() {
        return Optional.ofNullable(this.targetInformation);
    }

    @Override
    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null) {
            return false;
        }
        if (!pObj.getClass().equals(this.getClass())) {
            return false;
        }
        AutomatonState otherState = (AutomatonState)pObj;
        return Objects.equals(this.assumptions, otherState.assumptions) && Objects.equals(this.vars, otherState.vars) && Objects.equals(this.internalState, otherState.internalState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.assumptions, this.internalState);
    }

    public ImmutableList<AExpression> getAssumptions() {
        return this.assumptions;
    }

    public String getOwningAutomatonName() {
        return this.automaton.getName();
    }

    public Automaton getOwningAutomaton() {
        return this.automaton;
    }

    @Override
    public String toString() {
        return (String)(this.automaton != null ? this.automaton.getName() + ": " : "") + this.internalState.getName() + " " + Joiner.on((char)' ').withKeyValueSeparator("=").join(this.vars);
    }

    @Override
    public String toDOTLabel() {
        if (!this.internalState.getName().equals("Init")) {
            Object prettyPrintAsmpts = "";
            if (!this.assumptions.isEmpty()) {
                prettyPrintAsmpts = "\nAssumptions: " + this.assumptions.stream().map(AAstNode::toASTString).collect(Collectors.joining("; "));
            }
            if (!this.vars.isEmpty()) {
                prettyPrintAsmpts = (String)prettyPrintAsmpts + "\n" + Joiner.on((char)' ').withKeyValueSeparator("=").join(this.vars);
            }
            return (String)(this.automaton != null ? this.automaton.getName() + ": " : "") + this.internalState.getName() + (String)prettyPrintAsmpts;
        }
        return "";
    }

    @Override
    public boolean shouldBeHighlighted() {
        return false;
    }

    @Override
    public boolean checkProperty(String pProperty) throws InvalidQueryException {
        if (pProperty.equalsIgnoreCase(INTERNAL_STATE_IS_TARGET_PROPERTY)) {
            return this.getInternalState().isTarget();
        }
        List parts = Splitter.on((String)"==").trimResults().splitToList((CharSequence)pProperty);
        if (parts.size() != 2) {
            throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not split the property string correctly.");
        }
        String left = (String)parts.get(0);
        String right = (String)parts.get(1);
        if (left.equalsIgnoreCase("state")) {
            return this.getInternalState().getName().equals(right);
        }
        AutomatonVariable var = this.vars.get(left);
        if (var != null) {
            try {
                int val = Integer.parseInt(right);
                return var.getValue() == val;
            }
            catch (NumberFormatException e) {
                throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Could not parse the int \"" + right + "\".");
            }
        }
        throw new InvalidQueryException("The Query \"" + pProperty + "\" is invalid. Only accepting \"State == something\" and \"varname = something\" queries so far.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void modifyProperty(String pModification) throws InvalidQueryException {
        List parts = Splitter.on((String)":=").trimResults().splitToList((CharSequence)pModification);
        if (parts.size() != 2) {
            throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not split the string correctly.");
        }
        String left = (String)parts.get(0);
        String right = (String)parts.get(1);
        AutomatonVariable var = this.vars.get(left);
        if (var == null) throw new InvalidQueryException("Could not modify the variable \"" + left + "\" (Variable not found)");
        if (!(var instanceof AutomatonVariable.AutomatonIntVariable)) throw new InvalidQueryException("Automaton variable '" + var.getName() + "' is not supported in query '" + pModification + "'");
        try {
            int val = Integer.parseInt(right);
            ((AutomatonVariable.AutomatonIntVariable)var).setValue(val);
            return;
        }
        catch (NumberFormatException e) {
            throw new InvalidQueryException("The Query \"" + pModification + "\" is invalid. Could not parse the int \"" + right + "\".");
        }
    }

    @Override
    public String getCPAName() {
        return AutomatonAnalysisNamePrefix + this.automaton.getName();
    }

    boolean isTreatingErrorsAsTarget() {
        return this.treatErrorAsTarget;
    }

    public ExpressionTree<AExpression> getCandidateInvariants() {
        return this.candidateInvariants;
    }

    AutomatonInternalState getInternalState() {
        return this.internalState;
    }

    public String getInternalStateName() {
        return this.internalState.getName();
    }

    public Map<String, AutomatonVariable> getVars() {
        return this.vars;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.internalState.getStateId());
        out.writeObject(this.automaton.getName());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        int stateId = in.readInt();
        this.internalState = GlobalInfo.getInstance().getAutomatonInfo().getStateById(stateId);
        if (this.internalState == null) {
            if (stateId == AutomatonInternalState.ERROR.getStateId()) {
                this.internalState = AutomatonInternalState.ERROR;
            } else if (stateId == AutomatonInternalState.BREAK.getStateId()) {
                this.internalState = AutomatonInternalState.BREAK;
            } else if (stateId == AutomatonInternalState.BOTTOM.getStateId()) {
                this.internalState = AutomatonInternalState.BOTTOM;
            }
        }
        this.automaton = GlobalInfo.getInstance().getAutomatonInfo().getCPAForAutomaton((String)in.readObject()).getAutomaton();
    }

    public int getMatches() {
        return this.matches;
    }

    public int getFailedMatches() {
        return this.failedMatches;
    }

    public void setFailedMatches(int pFailedMatches) {
        this.failedMatches = pFailedMatches;
    }

    public void setMatches(int pMatches) {
        this.matches = pMatches;
    }

    static final class AutomatonUnknownState
    extends AutomatonState {
        private static final long serialVersionUID = -2010032222354565037L;
        private final AutomatonState previousState;

        AutomatonUnknownState(AutomatonState pPreviousState) {
            super(pPreviousState.getVars(), pPreviousState.getInternalState(), pPreviousState.automaton, (ImmutableList<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), -1, -1, pPreviousState.targetInformation, pPreviousState.isTreatingErrorsAsTarget());
            this.previousState = pPreviousState;
        }

        AutomatonState getPreviousState() {
            return this.previousState;
        }

        @Override
        public boolean equals(Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj == null) {
                return false;
            }
            if (!pObj.getClass().equals(this.getClass())) {
                return false;
            }
            AutomatonUnknownState otherState = (AutomatonUnknownState)pObj;
            return this.previousState.equals(otherState.previousState);
        }

        @Override
        public int hashCode() {
            return this.previousState.hashCode() + 724;
        }

        @Override
        public String toString() {
            return "AutomatonUnknownState<" + this.previousState + ">";
        }
    }

    static class BOTTOM
    extends AutomatonState {
        private static final long serialVersionUID = -401794748742705212L;

        public BOTTOM(Automaton pAutomaton, boolean pTreatErrorsAsTarget) {
            super((Map<String, AutomatonVariable>)ImmutableMap.of(), AutomatonInternalState.BOTTOM, pAutomaton, (ImmutableList<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), 0, 0, null, pTreatErrorsAsTarget);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == bottom");
        }

        @Override
        public String toString() {
            return "AutomatonState.BOTTOM";
        }
    }

    static class TOP
    extends AutomatonState {
        private static final long serialVersionUID = -7848577870312049023L;

        public TOP(Automaton pAutomaton, boolean pTreatErrorsAsTarget) {
            super((Map<String, AutomatonVariable>)ImmutableMap.of(), new AutomatonInternalState("_predefinedState_TOP", (List<AutomatonTransition>)ImmutableList.of()), pAutomaton, (ImmutableList<AExpression>)ImmutableList.of(), ExpressionTrees.getTrue(), 0, 0, null, pTreatErrorsAsTarget);
        }

        @Override
        public boolean checkProperty(String pProperty) throws InvalidQueryException {
            return pProperty.toLowerCase().equals("state == top");
        }

        @Override
        public String toString() {
            return "AutomatonState.TOP";
        }
    }
}

