/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTargetInformation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;

public class AutomatonStateARGCombiningHelper {
    private final Map<String, AutomatonInternalState> qualifiedAutomatonStateNameToInternalState = new HashMap<String, AutomatonInternalState>();
    private final Map<String, Automaton> nameToAutomaton = new HashMap<String, Automaton>();

    public boolean registerAutomaton(AutomatonState pStateOfAutomata) {
        Automaton automaton = pStateOfAutomata.getOwningAutomaton();
        String prefix = automaton.getName() + "::";
        if (this.nameToAutomaton.put(automaton.getName(), automaton) != null) {
            return false;
        }
        for (AutomatonInternalState internal : automaton.getStates()) {
            String qualifiedName = prefix + internal.getName();
            if (this.qualifiedAutomatonStateNameToInternalState.put(qualifiedName, internal) == null) continue;
            return false;
        }
        return true;
    }

    public AutomatonState replaceStateByStateInAutomatonOfSameInstance(AutomatonState toReplace) throws CPAException {
        String qualifiedName = toReplace.getOwningAutomatonName() + "::" + toReplace.getInternalStateName();
        if (this.qualifiedAutomatonStateNameToInternalState.containsKey(qualifiedName)) {
            AutomatonTargetInformation targetInformation = null;
            if (toReplace.isTarget() && !toReplace.getTargetInformation().isEmpty()) {
                Targetable.TargetInformation info = toReplace.getTargetInformation().iterator().next();
                assert (info instanceof AutomatonTargetInformation);
                targetInformation = (AutomatonTargetInformation)info;
            }
            return AutomatonState.automatonStateFactory(toReplace.getVars(), this.qualifiedAutomatonStateNameToInternalState.get(qualifiedName), this.nameToAutomaton.get(toReplace.getOwningAutomatonName()), toReplace.getAssumptions(), toReplace.getCandidateInvariants(), toReplace.getMatches(), toReplace.getFailedMatches(), targetInformation, toReplace.isTreatingErrorsAsTarget());
        }
        throw new CPAException("Changing state failed, unknown state.");
    }

    public boolean considersAutomaton(String pAutomatonName) {
        return this.nameToAutomaton.containsKey(pAutomatonName);
    }

    public static boolean endsInAssumptionTrueState(AutomatonState pPredecessor, CFAEdge pEdge, LogManager pLogger) {
        Preconditions.checkNotNull((Object)pPredecessor);
        Preconditions.checkArgument((!pPredecessor.getInternalState().isNonDetState() ? 1 : 0) != 0);
        AutomatonExpressionArguments exprArgs = new AutomatonExpressionArguments(pPredecessor, pPredecessor.getVars(), null, pEdge, pLogger);
        try {
            for (AutomatonTransition transition : pPredecessor.getInternalState().getTransitions()) {
                AutomatonExpression.ResultValue<Boolean> assertionsHold;
                exprArgs.clearTransitionVariables();
                AutomatonExpression.ResultValue<Boolean> match = transition.getTrigger().eval(exprArgs);
                if (match.canNotEvaluate()) {
                    return false;
                }
                if (!match.getValue().booleanValue()) continue;
                return transition.getFollowState().getName().equals("__TRUE") && !(assertionsHold = transition.assertionsHold(exprArgs)).canNotEvaluate() && assertionsHold.getValue() != false && transition.canExecuteActionsOn(exprArgs);
            }
        }
        catch (CPATransferException e) {
            return false;
        }
        return pPredecessor.getInternalState().getName().equals("__TRUE");
    }
}

