/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import java.io.PrintStream;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.util.statistics.StatIntHist;
import org.sosy_lab.cpachecker.util.statistics.StatKind;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

class AutomatonStatistics
implements Statistics {
    private final Automaton automaton;
    final ThreadSafeTimerContainer totalPostTime = new ThreadSafeTimerContainer("Total time for successor computation");
    final ThreadSafeTimerContainer matchTime = new ThreadSafeTimerContainer("Time for transition matches");
    final ThreadSafeTimerContainer assertionsTime = new ThreadSafeTimerContainer("Time for transition assertions");
    final ThreadSafeTimerContainer actionTime = new ThreadSafeTimerContainer("Time for transition actions");
    final ThreadSafeTimerContainer totalStrengthenTime = new ThreadSafeTimerContainer("Total time for strengthen operator");
    final StatIntHist automatonSuccessors = new StatIntHist(StatKind.AVG, "Automaton transfer successors");

    public AutomatonStatistics(Automaton pAutomaton) {
        this.automaton = pAutomaton;
    }

    @Override
    public String getName() {
        return "AutomatonAnalysis (" + this.automaton.getName() + ")";
    }

    @Override
    public void printStatistics(PrintStream out, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
        this.put(out, 0, "Number of states", this.automaton.getNumberOfStates());
        this.put(out, 0, this.totalPostTime);
        if (this.totalPostTime.getSumTime().compareTo(TimeSpan.ofMillis((long)500L)) >= 0) {
            this.put(out, 1, this.matchTime);
            this.put(out, 1, this.assertionsTime);
            this.put(out, 1, this.actionTime);
        }
        if (this.totalStrengthenTime.getUpdateCount() > 0) {
            this.put(out, 0, this.totalStrengthenTime);
        }
        long stateBranchings = this.automatonSuccessors.getValueCount() - (long)this.automatonSuccessors.getTimesWithValue(0) - (long)this.automatonSuccessors.getTimesWithValue(1);
        this.put(out, 0, "Automaton transfers with branching", stateBranchings);
        this.put(out, 0, this.automatonSuccessors);
        int statesWithAssumptionTransitions = 0;
        for (AutomatonInternalState state : this.automaton.getStates()) {
            if (!state.getTransitions().stream().anyMatch(p -> p.isTransitionWithAssumptions())) continue;
            ++statesWithAssumptionTransitions;
        }
        this.put(out, 0, "Number of states with assumption transitions", statesWithAssumptionTransitions);
    }
}

