/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.sosy_lab.cpachecker.core.interfaces.Targetable;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;

public class AutomatonTargetInformation
implements Targetable.TargetInformation {
    private final @NonNull Automaton automaton;
    private final @NonNull AutomatonTransition automatonTrans;
    private final @NonNull String propertyInstanceDescription;

    public AutomatonTargetInformation(Automaton pAutomaton, AutomatonTransition pTransition, String pDesc) {
        this.automaton = (Automaton)Preconditions.checkNotNull((Object)pAutomaton);
        this.automatonTrans = (AutomatonTransition)Preconditions.checkNotNull((Object)pTransition);
        this.propertyInstanceDescription = (String)Preconditions.checkNotNull((Object)pDesc);
    }

    public AutomatonTargetInformation(Automaton pAutomaton, AutomatonTransition pTransition) {
        this.automaton = (Automaton)Preconditions.checkNotNull((Object)pAutomaton);
        this.automatonTrans = (AutomatonTransition)Preconditions.checkNotNull((Object)pTransition);
        this.propertyInstanceDescription = "";
    }

    public AutomatonTransition getAutomatonTransition() {
        return this.automatonTrans;
    }

    @Override
    public String toString() {
        return !this.propertyInstanceDescription.isEmpty() ? this.propertyInstanceDescription : this.automaton.getName();
    }

    public int hashCode() {
        return Objects.hash(this.automaton, this.automatonTrans, this.propertyInstanceDescription);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AutomatonTargetInformation)) {
            return false;
        }
        AutomatonTargetInformation other = (AutomatonTargetInformation)obj;
        return this.automatonTrans.equals(other.automatonTrans) && this.automaton.equals(other.automaton) && this.propertyInstanceDescription.equals(other.propertyInstanceDescription);
    }
}

