/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.BlankEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.TransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonPrecision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonStatistics;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTargetInformation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferException;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingState;
import org.sosy_lab.cpachecker.cpa.threading.ThreadingTransferRelation;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.statistics.StatIntHist;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class AutomatonTransferRelation
implements TransferRelation {
    private final ControlAutomatonCPA cpa;
    private final LogManager logger;
    private final MachineModel machineModel;
    private final ThreadSafeTimerContainer.TimerWrapper totalPostTime;
    private final ThreadSafeTimerContainer.TimerWrapper matchTime;
    private final ThreadSafeTimerContainer.TimerWrapper assertionsTime;
    private final ThreadSafeTimerContainer.TimerWrapper actionTime;
    private final ThreadSafeTimerContainer.TimerWrapper totalStrengthenTime;
    private final StatIntHist automatonSuccessors;

    public AutomatonTransferRelation(ControlAutomatonCPA pCpa, LogManager pLogger, MachineModel pMachineModel, AutomatonStatistics pStats) {
        this.cpa = pCpa;
        this.logger = pLogger;
        this.machineModel = pMachineModel;
        this.totalPostTime = pStats.totalPostTime.getNewTimer();
        this.matchTime = pStats.matchTime.getNewTimer();
        this.assertionsTime = pStats.assertionsTime.getNewTimer();
        this.actionTime = pStats.actionTime.getNewTimer();
        this.totalStrengthenTime = pStats.totalStrengthenTime.getNewTimer();
        this.automatonSuccessors = pStats.automatonSuccessors;
    }

    public Collection<AutomatonState> getAbstractSuccessorsForEdge(AbstractState pElement, Precision pPrecision, CFAEdge pCfaEdge) throws CPATransferException {
        Preconditions.checkArgument((boolean)(pElement instanceof AutomatonState));
        if (pElement instanceof AutomatonState.AutomatonUnknownState) {
            return ImmutableSet.of((Object)this.cpa.getTopState());
        }
        Collection<AutomatonState> result = this.getAbstractSuccessors0((AutomatonState)pElement, pCfaEdge, pPrecision);
        this.automatonSuccessors.setNextValue(result.size());
        return result;
    }

    @Override
    public Collection<? extends AbstractState> getAbstractSuccessors(AbstractState pState, Precision pPrecision) throws CPATransferException, InterruptedException {
        return ImmutableSet.of((Object)this.cpa.getTopState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<AutomatonState> getAbstractSuccessors0(AutomatonState pElement, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        this.totalPostTime.start();
        try {
            if (pElement instanceof AutomatonState.AutomatonUnknownState) {
                pElement = ((AutomatonState.AutomatonUnknownState)pElement).getPreviousState();
            }
            ImmutableSet<AutomatonState> immutableSet = this.getFollowStates(pElement, null, pCfaEdge, false, pPrecision);
            return immutableSet;
        }
        finally {
            this.totalPostTime.stop();
        }
    }

    private ImmutableSet<AutomatonState> getFollowStates(AutomatonState state, List<AbstractState> otherElements, CFAEdge edge, boolean failOnUnknownMatch, Precision precision) throws CPATransferException {
        Preconditions.checkArgument((!(state instanceof AutomatonState.AutomatonUnknownState) ? 1 : 0) != 0);
        if (state == this.cpa.getBottomState()) {
            return ImmutableSet.of();
        }
        if (state.getInternalState().getTransitions().isEmpty()) {
            return ImmutableSet.of((Object)state);
        }
        if (precision instanceof AutomatonPrecision && !((AutomatonPrecision)precision).isEnabled()) {
            if (state.isTarget()) {
                return ImmutableSet.of();
            }
            return ImmutableSet.of((Object)state);
        }
        ImmutableSet.Builder lSuccessors = ImmutableSet.builderWithExpectedSize((int)2);
        AutomatonExpressionArguments exprArgs = new AutomatonExpressionArguments(state, state.getVars(), otherElements, edge, this.logger);
        boolean edgeMatched = false;
        int failedMatches = 0;
        boolean nonDetState = state.getInternalState().isNonDetState();
        ArrayList<Pair<AutomatonTransition, ImmutableMap>> transitionsToBeTaken = new ArrayList<Pair<AutomatonTransition, ImmutableMap>>(2);
        for (AutomatonTransition t : state.getInternalState().getTransitions()) {
            exprArgs.clearTransitionVariables();
            this.matchTime.start();
            AutomatonExpression.ResultValue<Boolean> match = t.match(exprArgs);
            this.matchTime.stop();
            if (match.canNotEvaluate()) {
                if (failOnUnknownMatch) {
                    throw new AutomatonTransferException("Automaton transition condition could not be evaluated", match);
                }
                return ImmutableSet.of((Object)new AutomatonState.AutomatonUnknownState(state));
            }
            if (match.getValue().booleanValue()) {
                edgeMatched = true;
                this.assertionsTime.start();
                AutomatonExpression.ResultValue<Boolean> assertionsHold = t.assertionsHold(exprArgs);
                this.assertionsTime.stop();
                if (assertionsHold.canNotEvaluate()) {
                    if (failOnUnknownMatch) {
                        throw new AutomatonTransferException("Automaton transition assertions could not be evaluated", assertionsHold);
                    }
                    return ImmutableSet.of((Object)new AutomatonState.AutomatonUnknownState(state));
                }
                if (assertionsHold.getValue().booleanValue()) {
                    if (!t.canExecuteActionsOn(exprArgs)) {
                        if (failOnUnknownMatch) {
                            throw new AutomatonTransferException("Automaton transition action could not be executed");
                        }
                        return ImmutableSet.of((Object)new AutomatonState.AutomatonUnknownState(state));
                    }
                    ImmutableMap transitionVariables = ImmutableMap.copyOf(exprArgs.getTransitionVariables());
                    transitionsToBeTaken.add(Pair.of(t, transitionVariables));
                } else {
                    String desc = Strings.nullToEmpty((String)t.getTargetInformation(exprArgs));
                    AutomatonTargetInformation prop = new AutomatonTargetInformation(state.getOwningAutomaton(), t, desc);
                    AutomatonState errorState = AutomatonState.automatonStateFactory((Map<String, AutomatonVariable>)ImmutableMap.of(), AutomatonInternalState.ERROR, state.getOwningAutomaton(), 0, 0, prop, state.isTreatingErrorsAsTarget());
                    this.logger.log(Level.FINER, new Object[]{"Automaton going to ErrorState on edge \"" + edge.getDescription() + "\""});
                    lSuccessors.add((Object)errorState);
                }
                if (nonDetState) continue;
                break;
            }
            ++failedMatches;
        }
        if (edgeMatched) {
            for (Pair pair : transitionsToBeTaken) {
                AutomatonTransition t = (AutomatonTransition)pair.getFirst();
                Map transitionVariables = (Map)pair.getSecond();
                this.actionTime.start();
                Map<String, AutomatonVariable> newVars = AutomatonTransferRelation.deepCloneVars(state.getVars());
                exprArgs.setAutomatonVariables(newVars);
                exprArgs.putTransitionVariables(transitionVariables);
                t.executeActions(exprArgs);
                this.actionTime.stop();
                AutomatonTargetInformation targetInformation = null;
                if (t.getFollowState().isTarget()) {
                    String desc = Strings.nullToEmpty((String)t.getTargetInformation(exprArgs));
                    targetInformation = new AutomatonTargetInformation(state.getOwningAutomaton(), t, desc);
                }
                this.logger.log(Level.ALL, new Object[]{"Replace variables in automata assumptions"});
                ImmutableList<AExpression> instantiatedAssumes = exprArgs.instantiateAssumptions(t.getAssumptions(edge, this.logger, this.machineModel));
                AutomatonState lSuccessor = AutomatonState.automatonStateFactory(newVars, t.getFollowState(), state.getOwningAutomaton(), instantiatedAssumes, t.getCandidateInvariants(), state.getMatches() + 1, state.getFailedMatches(), targetInformation, state.isTreatingErrorsAsTarget());
                if (lSuccessor instanceof AutomatonState.BOTTOM) continue;
                lSuccessors.add((Object)lSuccessor);
            }
            return lSuccessors.build();
        }
        AutomatonState stateNewCounters = AutomatonState.automatonStateFactory(state.getVars(), state.getInternalState(), state.getOwningAutomaton(), state.getMatches(), state.getFailedMatches() + failedMatches, null, state.isTreatingErrorsAsTarget());
        return ImmutableSet.of((Object)stateNewCounters);
    }

    private static Map<String, AutomatonVariable> deepCloneVars(Map<String, AutomatonVariable> pOld) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)pOld.size());
        for (Map.Entry<String, AutomatonVariable> e : pOld.entrySet()) {
            result.put(e.getKey(), e.getValue().clone());
        }
        return result;
    }

    public Collection<AutomatonState> strengthen(AbstractState pElement, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        Iterator possibleThreadingState;
        if (pElement instanceof AutomatonState.AutomatonUnknownState) {
            this.totalStrengthenTime.start();
            Collection<AutomatonState> successors = this.strengthenAutomatonUnknownState((AutomatonState.AutomatonUnknownState)pElement, pOtherElements, pCfaEdge, pPrecision);
            this.totalStrengthenTime.stop();
            assert (!FluentIterable.from(successors).anyMatch(Predicates.instanceOf(AutomatonState.AutomatonUnknownState.class)));
            return successors;
        }
        AutomatonState state = (AutomatonState)pElement;
        if ("WitnessAutomaton".equals(state.getOwningAutomatonName()) && ThreadingTransferRelation.getCreatedThreadFunction(pCfaEdge).isPresent() && (possibleThreadingState = Iterables.filter(pOtherElements, ThreadingState.class).iterator()).hasNext()) {
            return this.handleThreadCreationForWitnessValidation(pCfaEdge, pPrecision, state, (ThreadingState)possibleThreadingState.next());
        }
        return ImmutableSet.of((Object)state);
    }

    private Collection<AutomatonState> handleThreadCreationForWitnessValidation(CFAEdge pthreadCreateEdge, Precision pPrecision, AutomatonState state, ThreadingState threadingState) throws CPATransferException {
        ImmutableSet.Builder result = ImmutableSet.builder();
        for (CFAEdge firstEdgeOfThread : threadingState.getOutgoingEdges()) {
            if (firstEdgeOfThread.getPredecessor() instanceof FunctionEntryNode && firstEdgeOfThread.getPredecessor().getNumEnteringEdges() == 0) {
                assert (firstEdgeOfThread instanceof BlankEdge) : String.format("unexpected type for edge '%s' of type '%s'", firstEdgeOfThread, firstEdgeOfThread.getClass());
                BlankEdge dummyCallEdge = new BlankEdge(firstEdgeOfThread.getRawStatement(), pthreadCreateEdge.getFileLocation(), new CFANode(pthreadCreateEdge.getPredecessor().getFunction()), firstEdgeOfThread.getSuccessor(), "Function start dummy edge");
                Collection<AutomatonState> newStates = this.getAbstractSuccessorsForEdge(state, pPrecision, dummyCallEdge);
                result.addAll((Iterable)FluentIterable.from(newStates).filter(s -> !state.equals(s)));
                continue;
            }
            result.add((Object)state);
        }
        return result.build();
    }

    private Collection<AutomatonState> strengthenAutomatonUnknownState(AutomatonState.AutomatonUnknownState lUnknownState, Iterable<AbstractState> pOtherElements, CFAEdge pCfaEdge, Precision pPrecision) throws CPATransferException {
        LinkedHashSet<ImmutableList> strengtheningCombinations = new LinkedHashSet<ImmutableList>();
        strengtheningCombinations.add(ImmutableList.copyOf(pOtherElements));
        boolean changed = FluentIterable.from(pOtherElements).anyMatch(Predicates.instanceOf(AutomatonState.AutomatonUnknownState.class));
        while (changed) {
            changed = false;
            LinkedHashSet newCombinations = new LinkedHashSet();
            for (List list : strengtheningCombinations) {
                ArrayList newPartialCombinations = new ArrayList();
                newPartialCombinations.add(new ArrayList());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    AbstractState otherState;
                    AbstractState toAdd = otherState = (AbstractState)iterator.next();
                    if (otherState instanceof AutomatonState.AutomatonUnknownState) {
                        AutomatonState.AutomatonUnknownState unknownState = (AutomatonState.AutomatonUnknownState)otherState;
                        ArrayList<AbstractState> statesOtherToCurrent = new ArrayList<AbstractState>(list);
                        statesOtherToCurrent.remove(unknownState);
                        statesOtherToCurrent.add(lUnknownState);
                        ImmutableSet<AutomatonState> successors = this.getFollowStates(unknownState.getPreviousState(), statesOtherToCurrent, pCfaEdge, true, pPrecision);
                        ArrayList multipliedPartialCrossProduct = new ArrayList();
                        for (List list2 : newPartialCombinations) {
                            for (AbstractState successor : successors) {
                                ArrayList<AbstractState> multipliedNewOtherStates = new ArrayList<AbstractState>(list2);
                                multipliedNewOtherStates.add(successor);
                                multipliedPartialCrossProduct.add(multipliedNewOtherStates);
                            }
                        }
                        newPartialCombinations = multipliedPartialCrossProduct;
                        continue;
                    }
                    for (List newOtherStates : newPartialCombinations) {
                        newOtherStates.add(toAdd);
                    }
                }
                newCombinations.addAll(newPartialCombinations);
            }
            changed = !strengtheningCombinations.equals(newCombinations);
            strengtheningCombinations = newCombinations;
        }
        LinkedHashSet<AutomatonState> successors = new LinkedHashSet<AutomatonState>();
        for (List list : strengtheningCombinations) {
            successors.addAll((Collection<AutomatonState>)this.getFollowStates(lUnknownState.getPreviousState(), list, pCfaEdge, true, pPrecision));
        }
        return successors;
    }
}

