/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.model.AStatementEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpression;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonExpressionArguments;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.ExpressionSubstitution;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

class AutomatonTransition {
    private final AutomatonBoolExpr trigger;
    private final AutomatonBoolExpr assertion;
    private final ImmutableList<AExpression> assumptions;
    private final ExpressionTree<AExpression> candidateInvariants;
    private final ImmutableList<AutomatonAction> actions;
    private final AutomatonExpression.StringExpression targetInformation;
    private final String followStateName;
    private AutomatonInternalState followState = null;

    AutomatonTransition(Builder b) {
        this(b.trigger, b.assertions, b.assumptions, b.candidateInvariants, b.actions, b.followStateName, b.followState, b.targetInformation);
    }

    private AutomatonTransition(AutomatonBoolExpr pTrigger, List<AutomatonBoolExpr> pAssertions, List<AExpression> pAssumptions, ExpressionTree<AExpression> pCandidateInvariants, List<AutomatonAction> pActions, String pFollowStateName, AutomatonInternalState pFollowState, AutomatonExpression.StringExpression pTargetInformation) {
        this.trigger = (AutomatonBoolExpr)Preconditions.checkNotNull((Object)pTrigger);
        this.assumptions = pAssumptions == null ? ImmutableList.of() : ImmutableList.copyOf(pAssumptions);
        this.candidateInvariants = (ExpressionTree)Preconditions.checkNotNull(pCandidateInvariants);
        this.actions = ImmutableList.copyOf(pActions);
        this.followStateName = (String)Preconditions.checkNotNull((Object)pFollowStateName);
        this.followState = pFollowState;
        this.targetInformation = pTargetInformation;
        if (pAssertions.isEmpty()) {
            this.assertion = AutomatonBoolExpr.TRUE;
        } else {
            AutomatonBoolExpr lAssertion = null;
            for (AutomatonBoolExpr nextAssertion : pAssertions) {
                if (lAssertion == null) {
                    lAssertion = nextAssertion;
                    continue;
                }
                lAssertion = new AutomatonBoolExpr.And(lAssertion, nextAssertion);
            }
            this.assertion = lAssertion;
        }
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.assertion, this.assumptions, this.followStateName, this.trigger, this.targetInformation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AutomatonTransition)) {
            return false;
        }
        AutomatonTransition other = (AutomatonTransition)obj;
        return Objects.equals(this.actions, other.actions) && Objects.equals(this.assertion, other.assertion) && Objects.equals(this.assumptions, other.assumptions) && Objects.equals(this.followStateName, other.followStateName) && Objects.equals(this.trigger, other.trigger) && Objects.equals(this.targetInformation, other.targetInformation);
    }

    void setFollowState(Map<String, AutomatonInternalState> pAllStates) throws InvalidAutomatonException {
        if (this.followState == null) {
            this.followState = pAllStates.get(this.followStateName);
            if (this.followState == null) {
                throw new InvalidAutomatonException("No Follow-State with name " + this.followStateName + " found.");
            }
        }
    }

    public AutomatonExpression.ResultValue<Boolean> match(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return this.trigger.eval(pArgs);
    }

    public AutomatonExpression.ResultValue<Boolean> assertionsHold(AutomatonExpressionArguments pArgs) throws CPATransferException {
        return this.assertion.eval(pArgs);
    }

    public void executeActions(AutomatonExpressionArguments pArgs) throws CPATransferException {
        for (AutomatonAction action : this.actions) {
            AutomatonExpression.ResultValue<?> res = action.eval(pArgs);
            if (!res.canNotEvaluate()) continue;
            pArgs.getLogger().log(Level.SEVERE, new Object[]{res.getFailureMessage() + " in " + res.getFailureOrigin()});
        }
        if (!Strings.isNullOrEmpty((String)pArgs.getLogMessage())) {
            pArgs.getLogger().log(Level.INFO, new Object[]{pArgs.getLogMessage()});
            pArgs.clearLogMessage();
        }
    }

    public boolean canExecuteActionsOn(AutomatonExpressionArguments pArgs) throws CPATransferException {
        for (AutomatonAction action : this.actions) {
            if (action.canExecuteOn(pArgs)) continue;
            return false;
        }
        return true;
    }

    public AutomatonInternalState getFollowState() {
        return this.followState;
    }

    String getFollowStateName() {
        return this.followStateName;
    }

    public AutomatonBoolExpr getTrigger() {
        return this.trigger;
    }

    public String getTargetInformation(AutomatonExpressionArguments pArgs) {
        if (this.targetInformation == null) {
            if (this.getFollowState().isTarget()) {
                return this.getFollowState().getName();
            }
            return null;
        }
        return this.targetInformation.eval(pArgs).getValue();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.trigger);
        sb.append(" -> ");
        if (!this.assertion.equals(AutomatonBoolExpr.TRUE)) {
            sb.append("ASSERT ");
            sb.append(this.assertion);
            sb.append(" ");
        }
        if (!this.assumptions.isEmpty()) {
            sb.append("ASSUME {");
            sb.append(Joiner.on((String)"; ").join((Iterable)Collections2.transform(this.assumptions, AAstNode::toASTString)));
            sb.append("} ");
        }
        if (!this.actions.isEmpty()) {
            Joiner.on((String)" ").appendTo(sb, this.actions);
            sb.append(" ");
        }
        return sb.toString();
    }

    boolean meetsObserverRequirements() {
        if (this.followState.equals(AutomatonInternalState.BOTTOM)) {
            return false;
        }
        for (AutomatonAction action : this.actions) {
            if (!(action instanceof AutomatonAction.CPAModification)) continue;
            return false;
        }
        return true;
    }

    public ImmutableList<AExpression> getAssumptions(CFAEdge pEdge, LogManager pLogger, MachineModel pMachineModel) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AExpression assumption : this.assumptions) {
            Optional<AExpression> resolved = this.tryResolve(assumption, pEdge, pLogger, pMachineModel);
            if (!resolved.isPresent()) continue;
            builder.add((Object)resolved.orElseThrow());
        }
        return builder.build();
    }

    private Optional<AExpression> tryResolve(AExpression pAssumption, final CFAEdge pEdge, LogManager pLogger, MachineModel pMachineModel) {
        CBinaryExpressionBuilder binExpBuilder = new CBinaryExpressionBuilder(pMachineModel, pLogger);
        ExpressionSubstitution.Substitution substitution = new ExpressionSubstitution.Substitution(){

            @Override
            public CExpression substitute(CExpression pExpression) throws ExpressionSubstitution.SubstitutionException {
                AFunctionCallAssignmentStatement functionCallAssignment;
                AExpression functionNameExpression;
                AStatement statement;
                if (!(pExpression instanceof CIdExpression)) {
                    return pExpression;
                }
                CIdExpression idExpression = (CIdExpression)pExpression;
                if (!CProgramScope.isArtificialFunctionReturnVariable(idExpression)) {
                    return pExpression;
                }
                String functionName = CProgramScope.getFunctionNameOfArtificialReturnVar(idExpression);
                if (pEdge instanceof AStatementEdge && (statement = ((AStatementEdge)pEdge).getStatement()) instanceof AFunctionCallAssignmentStatement && (functionNameExpression = (functionCallAssignment = (AFunctionCallAssignmentStatement)statement).getFunctionCallExpression().getFunctionNameExpression()) instanceof AIdExpression && ((AIdExpression)functionNameExpression).getName().equals(functionName)) {
                    return (CExpression)((Object)functionCallAssignment.getLeftHandSide());
                }
                throw new ExpressionSubstitution.SubstitutionException("Cannot substitute function return variable: Not a call to " + functionName);
            }
        };
        if (pAssumption instanceof CExpression) {
            try {
                CExpression assumption = (CExpression)pAssumption;
                return Optional.of(ExpressionSubstitution.applySubstitution(assumption, substitution, binExpBuilder));
            }
            catch (ExpressionSubstitution.SubstitutionException e) {
                return Optional.empty();
            }
        }
        return Optional.of(pAssumption);
    }

    public ExpressionTree<AExpression> getCandidateInvariants() {
        return this.candidateInvariants;
    }

    public boolean isTransitionWithAssumptions() {
        return !this.assumptions.isEmpty();
    }

    public boolean nontriviallyMatches(CFAEdge pEdge, LogManager pLogger) {
        if (this.trigger != AutomatonBoolExpr.TRUE) {
            try {
                AutomatonExpression.ResultValue<Boolean> match = this.trigger.eval(new AutomatonExpressionArguments(null, null, null, pEdge, pLogger));
                return match.canNotEvaluate() || match.getValue() != false;
            }
            catch (CPATransferException e) {
                return true;
            }
        }
        return false;
    }

    static class Builder {
        private AutomatonBoolExpr trigger;
        private List<AutomatonBoolExpr> assertions;
        private List<AExpression> assumptions;
        private List<AutomatonAction> actions;
        private String followStateName;
        private @Nullable AutomatonInternalState followState;
        private ExpressionTree<AExpression> candidateInvariants;
        private @Nullable AutomatonExpression.StringExpression targetInformation;

        Builder(AutomatonBoolExpr pTrigger, String pFollowStateName) {
            this.trigger = pTrigger;
            this.assertions = ImmutableList.of();
            this.assumptions = ImmutableList.of();
            this.actions = ImmutableList.of();
            this.followStateName = pFollowStateName;
            this.candidateInvariants = ExpressionTrees.getTrue();
        }

        Builder(AutomatonBoolExpr pTrigger, @Nullable AutomatonInternalState pFollowState) {
            this(pTrigger, pFollowState != null ? pFollowState.getName() : "");
            this.followState = pFollowState;
        }

        @CanIgnoreReturnValue
        Builder withAssertion(AutomatonBoolExpr pAssertion) {
            this.assertions = ImmutableList.of((Object)pAssertion);
            return this;
        }

        @CanIgnoreReturnValue
        Builder withAssertions(List<AutomatonBoolExpr> pAssertions) {
            this.assertions = pAssertions;
            return this;
        }

        @CanIgnoreReturnValue
        Builder withAssumptions(List<AExpression> pAssumptions) {
            this.assumptions = pAssumptions;
            return this;
        }

        @CanIgnoreReturnValue
        Builder withActions(List<AutomatonAction> pActions) {
            this.actions = pActions;
            return this;
        }

        @CanIgnoreReturnValue
        Builder withCandidateInvariants(ExpressionTree<AExpression> pCandidateInvariants) {
            this.candidateInvariants = pCandidateInvariants;
            return this;
        }

        @CanIgnoreReturnValue
        Builder withTargetInformation(AutomatonExpression.StringExpression pTargetInformation) {
            this.targetInformation = pTargetInformation;
            return this;
        }

        AutomatonTransition build() {
            return new AutomatonTransition(this.trigger, this.assertions, this.assumptions, this.candidateInvariants, this.actions, this.followStateName, this.followState, this.targetInformation);
        }
    }
}

