/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Splitter;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class AutomatonVariable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -6765794863680244559L;
    protected final String name;

    private AutomatonVariable(String pName) {
        this.name = pName;
    }

    public static AutomatonVariable createAutomatonVariable(String pType, String pName, String ... args) {
        if (pType.toLowerCase().equals("int") || pType.toLowerCase().equals("integer")) {
            return new AutomatonIntVariable(pName);
        }
        if (pType.toLowerCase().equals("set")) {
            if (args.length > 0) {
                String value;
                AutomatonSetVariable result;
                String elementType = args[0];
                if (elementType.toLowerCase().equals("int")) {
                    result = new AutomatonSetVariable(pName);
                } else if (elementType.toLowerCase().equals("string")) {
                    result = new AutomatonSetVariable(pName);
                } else {
                    throw new IllegalArgumentException("Element type '" + elementType + "' is not suppoprted for sets");
                }
                if (args.length > 1 && !(value = args[1]).trim().isEmpty()) {
                    for (String elem : Splitter.on((char)',').split((CharSequence)value)) {
                        elem = elem.trim();
                        if (elementType.toLowerCase().equals("int")) {
                            try {
                                result.add(Integer.valueOf(elem));
                                continue;
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Value '" + elem + "' cannot be parsed as integer number");
                            }
                        }
                        result.add(elem);
                    }
                }
                return result;
            }
            throw new IllegalArgumentException("Element type was not specified for set variable");
        }
        throw new IllegalArgumentException("Type '" + pType + "' is not supported for automata variables");
    }

    public String getName() {
        return this.name;
    }

    public abstract String getType();

    public abstract int getValue();

    public abstract AutomatonVariable clone();

    public abstract int hashCode();

    public static final class AutomatonSetVariable<T>
    extends AutomatonVariable {
        private static final long serialVersionUID = 4293998838719160247L;
        private Set<T> set;

        private AutomatonSetVariable(String pName) {
            super(pName);
            this.set = new HashSet<T>();
        }

        private AutomatonSetVariable(String pName, Set<T> pSet) {
            super(pName);
            this.set = new HashSet<T>(pSet);
        }

        public boolean contains(Object obj) {
            return this.set.contains(obj);
        }

        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        public void add(Object obj) {
            this.set.add(obj);
        }

        public void remove(Object obj) {
            this.set.remove(obj);
        }

        @Override
        public int getValue() {
            if (this.set.isEmpty()) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return String.valueOf(this.set);
        }

        public boolean equals(Object pObj) {
            if (super.equals(pObj)) {
                return true;
            }
            if (!(pObj instanceof AutomatonSetVariable)) {
                return false;
            }
            AutomatonSetVariable otherVar = (AutomatonSetVariable)pObj;
            return this.set.equals(otherVar.set) && this.name.equals(otherVar.name);
        }

        @Override
        public int hashCode() {
            return this.set.hashCode() + this.name.hashCode();
        }

        @Override
        public AutomatonVariable clone() {
            return new AutomatonSetVariable<T>(this.name, this.set);
        }

        @Override
        public String getType() {
            return "set";
        }
    }

    public static final class AutomatonIntVariable
    extends AutomatonVariable {
        private static final long serialVersionUID = -5599402008148488971L;
        private int value = 0;

        private AutomatonIntVariable(String pName) {
            super(pName);
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public void setValue(int v) {
            this.value = v;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public boolean equals(Object pObj) {
            if (super.equals(pObj)) {
                return true;
            }
            if (!(pObj instanceof AutomatonIntVariable)) {
                return false;
            }
            AutomatonIntVariable otherVar = (AutomatonIntVariable)pObj;
            return this.value == otherVar.value && this.name.equals(otherVar.name);
        }

        @Override
        public int hashCode() {
            return this.value + this.name.hashCode();
        }

        @Override
        public AutomatonVariable clone() {
            AutomatonIntVariable result = new AutomatonIntVariable(this.name);
            result.setValue(this.getValue());
            return result;
        }

        @Override
        public String getType() {
            return "int";
        }
    }
}

