/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.waitlist.AbstractSortedWaitlist;
import org.sosy_lab.cpachecker.core.waitlist.Waitlist;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.util.AbstractStates;

public class AutomatonVariableWaitlist
extends AbstractSortedWaitlist<Integer> {
    private final String variableId;

    private AutomatonVariableWaitlist(Waitlist.WaitlistFactory pSecondaryStrategy, String pVariableId) {
        super(pSecondaryStrategy);
        this.variableId = pVariableId;
    }

    @Override
    protected Integer getSortKey(AbstractState pState) {
        int sortKey = Integer.MIN_VALUE;
        for (AutomatonState automatonState : AbstractStates.asIterable(pState).filter(AutomatonState.class)) {
            AutomatonVariable variable = automatonState.getVars().get(this.variableId);
            if (variable == null) continue;
            sortKey = Math.max(sortKey, variable.getValue());
        }
        return sortKey;
    }

    public static Waitlist.WaitlistFactory factory(Waitlist.WaitlistFactory pSecondaryStrategy, String pVariableId) {
        return () -> new AutomatonVariableWaitlist(pSecondaryStrategy, pVariableId);
    }
}

