/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import jhoafparser.ast.AtomLabel;
import jhoafparser.ast.BooleanExpression;
import jhoafparser.storage.StoredAutomaton;
import jhoafparser.storage.StoredEdgeWithLabel;
import jhoafparser.storage.StoredHeader;
import jhoafparser.storage.StoredState;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CParser;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CStatement;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CProblemType;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonVariable;
import org.sosy_lab.cpachecker.cpa.automaton.InvalidAutomatonException;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.CParserUtils;
import org.sosy_lab.cpachecker.util.ltl.LtlParseException;

public class BuechiConverterUtils {
    public static Automaton convertFromHOAFormat(StoredAutomaton pStoredAutomaton, String pEntryFunction, Configuration pConfig, LogManager pLogger, MachineModel pMachineModel, Scope pScope, ShutdownNotifier pShutdownNotifier) throws LtlParseException, InterruptedException {
        return new HoaToAutomatonTransformer(pStoredAutomaton, pEntryFunction, pConfig, pLogger, pMachineModel, pScope, pShutdownNotifier).doConvert();
    }

    private static class HoaToAutomatonTransformer {
        private static final String AUTOMATON_NAME = "Buechi_Automaton";
        private static final String FALSE = "0";
        private static final String TRUE = "1";
        private final LogManager logger;
        private final MachineModel machineModel;
        private final Scope scope;
        private final CParser parser;
        private final StoredAutomaton storedAutomaton;
        private final Optional<String> entryFunctionOpt;
        private final ShutdownNotifier shutdownNotifier;

        private HoaToAutomatonTransformer(StoredAutomaton pStoredAutomaton, String pEntryFunction, Configuration pConfig, LogManager pLogger, MachineModel pMachineModel, Scope pScope, ShutdownNotifier pShutdownNotifier) throws LtlParseException {
            this.storedAutomaton = (StoredAutomaton)Preconditions.checkNotNull((Object)pStoredAutomaton);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)pEntryFunction) ? 1 : 0) != 0);
            this.entryFunctionOpt = Optional.of(pEntryFunction);
            this.logger = (LogManager)Preconditions.checkNotNull((Object)pLogger);
            this.machineModel = (MachineModel)((Object)Preconditions.checkNotNull((Object)((Object)pMachineModel)));
            this.scope = (Scope)Preconditions.checkNotNull((Object)pScope);
            this.shutdownNotifier = (ShutdownNotifier)Preconditions.checkNotNull((Object)pShutdownNotifier);
            try {
                this.parser = CParser.Factory.getParser(pLogger, CParser.Factory.getOptions(pConfig), this.machineModel, this.shutdownNotifier);
            }
            catch (InvalidConfigurationException e) {
                throw new LtlParseException(e.getMessage(), e);
            }
        }

        private Automaton doConvert() throws LtlParseException, InterruptedException {
            StoredHeader storedHeader = this.storedAutomaton.getStoredHeader();
            StoredHeader.NameAndExtra accName = (StoredHeader.NameAndExtra)Iterables.getOnlyElement((Iterable)storedHeader.getAcceptanceNames());
            if (!accName.name.equals("Buchi")) {
                throw new LtlParseException(String.format("Only 'Buchi'-acceptance is allowed, but instead the following was found: %s (%s)", accName.name, ((List)accName.extra).toString()));
            }
            String accCond = storedHeader.getAcceptanceCondition().toStringInfix();
            if (!accCond.equals("Inf(0)")) {
                throw new LtlParseException(String.format("The only allowed acceptance-condition is %s, but instead the following was found: %s", "Inf(0)", accCond));
            }
            ImmutableSet requiredProperties = ImmutableSet.of((Object)"complete", (Object)"deterministic", (Object)"trans-labels", (Object)"explicit-labels", (Object)"state-acc", (Object)"no-univ-branch", (Object[])new String[0]);
            if (!requiredProperties.containsAll((Collection)storedHeader.getProperties())) {
                throw new LtlParseException(String.format("The storedAutomaton-param may only contain %s as properties, but instead the following were found: %s", requiredProperties, storedHeader.getProperties()));
            }
            List initStateList = (List)Iterables.getOnlyElement((Iterable)storedHeader.getStartStates());
            if (initStateList.size() != 1) {
                throw new LtlParseException("Univeral initial states are not supported");
            }
            int numAccSets = storedHeader.getNumberOfAcceptanceSets();
            if (numAccSets != 1) {
                throw new LtlParseException(String.format("Only one acceptance set was expected, but instead %d were found", numAccSets));
            }
            try {
                ImmutableList.Builder stateListBuilder = new ImmutableList.Builder();
                StoredState initBuchiState = this.storedAutomaton.getStoredState(((Integer)Iterables.getOnlyElement((Iterable)initStateList)).intValue());
                String initBuechiStateName = this.getStateName(initBuchiState);
                String initStateName = null;
                if (this.entryFunctionOpt.isPresent()) {
                    initStateName = "[pre-state] global-init";
                    this.addPreBuchiStates((ImmutableList.Builder<AutomatonInternalState>)stateListBuilder, this.entryFunctionOpt.orElseThrow(), initStateName, initBuechiStateName);
                } else {
                    initStateName = initBuechiStateName;
                }
                for (int i = 0; i < this.storedAutomaton.getNumberOfStates(); ++i) {
                    StoredState storedState = this.storedAutomaton.getStoredState(i);
                    ArrayList<AutomatonTransition> transitionList = new ArrayList<AutomatonTransition>();
                    for (StoredEdgeWithLabel edge : this.storedAutomaton.getEdgesWithLabel(i)) {
                        int successorStateId = (Integer)Iterables.getOnlyElement((Iterable)edge.getConjSuccessors());
                        String successorName = this.getStateName(this.storedAutomaton.getStoredState(successorStateId));
                        transitionList.addAll(this.getTransitions((BooleanExpression<AtomLabel>)edge.getLabelExpr(), successorName));
                    }
                    boolean isTargetState = false;
                    if (storedState.getAccSignature() != null) {
                        int accSig = (Integer)Iterables.getOnlyElement((Iterable)storedState.getAccSignature());
                        boolean bl = isTargetState = accSig == 0;
                        if (!isTargetState) {
                            throw new LtlParseException(String.format("Automaton state has an acceptance signature, but the value is different to the exptected value (expected: 0, actual: %d", accSig));
                        }
                    }
                    stateListBuilder.add((Object)new AutomatonInternalState(this.getStateName(storedState), transitionList, isTargetState, true, false));
                }
                return new Automaton(AUTOMATON_NAME, (Map<String, AutomatonVariable>)ImmutableMap.of(), (List<AutomatonInternalState>)stateListBuilder.build(), initStateName);
            }
            catch (InvalidAutomatonException e) {
                throw new RuntimeException("The passed storedAutomaton-parameter produces an inconsistent automaton", e);
            }
            catch (UnrecognizedCodeException e) {
                throw new LtlParseException(e.getMessage(), e);
            }
        }

        private void addPreBuchiStates(ImmutableList.Builder<AutomatonInternalState> pStateListBuilder, String pEntryFunctionName, String pInitStateName, String pInitBuechiStateName) {
            String initStateName = pInitStateName;
            String mainEntryStateName = "[pre-state] main-entry";
            AutomatonBoolExpr.MatchCFAEdgeRegEx matchCFAEdgeRegEx = new AutomatonBoolExpr.MatchCFAEdgeRegEx(".*\\s+" + pEntryFunctionName + "\\s*\\(.*\\)\\s*;?.*");
            AutomatonTransition initToMainEntry = new AutomatonTransition.Builder((AutomatonBoolExpr)matchCFAEdgeRegEx, "[pre-state] main-entry").build();
            AutomatonBoolExpr.CPAQuery query = new AutomatonBoolExpr.CPAQuery("location", "mainEntry==" + pEntryFunctionName);
            AutomatonTransition mainEntryToInitBuechiState = new AutomatonTransition.Builder((AutomatonBoolExpr)query, pInitBuechiStateName).build();
            AutomatonInternalState initState = new AutomatonInternalState(initStateName, (List<AutomatonTransition>)ImmutableList.of((Object)initToMainEntry, (Object)this.createTransition((List<AExpression>)ImmutableList.of(), initStateName)), false, false);
            AutomatonInternalState mainEntryState = new AutomatonInternalState("[pre-state] main-entry", (List<AutomatonTransition>)ImmutableList.of((Object)mainEntryToInitBuechiState, (Object)this.createTransition((List<AExpression>)ImmutableList.of(), "[pre-state] main-entry")), false, false);
            pStateListBuilder.add((Object)initState);
            pStateListBuilder.add((Object)mainEntryState);
        }

        private String getStateName(StoredState pState) {
            return pState.getInfo() != null ? pState.getInfo() : String.valueOf(pState.getStateId());
        }

        private List<AutomatonTransition> getTransitions(BooleanExpression<AtomLabel> pLabelExpr, String pSuccessorName) throws LtlParseException, UnrecognizedCodeException, InterruptedException {
            ImmutableList.Builder transitions = ImmutableList.builder();
            switch (pLabelExpr.getType()) {
                case EXP_OR: {
                    transitions.addAll(this.getTransitions((BooleanExpression<AtomLabel>)pLabelExpr.getLeft(), pSuccessorName));
                    transitions.addAll(this.getTransitions((BooleanExpression<AtomLabel>)pLabelExpr.getRight(), pSuccessorName));
                    break;
                }
                default: {
                    transitions.add((Object)this.createTransition(this.getExpressions(pLabelExpr), pSuccessorName));
                }
            }
            return transitions.build();
        }

        private List<AExpression> getExpressions(BooleanExpression<AtomLabel> pLabelExpr) throws LtlParseException, UnrecognizedCodeException, InterruptedException {
            ImmutableList.Builder expBuilder = ImmutableList.builder();
            BooleanExpression.Type type = pLabelExpr.getType();
            switch (type) {
                case EXP_TRUE: {
                    return ImmutableList.of((Object)this.assume(TRUE));
                }
                case EXP_FALSE: {
                    return ImmutableList.of((Object)this.assume(FALSE));
                }
                case EXP_ATOM: {
                    int apIndex = ((AtomLabel)pLabelExpr.getAtom()).getAPIndex();
                    return ImmutableList.of((Object)this.assume((String)this.storedAutomaton.getStoredHeader().getAPs().get(apIndex)));
                }
                case EXP_OR: {
                    expBuilder.addAll(this.getExpressions((BooleanExpression<AtomLabel>)pLabelExpr.getLeft()));
                    expBuilder.addAll(this.getExpressions((BooleanExpression<AtomLabel>)pLabelExpr.getRight()));
                    break;
                }
                case EXP_AND: {
                    expBuilder.addAll(this.getExpressions((BooleanExpression<AtomLabel>)pLabelExpr.getLeft()));
                    expBuilder.addAll(this.getExpressions((BooleanExpression<AtomLabel>)pLabelExpr.getRight()));
                    break;
                }
                case EXP_NOT: {
                    CBinaryExpressionBuilder b = new CBinaryExpressionBuilder(this.machineModel, this.logger);
                    CExpression exp = (CExpression)Iterables.getOnlyElement(this.getExpressions((BooleanExpression<AtomLabel>)pLabelExpr.getLeft()));
                    expBuilder.add((Object)b.negateExpressionAndSimplify(exp));
                    break;
                }
                default: {
                    throw new RuntimeException("Unhandled expression type: " + type);
                }
            }
            return expBuilder.build();
        }

        private CExpression assume(String pExpression) throws LtlParseException, InterruptedException {
            CStatement sourceAST;
            try {
                sourceAST = CParserUtils.parseSingleStatement(pExpression, this.parser, this.scope);
            }
            catch (InvalidAutomatonException e) {
                throw new LtlParseException(String.format("Error in literal of ltl-formula: %s", e.getMessage()), e);
            }
            CExpression expression = ((CExpressionStatement)sourceAST).getExpression();
            if (expression.getExpressionType() instanceof CProblemType) {
                this.logger.log(Level.WARNING, new Object[]{"The parsed expression is of type 'CProblemType', most likely because it depends on an unresolved name within the c-code"});
            }
            return expression;
        }

        private AutomatonTransition createTransition(List<AExpression> pAssumptions, String pFollowStateName) {
            return new AutomatonTransition.Builder(AutomatonBoolExpr.TRUE, pFollowStateName).withAssumptions(pAssumptions).build();
        }
    }
}

