/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CProgramScope;
import org.sosy_lab.cpachecker.cfa.DummyScope;
import org.sosy_lab.cpachecker.cfa.Language;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.parser.Scope;
import org.sosy_lab.cpachecker.core.defaults.AutomaticCPAFactory;
import org.sosy_lab.cpachecker.core.defaults.BreakOnTargetsPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.FlatLatticeDomain;
import org.sosy_lab.cpachecker.core.defaults.MergeSepOperator;
import org.sosy_lab.cpachecker.core.defaults.SingletonPrecision;
import org.sosy_lab.cpachecker.core.defaults.StaticPrecisionAdjustment;
import org.sosy_lab.cpachecker.core.defaults.StopSepOperator;
import org.sosy_lab.cpachecker.core.interfaces.AbstractDomain;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.CPAFactory;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysisWithBAM;
import org.sosy_lab.cpachecker.core.interfaces.MergeOperator;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.interfaces.StopOperator;
import org.sosy_lab.cpachecker.core.interfaces.pcc.ProofChecker;
import org.sosy_lab.cpachecker.cpa.automaton.Automaton;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonParser;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonPrecision;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonStatistics;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTargetInformation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTopMergeOperator;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransition;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonPrecisionAdjustment;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.globalinfo.AutomatonInfo;

@Options(prefix="cpa.automaton")
public class ControlAutomatonCPA
implements StatisticsProvider,
ConfigurableProgramAnalysisWithBAM,
ProofChecker.ProofCheckerCPA {
    @Option(secure=true, name="dotExport", description="export automaton to file")
    private boolean export = false;
    @Option(secure=true, name="dotExportFile", description="file for saving the automaton in DOT format (%s will be replaced with automaton name)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate dotExportFile = PathTemplate.ofFormatString((String)"%s.dot");
    @Option(secure=true, name="spcExportFile", description="file for saving the automaton in spc format (%s will be replaced with automaton name)")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private PathTemplate spcExportFile = PathTemplate.ofFormatString((String)"%s.spc");
    @Option(secure=true, required=false, description="file with automaton specification for ObserverAutomatonCPA and ControlAutomatonCPA")
    @FileOption(value=FileOption.Type.OPTIONAL_INPUT_FILE)
    private Path inputFile = null;
    @Option(secure=true, description="signal the analysis to break in case the given number of error state is reached. Use -1 to disable this limit.")
    private int breakOnTargetState = 1;
    @Option(secure=true, description="the maximum number of iterations performed after the initial error is found, despite the limit given as cpa.automaton.breakOnTargetState is not yet reached. Use -1 to disable this limit.")
    private int extraIterationsLimit = -1;
    @Option(secure=true, description="Whether to treat automaton states with an internal error state as targets. This should be the standard use case.")
    private boolean treatErrorsAsTargets = true;
    @Option(secure=true, description="Merge two automata states if one of them is TOP.")
    private boolean mergeOnTop = false;
    @Option(secure=true, name="prec.topOnFinalSelfLoopingState", description="An implicit precision: consider states with a self-loop and no other outgoing edges as TOP.")
    private boolean topOnFinalSelfLoopingState = false;
    private final Automaton automaton;
    private final AutomatonState topState;
    private final AutomatonState bottomState;
    private final AbstractDomain automatonDomain;
    private final AutomatonStatistics stats;
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;

    public static CPAFactory factory() {
        return AutomaticCPAFactory.forType(ControlAutomatonCPA.class);
    }

    protected ControlAutomatonCPA(@AutomaticCPAFactory.OptionalAnnotation Automaton pAutomaton, Configuration pConfig, LogManager pLogger, CFA pCFA, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this, ControlAutomatonCPA.class);
        this.cfa = pCFA;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        if (pAutomaton != null) {
            this.automaton = pAutomaton;
        } else {
            if (this.inputFile == null) {
                throw new InvalidConfigurationException("Explicitly specified automaton CPA needs option cpa.automaton.inputFile!");
            }
            this.automaton = this.constructAutomataFromFile(pConfig, this.inputFile);
        }
        pLogger.log(Level.FINEST, new Object[]{"Automaton", this.automaton.getName(), "loaded."});
        this.topState = new AutomatonState.TOP(this.getAutomaton(), this.isTreatingErrorsAsTargets());
        this.bottomState = new AutomatonState.BOTTOM(this.getAutomaton(), this.isTreatingErrorsAsTargets());
        this.automatonDomain = new FlatLatticeDomain(this.topState);
        this.stats = new AutomatonStatistics(this.automaton);
        if (this.export) {
            if (this.dotExportFile != null) {
                try (Writer w = IO.openOutputFile((Path)this.dotExportFile.getPath(new Object[]{this.automaton.getName()}), (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
                    this.automaton.writeDotFile(w);
                }
                catch (IOException e) {
                    pLogger.logUserException(Level.WARNING, (Throwable)e, "Could not write the automaton to DOT file");
                }
            }
            if (this.spcExportFile != null) {
                try {
                    IO.writeFile((Path)this.spcExportFile.getPath(new Object[]{this.automaton.getName()}), (Charset)Charset.defaultCharset(), (Object)this.automaton);
                }
                catch (IOException e) {
                    pLogger.logUserException(Level.WARNING, (Throwable)e, "Could not write the automaton to SPC file");
                }
            }
        }
    }

    private Automaton constructAutomataFromFile(Configuration pConfig, Path pFile) throws InvalidConfigurationException {
        Scope scope = this.cfa.getLanguage() == Language.C ? new CProgramScope(this.cfa, this.logger) : DummyScope.getInstance();
        List<Automaton> lst = AutomatonParser.parseAutomatonFile(pFile, pConfig, this.logger, this.cfa.getMachineModel(), scope, this.cfa.getLanguage(), this.shutdownNotifier);
        if (lst.isEmpty()) {
            throw new InvalidConfigurationException("Could not find automata in the file " + this.inputFile.toAbsolutePath());
        }
        if (lst.size() > 1) {
            throw new InvalidConfigurationException("Found " + lst.size() + " automata in the File " + this.inputFile.toAbsolutePath() + " The CPA can only handle ONE Automaton!");
        }
        return lst.get(0);
    }

    Automaton getAutomaton() {
        return this.automaton;
    }

    public void registerInAutomatonInfo(AutomatonInfo info) {
        info.register(this.automaton, this);
    }

    @Override
    public AbstractDomain getAbstractDomain() {
        return this.automatonDomain;
    }

    @Override
    public AbstractState getInitialState(CFANode pNode, StateSpacePartition pPartition) {
        return this.buildInitStateForAutomaton(this.automaton);
    }

    public AutomatonState buildInitStateForAutomaton(Automaton pAutomaton) {
        AutomatonInternalState initState = pAutomaton.getInitialState();
        AutomatonTargetInformation safetyProp = null;
        if (initState.isTarget()) {
            for (AutomatonTransition t : initState.getTransitions()) {
                if (!t.getFollowState().isTarget()) continue;
                Optional assumptionOpt = (Optional)t.getAssumptions(null, this.logger, this.cfa.getMachineModel()).stream().collect(MoreCollectors.toOptional());
                safetyProp = assumptionOpt.isPresent() ? new AutomatonTargetInformation(pAutomaton, t, ((AExpression)assumptionOpt.orElseThrow()).toASTString()) : new AutomatonTargetInformation(pAutomaton, t);
                break;
            }
            Verify.verifyNotNull(safetyProp);
        }
        return AutomatonState.automatonStateFactory(pAutomaton.getInitialVariables(), pAutomaton.getInitialState(), pAutomaton, 0, 0, safetyProp, this.isTreatingErrorsAsTargets());
    }

    @Override
    public MergeOperator getMergeOperator() {
        if (this.mergeOnTop) {
            return new AutomatonTopMergeOperator(this.automatonDomain, this.topState);
        }
        return MergeSepOperator.getInstance();
    }

    @Override
    public PrecisionAdjustment getPrecisionAdjustment() {
        PrecisionAdjustment lPrecisionAdjustment = this.breakOnTargetState > 0 ? new BreakOnTargetsPrecisionAdjustment(this.breakOnTargetState, this.extraIterationsLimit) : StaticPrecisionAdjustment.getInstance();
        return new ControlAutomatonPrecisionAdjustment(this.topState, lPrecisionAdjustment, this.topOnFinalSelfLoopingState);
    }

    @Override
    public StopOperator getStopOperator() {
        return new StopSepOperator(this.getAbstractDomain());
    }

    @Override
    public AutomatonTransferRelation getTransferRelation() {
        return new AutomatonTransferRelation(this, this.logger, this.cfa.getMachineModel(), this.stats);
    }

    public AutomatonState getBottomState() {
        return this.bottomState;
    }

    public AutomatonState getTopState() {
        return this.topState;
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(this.stats);
    }

    @Override
    public boolean areAbstractSuccessors(AbstractState pElement, CFAEdge pCfaEdge, Collection<? extends AbstractState> pSuccessors) throws CPATransferException, InterruptedException {
        ImmutableSet successors = ImmutableSet.copyOf(pSuccessors);
        ImmutableSet actualSuccessors = ImmutableSet.copyOf(this.getTransferRelation().getAbstractSuccessorsForEdge(pElement, SingletonPrecision.getInstance(), pCfaEdge));
        return successors.equals((Object)actualSuccessors);
    }

    boolean isTreatingErrorsAsTargets() {
        return this.treatErrorsAsTargets;
    }

    @Override
    public Precision getInitialPrecision(CFANode pNode, StateSpacePartition pPartition) throws InterruptedException {
        return new AutomatonPrecision(this.automaton);
    }
}

