/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.base.Function;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustment;
import org.sosy_lab.cpachecker.core.interfaces.PrecisionAdjustmentResult;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonInternalState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.exceptions.CPAException;

public class ControlAutomatonPrecisionAdjustment
implements PrecisionAdjustment {
    private final @Nullable PrecisionAdjustment wrappedPrec;
    private final AutomatonState topState;
    private final boolean topOnFinalSelfLoopingState;

    public ControlAutomatonPrecisionAdjustment(AutomatonState pTopState, PrecisionAdjustment pWrappedPrecisionAdjustment, boolean pTopOnFinalSelfLoopingState) {
        this.topState = pTopState;
        this.wrappedPrec = pWrappedPrecisionAdjustment;
        this.topOnFinalSelfLoopingState = pTopOnFinalSelfLoopingState;
    }

    @Override
    public Optional<PrecisionAdjustmentResult> prec(AbstractState pState, Precision pPrecision, UnmodifiableReachedSet pStates, Function<AbstractState, AbstractState> pStateProjection, AbstractState pFullState) throws CPAException, InterruptedException {
        Optional<PrecisionAdjustmentResult> wrappedPrecResult = this.wrappedPrec.prec(pState, pPrecision, pStates, pStateProjection, pFullState);
        if (!wrappedPrecResult.isPresent()) {
            return wrappedPrecResult;
        }
        AutomatonInternalState internalState = ((AutomatonState)pState).getInternalState();
        if (internalState.getName().equals(AutomatonInternalState.BREAK.getName())) {
            return Optional.of(wrappedPrecResult.orElseThrow().withAction(PrecisionAdjustmentResult.Action.BREAK));
        }
        if (this.topOnFinalSelfLoopingState && internalState.isFinalSelfLoopingState()) {
            AutomatonState adjustedSate = this.topState;
            Precision adjustedPrecision = pPrecision;
            return Optional.of(PrecisionAdjustmentResult.create(adjustedSate, adjustedPrecision, PrecisionAdjustmentResult.Action.CONTINUE));
        }
        return wrappedPrecResult;
    }
}

