/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.util.automaton.AutomatonGraphmlCommon;

class GraphMLState {
    private final String id;
    private final Set<String> invariants;
    private final Optional<String> explicitInvariantScope;
    private final EnumSet<AutomatonGraphmlCommon.NodeFlag> flags;

    public GraphMLState(String pId, Set<String> pInvariants, Optional<String> pExplicitInvariantScope, EnumSet<AutomatonGraphmlCommon.NodeFlag> pFlags) {
        this.id = Objects.requireNonNull(pId);
        this.invariants = ImmutableSet.copyOf(pInvariants);
        this.explicitInvariantScope = Objects.requireNonNull(pExplicitInvariantScope);
        this.flags = Objects.requireNonNull(pFlags);
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof GraphMLState) {
            GraphMLState other = (GraphMLState)pOther;
            return this.getId().equals(other.getId()) && this.getInvariants().equals(other.getInvariants()) && this.getExplicitInvariantScope().equals(other.getExplicitInvariantScope()) && this.flags.equals(other.flags);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getInvariants(), this.getExplicitInvariantScope(), this.flags);
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public Set<String> getInvariants() {
        return this.invariants;
    }

    public Optional<String> getExplicitInvariantScope() {
        return this.explicitInvariantScope;
    }

    public boolean isEntryState() {
        return this.flags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISENTRY);
    }

    public boolean isSinkState() {
        return this.flags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISSINKNODE);
    }

    public boolean isViolationState() {
        return this.flags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISVIOLATION);
    }

    public boolean isCycleHead() {
        return this.flags.contains((Object)AutomatonGraphmlCommon.NodeFlag.ISCYCLEHEAD);
    }
}

