/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.automaton;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonAction;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonBoolExpr;
import org.sosy_lab.cpachecker.cpa.automaton.GraphMLState;

class GraphMLTransition {
    private final GraphMLState source;
    private final GraphMLState target;
    private final Optional<String> functionEntry;
    private final Optional<String> functionExit;
    private final Optional<Predicate<FileLocation>> offsetMatcherPredicate;
    private final Optional<Predicate<FileLocation>> lineMatcherPredicate;
    private final AutomatonBoolExpr assumeCaseMatcher;
    private final GraphMLThread thread;
    private final Optional<AutomatonAction> threadAssignment;
    private final Set<String> assumptions;
    private final Optional<String> explicitAssumptionScope;
    private final Optional<String> explicitAssumptionResultFunction;
    private final boolean entersLoopHead;

    public GraphMLTransition(GraphMLState pSource, GraphMLState pTarget, Optional<String> pFunctionEntry, Optional<String> pFunctionExit, Optional<Predicate<FileLocation>> pOffsetMatcherPredicate, Optional<Predicate<FileLocation>> pLineMatcherPredicate, AutomatonBoolExpr pAssumeCaseMatcher, GraphMLThread pThread, Optional<AutomatonAction> pThreadAssignment, Set<String> pAssumptions, Optional<String> pExplicitAssumptionScope, Optional<String> pAssumptionResultFunction, boolean pEntersLoopHead) {
        this.source = Objects.requireNonNull(pSource);
        this.target = Objects.requireNonNull(pTarget);
        this.functionEntry = Objects.requireNonNull(pFunctionEntry);
        this.functionExit = Objects.requireNonNull(pFunctionExit);
        this.offsetMatcherPredicate = Objects.requireNonNull(pOffsetMatcherPredicate);
        this.lineMatcherPredicate = Objects.requireNonNull(pLineMatcherPredicate);
        this.assumeCaseMatcher = Objects.requireNonNull(pAssumeCaseMatcher);
        this.thread = Objects.requireNonNull(pThread);
        this.threadAssignment = Objects.requireNonNull(pThreadAssignment);
        this.assumptions = ImmutableSet.copyOf(pAssumptions);
        this.explicitAssumptionScope = Objects.requireNonNull(pExplicitAssumptionScope);
        this.explicitAssumptionResultFunction = Objects.requireNonNull(pAssumptionResultFunction);
        this.entersLoopHead = pEntersLoopHead;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof GraphMLTransition) {
            GraphMLTransition other = (GraphMLTransition)pOther;
            return this.getSource().equals(other.getSource()) && this.getTarget().equals(other.getTarget()) && this.getFunctionEntry().equals(other.getFunctionEntry()) && this.getFunctionExit().equals(other.getFunctionExit()) && this.getOffsetMatcherPredicate().equals(other.getOffsetMatcherPredicate()) && this.getLineMatcherPredicate().equals(other.getLineMatcherPredicate()) && this.getAssumeCaseMatcher().equals(other.getAssumeCaseMatcher()) && this.getThread().equals(other.getThread()) && this.getThreadAssignment().equals(other.getThreadAssignment()) && this.getAssumptions().equals(other.getAssumptions()) && this.getExplicitAssumptionScope().equals(other.getExplicitAssumptionScope()) && this.getExplicitAssumptionResultFunction().equals(other.getExplicitAssumptionResultFunction()) && this.entersLoopHead() == other.entersLoopHead();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getSource(), this.getTarget(), this.getFunctionEntry(), this.getFunctionExit(), this.getOffsetMatcherPredicate(), this.getLineMatcherPredicate(), this.getAssumeCaseMatcher(), this.getThread(), this.getThreadAssignment(), this.getAssumptions(), this.getExplicitAssumptionScope(), this.getExplicitAssumptionResultFunction(), this.entersLoopHead());
    }

    public String toString() {
        return String.format("(%s -> %s)", this.getSource(), this.getTarget());
    }

    public GraphMLState getSource() {
        return this.source;
    }

    public GraphMLState getTarget() {
        return this.target;
    }

    public Optional<String> getFunctionEntry() {
        return this.functionEntry;
    }

    public Optional<String> getFunctionExit() {
        return this.functionExit;
    }

    public Optional<Predicate<FileLocation>> getOffsetMatcherPredicate() {
        return this.offsetMatcherPredicate;
    }

    public Optional<Predicate<FileLocation>> getLineMatcherPredicate() {
        return this.lineMatcherPredicate;
    }

    public AutomatonBoolExpr getAssumeCaseMatcher() {
        return this.assumeCaseMatcher;
    }

    public GraphMLThread getThread() {
        return this.thread;
    }

    public Optional<AutomatonAction> getThreadAssignment() {
        return this.threadAssignment;
    }

    public Set<String> getAssumptions() {
        return this.assumptions;
    }

    public Optional<String> getExplicitAssumptionScope() {
        return this.explicitAssumptionScope;
    }

    public Optional<String> getExplicitAssumptionResultFunction() {
        return this.explicitAssumptionResultFunction;
    }

    public boolean entersLoopHead() {
        return this.entersLoopHead;
    }

    public static GraphMLThread createThread(int pId, String pName) {
        return new GraphMLThread(pId, pName);
    }

    static class GraphMLThread
    implements Comparable<GraphMLThread> {
        private final int id;
        private final String name;

        private GraphMLThread(int pId, String pName) {
            this.id = pId;
            this.name = Objects.requireNonNull(pName);
        }

        public boolean equals(Object pOther) {
            if (this == pOther) {
                return true;
            }
            if (pOther instanceof GraphMLThread) {
                GraphMLThread other = (GraphMLThread)pOther;
                return this.id == other.id && this.name.equals(other.name);
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            if (this.name.equals(Integer.toString(this.id))) {
                return this.name;
            }
            return String.format("%s (%d)", this.name, this.id);
        }

        @Override
        public int compareTo(GraphMLThread pOther) {
            return ComparisonChain.start().compare(this.id, pOther.id).compare((Comparable)((Object)this.name), (Comparable)((Object)pOther.name)).result();
        }
    }
}

